#!/usr/bin/perl -w
#########################################################
#           SimpleFTP - Web Based FTP Client            #
#########################################################
#                                                       #
#                                                       #
# This script was created by:                           #
#                                                       #
# PerlCoders Web Development Division.                  #
# http://www.perlcoders.com/                            #
#                                                       #
# This script and all included modules, lists or        #
# images, documentation are copyright 2001              #
# PerlCoders (http://perlcoders.com) unless             #
# otherwise stated in the module.                       #
#                                                       #
# Purchasers are granted rights to use this script      #
# on any site they own. There is no individual site     #
# license needed per site.                              #
#                                                       #
# Any copying, distribution, modification with          #
# intent to distribute as new code will result          #
# in immediate loss of your rights to use this          #
# program as well as possible legal action.             #
#                                                       #
# This and many other fine scripts are available at     #
# the above website or by emailing the authors at       #
# staff@perlcoders.com or info@perlcoders.com           #
#                                                       #
#########################################################
use strict;
use CGI qw/:standard/;

# Edit ONLY variables enclosed between comment block.

my $SCRIPT_DIR = '/home/public_html/cgi-bin/sftp';
my $SCRIPT_URL = 'http://whitemage.virtualave.net/cgi-bin/sftp';
my $real_pass = 'perlcoders';
my $max_length = 250; # In kilobytes (kb).

# Do not edit anything below this point. Thank you.

$max_length *= 1024;
$CGI::POST_MAX = $max_length;

my $q = new CGI;
my $logged_in = $q->cookie('SFTP_LI');
my $user_pass = $q->param('PASSWORD');
my $filename = $q->param('filename');
my $delete_filename = $q->param('delete_filename');
my $location = $q->param('location');
my $permission = $q->param('permission');
my $Mime = uploadInfo($filename);
$Mime = $Mime->{'Content-Type'};


if($logged_in eq 'YES') {
        print $q->header();
        if($filename and $location and $permission) {
                if($Mime !~ /text/) {
                        my $data;
                        open(OUT, ">$location");
                        binmode(OUT);
                        while(read($filename, $data, 1024)) {
                                print OUT $data;
                        }
                        close(OUT);
                        showPage("success.html", $location);
                        exit 1;
                } else {
                        open(OUT, ">$location");
                        while(<$filename>) {
                                print OUT "$_";
                        }
                        close(OUT);
                        showPage("success.html", $location);
                }
        } elsif( ($filename and $location and not $permission) or ($location and $permission and not $filename) or ($filename and $permission and not $location) ) {
                showPage("error.html");
                exit 1;
        } elsif($delete_filename) {
                unlink($delete_filename) || system("rm $delete_filename");
                showPage("deleted.html", $delete_filename);
                exit 1;
        } else {
                showPage("main.html");
        }
} elsif($user_pass) { # Trying to log in.
        if($user_pass eq $real_pass) {
                my $c_obj = $q->cookie( -name => 'SFTP_LI',
                                        -value => 'YES'
                                      );
                print $q->header(-cookie => $c_obj);
                showPage("main.html");
                exit 1;
        } else {
                print $q->header();
                showPage("wrong_pass.html");
                exit 1;
        }
} else {
# Display login page.
        print $q->header();
        showPage("login.html");
        exit 1;
}


#################################################
sub showPage {
my $file = shift;
my $other = shift;

open(IN, "$SCRIPT_DIR/templates/$file");
while(<IN>) {
        s/%REMOTE_FILE%/$other/gi;
        s/%SCRIPT_URL%/$SCRIPT_URL/gi;
        s/%LIST_FILES%/listFiles()/egi;
        print;
}
close(IN);
}

#################################################
sub listFiles {

opendir(DH, "$SCRIPT_DIR");
my @files = sort grep !/^\.?\.$/, readdir DH;
my @tmp;

for(@files) {
        if(-f) { # Normal file
                push @tmp, qq{<A HREF="$SCRIPT_URL/$_"><U>$_</U></A>};
        } elsif(-d) { # Directory
                push @tmp, qq{<A HREF="$SCRIPT_URL/$_"><B>$_</B>};
        } else { # Other
                push @tmp, qq{<A HREF="$SCRIPT_URL/$_">$_</A>};
        }
}
@tmp = sort -d, @tmp;
return join('<BR>', @tmp);
}

