#!/usr/local/bin/perl5 -T

# File:         skysearch.cgi
# 
# Function:     Simple search of *.html files
#
# Author(s):    Erik C. Thauvin (erik@skytouch.com)
#
# Copyright:    Copyright (C) 1996-97 Erik C. Thauvin
#               All Rights Reserved.
#
# Source:       Started anew.
#
#
# History:
#
#   06/02/97    ECT     Added default email domain.
#   04/08/97    ETC     Added <title>...</title> extraction.
#   03/19/97    ECT     Added email option for questions/comments.
#   03/17/97    ECT     Added support for virtual domains.
#   11/01/96    ECT     Added sort{} functions.
#   10/31/96    ECT     Cleaned up HTML output.
#   09/30/96    ECT     Added customizable search directory.
#   06/21/96    ECT     Cleaned up &printResult().
#   06/19/96    ECT     Added last modified *.html search routines.
#   06/18/96    ECT     Added multi-user support.
#   06/17/96    ECT     Initial coding.
#
#   
# Disclaimer:
#   
#   This software is provided "as is" without express or implied warranties.
#   Permission is granted to use, copy, modify and distribute this software,
#   provided this disclaimer and copyright are preserved on all copies. This
#   software may not, however, be sold or distributed for profit, or included
#   with other software which is sold or distributed for profit, without the
#   permission of the author.
#

#
# Setup environment
#

$ENV{'PATH'} = "/bin:/usr/bin:/usr/lib";
$ENV{'IFS'}  = "";

require '/usr/www/cgi-bin/cgi-lib.pl';

#
# Read POST data
#
&ReadParse();

#
# Base directory and base URL
#
$basedir = '/u/';
$baseurl = 'http://www.eskimo.com/';

# Valid users
#
@users = ('skytouch', 'chance', 'brian', 'ideals');

#
# Default email domain
#
$edomain = "eskimo.com";

#
# Default title
#
$title = $in{"title"} || 'Search Results';

#
# The truth is out there!
#
if ($ENV{'REQUEST_METHOD'} eq 'POST')
{
    $user = $in{'user'};
    $query = $in{'query'};
    $email = $in{'email'};
    $vdomain = $in{'vdomain'};
    $dir = $in{'dir'};
    
    if (!&validate($user))
    {
        &error('Access denied! Please contact <a href=\"mailto:erik\@skytouch.com\">SkyTouch Communications</a> for authorization.');
    }
    else
    {
        if ($vdomain)
        {
            $baseurl = 'http://' . "$in{'vdomain'}/";           
        }
        else
        {
            $baseurl .= "~$user/";
        }
        
        $basedir .= substr($user, 0, 1) . "/$user/public_html/";
        if ($dir)
        {
            $basedir .= "$in{'dir'}/";
            $baseurl .= "$in{'dir'}/";
        }
        
        if (!$email)
        {
            $email = $user . "\@" . $edomain;
        }

    }
    
    if ($query)
    {
        if (length($query) > 2)
        {
            opendir(DIR, $basedir) || &error("Can't open $basedir: $!");
            @files = grep { /.*\.(sh|h)tm(l$|$)/ && -f $basedir.$_ } readdir(DIR);
            closedir(DIR);

            if ($query ne 'new')
            {
                foreach $file (@files)
                {
                    if (open(F, $basedir.$file))
                    {
                        @data = <F>;
                        $hits = grep(/$query/i, @data);
                        if ($hits)
                        {
                            $result{$file} = $hits;
                            $header = join(' ', $data[0], $data[1], $data[2], $data[3], $data[4], $data[5], $data[6], $data[7], $data[8], $data[9]);
                            $header =~ s/\n//g;
                            if ($header =~ /<title>(.*)<\/title>/i)
                            {
                                $titles{$file} = "$1";
                            }
                            else
                            {
                                $titles{$file} = "$file";
                            }
                        }
                    close(F);
                    }
                }
            }
            else
            {
                $time = time();
                
                foreach $file (@files)
                {
                    if (-r $basedir.$file)
                    {
                        @stats = stat($basedir.$file);
                        if (($time - $stats[9]) <= 172800)
                        {
                            $result{$file} = $stats[9];
                        }
                    }
                }
            }   
            if (%result)
            {
                if (!@stats)
                {
                    $html = "The string \"<b>$query</b>\" was found in:\n<p>\n<ol>\n<p>";               
                    
                    foreach $page (sort {$result{$b} <=> $result{$a}} (sort keys %titles))
                    {
                        $html .= "<li> <b><a href=\"$baseurl$page\">$titles{$page}</a></b>\n";
                        $html .= "<br> Hits: <b>$result{$page}</b>";
                        
                        if ("$titles{$page}" ne "$page")
                        {
                            $html .= ", File: <b>$page</b>";
                        }
                        
                        $html .= "\n<p>\n";
                    }
                }
                else
                {
                    $html = "The following documents have been modified in the last 48 hours:\n<p>\n<ol>\n";

                    foreach $page (sort {$result{$b} <=> $result{$a}} keys %result)
                    {
                        @ltime = localtime($result{$page});
                        $html .= "<li> <b><a href=\"$baseurl$page\">$page</a></b>\n";
                        $html .= sprintf("<br> Date: <b>%02d-%02d-%s</b>, Time: <b>%02d:%02d</b>\n<p>\n", $ltime[4] + 1, $ltime[3], $ltime[5], $ltime[2], $ltime[1]);
                    }   
                }
                
                $html .= "</ol>\n<p>\n";
                
                &printResult($html);
            }
            else
            {
                if (!@stats)
                {
                    &error('Nothing was found. Please try again.');
                }
                else
                {
                    &error('No documents were modified in the last 48 hours.');
                }
            }
        }
        else
        {
            &error('Search query is too short (3 chars minimum).');
        }
    }
    else
    {
        &error('Please specify a search query. Thank you.');
    }
}
else
{
    &error("This script should be referenced with a METHOD of POST. If you don't understand this, see the <a href=\"http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/Docs/fill-out-forms/overview.html\">forms overview</a>.\n<p>\n<p>\nThank you.");
}


sub printResult
{
    print &PrintHeader()
        . "<html>\n"
        . "<head>\n"
        . "<title>$title</title>\n"
        . "</head>\n"
        . "<body bgcolor=#ffffff>\n"
        . "<h1><hr size=1><font size=5>Search Results</font><hr size=1></h1>\n"
        . "@_"
        . "<hr size=1>\n"
        . "<center>\n"
        . "<form method=\"POST\" action=\"http://www.eskimo.com/cgi-bin/skysearch.cgi\">\n"
        . "<input type=\"hidden\" name=\"user\" value=\"$user\">\n"
        . "<input type=\"hidden\" name=\"email\" value=\"$email\">\n";

        if ($vdomain)
        {
            print "<input type=\"hidden\" name=\"vdomain\" value=\"$vdomain\">\n";
        }
  
        if ($dir)
        {
            print "<input type=\"hidden\" name=\"dir\" value=\"$dir\">\n";
        }
            
    print "<input type=\"hidden\" name=\"title\" value=\"$title\">\n"
        . "<input size=25 name=\"query\" value=\"$query\">\n"
        . "<input type=\"submit\" value=\"Search...\">\n"
        . "</form>\n"
        . "</center>\n"
        . "<a href=\"http://www.skytouch.com/\"><img align=\"right\" alt=\"Designed by...\" src=\"http://www.skytouch.com/images/skytouch-mini.gif\" border=\"0\"></a>"
        . "<hr size=1>\n";
        
    if (length($email) > 0)
    {
        print "<font size=-1>Send questions and/or comments to <a href=\"mailto:$email\">$email</a></font>\n";
    }
    
    print "</body>\n"
        . "</html>\n";
}


sub error
{
    &printResult("<blockquote>\n@_\n</blockquote>\n");
    exit(1);
}


sub validate
{
    local($u) = @_;
    foreach (@users)
    {
        if ($_ eq $u)
        {
             return 1;
        }
    }
    return 0;
}
