#!/usr/bin/perl

############################################################
#
#	Recommendation script
#	Copyright, 1999. Jim Melanson
#	webmaster@thebeaches.to
#
############################################################
#
#	NOTICE: This script requires the use of the Perl Module
#	called --  Text::Wrap
#
#	If it's not installed on your server, the program won't work.
#
#############################################################
#
#	Setup: Follow the instructions with each variable as you define
#	that variable (below) and the program will be ready to run.
#
#	To access the program so that someone can use it, simply link
#	to the full URL to the program as it is on your server.
#
#	To add, change or delete the "canned" message that is delivered
#	with each email, add: ?admin
#	to the end of the URL to the program.
#
##############################################################

$Data = "/home/programm/HTML/cgilogs/recommender";
	# You need to create a directory outside of your cgi-bin where
	# the program can store it's data file. Once you have created
	# this directory, the directory and it's parent directories must
	# all be CHMOD 777.
	#
	# This variable, $Data, will be the absolute path to the
	# data directory that you create.

$MailProgram = "/usr/sbin/sendmail";
	# This is the absolute path to the Unix Senmail program on your
	# server. If you don't know yours, try the one above as it's
	# fairly standard. If it doesn't work then contact your SysAdmin
	# or ISP to get the correct path. Note that this var does not
	# end in a trailing slash.

$AdminEmail = "webmaster\@programmers-club.com";
	# This is your email address. Note that the @ symbol must be
	# escaped by putting a back slash in front of it.

$SiteName = "Programs For Sale (Programmers-Club.Com)";
	# This is the name of the site that will be delivered with
	# the email invitation.

$ReDirectLink = "http://www.programmers-club.com/programs/index.shtml";
	# This is the URL that you want the invited person to receive
	# in their email. This can be any combination of text & URL.

$offset = -4;
	# This is your offset from GMT, in hours.

$Pass = "Pt6KL5h";
	# Only very basic password protection here. Set this variable
	# to whatever password you want to have.

$FONT = "<FONT SIZE=\"-1\" FACE=\"verdana,helvetica,arial\">";

############################################################

$ScriptURL = "http://$ENV{'SERVER_NAME'}$ENV{'SCRIPT_NAME'}";

&Parse;
&Date;

if($ENV{'QUERY_STRING'} =~ /^admin/) {
    &Admin;
}
elsif(%FORM) {
    use Text::Wrap;
    $Text::Wrap::columns = 65;
    $pre1 = "\t";
    $pre2 = "\t";
    if($FORM{'send_to'} && $FORM{'send_from'}) {
	   if(&CheckEmail($FORM{'send_from'})) {
		if($FORM{'send_to'} =~ /\w +\w/) {
		    @temp_sends = split(/ +/, $FORM{'send_to'});
		} else {
		    push(@temp_sends, $FORM{'send_to'});
		}
		foreach $temp_send (@temp_sends) {
		    if(&CheckEmail($temp_send)) {
			push(@sends, $temp_send);
		    } else {
			push(@bad_sends, $temp_send);
		    }
		}
		if(open(CAN, "<$Data/canned.file")) {
		    flock(CAN, '1');
		    @canned = <CAN>;
		    close(CAN);
		    chop($canned[0]);
		    $canned[0] =~ s/!LBCR!/\n/g;
		}
		foreach $send (@sends) {
		    if(open(MAIL, "|$MailProgram -t")) {
		    	print MAIL "To: $send\n";
		    	print MAIL "From: $FORM{'send_from'}\n";
		    	print MAIL "Subject: An Invitation from a friend\n\n";

		    	print MAIL "Hello,\n\n";
		    	print MAIL "This invitation to visit the\n";
		    	print MAIL "$SiteName was sent to you by:\n\n";

		    	print MAIL "$FORM{'name'} ($FORM{'send_from'})\n\n";

	            	print MAIL wrap($pre1, $pre2, $FORM{'comments'});

		    	if(@canned) {
                            print MAIL wrap($pre1, $pre2, $canned[$a]);
		    	}

		    	print MAIL "\n\nHere is the link to the site:\n\n";
		    	print MAIL "$ReDirectLink\n\n";

		    	print MAIL "\n\nSite Recommender V1.0\n";
			print MAIL "Copyright $ThisYear, Jim Melanson\n";
			print MAIL "webmaster\@thebeaches.to\n\n";
		    	close(MAIL);
		    }
		}

		if(open(MAIL, "|$MailProgram -t")) {
		    print MAIL "To: $FORM{'send_from'}\n";
		    print MAIL "From: $AdminEmail\n";
		    print MAIL "Subject: Invitation Sent!\n\n";

		    print MAIL "Your invitation to visit our site\n";
		    print MAIL "has been sent to:\n";
		    foreach $send (@sends) {
		        print MAIL "$send\n";
		    }
		    print MAIL "\nHere is the link to the site:\n\n";
		    print MAIL "$ReDirectLink\n\n";

		    print MAIL "Thank you for recommending $SiteName!\n";
		    print MAIL "\n\nSite Recommender V1.0\n";
		    print MAIL "Copyright $ThisYear, Jim Melanson\n";
		    print MAIL "webmaster\@thebeaches.to\n\n";
		    close(MAIL);
		}

		if(open(MAIL, "|$MailProgram -t")) {
		    print MAIL "To: $AdminEmail\n";
		    print MAIL "From: $AdminEmail\n";
		    print MAIL "Subject: Recommendation Delivery Notice\n\n";

		    print MAIL "on $date at $time\n\n";
		    print MAIL "Site Visitor $FORM{'send_from'}\n";
		    print MAIL "sent a membership invitation to:\n";
		    foreach $send (@sends) {
		        print MAIL "$send\n";
		    }
		    print MAIL "\n\nSite Recommender V1.0\n";
		    print MAIL "Copyright $ThisYear, Jim Melanson\n";
		    print MAIL "webmaster\@thebeaches.to\n\n";
		    close(MAIL);
		}
		if(@bad_sends) {
    		    &PrintHead;
    		    print "<CENTER><B>One or more of the email addresses you entered<BR>\n";
    		    print "was not in a valid e-mail address format.<P>\n";
    		    print "Please correct the addresses listed below and re-submit!<P>\n";
		    print "<TABLE BORDER=0><TR><TD>$FONT<OL>\n";
		    foreach $bad (@bad_sends) {
			print "<LI>$bad\n";
		    }
		    print "</OL></FONT></TD></TR></TABLE><P>\n";
		    print "<FORM ACTION=\"$ScriptURL\" METHOD=\"POST\">\n";
    		    print "<CENTER><TABLE BORDER=0>\n";
    		    print "<TR><TD ALIGN=\"RIGHT\">$FONT<B>Send this to (E-Mail):</B></FONT></TD><TD><INPUT TYPE=\"TEXT\" NAME=\"send_to\" SIZE=40></TD></TR>\n";
    		    print "<TR><TD ALIGN=\"RIGHT\">$FONT<B>My name is:</B></FONT></TD><TD><INPUT TYPE=\"TEXT\" NAME=\"name\" VALUE=\"$FORM{'name'}\" SIZE=40></TD></TR>\n";
    		    print "<TR><TD ALIGN=\"RIGHT\">$FONT<B>My E-Mail is:</B></FONT></TD><TD><INPUT TYPE=\"TEXT\" NAME=\"send_from\" VALUE=\"$FORM{'send_from'}\" SIZE=40></TD></TR>\n";
    		    print "<TR><TD COLSPAN=2>$FONT<B>Comments:</B></FONT><BR><TEXTAREA NAME=\"comments\" COLS=55 ROWS=4>$FORM{'comments'}</TEXTAREA></TD></TR>\n";
    		    print "</TABLE><P><INPUT TYPE=\"SUBMIT\" VALUE=\"Send Recommendation\"></FORM><P>\n";
    		    &PrintFoot;
		} else {
		    &PrintHead;
		    print "<CENTER><B>Thank You! Your E-Mail invitation has been sent!</B><P>\n";
	 	    print "<A HREF=\"$ScriptURL\">Send Another Invitation?</A><BR><BR><BR><BR><BR><BR>\n";
		    &PrintFoot;
		}
	    } else {
		$Problem = "your e-mail address was not in a valid email address format. Please go back and correct it.";
		&Error($Problem);
	   }
    } else {
	$Problem = "you forgot to enter one or both of the e-mail addresses. Both your e-mail address and the recipients e-mail address are required.";
	&Error($Problem);
    }
} else {
    &PrintHead;
    print "Enter the e-mail address of the person you want to invite to our site\n";
    print "along with your name and e-mail. You can even add some comments if you would\n";
    print "like to!<P>\n";

    print "<FORM ACTION=\"$ScriptURL\" METHOD=\"POST\">\n";
    print "<CENTER><TABLE BORDER=0>\n";
    print "<TR><TD>$FONT<B>Send this to (E-Mail):</B></FONT><BR><INPUT TYPE=\"TEXT\" NAME=\"send_to\" SIZE=40><P></TD></TR>\n";
    print "<TR><TD>$FONT<B>My name is:</B></FONT><BR><INPUT TYPE=\"TEXT\" NAME=\"name\" SIZE=40><P></TD></TR>\n";
    print "<TR><TD>$FONT<B>My E-Mail is:</B></FONT><BR><INPUT TYPE=\"TEXT\" NAME=\"send_from\" SIZE=40><P></TD></TR>\n";
    print "<TR><TD COLSPAN=2>$FONT<B>Comments:</B></FONT><BR><TEXTAREA NAME=\"comments\" COLS=45 ROWS=6></TEXTAREA></TD></TR>\n";
    print "</TABLE><P><INPUT TYPE=\"SUBMIT\" VALUE=\"Send Invitation\"></FORM><P>\n";
    &PrintFoot;
}

sub Admin {
    if($FORM{'pass'} eq $Pass) {
        if($ENV{'QUERY_STRING'} =~ /^admin_update/) {
	    if($FORM{'deletemessage'} == 2) {
		unlink("$Data/canned.file");
		$ENV{'QUERY_STRING'} = 'admin';
		&Admin;
	    } else {
	        open(CAN, ">$Data/canned.file");
		flock(CAN, '1');
		print CAN "$FORM{'message'}\n";
		close(CAN);
		$ENV{'QUERY_STRING'} = 'admin';
		&Admin;
	    }
        } else {
	    if(open(CAN, "<$Data/canned.file")) {
	  	    flock(CAN, '1');
		    @canned = <CAN>;
		    close(CAN);
		    chop($canned[0]);
		    $canned[0] =~ s/!LBCR!/\n/g;
		    $content = $canned[0];
	    }
	    &PrintHead;
	    print "<FORM ACTION=\"$ScriptURL?admin_update\" METHOD=\"POST\">\n";
	    print "<INPUT TYPE=\"HIDDEN\" NAME=\"pass\" VALUE=\"$FORM{'pass'}\">\n";
	    print "<BLOCKQUOTE><B>Make your additions or changes to the canned message\n";
	    print "on this form. If you wish to delete the entire message so that\n";
	    print "no message appears on the mailings, simply check the \"Delete Message\" box\n";
	    print "and submit the form!</B><P>\n";
	    print "<INPUT TYPE=\"CHECKBOX\" NAME=\"deletemessage\" VALUE=\"2\"><FONT COLOR=\"RED\">Delete Message</FONT><P>\n";
	    print "<TEXTAREA NAME=\"message\" COLS=60 ROWS=10>\n";
	    if($content) {
		print "$content\n";
	    }
	    print "</TEXTAREA><P><INPUT TYPE=\"SUBMIT\" VALUE=\"Update!\"></FORM><P>\n";
	    &PrintFoot;
        }
    } else {
	&PrintHead;
	print "<CENTER><B>Administration Login<P>\n";
	print "<FORM ACTION=\"$ScriptURL?admin\" METHOD=\"POST\">\n";
	print "Password:<INPUT TYPE=\"PASSWORD\" NAME=\"pass\" SIZE=10><INPUT TYPE=\"SUBMIT\" VALUE=\"Login\">\n";
	print "</FORM><BR><BR><BR><BR><BR><BR>\n";
	&PrintFoot;
    }
}

sub Parse {
    local($name, $value, $buffer, $pair, $hold, @pairs);
    %FORM = ();

    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    @pairs = split(/&/, $buffer);
    foreach $pair (@pairs) {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	if($name eq 'message') {
	    $value =~ s/\n/!LBCR!/g;
	} else {
	    unless($name eq 'comments') {
	        $value =~ s/\n//g;
	    }
 	}

      #This section checks the value portion (user input) of
      #all name/value pairs.
	#$value =~ s/<([^>]|\n)*>//g;    #Remove this tag to permit HTML tags
	#$value =~ s/<.*>?//g;		#Remove this tag to permit HTML tags
	$value =~ s/<!--(.|\n)*-->//g;
	$value =~ s/\s-\w.+//g;
	$value =~ s/system\(.+//g;
	$value =~ s/grep//g;
	$value =~ s/\srm\s//g;
	$value =~ s/\srf\s//g;
	$value =~ s/\smkdir\s//g;
	$value =~ s/\srmdir\s//g;
	$value =~ s/\.\.([\/\:]|$)//g;
	$value =~ s/< *((SCRIPT)|(APPLET)|(EMBED))[^>]+>//ig;

      #This section checks the value portion (from element name) of
      #all name/value pairs. This was included to prevent any nasty
      #surprises from those who would hijack you forms!
        $name =~ s/<.*>?//g;
	$name =~ s/<!--(.|\n)*-->//g;
	$name =~ s/^\s-\w.+//g;
	$name =~ s/system\(.+//g;
	$name =~ s/grep//g;
	$name =~ s/\srm\s//g;
	$name =~ s/\srf\s//g;
	$name =~ s/\smkdir\s//g;
	$name =~ s/\srmdir\s//g;
	$name =~ s/\.\.([\/\:]|$)//g;
	$name =~ s/< *((SCRIPT)|(APPLET)|(EMBED))[^>]+>//ig;

	$FORM{$name} = $value;
    }
}

sub Date {
    #This is your offset from GMT. Can either be a positive value
    #for ahead of GMT or a negative value for behind GMT. Do Not put
    #this value in brackets. For example, my town of Pefferlaw is just
    #north of Toronto, Ontario, Canada which is four hours behind GMT.
    #Therefore I set an offset of -4 (for GMT minus four hours).
    #If I were in Paris, I would set it to 1 because my local time would
    #be one hour ahead of GMT (GMT + one hour).

    $offset_val = ($offset * 3600);
    ($Second, $Minute, $Hour, $DayOfMonth, $Month, $Year, $Weekday,
	    $DayOfYear, $IsDST) = gmtime(time + $offset_val);
    @MonthArray = ('January', 'February', 'March', 'April',
    			'May', 'June', 'July', 'August',
		   	'September', 'October', 'November', 'December');
    @DayArray = ('Sunday', 'Monday', 'Tuesday', 'Wednesday',
			'Thursday', 'Friday', 'Saturday');
    $ThisYear = $Year + 1900;

    $WordMonth = $MonthArray[$Month];
    $Month++;
    if($Month < 10) {$Month = "0" . $Month}

    $WordDay = $DayArray[$Weekday];
    $AbsDayOfMonth = $DayOfMonth;
    if($DayOfMonth =~ /1$/) {$ext = "st"}
    elsif($DayOfMonth =~ /2$/) {$ext = "nd"}
    elsif($DayOfMonth =~ /3$/) {$ext = "rd"}
    else {$ext = "th"}
    if($DayOfMonth < 10) {$DayOfMonth = "0" . $DayOfMonth}

    if($Hour < 10) {$Hour = "0" . $Hour}
    $Hour24 = $Hour;
    if($Hour > 12) {
 	$Hour12 = $Hour - 12;
	if($Hour12 < 10) {$Hour12 = "0" . $Hour12}
    } else {
        $Hour12 = $Hour;
    }

    if($Minute < 10) {$Minute = "0" . $Minute}
    if($Second < 10) {$Second = "0" . $Second}
    if($DayOfMonth =~ /1$/) {$ext = "st"}
    elsif($DayOfMonth =~ /2$/) {$ext = "nd"}
    elsif($DayOfMonth =~ /3$/) {$ext = "rd"}
    else {$ext = "th"}
    $date = "$ThisYear/$Month/$DayOfMonth";
    $time = "$Hour12:$Minute:$Second";

    $get_pid = $$;
    $length_pid = length($get_pid);
    if($length > 10) {
	$start_cut = $length - 10;
	$pid = substr($get_pid, $start_cut, 10);
    } else {
	$pid = $get_pid;
    }
    $pid_date = "$ThisYear$Month$DayOfMonth$pid";
}

sub CheckEmail {
    local($EMAIL) = @_[0];

    if($EMAIL) {
        if(($EMAIL =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)|(\.$)/) ||
	    ($EMAIL !~ /^.+@\[?(\w|[-.])+\.[a-zA-Z]{2,3}|[0-9]{1,3}\]?$/)) {
	    return(0);
        }
        else {return(1)}
    }
    else {
    	return(0);
    }
}

sub Error {
    $cause = $_[0];
    &PrintHead('An Error Has Occured');
    print "An error was detected. The error occured because $cause<P>\n";
    &PrintFoot;
}

sub PrintHead {
    print "Content-type: text/html\n\n";

    print "<HEAD><TITLE>Site Recommender</TITLE></HEAD>\n";
    print "<BODY TEXT=\"#330066\" LINK=\"#336666\" ALINK=\"#336666\" VLINK=\"#336666\" BGCOLOR=\"#FFFFE3\">\n";
    print "<FONT SIZE=\"-1\" FACE=\"verdana, arial, helvetica\">\n";
}

sub PrintFoot {
    print "<center><HR WIDTH=55%><FONT SIZE=\"-2\" FACE=\"verdana, arial, helvetica\">\n";
    print "<A HREF=\"mailto:webmaster\@thebeaches.to\">&copy;1999, Jim Melanson</A>\n";
    print "<P></BODY></HTML>\n";
}


