#!/usr/bin/perl -Tw

$| = 1;

use strict;
use CGI;
use DBI;
use HTML::Template;

require "./pcard-setup.pl";

# Import global variables that are defined in the setup file:
use vars qw($imgpath $pcardimgs $cgipath);

# Check if the referrer is allowed to run this script
&check_url;

my $query = new CGI;

# Get the input from the form 
my $card       = $query->param("card");
my $card_th    = $card;
my $bg_color   = $query->param("bg_color");
my $text_color = $query->param("text_color");
my $postalid   = $query->cookie(-name=>'POSTALID');

my ($sid, $sender, $semail, $command, $sth, $dbh, $result);

# Import database access variables from setup file
use vars qw($driver $server $port $database $db_user $db_pass);

if ($card eq ""){
   &error('no_card_selected');
}

# The thumbnail of "image.ext" is called "image_th.ext"
$card_th =~ s/([^\.]*)\.([^\.]*)/$1_th.$2/g;

my ($Day,$Month,$Year);

# get_date is defined in pcard-setup
my $now = &get_date;
if ($now =~ /([0-9]+)-([0-9]+)-([0-9]+)/) {
   $Day   = $3;
   $Month = $2;
   $Year  = $1;
}

# if we have a cookie get sender info from the database

if ($postalid ne "") {
   # we have an id, get the sender name and email from the database

   $dbh = DBI->connect("DBI:$driver:$database:$server:$port",$db_user,$db_pass);
              die "DBI error from connect:", $DBI::errstr unless $dbh;

   $sid = $postalid;
   $command  = "select sender,semail from senders where id = $sid";

   $sth = $dbh->prepare($command);
           die "DBI error with prepare:", $sth->errstr unless $sth;

   $result = $sth->execute;
         die "DBI error with execute:", $sth->errstr unless $result;

   ($sender, $semail) = $sth->fetchrow;

   $sth->finish;
   $dbh->disconnect;

}

# open the html template
my $template = HTML::Template->new(filename => './pages/write-card.html');

# fill in the parameters
$template->param(
   Day        => $Day,
   Month      => $Month,
   Year       => $Year,
   imgpath    => $imgpath,
   cgipath    => $cgipath,
   card       => $card,
   sender     => $sender,
   semail     => $semail
);

print $query->header();
print $template->output;
exit;








