#!/usr/bin/perl -Tw

$| = 1;

use strict;
use CGI;
use DBI;
use HTML::Template;

require "./pcard-setup.pl";

# Import global variables that are defined in the setup file:
use vars qw($imgpath $pcardimgs $home $cgipath $domain $noIDerror $wrongIDerror);

# Import database access variables from setup file:
use vars qw($driver $server $port $database $db_user $db_pass);

my ($command,$sth,$dbh,$result,$sender,$semail,$recipient,$remail,$card,
         $message,$in_date,$retrieved,$bg_color,$text_color,$greeting,$id);        

my $query = new CGI;

# ID number provided via GET method in query string as "ID"
$id = $query->param("ID");

# If no ID number was in the query string (or something else,
# not a number), give a message with retry option

if ($id !~ /^[0-9]+$/){
    &error($noIDerror);
    exit;
}

$command = "select s.sender,semail,recipient,remail,card,greeting,message,bg_color,text_color,retrieved,in_date
             from senders s, postcards p where p.id = $id and p.sender = s.id";

$dbh = DBI->connect("DBI:$driver:$database:$server:$port",$db_user,$db_pass);
              die "DBI error from connect:", $DBI::errstr unless $dbh;

$sth = $dbh->prepare($command);
           die "DBI error with prepare:", $sth->errstr unless $sth;

my $result = $sth->execute;
         die "DBI error with execute:", $sth->errstr unless $result;

my @arr = ();

while (@arr = $sth->fetchrow){
    ($sender,$semail,$recipient,$remail,$card,$greeting,$message,$bg_color,$text_color,$retrieved,$in_date) = @arr;
}

if ($semail eq ""){
    &error($wrongIDerror);
    exit;
}

if ($in_date =~ /([0-9]+)-([0-9]+)-([0-9]+)/) {
   $in_date = "$2/$3/$1";
}

# Warn the sender that the recipient has picked up the card (first time only)
if ($retrieved == 0) {
   &pickup_notification($semail,$sender,$remail,$recipient,$in_date);
}

$command = "update postcards set retrieved = (retrieved + 1) where id = $id";

$sth = $dbh->prepare($command);
           die "DBI error with prepare:", $sth->errstr unless $sth;

$result = $sth->execute;
           die "DBI error with execute:", $sth->errstr unless $result;

$sth->finish;
$dbh->disconnect;

# open the html template
my $template = HTML::Template->new(filename => './pages/show-card.html');

# fill in the parameters
$template->param(
   greeting   => $greeting,
   bg_color   => $bg_color,
   text_color => $text_color,
   pcardimgs  => $pcardimgs,
   card       => $card,
   message    => $message,
   sender     => $sender,
   semail     => $semail,
   home       => $home,
   imgpath    => $imgpath
);

print $query->header();
print $template->output;
exit;
