#!/usr/bin/perl -Tw

$| = 1;

use strict;
use CGI;
use DBI;
use HTML::Template;

require "./pcard-setup.pl";

# Import global variables that are defined in the setup file
use vars qw($imgpath $pcardimgs $home $cgipath $domain);

# Import database access variables from setup file
use vars qw($driver $server $port $database $db_user $db_pass);

# Check if the referer is allowed to run this script
&check_url;

my $query         = new CGI;
my $bg_color      = $query->param("bg_color");
my $text_color    = $query->param("text_color");
my $day_to_send   = $query->param("day_to_send");
my $month_to_send = $query->param("month_to_send");
my $year_to_send  = $query->param("year_to_send");
my $sender        = $query->param("sender");
my $semail        = $query->param("semail");
my $recipient     = $query->param("recipient");
my $remail        = $query->param("remail");
my $card          = $query->param("card");
my $greeting      = $query->param("greeting");
my $message       = $query->param("message");
my $postalid      = $query->cookie(-name=>'POSTALID');
my $retrieved     = -1;

my ($sdate,$to_send_message,$command,$sth,$dbh,$result);
my ($sid, $insender, $insemail);

# dbsender, dbsemail is how we save (have saved) sender name
# and email in the database
my $dbsender = caplower($sender);
my $dbsemail = lc($semail);

$dbh = DBI->connect("DBI:$driver:$database:$server:$port",$db_user,$db_pass);
              die "DBI error from connect:", $DBI::errstr unless $dbh;

# Check if we have the sender id from the cookie

if ($postalid ne "") {

   # we have an id from the cookie, get the sender name and email from the database
   $sid = $postalid;
   $command  = "select sender,semail from senders where id = $sid";

   $sth = $dbh->prepare($command);
           die "DBI error with prepare:", $sth->errstr unless $sth;

   $result = $sth->execute;
         die "DBI error with execute:", $sth->errstr unless $result;

   ($insender, $insemail) = $sth->fetchrow;

} else {
   
   # no cookie, search for the email address in the database
   $command  = "select id,sender,semail from senders where semail = '$dbsemail'";

   $sth = $dbh->prepare($command);
           die "DBI error with prepare:", $sth->errstr unless $sth;

   $result = $sth->execute;
         die "DBI error with execute:", $sth->errstr unless $result;

   ($sid, $insender, $insemail) = $sth->fetchrow;

}

if ($dbsemail eq $insemail) {

   # We found sender email from database equal to email given   
   if ($dbsender ne $insender) {
      # The name given is not the same, update the name in the database
      $command  = "update senders set sender = '$dbsender' where id = $sid";
      $sth = $dbh->prepare($command);
             die "DBI error with prepare:", $sth->errstr unless $sth;

      $result = $sth->execute;
             die "DBI error with execute:", $sth->errstr unless $result;
   }

} else {

   # New data to save sender name and email in the database
   $command = "insert into senders (sender, semail) values ('$sender', '$semail')";

   $sth = $dbh->prepare($command);
            die "DBI error with prepare:", $sth->errstr unless $sth;

   $result = $sth->execute;
            die "DBI error with execute:", $sth->errstr unless $result;

   # get the id of the sender (auto-increment column table senders)
   $command = "select last_insert_id()";

   $sth = $dbh->prepare($command);
           die "DBI error with prepare:", $sth->errstr unless $sth;

   $result = $sth->execute;
         die "DBI error with execute:", $sth->errstr unless $result;

   # the sender id
   $sid = $sth->fetchrow;

}


# Note that the "sdate" date is the date that the message should be (or has been) sent.
# As a check to see whether the message was really sent or not, as we send the message,
# "retrieved" passes from -1 to 0.

my $db_date = &get_date;
$sdate = $year_to_send . "-" . $month_to_send . "-" . $day_to_send;

# Generate a (more or less) random id number for the database
srand (time ^ $$ ^ unpack "%32L*", 'ps axww | gzip');

my $id =  (int(rand 99) + 1) * (int(rand 99) + 1) * (int(rand 99) + 1);

if ($sdate eq $db_date){
    $retrieved = 0;
}


$command = "insert into postcards (
    id, sender, recipient,   remail,   card,   message,   in_date,
             bg_color,   text_color,   greeting,   sdate,   retrieved
 ) values (
   $id,'$sid','$recipient','$remail','$card','$message','$db_date',
           '$bg_color','$text_color','$greeting','$sdate','$retrieved'
 )";

$sth = $dbh->prepare($command);
           die "DBI error with prepare:", $sth->errstr unless $sth;

$result = $sth->execute;
         die "DBI error with execute:", $sth->errstr unless $result;

# increment the number of cards sent by this user
$command = "update senders set cards =  (cards + 1) where id = '$sid'";

$sth = $dbh->prepare($command);
           die "DBI error with prepare:", $sth->errstr unless $sth;

$result = $sth->execute;
         die "DBI error with execute:", $sth->errstr unless $result;


$sth->finish;
$dbh->disconnect;

# Send the email now or quit with a message saying when it'll be sent
if ($sdate eq $db_date){
    &pcard_notification($remail,$recipient,$id);
} else {
    $sdate =~ s~([0-9]+)-([0-9]+)-([0-9]+)~$2/$3/$1~g;
    $to_send_message = "<p align=center>The message will be sent on $sdate";
}

# open the html template
my $template = HTML::Template->new(filename => './pages/send-card.html');

# fill in the parameters
$template->param(
   imgpath         => $imgpath,
   to_send_message => $to_send_message,
   home            => $home
);

# For the cookie, find the domain (add a dot in front in case of only one dot)
my $c_domain = $domain;
$c_domain =~ s/^http:\/\/([^\/]+).*$/$1/g ;
if ( $c_domain !~ /([^\.]+)\.([^\.]+)\.([^\.]+)/) {
   $c_domain = ".".$c_domain;
}

# create a cookie that identifies the sender
my $cookie = $query->cookie(-name    => 'POSTALID',
			    -value   => $sid,
			    -expires => '+1y',
			    -path    => '/',
			    -domain  => $c_domain);

print $query->header(-cookie=>$cookie);
print $template->output;
exit;






