#!/usr/bin/perl -Tw

$| = 1;

use strict;
use CGI;
use HTML::Template;

require "./pcard-setup.pl";

# Import global variables that are defined in the setup file:
use vars qw($imgpath $pcardimgs $home $cgipath);

# Check if the referrer is allowed to run this script
&check_url;

my $query = new CGI;

# Get the input from the form
my $card  = $query->param("card");

# If no postcard was selected, redirect to the start page
if ($card eq "") {
    print "Location: $home\n\n";
    exit;
}

# open the html template
my $template = HTML::Template->new(filename => './pages/select-card.html');

# fill in the parameters
$template->param(
   pcardimgs     => $pcardimgs,
   card          => $card,
   cgipath       => $cgipath,
   imgpath       => $imgpath,
);

print $query->header();
print $template->output;
exit;
