#!/usr/bin/perl -Tw

$| = 1;

use strict;
use CGI;
use HTML::Template;

require "./pcard-setup.pl";

# Import global variables that are defined in the setup file:
use vars qw($imgpath $pcardimgs $home $cgipath);

# Check if the referrer is allowed to run this script
&check_url;

my $query = new CGI;

# Get the input from the form
my $bg_color      = $query->param("bg_color");
my $text_color    = $query->param("text_color");
my $day_to_send   = $query->param("day_to_send");
my $month_to_send = $query->param("month_to_send");
my $year_to_send  = $query->param("year_to_send");
my $sender        = $query->param("sender");
my $semail        = $query->param("semail");
my $recipient     = $query->param("recipient");
my $remail        = $query->param("remail");
my $card          = $query->param("card");
my $greeting      = $query->param("greeting");
my $message       = $query->param("message");
my $missing_list  = "";

# If no postcard was selected, redirect to the start page
if ($card eq "") {
    print "Location: $home\n\n";
    exit;
}

# Gather all required fields that are empty
if ($sender eq "") {
    $missing_list .= "Sender name<br>";
}
if ($semail eq "") {
    $missing_list .= "Sender email<br>";
}
if ($recipient eq "") {
    $missing_list .= "Recipient name<br>  ";
}
if ($remail eq "") {
    $missing_list .= "Recipient email<br>";
}
if ($greeting eq "") {
    $missing_list .= "Greeting<br>";
}

# Give the error message, listing the empty fields
if ($missing_list ne ""){
   my $errortext = "<h3>Error: Missing Fields</h3>";
   $errortext .= "The following fields are empty:<p>$missing_list";
   $errortext .= "<p>Please go back and fill in these fields.";
   &error($errortext);
}

# Check the syntax of the given email addresses
if (!&check_email($semail) || !&check_email($remail)){
    &error('invalid_email');
} 

# Clean up a little
$message =~ s/\r//g;
$message =~ s/\t/ /g;
$message =~ s/\n/<br>/g;


# Send now or later?
my $today = &get_date;
my $send_date = $month_to_send . "/" . $day_to_send . "/" . $year_to_send;
if ($today eq $year_to_send . "-" . $month_to_send . "-" . $day_to_send) {
    $send_date = "now";
}

# open the html template
my $template = HTML::Template->new(filename => './pages/preview-card.html');

# fill in the parameters
$template->param(
   greeting      => $greeting,
   bg_color      => $bg_color,
   text_color    => $text_color,
   pcardimgs     => $pcardimgs,
   card          => $card,
   message       => $message,
   cgipath       => $cgipath,
   day_to_send   => $day_to_send,
   month_to_send => $month_to_send,
   year_to_send  => $year_to_send,
   sender        => $sender,
   semail        => $semail,
   recipient     => $recipient,
   remail        => $remail,
   imgpath       => $imgpath,
   send_date     => $send_date
);

print $query->header();
print $template->output;
exit;
