## ############################################## ##
##                                                ##
## Global variables. You will have to edit these  ##
##                                                ##
## ############################################## ##

# Your domain (no trailing slashes)
$domain = "http://www.yourdomain.com";

# Where your static start page is (can be full URL)
$home = "/postcards/example.html";

# Where your images (other than postcards) are   
$imgpath = "/postcards/images";

# Where your postcards and their thumbnails are
$pcardimgs = "/postcards/pcards";

# Where your scripts are
$cgipath = "/cgi-bin/pcards";

# The address of the database server
$server = "localhost";

# The port if different from default
$port = "";

# The DBI driver to use (mysql, mSQL, ...)
$driver = "mysql";

# The name of the database
$database = "pcards";

# The username and password to connect, as defined in your database
$db_user = "";
$db_pass = "";

# Number of days the postcard will stay in the database after
# the notification message has been sent
$delete_after = 31;

# Location of your mail programme (e.g. sendmail)
$mailprog = '/usr/sbin/sendmail';

# From address used in email messages
$from_address = 'postcards@www.yourdomain.com'; 

# Not to allow just anybody on the net to run your scripts, give 
# here the names and aliases (ip) of the domains that are allowed
@referers = ('localhost','127.0.0.1','www.yourdomain.com');

# Error message when there is no ID on the GET query string in show-card.pl
$noIDerror = qq~
    <FONT SIZE ="3">Oops! No ID number given!</FONT>
    <P>When you have received a postcard you need an ID-number to see it, 
       the ID-number is given in the Email you received at the end 
       of the URL.<br>You can give the ID number below and try again. 
    <FORM METHOD="GET" ACTION = "$cgipath/show-card.pl">
    <INPUT TYPE = "TEXT" SIZE = 10 NAME="ID">
    <INPUT TYPE = "SUBMIT" VALUE="Try again">
    </FORM>~;

# Error message when a wrong ID is given to show-card.pl
$wrongIDerror = qq~
    <FONT SIZE ="3">Oops! Wrong ID number given!</FONT>
    <P>When you have received a postcard you need an ID-number
       to see it, the ID-number is given in the Email you received at the end 
       of the URL.<br> You can give the ID number below and try again. 
    <FORM METHOD="GET" ACTION = "$cgipath/show-card.pl">
    <INPUT TYPE = "TEXT" SIZE = 10 NAME="ID">
    <INPUT TYPE = "SUBMIT" VALUE="Try again">
    </FORM>~;


# You may want to edit the text of the email messages in the next
# two functions

sub pcard_notification {
    my ($email,$name,$id_number) = @_;

    # To avoid taint checking error
    $ENV{PATH} = "";

    open(MAIL,"|$mailprog -t");    
    print MAIL "To: $email ($name)\n";
    print MAIL "From: $from_address\n";
    
    # Change subject and message text here:
    print MAIL "Subject: An Electronic Postcard has been sent to You!\n\n";    
    print MAIL "\nAn Electronic Postcard has been sent to You!\n\n";
    print MAIL "Go to the following internet address:\n\n";
    print MAIL "$domain$cgipath/show-card.pl?ID=$id_number\n\n";
    print MAIL "to see the postcard and the message.\n";
    close (MAIL);
}
# end pcard_notification

sub pickup_notification {
    my ($sender_email,$sender_name,$recipient_email,$recipient_name,$in_date) = @_;

    # To avoid taint checking error
    $ENV{PATH} = "";
    open(MAIL,"|$mailprog -t");    
    print MAIL "To: $sender_email ($sender_name)\n";
    print MAIL "From: $from_address\n";

    # Change subject and message text here:
    print MAIL "Subject: $recipient_name has picked up your postcard.\n\n";    
    print MAIL "\n$recipient_name ($recipient_email) has picked up the postcard\n";
    print MAIL "that you sent on $in_date from $domain.\n\n";
    close (MAIL);
}
# end pickup_notification

## DO NOT FORGET TO EDIT cron-card.pl, AND PUT THE FULL
## PATH TO THIS FILE (pcard-setup.pl) WHERE THAT IS INDICATED

## ########################################### ##
##                                             ##
##  NO FURTHER EDITING IS SHOULD BE NECESSARY  ##
##         (but go ahead if you like)          ## 
##                                             ##
## ########################################### ##


##  Check referrer 

sub check_url {
    my $check_referer = 0;
    my $referer = "";

    if ($ENV{'HTTP_REFERER'}) {
        foreach $referer (@referers) {
            if ($ENV{'HTTP_REFERER'} =~ m|https?://([^/]*)$referer|i) {
                $check_referer = 1;
                last;
            }
        }
    } else {
        $check_referer = 1;
    }
    if ($check_referer != 1) { 
            &error('bad_referer') 
    }
}
# end check_url

##  Get current date, "YYYY-MM-DD" format

sub get_date {
    my ($mday,$mon,$year) = (localtime(time))[3,4,5];
    $year = (1900 + $year);
    $mon++;
    my $date = "$year-$mon-$mday";
    return $date;
}
# end get_date

## Purge the database

sub purge_db {
    # Delete postcards whose notification message has been sent $delete_after days ago or more
    my $deldate = ($delete_after * 86400);
    my ($mday,$mon,$year) = (localtime((time - $deldate)))[3,4,5];
    $year = (1900 + $year);
    $mon++;
    $deldate = "$year-$mon-$mday";

    my $dbh = DBI->connect("DBI:$driver:$database:$server:$port",$db_user,$db_pass);
              die "DBI error from connect:", $DBI::errstr unless $dbh;

    my $command = "delete from postcards where sdate < \"$deldate\"";

    my $sth = $dbh->prepare($command);
              die "DBI error with prepare:", $sth->errstr unless $sth;

    my $result = $sth->execute;
              die "DBI error with execute:", $sth->errstr unless $result;

    $sth->finish;
    $dbh->disconnect;
}
# end purge_db 

##  Display error message

sub error { 
    my $error = shift;
    my ($host,$missing_field,$missing_field_list,$errortext);
    if ($error eq 'bad_referer') {
        if ($ENV{'HTTP_REFERER'} =~ m|^https?://([\w\.]+)|i) {
           $host = $1;
           $errortext = "<h3>Access denied!</h3>";
           $errortext .= "$host: You have no permission to access this script.";
        } else {
           $errortext = "<h3>Access denied!</h3>";
           $errortext .= "You have no permission to access this script.";
        }
     } elsif ($error eq 'invalid_email') {
         $errortext = "<h3>Error: invalid email address</h3>";
         $errortext .= "An invalid email address was specified, please go back and correct it.";
     } else {
         $errortext = $error;
     } 

     my $template = HTML::Template->new(filename => './pages/error.html');

     # fill in the parameters
     $template->param(
        imgpath    => $imgpath,
        errortext  => $errortext
     );

     print "Content-type: text/html\n\n";
     print $template->output;
     exit;
}
# end error


## Function to lowercase a string, with first letter of each word uppercase

sub caplower {
    my $string = shift;

    $string =~ s/((^\w)|(\s\w))/\U$1/g;
    $string =~ s/([\w']+)/\u\L$1/g;
    return $string;
}
# end caplower


# Sub routine to check if a (syntactically) valid email address was specified

sub check_email {
  my $email = shift;
  if ($email =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)/ ||
      $email !~ /^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?)$/) {
      return 0;
  } else {
      return 1;
  }
}
# end check_email


1;





