#!/usr/bin/perl
#######################################################
$basepicurl = "http://www.company.com/postcard/pictures/";
$location = "http://www.company.com/postcard/";
$cgi = "http://www.company.com/postcard/card.cgi";
$cards = "$ENV{DOCUMENT_ROOT}/postcard/cards/";
$preview1 = "$ENV{DOCUMENT_ROOT}/postcard/preview1.html";
$preview2 = "$ENV{DOCUMENT_ROOT}/postcard/preview2.html";
$makecard = "$ENV{DOCUMENT_ROOT}/postcard/makecard.html";
$thank_you = "$ENV{DOCUMENT_ROOT}/postcard/thankyou.html";
$error = "$ENV{DOCUMENT_ROOT}/postcard/error.html";
$email1 = "$ENV{DOCUMENT_ROOT}/postcard/email1.txt";
$email2 = "$ENV{DOCUMENT_ROOT}/postcard/email2.txt";
$mailprog = '/usr/bin/sendmail';
$MAX_DAYS = '10';

$subject1 = "You Have A Postcard!";
$subject2 = "Thank You for using our Postcard Card";

########################################################
########################################################
# Don't Edit Passed Here			       #
########################################################
########################################################

$i=0;
read(STDIN,$buffer,$ENV{'CONTENT_LENGTH'});
if ($ENV{'QUERY_STRING'})
	{$buffer = "$buffer\&$ENV{'QUERY_STRING'}";}
@pairs = split(/&/,$buffer);
foreach $pair (@pairs){
	($name,$value) = split(/=/,$pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
	$VALUE{$name} = $value;
}

############################################
#Gets the Current Date
############################################
   ($sec,$min,$hr,$day,$month,$year,$day_of_week,$day_of_year,$some) = localtime(time);
   @months = ("Jan","Feb","March","April","May","June","July","Aug","Sept","Oct","Nov","Dec");

   $minute = $min + 10;
   $hour = $hr + 10;
   $second = $sec + 10;

   $DATE = `date +"%B-%d-%Y.dat"`; 
   chop ($DATE);

   $SHORTDATE = `date +"%B %d, %Y at %T %Z"`; 
   chop ($SHORTDATE);

############################################
#Gets Picture Data and Moves on to Next Page
############################################

if ($VALUE{'action'} eq 'preview') {

   $pic = $VALUE{'PICTURES'};
   $VALUE{'PICTURE'} = $VALUE{'PICTURES'};
   $VALUE{'PICTURES'} = "$basepicurl$pic";

 #########################
 #Prints the Preview Page
 #########################

   print "Content-type: text/html\n\n";
   open(TEMPLATE,"$preview1");
   &template;
   print $template;
exit;
  }

 #########################
 #Prints the Preview Page
 #########################
if ($VALUE{'action'} eq 'preview1') {
   $pic = $VALUE{'PICTURE'};
   $VALUE{'PICTURES'} = "$basepicurl$pic";

   $VALUE{'MESSAGE'} =~ s/\r//g;
   $VALUE{'MESSAGE'} =~ s/  /&nbsp; /g;
   $VALUE{'MESSAGE'} =~ s/\<[^\>]*\>//ig;
   $VALUE{'MESSAGE'} =~ s/\<//g;
   $VALUE{'MESSAGE'} =~ s/\>//g;
   $VALUE{'MESSAGE'} =~ s/"/'/g;
   $VALUE{'MESSAGE'} =~ s/\n/<BR>/g;


   print "Content-type: text/html\n\n";
   open(TEMPLATE,"$preview2");
   &template;
   print $template;
exit;
}

##########
#Send Card
##########
if ($VALUE{'action'} eq 'send') {
&no_email unless $VALUE{'MAILFROM'} && $VALUE{'MAILTO'};

  ######################
  #Save the Data
  ######################
   #$VALUE{'MESSAGE'} =~ s/&nbsp;/&nbsp;/g;
   $date = time;

   $create_card = "$cards$date.dat";

   open(DATA, ">>$create_card");
   print DATA "$VALUE{'SENDER'}|$VALUE{'MAILFROM'}|$VALUE{'RECIPIENT'}|$VALUE{'MAILTO'}|$VALUE{'MESSAGE'}|$VALUE{'PICTURE'}\n";
   close(DATA);

   $url_of_card = "$cgi?$date";

  ##########################
  #Print Thank You HTML
  ##########################   
   print "Content-type: text/html\n\n"; 

   open(TEMPLATE,"$thank_you");
   &template;
   print $template;

   $template = '';

  ##########################
  #Send E-mail to Recipient
  ##########################   

   open (MAIL, "|$mailprog -t") || die "Can't open $mailprog!\n";
   print MAIL "To: $VALUE{'MAILTO'} ($VALUE{'RECIPIENT'})\n";
   print MAIL "From: $VALUE{'MAILFROM'} ($VALUE{'SENDER'})\n";
   print MAIL "Subject: $subject1\n\n";

   open(TEMPLATE,"$email1");
   &template;
   print MAIL $template;

   close(MAIL);

   &delete;
   exit;
}

########################
#No E-Mail Addresses
######################## 
sub no_email {
   print "Content-type: text/html\n\n";
   print "<HTML>\n<TITLE>No Picture</TITLE>\n";
   print "<BODY BGCOLOR=#FFFFFF>\n";
   print "Could not Continue!<BR>\n";
   print "<B>[Possible Reasons:]</B><BR>\n";
   print "&nbsp;&nbsp;1.) Please make sure that you filled in both E-Mail Addresses.";
   exit;
}

#######################################
#Creates the Postcard
#######################################
if ($ENV{'QUERY_STRING'}) {

   ############################################
   #Makes Postcards and Sends Thank You E-mail
   ############################################
   $create_card = "$cards$ENV{'QUERY_STRING'}.dat";

    if(-e $create_card){
    open(DATA, "$create_card");
    @data = <DATA>;
    close(DATA);

    foreach $temp (@data){
    chop($temp);
    ($SENDER, $MAILFROM, $RECIPIENT, $MAILTO, $MESSAGE, $PICTURES) = split(/\|/, $temp);

       $VALUE{'SENDER'} = $SENDER;
       $VALUE{'MAILFROM'} = $MAILFROM;
       $VALUE{'RECIPIENT'} = $RECIPIENT;
       $VALUE{'MAILTO'} = $MAILTO;
       $VALUE{'MESSAGE'} = $MESSAGE;
       $VALUE{'MESSAGE'} =~ s/  /&nbsp; /g;
       $VALUE{'PICTURES'} = "$basepicurl$PICTURES";
       $VALUE{'LINK'} = "$link$LINK";
       $VALUE{'PICTURE'} = "$basepicurl$PICTURES";
    }
  
      print "Content-type: text/html\n\n";
      open(TEMPLATE,"$makecard");
      &template;
      print $template;

      $template = '';


   open (MAIL, "|$mailprog -t") || die "Can't open $mailprog!\n";
   print MAIL "To: $VALUE{'MAILFROM'} ($VALUE{'SENDER'})\n";
   print MAIL "From: $VALUE{'MAILTO'} ($VALUE{'RECIPIENT'})\n";
   print MAIL "Subject: $subject2\n\n";

   open(TEMPLATE,"$email2");
   &template;
   print MAIL $template;

   close(MAIL);
     }
   else {
      print "Content-type: text/html\n\n";
      open(TEMPLATE,"$error");
      &template;
      print $template;
     }
exit;
}

#######################################
#DELETES the information 
#######################################
sub delete {
 $deletes = "$cards$DATE";

  if(-e $deletes){
  }
  else{
    open(DATA, ">>$deletes");
    close(DATA);

   local(@items, $pair);
   opendir(DELETE, "$cards");
   @items = grep(/[0-9].dat/,readdir(DELETE));
   closedir(DELETE);
   foreach $pair (@items){
     if (-M "$cards$pair" > $MAX_DAYS){
       unlink("$cards$pair");
      }
   }
 }
}

#####################
#Calls the Template 
#####################

sub template {
     while (<TEMPLATE>){
       $template .= $_;
       }
     close(TEMPLATE);

        $template =~ s/\%%%PICTURES%%%/$VALUE{'PICTURES'}/g;
        $template =~ s/\%%%PICTURE%%%/$VALUE{'PICTURE'}/g;
        $template =~ s/\%%%SENDER%%%/$VALUE{'SENDER'}/g;
        $template =~ s/\%%%MAILFROM%%%/$VALUE{'MAILFROM'}/g;
        $template =~ s/\%%%MAILTO%%%/$VALUE{'MAILTO'}/g;
        $template =~ s/\%%%RECIPIENT%%%/$VALUE{'RECIPIENT'}/g;
        $template =~ s/\%%%MESSAGE%%%/$VALUE{'MESSAGE'}/g;
        $template =~ s/\%%%CGI%%%/$cgi/g;
        $template =~ s/\%%%MAX_DAYS%%%/$MAX_DAYS/g;
        $template =~ s/\%%%SHORTDATE%%%/$SHORTDATE/g;
        $template =~ s/\%%%url_of_card%%%/$url_of_card/g;
}