#!/usr/bin/perl
##############################################################################
# Cliff's Search Engine Position Analyzer Script Version 3.0                 # 
# Copyright 1998 Shaven Ferret Productions                                   #
# Created 6/17/98   Last Modified 9/10/99                                    #
# Available at http://www.shavenferret.com/scripts                           #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1998 Shaven Ferret Productions All Rights Reserved.              #
#                                                                            #
# This script can be used\modified free of charge as long as you don't       #
# change this header thing, or the part that generates the return link.  If  #
# really need to change these, go to                                         #
# http://www.shavenferret.com/scripts/register.shtml . By using this script  #
# you agree to indemnify me from any liability that might arise from its use.#
#                                                                            #
# Redistributing\selling the code for this program without prior written     #
# consent is expressly forbidden.                                            #
##############################################################################
                                             
# If you aren't going to put position.txt in the same directory as this file,
# change the next line to position.txt's server path.
$datapath = "position.txt";

# If you want to keep other people from using this script, enter the password
# you want to use to access the script below.
$password = "shavenferret.com";

##############################################################################
#                   No further modification is required.                     #
##############################################################################

$| = 1;
use LWP::Simple;

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
        ($name, $value) = split(/=/, $pair);
        $FORM{$name} = $value;
}

if ($FORM{'action'} eq "update") { &update; }
elsif ($FORM{'action'} eq "search") { &search; }
else { &main; }

sub update {
        &parse("password");
        unless ($password eq $FORM{'password'}) {
                &top("Bad Password");
                print "The password you entered is incorrect.</body></html>\n";
                exit;                
        }
        open(FILE,">$datapath");                
        for ($i = 0; $i <= $FORM{'lines'}; $i++) {
                &parse($i);
                $FORM{$i} =~ s/\[quot\]/"/ig;
                $FORM{$i} =~ s/\[space\]/&nbsp;/ig;
                print FILE "$FORM{$i}\n";
        }
        close(FILE);
        &top("Data files updated");
        print "</body></html>\n";
        exit;
}

sub main {
        &top("Cliff's Search Engine Position Analyzer Script");
        print "<center><hr width=\"400\">Search Engine Position Analyzer";
        print " script by <a href=\"http://www.shavenferret.com/cliff/\" target=\"new\">";
        print "Cliff</a>, <a href=\"http://www.shavenferret.com\" target=\"new\">Shaven Ferret\n";
        print "Productions</a>, and can be found at <a href=\"http:";
        print "//www.shavenferret.com/scripts\" target=\"new\">ht";
        print "tp://www.shavenferret.com/scripts</a>.<hr width=\"";
        print "70%\"></center>\n";        
        &topform("search");
        &textrow("URL to search for:","url","http://");
        &textrow("What words should I search for?","keywords");
        print "<tr><td align=\"right\">What search engines should I check?</td><td>\n";
        open(FILE,"$datapath");
        @lines = <FILE>;
        close(FILE);
        for ($i = 0; $i <= $#lines; $i++) {
                my @stuff = split(/\|/,$lines[$i]);
                print "<input type=\"checkbox\" name=\"$i\" value=\"-1\" checked>\n";
                print "<a href=\"$stuff[1]\">$stuff[0]</a><br>\n";
        }
        print "</td></tr>\n";
        &closeform("Check it");
        print "</center><h1>Help:</h1>Definition";
        print "s:<ul><li>URL: this is the thing that begins with ";
        print "http:// that people type in to get to your page<li";
        print ">Keywords to search for: these are what the script will search for ";
        print "when looking for your page.</ul>Time:<ul>While the actual time it";
        print " takes per search engine varies greatly, you can p";
        print "robably expect each search engine to add about 5 s";
        print "econds.  While this is considerably faster than do";
        print "ing it by hand, it does tend to add up.  In short,";
        $searches = $#lines + 1; $total = $searches * 5;
        print " if you leave all $searches search engines checked, you ca";
        print "n expect it to take about $total seconds or so.\n";
        print "<center><hr width=\"400\">Search Engine Position Analyzer";
        print " script by <a href=\"http://www.shavenferret.com/cliff/\" target=\"new\">";
        print "Cliff</a>, <a href=\"http://www.shavenferret.com\" target=\"new\">Shaven Ferret\n";
        print "Productions</a>, and can be found at <a href=\"http:";
        print "//www.shavenferret.com/scripts\" target=\"new\">ht";
        print "tp://www.shavenferret.com/scripts</a>.<hr width=\"";
        print "70%\"></center>\n";        
        print "</body></html>\n";
        exit;
}

sub search {
        &top("Results");
        open(FILE,"$datapath");
        @lines = <FILE>;
        close(FILE);
	&parse("url");
	$FORM{'url'} = quotemeta($FORM{'url'});
        print "<ul>\n";
        for ($i = 0; $i <= $#lines; $i++) {
                if ($FORM{$i}) {
			chomp($lines[$i]);
                        ($name,$url,$search,$split,@mark) = split(/\|/,$lines[$i]);
                        for ($j = 0; $j <= 1; $j++) {
				$pos = "";
                                if (substr($mark[$j],-1,4) eq "\$") { chop($mark[$j]); $pos = "l"; }
                                if (substr($mark[$j],-1,1) eq "\$") {  chop($mark[$j]); $pos = "f"; }
				$mark[$j] = quotemeta($mark[$j]);
                                if ($pos eq "l") { $mark[$j] = "$mark[$j]" . "\$"; }
                                if ($pos eq "f") { $mark[$j] = "^" . "$mark[$j]"; }
			}
                        @searches = split(/\^/,$search);
			$searches[0] =~ s/\[search for this\]/$FORM{'keywords'}/ig;
                        print "<li><a href=\"$searches[0]\">$name</a>: \n";
                        $rank = 0; $found = 0;
                        foreach $search(@searches) {
                                $search =~ s/\[search for this\]/$FORM{'keywords'}/ig;
                                $page = get($search);
                                @searchlines = split(/$split/, $page);
                                foreach $line(@searchlines) {
                                        if ($line =~ /$mark[0]/ && $line =~ /$mark[1]/ && $found == 0) {
						$rank++;
	                                        if ($line =~ /$FORM{'url'}/) { $found = -1;  } 
			                }
                                }
                                if ($found) { last }
                        }
                        if ($found) { print "#<b>$rank</b></li>\n"; }
                        else { print "Not in top 50</li>\n"; }
                }
        }
        print "</li></body></html>\n";
}

sub top {
        my $title = shift(@_);
        print "Content-type: text/html\n\n";
        print "<html><head><title>$title</title>\n";
        print "<body bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#FF0000\" vlink=\"#CC0000\">\n";
        print "<h1>$title</h1>\n";
}

sub topform {
        my $action = shift(@_);
        print "<form method=\"POST\">\n";
        print "<input type=\"hidden\" name=\"action\" value=\"$action\">\n";
        if ($FORM{'password'}) { print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n"; }
        print "<center><table width=\"525\" border=\"5\" cellpadding=\"4\" cellspacing=\"4\">\n";
        print "<tr><td><table cols=\"2\">\n";
}

sub closeform {
        my $label = shift(@_);
        print "<tr><td align=\"right\"><input type=\"submit\" value=\" $label \">\n";
        print "</td><td><input type=\"reset\"></td></tr></table></td></tr></table></form>\n";
}

sub textrow {
        (my $desc, my $name, my $value) = @_;
        print "<tr><td align=\"right\">$desc</td><td>\n";
        print "<input type=\"text\" name=\"$name\" value=\"$value\"></td></tr>\n";
}

sub parse {
        my $var = shift(@_);        
        $FORM{$var} =~ tr/+/ /;
        $FORM{$var} =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
}
