#!/usr/bin/perl
#
# dclinks97.pl
# Written By David S. Choi, dc@sitedeveloper.com
# 16 November 1997
#
##########  YOU MUST KEEP THIS COPYRIGHTS NOTICE INTACT ###############
# Copyright  1997 DCScripts All Rights Reserved
# As part of the installation process, you will be asked
# to accept the terms of this Agreement. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts and DCLinks97.
# You should carefully read the following terms and conditions before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of the Software.
#
# Versions of the Software 
# You may install as many copies of DCLinks97 Script.
# 
# License to Redistribute
# Distributing the software and/or documentation with other products
# (commercial or otherwise) or by other than electronic means without
# DCScripts's prior written permission is forbidden.
# All rights to the DCLinks97 software and documentation not expressly
# granted under this Agreement are reserved to DCScripts.
#
# Disclaimer of Warranty
# THIS SOFTWARE AND ACCOMPANYING DOCUMENTATION ARE PROVIDED "AS IS" AND
# WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR ANY OTHER
# WARRANTIES WHETHER EXPRESSED OR IMPLIED.   BECAUSE OF THE VARIOUS HARDWARE
# AND SOFTWARE ENVIRONMENTS INTO WHICH HKDBOARD MAY BE USED, NO WARRANTY OF
# FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.  THE USER MUST ASSUME THE
# ENTIRE RISK OF USING THIS PROGRAM.  ANY LIABILITY OF HKDESIGN WILL BE
# LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT OR REFUND OF PURCHASE PRICE.
# IN NO CASE SHALL DCSCRIPTS BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR
# CONSEQUENTIAL DAMAGES OR LOSS, INCLUDING, WITHOUT LIMITATION, LOST PROFITS
# OR THE INABILITY TO USE EQUIPMENT OR ACCESS DATA, WHETHER SUCH DAMAGES ARE
# BASED UPON A BREACH OF EXPRESS OR IMPLIED WARRANTIES, BREACH OF CONTRACT,
# NEGLIGENCE, STRICT TORT, OR ANY OTHER LEGAL THEORY. THIS IS TRUE EVEN IF
# DCSCRIPTS IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. IN NO CASE WILL
# DCSCRIPT'S LIABILITY EXCEED THE AMOUNT OF THE LICENSE FEE ACTUALLY PAID
# BY LICENSEE TO DCSCRIPTS.
#
###########################################################################

# Define directory path to your setup file.
# Try relative path

$path = ".";

#----you shouldn't need to change anything below this line

require "$path/dclinks98.setup";
require "$cgidir/cgi-lib.pl";

# OK Let's read in formdata

&ReadParse;

# Send HTTP header to the server

print "Content-type: text/html\n\n";

# Format Comment input so that it will fit nicely in the database

if ($in{'Description'}) {
	$in{'Description'} =~ s/</&lt;/g;
	$in{'Description'} =~ s/>/&gt;/g;
	$in{'Description'} =~ s/\cM//g;
	$in{'Description'} =~ s/\n\n/ /g;
	$in{'Description'} =~ s/\n/ /g;
}


# Depending on Form input:
#	1) Display add to links form
#	2) Add Link information to the database
# 	3) Display Links

if ($in{'action'} eq "add_form") {

	$header = $add_links_header;
	$sub_header = $add_links_sub_header;

	&add_form;
}
elsif ($in{'action'} eq "add_links") {

	$header = $thank_you_header;
	$sub_header = $thank_you_sub_header;

	&add_links;

	&display_main;

}
elsif ($in{'action'} eq "view_category") {

	$header = $display_view_header;
	$sub_header = $display_view_sub_header;
	
	&view_category;
}
else {

	$header = $display_main_header;
	$sub_header = $display_main_sub_header;

	&display_main;
}

&display_output;

exit(0);

####################### END OF THE MAIN PROGRAM ####################

sub display_main {

	open(LINKSDATA,"$datafile") || die $!;
	flock(LINKSDATA,2);
		@linksdata = <LINKSDATA>;
	flock(LINKSDATA,8);
	close(LINKSDATA);

	foreach $line (@linksdata){
		(@linedata) = split(/\|/,$line);
		$Category_num{$linedata[$cat_id]}++;
	}

	$html_output .= qq~
		<font face="$font_face" size="$font_size" color="$font_color"><ul>
		~;

	foreach $cat (@Category_list) {

		$cat1 = $cat;
		$cat =~ tr/ /+/;

		if ($Category_num{"$cat1"} eq "" ) {$Category_num{"$cat1"} = "0";}
	
		$html_output .= qq~
		<li>
		<b>
		<a href="$dcscript?action=view_category&category=$cat">$cat1</a>
		</b>
		($Category_num{"$cat1"} links)
		<br>
		 $Category_desc{$cat1}
		</li>~;
	}
	$html_output .= "</ul></FONT>\n";
}


sub view_category {

	$category = $in{"category"};
	
	$category =~ tr/+/ /;
	
	open(LINKSDATA,"$datafile") || die $!;
	flock(LINKSDATA,2);
		@linksdata = <LINKSDATA>;
	flock(LINKSDATA,8);
	close(LINKSDATA);

	
	$html_output .= qq~
	<P align="center">
	<font face="$font_face" size="$font_size" color="$font_color">
	<B>Viewing Links in $category</b>
	<ul>
	~;
	
	foreach $line (@linksdata) {
		@row = split(/\|/,$line);
		foreach ($j = 0;$j <= @row-1;$j++){
			$rowdata{$link_fields[$j]} = $row[$j];
		}
		if ($rowdata{$link_fields[$cat_id]} =~ /$category/) {
			$hit = "yes";
			$html_output .= qq~
			<li>~;
			$html_output .= &list_record(@rowdata);
		
		}
	}

	unless ($hit) {
		$html_output .= qq~
		<P align="center">
		No links in $category.
		~;
	}
		$html_output .= qq~
		</ul>
		</font>
		~;
}


sub list_record {

	local(@rowdata) = @_;
	local($output);
	
	$rowdata{"Homepage"} =~ s/http:\/\///g;
	$output .= qq~
	<b><a href="http://$rowdata{"Homepage"}">$rowdata{"Name"}</a></b>
	$rowdata{"Description"}
	~;
	
	$output;
}

sub add_links {

	open(LINKSDATA,"$datafile") || die $!;
	flock(LINKSDATA,2);
		@linksdata = <LINKSDATA>;
	flock(LINKSDATA,8);
	close(LINKSDATA);

	# Following code checks duplicate links
	foreach (@linksdata) {
		if ($_ =~ /$in{'Homepage'}/) {
			$header = "ERROR!!! Duplicate Link!";
			$sub_header = "Did you submit correct URL?";
			$html_output .= qq~
				Our links database already has your link...
			~;
			&display_output;
			exit(0);
		}
	}

	$id = &get_number();
	($date,$localtime) = &get_date();
	$date = $localtime." ".$date;

	$in{'ID'} = $id;
	$in{'Date'} = $date;

	foreach $field (@link_fields) {
		$in{$field} =~ s/\|/\s/g;
		$newline .= $in{$field}."|";
	}

	chop($newline);
	$newline .= "\n";
	
	open(LINKSDATA,">$datafile") || die $!;
	flock(LINKSDATA,2);
		print LINKSDATA $newline;
		print LINKSDATA @linksdata;
	flock(LINKSDATA,8);
	close(LINKSDATA);
	
}

sub add_form {

	
	$html_output .= qq~
	<center>
	<table border="0">
	<form action="$dcscript" method="post">
	<input type="hidden" name="action" value="add_links">~;
	
	foreach $link_field (@link_fields){
		$html_output .= &table_row($link_field,$field_input_type{$link_field});
	}

	$html_output .= qq~
	<tr>
	<td colspan="2" align="center">
	<input type="submit" value="Submit My Links!">
	<input type="reset">
	</form>
	</table>
	</center>~;
}

sub table_row {

	my ($field,$type) = @_;
	($field,$type) = @_;
	my ($table_row);
	
	if ($type eq "text") {
		$table_row .= qq~
		<tr>
		<td valign="top">
		$field
		</td>
		<td>
		<input type="$type" name="$field" size="40">
		</td>
		</tr>
		~;
	}
	elsif ($type eq "textarea") {
		$table_row .= qq~
		<tr>
		<td valign="top">
		$field
		</td>
		<td>
		<textarea name="$field" rows="6" cols="40" wrap="physical"></textarea>
		</td>
		</tr>
		~;
		
	}
	elsif ($type eq "select") {

		@option_list = eval("@".$field."_list");
		$table_row .= qq~
		<tr>
		<td valign="top">
		$field
		</td>
		<td>
		<select name="$field">~;
		foreach $option (@option_list) {
			$table_row .= "<option value=\"$option\">$option\n";
		}
		
		$table_row .= qq~
		</select>
		</td>
		</tr>
		~;

	}
	
	$table_row;
}

sub get_number {
	
	local($num);
		
	open(NUMBER,"$counter") || die $!;
   		$num = <NUMBER>;
	close(NUMBER);

	$num++;

	open(NUMBER,">$counter") || die $!;
   		print NUMBER $num;
	close(NUMBER);
	 	  
	$num;
}

sub display_output {

	open(TEMPLATE,"$booktemplate") || die $!;
	{  local $/ = undef;
		$template = <TEMPLATE>;
	}

	close(TEMPLATE);

	$template =~ s/\$HTML_OUTPUT/$html_output/g;
	$template =~ s/\$HEADER/$header/g;
	$template =~ s/\$SUB_HEADER/$sub_header/g;
	print $template;

}

sub get_date {

   local($date,$localtime);
   
   ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

   if ($sec < 10) {
      $sec = "0$sec";
   }
   if ($min < 10) {
      $min = "0$min";
   }
   if ($hour < 10) {
      $hour = "0$hour";
   }
   if ($mon < 10) {
      $mon = "0$mon";
   }
   if ($mday < 10) {
      $mday = "0$mday";
   }

   $month = ($mon + 1);

   @months = ("January","February","March","April","May","June","July","August","September","October","November","December");

   $localtime = "$hour\:$min\:$sec";
   $date = "$month/$mday/$year";

   ($date,$localtime);
   
}
