#!/usr/bin/perl

#############################################################
# Ikonboard v2.1
# Copyright 2000 Ikondiscussion.com - All Rights Reserved
# Ikondiscussion is a trademark of Ikondiscussion.com
#
# Software Distributed by: Ikondiscussion.com
# Visit us online at http://www.ikondiscussion.com
# Email us on boards@ikondiscussion.com
#
# All files written by Matthew Mecham
#############################################################

use CGI::Carp "fatalsToBrowser";          # Output errors to browser
use CGI qw(:standard);                    # Saves loads of work
$CGI::POST_MAX=1024 * 150;                # limit post data
$CGI::DISABLE_UPLOADS = 1;                # Disable uploads

eval {
($0 =~ m,(.*)/[^/]+,)   and unshift (@INC, "$1");
($0 =~ m,(.*)\\[^\\]+,) and unshift (@INC, "$1");
require "ikon.lib";          # Require ikonboard ()
require "data/progs.cgi";    # Require prog names
require "data/boardinfo.cgi";# Require board info
require "data/styles.cgi";   # Require styles info
};
if ($@) {
    print header(); print start_html(-title=>"Ikonboard Error!");
    print "Could not find these files: $@\nIf you are running NT you may need to enter the full path in each require statement in each script";
    print end_html; exit;
}

$|++;                                     # Unbuffer the output

#################--- Begin the program ---###################

$thisprog = "whosonline.cgi";


if (! $inmembername) { $inmembername = cookie("amembernamecookie"); }
if (! $inpassword)   { $inpassword   = cookie("apasswordcookie");   }

if ($inmembername eq "") {
    $inmembername = "Guest";
    }
    else {
        &getmemberstime("$inmembername");
        }

$helpurl = &helpfiles("Active_Users");
$helpurl = qq~$helpurl<img src="$imagesurl/images/help_b.gif" border=0></a>~;

&title;

$output .= qq~
<table cellpadding=0 cellspacing=0 border=0 width=$tablewidth align=center>
    <tr>
        <td width=30% rowspan=2><img src="$imagesurl/images/$boardlogo" border=0></td>
        <td valign=middle align=left><font face="$font" color=$fontcolormisc size=2>
            &nbsp;&nbsp;<img src="$imagesurl/images/closedfold.gif" border=0><a href="$forumsummaryprog">&nbsp;&nbsp;$boardname</a>
	        <br>
            &nbsp;&nbsp;<img src="$imagesurl/images/bar.gif" border=0><img src="$imagesurl/images/openfold.gif" border=0>&nbsp;&nbsp;Active Users
        </td>
        <tr>
        <td valign=bottom align=right>&nbsp; $helpurl</td>
    </tr>
</table>
<p>
<table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
    <tr>
        <td>
        <table cellpadding=6 cellspacing=1 border=0 width=100%>
        <tr>
        <td bgcolor=$miscbacktwo valign=middle colspan=3 align=center><font face="$font" color=$fontcolormisc size=2><b>Active users</b></font>
    </td>
</tr>
~;

    $filetoopen = "$ikondir" . "data/onlinedata.dat";
    open(FILE,"$filetoopen");
    @onlinedata = <FILE>;
    close(FILE);

    $output .= qq~
        <tr>
        <td bgcolor=$miscbackone><font face="$font" color=$fontcolormisc size=2><b>Members Name</b></font></td>
        <td bgcolor=$miscbackone><font face="$font" color=$fontcolormisc size=2><b>Time of last action</b></font></td>
        <td bgcolor=$miscbackone><font face="$font" color=$fontcolormisc size=2><b>Last action</b></font></td>
    </tr>
    ~;
            
foreach $line (@onlinedata) {
    chomp $line;
    ($savedusername, $savedtime, $savedwhere) = split(/\|/, $line);
    $savedtime = $savedtime + ($timezone*3600) + ($timedifferencevalue*3600);
    $longdate = &longdate("$savedtime");
    $shorttime = &shorttime("$savedtime");
    $savedtime = "$longdate - $shorttime";
    $lookfor = substr($savedusername, 0, 5);
    if ($lookfor eq "Guest") { $savedusername = "Guest"; }
    if ($savedusername eq "Guest" && $savedwhere eq "Logging in") { next; }
    
    $output .=qq~
    <tr>
    <td bgcolor=$miscbackone nowrap><font face="$font" color=$fontcolormisc size=2><b>$savedusername</b></font></td>
    <td bgcolor=$miscbackone nowrap><font face="$font" color=$fontcolormisc size=2>$savedtime</font></td>
    <td bgcolor=$miscbackone><font face="$font" color=$fontcolormisc size=1>$savedwhere</font></td>
    </tr> ~;
    }
    
$output .= qq~</table></td></tr></table>~;

print header();
&output(
       -Title   => "$boardname - Active Users", 
       -ToPrint => $output, 
       -Version => $versionnumber 
       );
