#!/usr/bin/perl

#############################################################
# Ikonboard v2.1
# Copyright 2000 Ikondiscussion.com - All Rights Reserved
# Ikondiscussion is a trademark of Ikondiscussion.com
#
# Software Distributed by: Ikondiscussion.com
# Visit us online at http://www.ikondiscussion.com
# Email us on boards@ikondiscussion.com
#
# All files written by Matthew Mecham
#############################################################

use CGI::Carp "fatalsToBrowser";          # Output errors to browser
use CGI qw(:standard);                    # Saves loads of work
$CGI::POST_MAX=1024 * 150;                # limit post data
$CGI::DISABLE_UPLOADS = 1;                # Disable uploads

eval {
($0 =~ m,(.*)/[^/]+,)   and unshift (@INC, "$1");
($0 =~ m,(.*)\\[^\\]+,) and unshift (@INC, "$1");
require "ikon.lib";          # Require ikonboard ()
require "ikonadmin.lib";     # Require Admin func()
require "data/progs.cgi";    # Require prog names
require "data/boardinfo.cgi";# Require board info
require "data/styles.cgi";   # Require styles info
};
if ($@) {
    print header(); print start_html(-title=>"Ikonboard Error!");
    print "Could not find these files: $@\nIf you are running NT you may need to enter the full path in each require statement in each script";
    print end_html; exit;
}

$|++;                                     # Unbuffer the output

#################--- Begin the program ---###################

$thisprog = "setmembers.cgi";

$query = new CGI;

&checkVALIDITY;

$action          = $query -> param('action');
$checkaction     = $query -> param('checkaction');
$inletter        = $query -> param('letter');
$inmember        = $query -> param('member');
$inmember        = &unHTML("$inmember");
$action          = &unHTML("$action");

$inmembername = cookie("adminname");
$inpassword   = cookie("adminpass");


print header();       
&admintitle;
        
&getmember("$inmembername");
        
        
        if (($membercode eq "ad") && ($inpassword eq $password) && ($inmembername eq $membername)) {
            
            print qq~
            <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
            <b>Welcome to your ikon board Administration Center / Member Control</b>
            </td></tr>
            ~;
            
            my %Mode = ( 
            'updatecount'        =>    \&docount,
            'viewletter'         =>    \&viewletter,
            'edit'               =>    \&edit,        
            'deletemember'       =>    \&deletemember,
            'unban'              =>    \&unban
            );


            if($Mode{$action}) { 
               $Mode{$action}->();
               }
                else { &memberoptions; }
            
            print qq~</table></td></tr></table>~;
            }
                
            else {
               &adminlogin;
               }
        

##################################################################################
######## Subroutes (forum list)


sub memberoptions {

    $dirtoopen = "$ikondir" . "members";

    opendir (DIR, "$dirtoopen"); 
    @filedata = readdir(DIR);
    closedir (DIR);

    @sortedfile = sort(@filedata);
    @sortedfile = grep(/cgi/,@sortedfile);

    foreach (@sortedfile) {
        $fr = substr($_, 0, 1);
        $fr =~ tr/a-z/A-Z/;
        push(@letters,$fr);
        }

    @sortedletters = sort(@letters);

     
    print qq~
     
    <tr>
    <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
    <font face=verdana color=#990000 size=3><b>Please Select an option</b>
    </td>
    </tr>          
                
    <tr>
    <td bgcolor=#FFFFFF valign=middle align=left colspan=2>
    <font face=verdana color=#333333 size=2><b><a href="$thisprog?action=updatecount">Update Board Membercount</a></b><br>
    This will ensure that the total members count is fully up to date.
    </td>
    </tr>         
                
    <tr>
    <td bgcolor=#FFFFFF valign=middle align=left colspan=2>
    <font face=verdana color=#333333 size=2><b>View, delete, ban or edit a member</b><br>
    You can view member details by choosing a letter below, you can edit and change the member status.<br>
    To ban a member, simply click on edit, and change their membertype to 'banned' in the drop down box.<br>
    To unban a member, click on the link (if it applies) next to 'delete' link.<p>
    ~;
    
    foreach (@sortedletters) {
        unless ($_ eq "$ltr") {
            $tempoutput .= qq~<a href="$thisprog?action=viewletter&letter=$_">&nbsp;$_&nbsp;</a>~;
            $ltr = "$_";
            }
        }
    
    print qq~
    Current Member Sections:<p>$tempoutput
    </td>
    </tr>           
                
                
                
    <tr>
    <td bgcolor=#FFFFFF valign=middle align=left colspan=2>
    <font face=verdana color=#333333 size=2>
    <b>Quick Notes:</b><p>
    If you wish to give a member a custom member title, do so by editing their details.<br>
    This board uses a member code stored seperately to determine their member status.<br>
    If you choose to make a member a moderator in the forum set-up and they do not have a custom member title, 
    they will automatically be promoted to moderator status. If they have a custom member title already, they will
    be promoted and retain their current title.<br>
    A moderator can only moderate in their forum, but they will be able to use the #Moderation Mode feature in any forum.<br>
    Please ensure that you only choose trustworthy moderators.<br>
    A moderator will also be able to bypass the floodcontrol automatically as does the administrator.<br>
    Only administrators have access to this administration center.<br><br>
    Banning a member will ban them from re-registering is their username, email address or IP address match.
    </td>
    </tr>             
     ~;        
     
     } # end routne
     
     
##################################################################################
######## Subroutes (Do member count)  


sub docount {

    $dirtoopen = "$ikondir" . "members";

    opendir (DIR, "$dirtoopen"); 
    @filedata = readdir(DIR);
    closedir (DIR);

    @countvar = grep(/cgi/,@filedata);
    
    $newtotalmembers = @countvar;
    
        require "$ikondir" . "data/boardstats.cgi";
        
        $filetomake = "$ikondir" . "data/boardstats.cgi";
        
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "\$lastregisteredmember = \"$lastregisteredmember\"\;\n";
        print FILE "\$totalmembers = \"$newtotalmembers\"\;\n";
        print FILE "\$totalthreads = \"$totalthreads\"\;\n";
        print FILE "\$totalposts = \"$totalposts\"\;\n";
        print FILE "\n1\;";
        close (FILE);
    
        print qq~
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=center colspan=2>
        <font face=verdana color=#990000 size=3>
                    
        <b>Member Count Updated</b><p>
                    
        <font size=-1 color=#333333> You have $newtotalmembers currently registered members</font>
                    
        </td></tr>
         ~;
         
     } # end routine

##################################################################################
######## Subroutes (Do member count) 


sub viewletter {

    $dirtoopen = "$ikondir" . "members";

    opendir (DIR, "$dirtoopen"); 
    @filedata = readdir(DIR);
    closedir (DIR);

    @sortedfile = sort(@filedata);
    @sortedfile = grep(/cgi/,@sortedfile);
    @sortedfile = sort alphabetically(@sortedfile);
    
    foreach (@sortedfile) {
        $fr = substr($_, 0, 1);
        $fr =~ tr/a-z/A-Z/;
        push(@letters,$fr);
        }
    @sortedletters = sort(@letters);
        
    foreach (@sortedletters) {
        unless ($_ eq "$ltr") {
            $tempoutput .= qq~<a href="$thisprog?action=viewletter&letter=$_">&nbsp;$_&nbsp;</a>~;
            $ltr = "$_";
            }
        }

     
    print qq~
    <tr>
    <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
    <font face=verdana color=#990000 size=3><b>View all members beginning with $inletter</b><p>
    Choose another letter $tempoutput
    </td>
    </tr>          
    ~;
               
               
    foreach (@sortedfile) {
        $ftr = substr($_, 0, 1);
        $ftr =~ tr/a-z/A-Z/;
        if ($inletter eq "$ftr") {
            $_ =~ s/\.cgi//;
            $member = $_;
            &getmember("$member");
            &showmember;
            }
        }
        
   } # end route



##################################################################################
######## Subroutes (Show member) 


sub showmember {

    $joineddate = &longdate("$joineddate");
    
    $cleanmember = $member;
    $cleanmember =~ s/\_/ /g;
    
    ## Sort last post, and where
    
    ($postdate, $posturl, $posttopic) = split(/\%%%/,$lastpostdate);
    
    if ($postdate ne "Not Posted") {
        $postdate = &longdate("$postdate");
        $lastpostdetails = qq~Last posted in <a href="$posturl">$posttopic</a> on $postdate~;
        }
        else {
            $lastpostdetails = "Not posted";
            }

    if ($membercode eq "banned") {
        $unbanlink = qq~ | <a href="$thisprog?action=unban&member=$member">[ Unban ]</a>~;
        }
    
    print qq~
    <tr>
    <td bgcolor=#EEEEEE valign=middle colspan=2 align=center><font face=$font color=$fontcolormisc size=2><b>Profile for <font color=$fonthighlight>$cleanmember</b>- <a href="$thisprog?action=edit&member=$member">[ Edit ]</a> | <a href="$thisprog?action=deletemember&member=$member">[ Delete ]</a>$unbanlink</font></td></tr>
    <tr>
    <td bgcolor=#FFFFFF valign=middle width=30%><font face=verdana color=#333333 size=1><b>Member Since:</b></font></td>
    <td bgcolor=#FFFFFF valign=middle><font face=verdana color=#333333 size=1>$joineddate</font></td></tr>
    <tr>
    <td bgcolor=#FFFFFF valign=middle><font face=verdana color=#333333 size=1><b>Member Title:</b></font></td>
    <td bgcolor=#FFFFFF valign=middle><font face=verdana color=#333333 size=1>$membertitle</font></td></tr>
    <tr>
    <td bgcolor=#FFFFFF valign=middle><font face=verdana color=#333333 size=1><b>Last Post:</b></font></td>
    <td bgcolor=#FFFFFF valign=middle><font face=verdana color=#333333 size=1>$lastpostdetails</font></td></tr>
    <tr>
    <td bgcolor=#FFFFFF valign=middle><font face=verdana color=#333333 size=1><b>Member Since:</b></font></td>
    <td bgcolor=#FFFFFF valign=middle><font face=verdana color=#333333 size=1>$joineddate</font></td></tr>
    <tr>
    <td bgcolor=#FFFFFF valign=middle><font face=verdana color=#333333 size=1><b>Total Posts:</b></font></td>
    <td bgcolor=#FFFFFF valign=middle><font face=verdana color=#333333 size=1>$numberofposts</font></td></tr>
    
    ~;
    $unbanlink = "";
    } # end routine


##################################################################################
######## Subroutes (Edit member) 


sub edit {

    if ($checkaction eq "yes") {
    
    
    $innewpassword      = $query -> param('password');
    $inmembertitle      = $query -> param('membertitle');
    $inemailaddress     = $query -> param('emailaddress');
    $inhomepage         = $query -> param('homepage');
    $inaolname          = $query -> param('aolname');
    $inicqnumber        = $query -> param('icqnumber');
    $inlocation         = $query -> param('location');
    $innumberofposts    = $query -> param('numberofposts');
    $intimedifference   = $query -> param('timedifference');
    $inmembercode       = $query -> param('membercode');

    $inlocation = &cleaninput("$inlocation");
    
    
    if ($inpassword eq "")     { $blank = "yes"; }
    if ($inemailaddress eq "") { $blank = "yes"; }
    
    if ($blank eq "yes") {
    
        print qq ~
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=center colspan=2><font face=verdana color=#333333 size=2><b>You must include a password, and email address for the user</b></font></td></tr>
        ~;
        
        }
    

        # Sort out the private access
    
        
        $filetoopen = "$ikondir" . "data/allforums.cgi";
        open(FILE,"$filetoopen");
        flock(FILE,2);
        @forums = <FILE>;
        close(FILE);
        
        foreach $forum (@forums) {
            chomp $forum;
            ($forumid, $trash) = split(/\|/,$forum);
            $namekey = "allow" . "$forumid";
            $tocheck = $query -> param("$namekey");
            if ($tocheck eq "yes") {
                $allowedforums2 .= "$forumid=$tocheck&";
                }
            }
            
        &getmember("$inmember");
    
        $memberfiletitle = $inmember;
        $memberfiletitle =~ s/ /\_/isg;

        

        # Add to ban lists (if required)

        if ($inmembercode eq "banned") { 
            
            $filetoopen = "$ikondir" . "data/banlist.cgi";
            open(FILE,">>$filetoopen");
            print FILE "$inmember|$inemailaddress|$ipaddress";
            close(FILE);

            $banresult = "$membername was banned successfully";
            }




        $filetomake = "$ikondir" . "members/$memberfiletitle.cgi";
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "$membername|$innewpassword|$inmembertitle|$inmembercode|$innumberofposts|$inemailaddress|$showemail|$ipaddress|$inhomepage|$inaolname|$inicqnumber|$inlocation|$interests|$joineddate|$lastpostdate|$signature|$intimedifference|$allowedforums2|$useravatar|$misc1|$misc2|$misc3";
        close(FILE);

                print qq~
                <tr>
                <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
                <font face=verdana color=#333333 size=3><b>All information saved</b><br><br>$banresult<br>
                </td></tr>
                ~;
    
    }
    
    else {
    
    
    
    $filetoopen = "$ikondir" . "data/allforums.cgi";
         open(FILE,"$filetoopen");
         flock(FILE,2);
         @forums = <FILE>;
         close(FILE);

         
         foreach $forum (@forums) {
            chomp $forum;
            ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);   
            if ($privateforum eq "yes") { 
                $grab = "$forumid|$forumname";
                push(@newforums, $grab);
                }
            }
        $cleanmember = $inmember;
        $cleanmember =~ s/\_/ /g;
    
        &getmember("$inmember");
        
        if($privateforums) {
            @private = split(/&/,$privateforums);
            foreach $accessallowed (@private) {
                chomp $accessallowed;
                ($access, $value) = split(/=/,$accessallowed);
                $allowedentry2{$access} = $value;
                }
            }
    
        @allowedforums = sort alphabetically(@newforums);
        foreach $line (@allowedforums) {
            ($forumid, $forumname) = split(/\|/,$line);
            if ($allowedentry2{$forumid} eq "yes") { $checked = " checked"; }
            else { $checked = ""; }
            $privateoutput .= qq~<input type="checkbox" name="allow$forumid" value="yes"$checked>$forumname<br>\n~;
            }
            
    $memberstateoutput = qq~<select name="membercode"><option value="me">Member<option value="banned">Ban member<option value="ad">Administrator<option value="mo">Moderator</select>~;
    
    $memberstateoutput =~ s/value=\"$membercode\"/value=\"$membercode\" selected/g;
    
    print qq~
    <form action="$thisprog" method=post>
    <input type=hidden name="action" value="edit">
    <input type=hidden name="checkaction" value="yes">
    <input type=hidden name="member" value="$inmember">
    <tr>
    <td bgcolor=#EEEEEE colspan=2><font face=verdana color=#333333 size=3><b>Editing Name:</b>$membername</td>
    </tr>
    <tr>
    <td bgcolor=#FFFFFF><font face=verdana color=#333333 size=1><b>Member Title:</b><br>You can add a custom member title.</td>
    <td bgcolor=#FFFFFF><input type=text size=20 name="membertitle" value="$membertitle"></td>
    </tr>
    <tr>
    <td bgcolor=#FFFFFF><font face=verdana color=#333333 size=1><b>Number of posts:</b></td>
    <td bgcolor=#FFFFFF><input type=text size=20 name="numberofposts" value="$numberofposts"></td>
    </tr>
    <tr>
    <td bgcolor=#FFFFFF><font face=verdana color=#333333 size=1><b>Password:</b></td>
    <td bgcolor=#FFFFFF><input type=text size=20 name="password" value="$password"></td>
    </tr>
    <tr>
    <td bgcolor=#FFFFFF><font face=verdana color=#333333 size=1><b>Email Address:</b></td>
    <td bgcolor=#FFFFFF><input type=text size=20 name="emailaddress" value="$emailaddress"></td>
    </tr><tr>
    <td bgcolor=#FFFFFF><font face=verdana color=#333333 size=1><b>Homepage:</b></td>
    <td bgcolor=#FFFFFF><input type=text size=20 name="homepage" value="$homepage"></td>
    </tr><tr>
    <td bgcolor=#FFFFFF><font face=verdana color=#333333 size=1><b>AOL Name:</b></td>
    <td bgcolor=#FFFFFF><input type=text size=20 name="aolname" value="$aolname"></td>
    </tr><tr>
    <td bgcolor=#FFFFFF><font face=verdana color=#333333 size=1><b>ICQ Number:</b></td>
    <td bgcolor=#FFFFFF><input type=text size=20 name="icqnumber" value="$icqnumber"></td>
    </tr><tr>
    <td bgcolor=#FFFFFF><font face=verdana color=#333333 size=1><b>Location:</b></td>
    <td bgcolor=#FFFFFF><input type=text size=20 name="location" value="$location"></td>
    </tr><tr>
    <td bgcolor=#FFFFFF><font face=verdana color=#333333 size=1><b>Time offset:</b></td>
    <td bgcolor=#FFFFFF><input type=text size=20 name="timedifference" value="$timedifference"></td>
    </tr><tr>
    <td bgcolor=#FFFFFF align=left colspan=2><font face=verdana color=#333333 size=1><b>Private Forums (check box to allow access)</b><br>
    $privateoutput</td>
    </tr><tr>
    <td bgcolor=#FFFFFF><font face=verdana color=#333333 size=1><b>Memberstate:</b></td>
    <td bgcolor=#FFFFFF>$memberstateoutput</td>
    </tr><tr>
    <td colspan=2 bgcolor=#EEEEEE align=center><input type=submit value=submit name=submit></form></td>
    </tr>
    ~;
    
    } # end else
    
} # endroute


############### delete member

sub deletemember {

if ($checkaction eq "yes") {

    # Check to see if they were the last member to register

    require "$ikondir" . "data/boardstats.cgi";
        

    if($inmember eq "$lastregisteredmember") { #start
        
        # If they were, go through the members, and find the previous last registered

        $dirtoopen = "$ikondir" . "members";

        opendir (DIR, "$dirtoopen"); 
        @filedata = readdir(DIR);
        closedir (DIR);
        @inmembers = grep(/cgi/,@filedata);

        local($highest) = 0;

        foreach (@inmembers) {
            $_ =~ s/\.cgi//g;
            &getmember("$_");
            if (($joineddate > $highest) && ($inmember ne $membername)) {
                $highest = $joineddate;
                $memberkeep = $membername;
                }
        }
        


        $filetomake = "$ikondir" . "data/boardstats.cgi";
        $totalmembers--;
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "\$lastregisteredmember = \"$memberkeep\"\;\n";
        print FILE "\$totalmembers = \"$totalmembers\"\;\n";
        print FILE "\$totalthreads = \"$totalthreads\"\;\n";
        print FILE "\$totalposts = \"$totalposts\"\;\n";
        print FILE "\n1\;";
        close (FILE);
        } # end if new/delete member

    else {
        require "$ikondir" . "data/boardstats.cgi";

        $filetomake = "$ikondir" . "data/boardstats.cgi";
        $totalmembers--;
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "\$lastregisteredmember = \"$lastregisteredmember\"\;\n";
        print FILE "\$totalmembers = \"$totalmembers\"\;\n";
        print FILE "\$totalthreads = \"$totalthreads\"\;\n";
        print FILE "\$totalposts = \"$totalposts\"\;\n";
        print FILE "\n1\;";
        close (FILE);
        } # end if else

        # Delete the database for the member

        $filetounlink = "$ikondir" . "members/$inmember.cgi";
        unlink $filetounlink;

        print qq~
        <tr>
        <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
        <font face=verdana color=#333333 size=3><b>The member has been deleted, and the member removed from the database</b>
        </td></tr>
         ~;


} # end checkaction else

else {

        $cleanedmember = $inmember;
        $cleanedmember =~ s/\_/ /g;

        print qq~
        <tr>
        <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
        <font face=verdana color=#990000 size=3><b>WARNING!</b>
        </td></tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=center colspan=2>
        <font face=verdana color=#333333 size=2>Only click on the link below if you wish to delete <b>$cleanedmember</b><p>
        &raquo;<a href="$thisprog?action=deletemember&checkaction=yes&member=$inmember">Delete the member</a>&laquo;
        </td></tr>
        </table></td></tr></table>
        ~;
        }

} # end routine


sub unban {

        &getmember("$inmember");
    
        $memberfiletitle = $inmember;
        $memberfiletitle =~ s/ /\_/isg;

        # Remove from ban lists
            
        $filetoopen = "$ikondir" . "data/banlist.cgi";
        open(FILE,"$filetoopen");
        @bandata = <FILE>;
        close(FILE);

        open(FILE,">$filetoopen");
        flock (FILE, 2);
        foreach (@bandata) {
            chomp $_;
            ($bannedname, $bannedemail, $bannedip) = split(/\|/,$_);
            $bannedname =~ s/\_/ /g;
            unless ($bannedname eq $membername) { print FILE "$_\n"; }
            }
        close(FILE);
            

        $filetomake = "$ikondir" . "members/$memberfiletitle.cgi";
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "$membername|$password|Member|me|$numberofposts|$emailaddress|$showemail|$ipaddress|$homepage|$aolname|$icqnumber|$location|$interests|$joineddate|$lastpostdate|$signature|$timedifference|$allowedforums|$useravatar|$misc1|$misc2|$misc3";
        close(FILE);

        print qq~
        <tr>
        <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
        <font face=verdana color=#333333 size=3><b>$membername has been unbanned</b>
        </td></tr>
        ~;

} # end route


print qq~</td></tr></table></body></html>~;
exit;





