#!/usr/bin/perl

#############################################################
# Ikonboard v2.1
# Copyright 2000 Ikondiscussion.com - All Rights Reserved
# Ikondiscussion is a trademark of Ikondiscussion.com
#
# Software Distributed by: Ikondiscussion.com
# Visit us online at http://www.ikondiscussion.com
# Email us on boards@ikondiscussion.com
#
# All files written by Matthew Mecham
# This file co-written with ArmandoG
#############################################################

use CGI::Carp "fatalsToBrowser";          # Output errors to browser
use CGI qw(:standard);                    # Saves loads of work
$CGI::POST_MAX=1024 * 150;                # limit post data
$CGI::DISABLE_UPLOADS = 1;                # Disable uploads

eval {
($0 =~ m,(.*)/[^/]+,)   and unshift (@INC, "$1");
($0 =~ m,(.*)\\[^\\]+,) and unshift (@INC, "$1");
require "ikon.lib";          # Require ikonboard ()
require "ikonadmin.lib";     # Require Admin func()
require "data/progs.cgi";    # Require prog names
require "data/boardinfo.cgi";# Require board info
require "data/styles.cgi";   # Require styles info
};
if ($@) {
    print header(); print start_html(-title=>"Ikonboard Error!");
    print "Could not find these files: $@\nIf you are running NT you may need to enter the full path in each require statement in each script";
    print end_html; exit;
}

$|++;                                     # Unbuffer the output

#################--- Begin the program ---###################

$thisprog = "setforums.cgi";

$inmembername = cookie("adminname");
$inpassword   = cookie("adminpass");


    $query = new CGI;

    &checkVALIDITY;
    
	@params = $query->param;
	foreach $param(@params) {
		$theparam = $query->param($param);
        $theparam = &cleaninput("$theparam");
		$PARAM{$param} = $theparam;
	    }

    $cookiepath = $query->url(-absolute=>1);
    $cookiepath =~ s/$thisprog//sg;

    $action      =  $PARAM{'action'};
    $inforum     =  $PARAM{'forum'};
    $incategory  =  $PARAM{'category'};
    $checkaction =  $PARAM{'checkaction'};

    $new_categoryname     = $PARAM{'categoryname'};
    $new_categorynumber   = $PARAM{'categorynumber'};
    $new_forumname        = $PARAM{'forumname'};
    $new_forumdescription = $PARAM{'forumdescription'};
    $new_forummoderator   = $PARAM{'forummoderator'};
    $new_htmlstate        = $PARAM{'htmlstate'};
    $new_idmbcodestate    = $PARAM{'idmbcodestate'};
    $new_privateforum     = $PARAM{'privateforum'};
    $new_startnewthreads  = $PARAM{'startnewthreads'};
    $new_forumgraphic     = $PARAM{'forumgraphic'};
   


print header();

&admintitle;
        
&getmember("$inmembername");
        
        if (($membercode eq "ad") && ($inpassword eq $password) && ($inmembername eq $membername)) { #s1
            
            my %Mode = ( 
            'addforum'            =>    \&addforum,
            'processnew'          =>    \&createforum,
            'edit'                =>    \&editform,
            'doedit'              =>    \&doedit,       
            'addcategory'         =>    \&catform,
            'doaddcategory'       =>    \&doaddcategory,
            'editcatname'         =>    \&editcatname,
            'reordercategories'   =>    \&reordercats,
            'recount'             =>    \&recount
            );


            if($Mode{$action}) { 
               $Mode{$action}->();
               }
                elsif (($action eq "delete") && ($checkaction ne "yes")) { &warning; }
                elsif (($action eq "delete") && ($checkaction eq "yes")) { &deleteforum; }
                else { &forumlist; }
            
            } #e1
                
                else {
                    &adminlogin;
                    }
        

##################################################################################
######## Subroutes (forum list)

sub forumlist {
    $highest = 0;
    print qq~
    <tr><td bgcolor=#333333 colspan=3><font face=verdana size=3 color=#FFFFFF>
    <b>Welcome to your ikon board Administration Center / Forum Set-up</b>
    </td></tr>
    <tr><td bgcolor=#FFFFFF colspan=3><font face=verdana size=1 color=#333333>
    <b>Quick Notes:</b><br><br>
    Below you will see a list of your current categories and forums. You can either choose to edit the category name or add a new 
    forum to that category. You can either edit an existing forum, or detele the forum.<br><br>
    You may also redorder the way the current categories are listed or choose to add another category and forum (in the new category).
    </td></tr>
    ~;

    $filetoopen = "$ikondir" . "data/allforums.cgi";
    open(FILE, "$filetoopen");
    @forums = <FILE>;
    close(FILE);

    foreach $forum (@forums) { #start foreach @forums
        chomp $forum;
        ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);
        $rearrange = ("$categoryplace|$category|$forumname|$forumdescription|$forumid|$threads|$posts");
        push (@rearrangedforums, $rearrange);

    } # end foreach (@forums)

    @finalsortedforums = sort(@rearrangedforums);

    foreach $sortedforums (@finalsortedforums) { #start foreach @finalsortedforums

        ($categoryplace, $category, $forumname, $forumdescription, $forumid, $threads, $posts) = split(/\|/,$sortedforums);
    
        if ($categoryplace ne $lastcategoryplace) { #start if $categoryplace
            print qq~
            <tr>
            <td bgcolor=#EEEEEE width=20% nowrap><font face=verdana color=#333333 size=3>
            <b>&raquo; $category</b><td bgcolor=#EEEEEE width=15% align=center nowrap><font face=verdana color=#333333 size=2><a href="$thisprog?action=editcatname&category=$categoryplace">Edit Category Name</a></td><td bgcolor=#EEEEEE width=25% align=left><font face=verdana color=#333333 size=2><a href="$thisprog?action=addforum&category=$categoryplace"><b>Add Forum to this category</b></a></font></td>
            </td></tr>
            <tr>
            <td bgcolor=#FFFFFF colspan=3 align=left nowrap><font face=verdana color=#333333 size=3>
            <b>$forumname</b><br><font face=verdana color=#333333 size=2>Posts: <b>$posts</b> | Topics: <b>$threads</b><br><br><a href="$thisprog?action=edit&forum=$forumid">Edit Forum</a> | <font face=verdana color=#333333 size=2><a href="$thisprog?action=delete&forum=$forumid">Delete Forum</a> | <a href="$thisprog?action=recount&forum=$forumid">Recount Post Numbers / Fix Forum</a></font></td>
             </font></td></tr>
            ~;
            } # end if
            else {
                print qq~
                <tr>
                <td bgcolor=#FFFFFF colspan=3 align=left nowrap><hr noshade size=1><font face=verdana color=#333333 size=3>
                <b>$forumname</b><br><font face=verdana color=#333333 size=2>Posts: <b>$posts</b> | Topics: <b>$threads</b><br><br><a href="$thisprog?action=edit&forum=$forumid">Edit Forum</a> | <font face=verdana color=#333333 size=2><a href="$thisprog?action=delete&forum=$forumid">Delete Forum</a> | <a href="$thisprog?action=recount&forum=$forumid">Recount Post Numbers / Fix Forum</a></font></td>
                </font></td></tr>
                ~;
                }
            $lastcategoryplace = $categoryplace;
            if ($categoryplace > $highest) { $highest = $categoryplace; }
            } # end foreach
    
        $highest++;
        
        print qq~
        <tr>
        <td bgcolor=#EEEEEE colspan=3 align=center><font face=verdana color=#333333 size=3>
        <a href="$thisprog?action=reordercategories"><b>Reorder Current Categories</b></a>
         - <a href="$thisprog?action=addcategory&category=$highest"><b>Add new Category and forum</b></a>
        </font></td>
        </tr>
        </tr></table></td></tr></table>~;
    
} # end routine.

##################################################################################
######## Recount forum posts


sub recount { #start

        
        $dirtoopen = "$ikondir" . "forum$inforum";
        
        opendir (DIR, "$dirtoopen"); 
        @dirdata = readdir(DIR);
        closedir (DIR);
        
        @thd = grep(/thd/,@dirdata);
        $topiccount = @thd;
        

        foreach $topic (@thd) {
        
        $filetoopen = "$ikondir" . "forum$inforum/$topic";

            open (FILE, "$filetoopen");
            @threads = <FILE>;
            close (FILE);

            $newthreads = @threads;
            $newthreads--;
            $threadcount = ($threadcount + $newthreads);
         }
       
         $threadcount = "0" if (!$threadcount);
         $topiccount  = "0" if (!$topiccount);
                    
        
         $filetoopen = "$ikondir" . "data/allforums.cgi";
         open(FILE,"$filetoopen") or &systemerror("Cannot locate $filetoopen");
         @allforums = <FILE>;
         close(FILE);

         $filetomake = "$ikondir" . "data/allforums.cgi";
         open(FILE, ">$filetomake");
         flock(FILE, 2);
         foreach $forum (@allforums) { #start foreach @forums
         chomp($forum);
            ($tempno, $trash) = split(/\|/,$forum);
                if ($inforum eq $tempno) {
                    ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);
                    $posts = $threadcount;
                    $threads = $topiccount;
                    print FILE "$forumid|$category|$categoryplace|$forumname|$forumdescription|$forummoderator|$htmlstate|$idmbcodestate|$privateforum|$startnewthreads|$lastposter|$lastposttime|$threads|$posts|$forumgraphic\n";
                }
            else { print FILE "$forum\n"; }
         }
         close(FILE);
    
         rebuildLIST(-Forum=>"$inforum");

         print qq~
         <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
         <b>Welcome to your ikon board Administration Center / Recount forum results</b>
         </td></tr>
         <tr>
         <td bgcolor=#FFFFFF valign=middle align=left colspan=2>
         <font face=verdana color=#990000 size=3>
         <center><b>Forum Updated succesfully</b></center><p>
         $topiccount total topic(s)<p>
         $threadcount total replies to topics
         </td></tr></table></td></tr></table>
         ~;


} # routine ends

##################################################################################
######## Subroutes ( Add forum Form )


sub addforum {

        print qq~
        <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
        <b>Welcome to your ikon board Administration Center / Add a forum</b>
        </td></tr>
        ~;

        $filetoopen = "$ikondir" . "data/allforums.cgi";
        open(FILE, "$filetoopen");
        @forums = <FILE>;
        close(FILE);


# Find the category name from the number

        foreach (@forums) {
            ($trash, $tempcategoryname, $tempcategoryplace, $trash) = split(/\|/, $_);
            if ($incategory eq $tempcategoryplace) {
                $category = $tempcategoryname;
                }
            }
        
        
# Present the form to be filled in


        print qq~
        
        <tr>
        <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
        <font face=verdana color=#990000 size=3><b>New forum in category '$category' set-up</b>
        </td></tr>
                
        <form action="$thisprog" method="post">
        <input type=hidden name="categorynumber" value="$incategory">
        <input type=hidden name="categoryname" value="$category">
        <input type=hidden name="action" value="processnew">       
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Forum Name</b><br>Please enter the name of your new forum</font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="forumname" value="$forumname"></td>
        </tr>       
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Forum Description</b><br>Please enter the description of your new forum</font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="forumdescription" value="$forumdescription"></td>
        </tr>   
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Forum Moderator(s)</b><br>Please enter the moderator(s) of your new forum. If you wish to have multiple moderators, enter the names seperated by a comma. For example : name1,name2,name3</font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="forummoderator" value="$forummoderator"></td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>HTML On or Off?</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <select name="htmlstate">
        <option value="on">ON<option value="off" selected>OFF</select>
        </td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>IkonCode On or Off?</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <select name="idmbcodestate">
        <option value="on" selected>ON<option value="off">OFF</select>
        </td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Do you wish to make this a private forum?</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <select name="privateforum">
        <option value="yes">YES<option value="no" selected>NO</select>
        </td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Who's allowed to start new threads?</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <select name="startnewthreads">
        <option value="yes" selected>All registered members<option value="no">Admin/Forum moderator(s) only</select>
        </td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Forum Graphic</b><br>Please enter the name of the graphic to be used. This is the graphic that sits to the left of the links under the menu.(i.e. general.gif) <b>Do not include the URL or path to it</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="forumgraphic" value="logo.gif"></td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=center colspan=2>
        <input type=submit value=submit ></form></td></tr></table></td></tr></table>
        ~;
        
} # end route   


##################################################################################
######## Subroutes ( Create Forum )


sub createforum {   


                $filetoopen = "$ikondir" . "data/allforums.cgi";
                open(FILE, "$filetoopen");
                @forums = <FILE>;
                close(FILE);

                # Create a new number for the new forum folder, and files.

                foreach (@forums) {
                    ($forumid, $binit) = split(/\|/,$_);
                    if ($forumid > $high) { $high = $forumid; }
                    }
                    
                $high++;
                
                $newforumid = $high;    

               
                # Lets create the directory.
                
                $dirtomake = "$ikondir" . "forum$newforumid";

                mkdir ("$dirtomake", 0755);
                
                # Lets add a file to stop snoops, and to use to see if the forum was created
                
                $filetomake = "$dirtomake/index.html";
                open(FILE,">$filetomake");
                print FILE "-";
                close(FILE);

                $filetomake = "$dirtomake/.htaccess";
                open(FILE, ">$filetomake");
                flock (FILE, 2);
                print FILE "AuthUserFile /dev/null\n";
                print FILE "AuthGroupFile /dev/null\n";
                print FILE "AuthName DenyViaWeb\n";
                print FILE "AuthType Basic\n";
                print FILE "\n\n\n\n";
                print FILE "<Limit GET>\n";
                print FILE "order allow,deny\n";
                print FILE "deny from all\n";
                print FILE "</Limit>\n";
                close (FILE);

                $filetoopen = "$ikondir" . "data/allforums.cgi";
                open(FILE, "$filetoopen");
                @forums = <FILE>;
                close(FILE);
   
                
                open(FILE, ">$filetoopen");
                flock(FILE, 2);
                foreach $line (@forums) {
                    chomp $line;
                    print FILE "$line\n";
                    }
                print FILE "$newforumid|$new_categoryname|$new_categorynumber|$new_forumname|$new_forumdescription|$new_forummoderator|$new_htmlstate|$new_idmbcodestate|$new_privateforum|$new_startnewthreads|||0|0|$new_forumgraphic";
                close(FILE);
                
                print qq~
                <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
                <b>Welcome to your ikon board Administration Center / Add a forum result:</b>
                </td></tr>
                <tr>
                <td bgcolor=#FFFFFF valign=middle align=left colspan=2>
                <font face=verdana color=#333333 size=2>
                ~;

                print "<b>Status</b><p>\n";
                print "<ul>\n";
                if (-e $dirtomake) {
                print "<li><b>New Forum Directory Created</b><p>\n";
                    }
                    else {
                        print "<li><b>New Forum Directory Not Created</b><p>Are you sure the directory containing the forum folders has been CHMODded correctly?<p>\n";
                        }
                

                $filetoopen = "$dirtomake/index.html";
                if (-e $filetoopen) {
                    print "<li><b>New Forum (index.html) File Created</b><p>\n";
                    }
                    else {
                        print "<li><b>New Forum (index.html) File Not Created</b><p>Check the CHMOD value of the root Ikonboard folder\n";
                        }
                print "$filetoopen<p>\n";
                print "</ul></td></tr></table></td></tr></table>\n";

} ######## end routine
        
##################################################################################
######## Subroutes ( Warning of Delete Forum )  

sub warning { #start

        print qq~
        <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
        <b>Welcome to your ikon board Administration Center / Delete a forum</b>
        </td></tr>
        <tr>
        <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
        <font face=verdana color=#990000 size=3><b>WARNING!</b>
        </td></tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=center colspan=2>
        <font face=verdana color=#333333 size=2>Only click on the link below if you wish to delete the forum, and all of it's contents!<p>
        &raquo;<a href="$thisprog?action=delete&checkaction=yes&forum=$inforum">Delete the forum, and all files</a>&laquo;
        </td></tr>
        </table></td></tr></table>
        
        ~;
        
} # end routine     
        
##################################################################################
######## Subroutes ( Deletion of a Forum )  

sub deleteforum { #start

        
        $dirtoopen = "$ikondir" . "forum$inforum";
        
        opendir (DIR, "$dirtoopen"); 
        @dirdata = readdir(DIR);
        closedir (DIR);
        
        @thd = grep(/thd/,@dirdata);
        $thdcount = @thd;
        
        @mal = grep(/mal/,@dirdata);
        @list = grep(/cgi/,@dirdata);


        foreach $topic (@thd) {
        
        $filetoopen = "$ikondir" . "forum$inforum/$topic";

            open (FILE, "$filetoopen");
            @threads = <FILE>;
            close (FILE);

            $newthreads = @threads;

            $threadcount = ($threadcount + $newthreads);

            }
       
            $threadcount--;
                    
        foreach $file (@thd) {
            $filetoremove = "$dirtoopen/$file";
            unlink $filetoremove;
            }
        foreach $file (@mal) {
            $filetoremove = "$dirtoopen/$file";
            unlink $filetoremove;
            }
        foreach $file (@list) {
            $filetoremove = "$dirtoopen/$file";
            unlink $filetoremove;
            }
        
        # Remove all remaining files.

        foreach $file (@dirdata) {
            $filetoremove = "$dirtoopen/$file";
            unlink $filetoremove;
            }

         $dirtoremove = "$ikondir" . "forum$inforum";
         rmdir $dirtoremove;

         $filetoopen = "$ikondir" . "data/allforums.cgi";
         open(FILE,"$filetoopen") or &systemerror("Cannot locate $filetoopen");
         flock (FILE, 2);
         @forums = <FILE>;
         close(FILE);

         open(FILE,">$filetoopen");
         flock(FILE,2);
         foreach $forum (@forums) {
         chomp $forum;
            ($forumid,$category,$notneeded,$notneeded) = split(/\|/,$forum);
                unless ($forumid eq "$inforum") {
                    print FILE "$forum\n";
                    }
                }
         close(FILE);


        require "$ikondir" . "data/boardstats.cgi";
        
        $filetomake = "$ikondir" . "data/boardstats.cgi";
        
        $totalthreads = $totalthreads - $thdcount;
        $totalposts = $totalposts - $threadcount;
        
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "\$lastregisteredmember = \"$lastregisteredmember\"\;\n";
        print FILE "\$totalmembers = \"$totalmembers\"\;\n";
        print FILE "\$totalthreads = \"$totalthreads\"\;\n";
        print FILE "\$totalposts = \"$totalposts\"\;\n";
        print FILE "\n1\;";
        close (FILE);

                    
                    print qq~
                    <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
                    <b>Welcome to your ikon board Administration Center / Delete a forum results</b>
                    </td></tr>
                    <tr>
                    <td bgcolor=#FFFFFF valign=middle align=left colspan=2>
                    <font face=verdana color=#990000 size=3>
                    
                    <center><b>Forum Deleted</b></center><p>
                    
                    $thdcount topic(s) deleted<p>

                    $threadcount threads deleted
                    
                    </td></tr></table></td></tr></table>
                    ~;


} # routine ends

##################################################################################
######## Subroutes ( Editing of a Forum )   

sub editform {

        
        # Grab the line to edit.
        
        $filetoopen = "$ikondir" . "data/allforums.cgi";
         open(FILE,"$filetoopen") or &systemerror("Cannot locate $filetoopen");
         flock(FILE,2);
         @forums = <FILE>;
         close(FILE);

         
         foreach $forum (@forums) {
         chomp $forum;
            ($forumid,$category,$notneeded,$notneeded) = split(/\|/,$forum);
                if ($forumid eq "$inforum") {
                    ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);   
                    }
                }
         
# Present the form to be filled in


        print qq~
        <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
        <b>Welcome to your ikon board Administration Center / Edit a forum</b>
        </td></tr>
        <tr>
        <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
        <font face=verdana color=#990000 size=3><b>Edit '$forumname' in category '$category' set-up</b>
        </td></tr>
                
        <form action="$thisprog" method="post">
        <input type=hidden name="action" value="doedit">
        <input type=hidden name="forum" value="$inforum">
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Forum Name</b><br>Please enter the new name of your forum</font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="forumname" value="$forumname"></td>
        </tr>       
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Forum Description</b><br>Please enter the new description of your forum</font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="forumdescription" value="$forumdescription"></td>
        </tr>   
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Forum Moderator(s)</b><br>Please enter the moderator(s) of your forum. If you wish to have multiple moderators, enter the names seperated by a comma. For example : name1,name2,name3</font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="forummoderator" value="$forummoderator"></td>
        </tr>
        ~;
        
        $tempoutput = qq~<select name="htmlstate"><option value="on">ON<option value="off">OFF</select>~;
        $tempoutput =~ s/value=\"$htmlstate\"/value=\"$htmlstate\" selected/g;
        
        print qq~
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>HTML On or Off?</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        $tempoutput
        </td>
        </tr>
        ~;
        
        $tempoutput = qq~<select name="idmbcodestate"><option value="on">ON<option value="off">OFF</select>~;
        $tempoutput =~ s/value=\"$idmbcodestate\"/value=\"$idmbcodestate\" selected/g;
        
        print qq~
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>IkonCode On or Off?</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        $tempoutput
        </td>
        </tr>
        ~;
        
        $tempoutput = qq~<select name="privateforum"><option value="yes">YES<option value="no">NO</select>~;
        $tempoutput =~ s/value=\"$privateforum\"/value=\"$privateforum\" selected/g;
        if (!$privateforum) { 
            $tempoutput = qq~<select name="privateforum"><option value="yes">YES<option value="no" selected>NO</select>~;
            }
        print qq~
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Do you wish to make this a private forum?</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        $tempoutput
        </td>
        </tr>
        ~;
        
        $tempoutput = qq~<select name="startnewthreads"><option value="yes">All registered members<option value="no">Admin/Forum moderator(s) only</select>~;
        $tempoutput =~ s/value=\"$startnewthreads\"/value=\"$startnewthreads\" selected/g;
        
        print qq~
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Who's allowed to start new threads?</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        $tempoutput
        </td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Forum Graphic</b><br>Please enter the path of the graphic to be used. This is the graphic that sits to the left of the links under the menu.</font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="forumgraphic" value="$forumgraphic"></td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=center colspan=2>
        <input type=submit value=submit ></form></td></tr></table></td></tr></table>
        ~;
        
} # end route   

##################################################################################
######## Subroutes ( Processing the edit of a forum)    


sub doedit {
        
        # Grab the line to edit.
        
         $filetoopen = "$ikondir" . "data/allforums.cgi";
         open(FILE,"$filetoopen") or &systemerror("Cannot locate $filetoopen");
         flock(FILE,2);
         @forums = <FILE>;
         close(FILE);

         foreach $forum (@forums) {
         chomp $forum;
            ($forumid, $notneeded) = split(/\|/,$forum);
                if ($forumid eq "$inforum") {
                    ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);   
                    }
                }

                # Time to process the forms

                $editedline = "$inforum|$category|$categoryplace|$new_forumname|$new_forumdescription|$new_forummoderator|$new_htmlstate|$new_idmbcodestate|$new_privateforum|$new_startnewthreads|$lastposter|$lastposttime|$threads|$posts|$new_forumgraphic";
                chomp $editedline;

                # Lets re-open the file
                
                $filetoopen = "$ikondir" . "data/allforums.cgi";
                open(FILE,"$filetoopen") or &systemerror("Cannot locate $filetoopen");
                flock(FILE,2);
                @forums = <FILE>;
                close(FILE);
                
                # Lets remake the file...
                
                $filetoopen = "$ikondir" . "data/allforums.cgi";
                open(FILE,">$filetoopen") or &systemerror("Cannot locate $filetoopen");
                flock(FILE,2);
                foreach $forum (@forums) {
                chomp $forum;
                ($tempforumid,$notneeded) = split(/\|/,$forum);
                    if ($tempforumid eq "$inforum") {
                        print FILE "$editedline\n";
                        }
                        else {
                            print FILE "$forum\n";
                            }
                    }
                close (FILE);


                 print qq~
                <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
                <b>Welcome your ikon board Administration Center / Edit forum Result:</b>
                </td></tr>
                <tr>
                <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
                <font face=verdana color=#333333 size=3><b>All information saved</b><p>
                <font size=2>
                If you have made someone a moderator, you may wish to edit their profile from
                within the administration center to make them a moderator. This is not vitally  
                important, although they will not have the 'team' icon next to their name.</font>
                </td></tr></table></td></tr></table>
                ~;
                
            } # end routine

##################################################################################
######## Subroutes ( Add category/forum Form )


sub catform {

# Present the form to be filled in


        print qq~
        <form action="$thisprog" method="post">
        <input type=hidden name="action" value="doaddcategory">
        <input type=hidden name="category" value="$incategory">
        <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
        <b>Welcome to your ikon board Administration Center / Add new Category and Forum</b>
        </td></tr>
        <tr>
        
        <tr>
        <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
        <font face=verdana color=#990000 size=3><b>New category and forum set-up</b>
        </td></tr>
                
                
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Category Name</b><br>Please enter the name of your new Category</font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="categoryname" value="$categoryname"></td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Forum Name</b><br>Please enter the name of your new forum</font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="forumname" value="$forumname"></td>
        </tr>       
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Forum Description</b><br>Please enter the description of your new forum</font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="forumdescription" value="$forumdescription"></td>
        </tr>   
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Forum Moderator(s)</b><br>Please enter the moderator(s) of your new forum. If you wish to have multiple moderators, enter the names seperated by a comma. For example : name1,name2,name3</font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="forummoderator" value="$forummoderator"></td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>HTML On or Off?</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <select name="htmlstate">
        <option value="on">ON<option value="off" selected>OFF</select>
        </td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>IkonCode On or Off?</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <select name="idmbcodestate">
        <option value="on" selected>ON<option value="off">OFF</select>
        </td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Do you wish to make this a private forum?</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <select name="privateforum">
        <option value="yes">YES<option value="no" selected>NO</select>
        </td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Who's allowed to start new threads?</b></font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <select name="startnewthreads">
        <option value="yes" selected>All registered members<option value="no">Admin/Forum moderator(s) only</select>
        </td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=left width=40%>
        <font face=verdana color=#333333 size=1><b>Forum Graphic</b><br>Please enter the name of the graphic to be used. This is the graphic that sits to the left of the links under the menu.</font></td>
        <td bgcolor=#FFFFFF valign=middle align=left>
        <input type=text size=40 name="forumgraphic" value="logo.gif"></td>
        </tr>
        
        <tr>
        <td bgcolor=#FFFFFF valign=middle align=center colspan=2>
        <input type=submit value=submit ></form></td></tr></table></td></tr></table>
        ~;
        
} # end route   


##################################################################################
######## Subroutes ( Create New cat/forum )


sub doaddcategory { 

                $filetoopen = "$ikondir" . "data/allforums.cgi";
                open(FILE, "$filetoopen");
                @forums = <FILE>;
                close(FILE);

                # Create a new number for the new forum folder, and files.

                foreach (@forums) {
                    ($forumid, $binit) = split(/\|/,$_);
                    if ($forumid > $high) { $high = $forumid; }
                    }
                    
                $high++;
                
                $newforumid = $high;    

               
                # Lets create the directory.
                
                $dirtomake = "$ikondir" . "forum$newforumid";

                mkdir ("$dirtomake", 0755);
                
                # Lets add a file to stop snoops, and to use to see if the forum was created
                
                $filetomake = "$dirtomake/index.html";
                open(FILE,">$filetomake");
                print FILE "-";
                close(FILE);
                
                $filetomake = "$dirtomake/.htaccess";
                open(FILE, ">$filetomake");
                flock (FILE, 2);
                print FILE "AuthUserFile /dev/null\n";
                print FILE "AuthGroupFile /dev/null\n";
                print FILE "AuthName DenyViaWeb\n";
                print FILE "AuthType Basic\n";
                print FILE "\n\n\n\n";
                print FILE "<Limit GET>\n";
                print FILE "order allow,deny\n";
                print FILE "deny from all\n";
                print FILE "</Limit>\n";
                close (FILE);

                $filetoopen = "$ikondir" . "data/allforums.cgi";
                open(FILE, "$filetoopen");
                @forums = <FILE>;
                close(FILE);
   
                
                open(FILE, ">$filetoopen");
                flock(FILE, 2);
                foreach $line (@forums) {
                    chomp $line;
                    print FILE "$line\n";
                    }
                print FILE "$newforumid|$new_categoryname|$incategory|$new_forumname|$new_forumdescription|$new_forummoderator|$new_htmlstate|$new_idmbcodestate|$new_privateforum|$new_startnewthreads|||0|0|$new_forumgraphic";
                close(FILE);
                
                print qq~
                <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
                <b>Welcome to your ikon board Administration Center / Add a Category and Forum result:</b>
                </td></tr>
                <tr>
                <td bgcolor=#FFFFFF valign=middle align=left colspan=2>
                <font face=verdana color=#333333 size=2>
                ~;

                print "<b>Status</b><p>\n";
                print "<ul>\n";
                if (-e $dirtomake) {
                print "<li><b>New Category and Forum Directory Created</b><p>\n";
                    }
                    else {
                        print "<li><b>New Category and Forum Directory Not Created</b><p>Are you sure the directory containing the forum folders has been CHMODded correctly?<p>\n";
                        }
                

                $filetoopen = "$dirtomake/index.html";
                if (-e $filetoopen) {
                    print "<li><b>New Forum (index.html) File Created</b><p>\n";
                    }
                    else {
                        print "<li><b>New Forum (index.html) File Not Created</b><p>\n";
                        }
                print "$filetoopen<p>\n";
                print "</ul></td></tr></table></td></tr></table>\n";

} # end routine
        

##################################################################################
######## Subroutes ( Edit Category Name )


sub editcatname {

        
        if ($checkaction ne "yes") {
        
            # Grab the line to edit.
        
            $filetoopen = "$ikondir" . "data/allforums.cgi";
            open(FILE,"$filetoopen") or &systemerror("Cannot locate $filetoopen");
            flock(FILE,2);
            @forums = <FILE>;
            close(FILE);

            foreach $forum (@forums) {
            chomp $forum;
                ($notneeded, $notneeded, $categoryplace) = split(/\|/,$forum);
                    if ($incategory eq "$categoryplace") {
                        ($trash, $categoryname, $notneeded) = split(/\|/,$forum);   
                        }
                    }
        
            # Present the form to be filled in


            print qq~
            <form action="$thisprog" method="post">
            <input type=hidden name="action" value="editcatname">
            <input type=hidden name="category" value="$incategory">
            <input type=hidden name="checkaction" value="yes">
            <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
            <b>Welcome to your ikon board Administration Center / Edit Categoryname</b>
            </td></tr>
            <tr>
        
            <tr>
            <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
            <font face=verdana color=#990000 size=3><b>Edit the name of category '$categoryname'</b>
            </td></tr>
                
                
            <tr>
            <td bgcolor=#FFFFFF valign=middle align=left width=40%>
            <font face=verdana color=#333333 size=1><b>Category Name</b><br>Please enter the new name of your Category</font></td>
            <td bgcolor=#FFFFFF valign=middle align=left>
            <input type=text size=40 name="categoryname" value="$categoryname"></td>
            </tr>
            
            
            <tr>
            <td bgcolor=#FFFFFF valign=middle align=center colspan=2>
            <input type=submit value=submit ></form></td></tr></table></td></tr></table>
            ~;
            } # end if
            
            else {
            
                # Grab the lines to change.
        
                $filetoopen = "$ikondir" . "data/allforums.cgi";
                open(FILE,"$filetoopen") or &systemerror("Cannot locate $filetoopen");
                flock(FILE,2);
                @forums = <FILE>;
                close(FILE);

                # Lets remake the file with the new info
                
                $filetoopen = "$ikondir" . "data/allforums.cgi";
                open(FILE,">$filetoopen") or &systemerror("Cannot locate $filetoopen");
                flock(FILE,2);
                foreach $forum (@forums) {
                chomp $forum;
                ($notneeded, $notneeded, $categorynumber) = split(/\|/,$forum);
                    if ($incategory eq "$categorynumber") {
                        ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);
                        $linetochange = "$forumid|$new_categoryname|$incategory|$forumname|$forumdescription|$forummoderator|$htmlstate|$idmbcodestate|$privateforum|$startnewthreads|$lastposter|$lastposttime|$threads|$posts|$forumgraphic"; 
                        chomp $linetochange;
                        print FILE "$linetochange\n";
                        $forumname = ""; $forumdescription = ""; $forummoderator = ""; $lastposter = ""; $lastposttime = ""; $threads = ""; $posts = ""; $forumgraphic = "";
                        }
                        else {
                            print FILE "$forum\n";
                            }
                    }
                close (FILE);
                
                
                print qq~
                <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
                <b>Welcome your ikon board Administration Center / Edit Category Name Result:</b>
                </td></tr>
                <tr>
                <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
                <font face=verdana color=#333333 size=3><b>All information saved</b>
                </td></tr></table></td></tr></table>
                ~;
                
                } # end else
                
            } # end routine


##################################################################################
######## Subroutes ( Edit Category Name )


sub reordercats {

        
        if ($checkaction ne "yes") {

            print qq~
            <form action="$thisprog" method="post">
            <input type=hidden name="action" value="reordercategories">
            <input type=hidden name="checkaction" value="yes">
            <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
            <b>Welcome to your ikon board Administration Center / Reorder Categories</b>
            </td></tr>
            <tr><td bgcolor=#FFFFFF" colspan=3><font face=verdana size=2 color=#333333>
            <b>Quick Notes:</b><br><br>
            You may reorder the categories. The categories are listed by number. <b>1 being listed first</b><br><br>
            <b>It is vital that you double check all the information before submitting.</b><br><br>
            <center>Please ensure that you haven't repeated a number. Doing so will render the category 'invisable'.</center><br><br>
            </td></tr>
            ~;
            
            $filetoopen = "$ikondir" . "data/allforums.cgi";
            open(FILE, "$filetoopen") or &systemerror("Cannot locate $filetoopen");
            @forums = <FILE>;
            close(FILE);

            foreach $forum (@forums) { #start foreach @forums
                chomp $forum;
                ($forumid, $category, $categoryplace, $forumname, $forumdescription) = split(/\|/,$forum);
                $rearrange = ("$categoryplace|$category|$forumname|$forumdescription|$forumid");
                push (@rearrangedforums, $rearrange);

                } # end foreach (@forums)

            @finalsortedforums = sort(@rearrangedforums);

            foreach $sortedforums (@finalsortedforums) { #start foreach @finalsortedforums

                ($categoryplace, $category) = split(/\|/,$sortedforums);
    
                if ($categoryplace ne $lastcategoryplace) { #start if $categoryplace
                    print qq~
                    <tr>
                    <td bgcolor=#FFFFFF width=40%><font face=verdana color=#333333 size=3>
                    <b>&raquo; $category</b></font></td>
                    <td bgcolor=#FFFFFF><font face=verdana color=#333333 size=2>Current Place [ $categoryplace ] - Enter the New Number - <input type=text size=4 maxlength=2 name="$categoryplace" value="$categoryplace">
                    </td></tr>
                    ~;
                    } # end if
                    
                    $lastcategoryplace = $categoryplace;
                    
                 } # end foreach
                    
                    
                    
                    print qq~
                    <tr>
                    <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
                    <input type=submit value=submit ></form></td></tr></table></td></tr></table>
                    ~;
                    
            } # end if
    
            
            else {
            
                # Grab the lines to change.
        
                $filetoopen = "$ikondir" . "data/allforums.cgi";
                open(FILE,"$filetoopen") or &systemerror("Cannot locate $filetoopen");
                flock(FILE,2);
                @forums = <FILE>;
                close(FILE);

                # Lets remake the file with the new info
                
                $filetoopen = "$ikondir" . "data/allforums.cgi";
                open(FILE,">$filetoopen") or &systemerror("Cannot locate $filetoopen");
                flock(FILE,2);
                foreach $forum (@forums) {
                    chomp $forum;
                    ($notneeded, $notneeded, $categorynumber) = split(/\|/,$forum);
                    $newid = $PARAM{$categorynumber};
                    ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);
                    print FILE "$forumid|$category|$newid|$forumname|$forumdescription|$forummoderator|$htmlstate|$idmbcodestate|$privateforum|$startnewthreads|$lastposter|$lastposttime|$threads|$posts|$forumgraphic\n"; 
                    }
            
                close (FILE);
                
                
                print qq~
                <tr><td bgcolor=#333333" colspan=2><font face=verdana size=3 color=#FFFFFF>
                <b>Welcome your ikon board Administration Center / Edit Category Name Result:</b>
                </td></tr>
                <tr>
                <td bgcolor=#EEEEEE valign=middle align=center colspan=2>
                <font face=verdana color=#333333 size=3><b>All information saved</b>
                </td></tr></table></td></tr></table>
                ~;
                
                } # end else
            
            
} # end routine

print qq~</td></tr></table></body></html>~;
exit;
