#!/usr/bin/perl

#############################################################
# Ikonboard v2.1
# Copyright 2000 Ikondiscussion.com - All Rights Reserved
# Ikondiscussion is a trademark of Ikondiscussion.com
#
# Software Distributed by: Ikondiscussion.com
# Visit us online at http://www.ikondiscussion.com
# Email us on boards@ikondiscussion.com
#
# All files written by Matthew Mecham
#############################################################

use CGI::Carp "fatalsToBrowser";          # Output errors to browser
use CGI qw(:standard);                    # Saves loads of work
$CGI::POST_MAX=1024 * 150;                # limit post data
$CGI::DISABLE_UPLOADS = 1;                # Disable uploads

eval {
($0 =~ m,(.*)/[^/]+,)   and unshift (@INC, "$1");
($0 =~ m,(.*)\\[^\\]+,) and unshift (@INC, "$1");
require "ikon.lib";          # Require ikonboard ()
require "data/progs.cgi";    # Require prog names
require "data/boardinfo.cgi";# Require board info
require "data/styles.cgi";   # Require styles info
};
if ($@) {
    print header(); print start_html(-title=>"Ikonboard Error!");
    print "Could not find these files: $@\nIf you are running NT you may need to enter the full path in each require statement in each script";
    print end_html; exit;
}

$|++;                                     # Unbuffer the output

#################--- Begin the program ---###################

$thisprog = "postings.cgi";

$query = new CGI;

&checkVALIDITY;

$cookiepath = $query->url(-absolute=>1);
$cookiepath =~ s/$thisprog//sg;

for ('forum','topic','membername','password','action','postno',
     'notify','deletepost','previewfirst','intopictitle','intopicdescription',
     'inpost','inshowemoticons','inshowsignature','checked','movetoid','leavemessage') {
    next unless defined $_;
    next if $_ eq 'SEND_MAIL';
    $tp = $query->param($_);
    $tp = &cleaninput("$tp");
    ${$_} = $tp;
    }


$inforum       = $forum;
$intopic       = $topic;
$inmembername  = $membername;
$inpassword    = $password;
$inpostno      = $postno;
$innotify      = $notify; 
$indeletepost  = $deletepost;
$inleavemessage= $leavemessage;
$currenttime   = time;


# Begin Program

if ($inshowemoticons ne "yes") { $inshowemoticons eq "no"; }
if ($innotify ne "yes")        { $innotify eq "no"; }

if ($checked eq "yes") {
    $namecookie = cookie(-name    =>   "amembernamecookie",
                         -value   =>   "$inmembername",
                         -path    =>   "$cookiepath",
                         -expires =>   "+30d");
    $passcookie = cookie(-name    =>   "apasswordcookie",
                         -value   =>   "$inpassword",
                         -path    =>   "$cookiepath",
                         -expires =>   "+30d");
    print header(-cookie=>[$namecookie, $passcookie]);
    }
    else {
        print header();
        }

if (($inforum)  && ($inforum !~ /^[0-9]+$/))  { &error("General&Please do not modify the URL's generated."); }
if (($intopic ) && ($intopic  !~ /^[0-9]+$/)) { &error("General&Please do not modify the URL's generated."); }
if (($inpostno) && ($inpostno !~ /^[0-9]+$/)) { &error("General&Please do not modify the URL's generated."); }
if (($movetoid) && ($movetoid !~ /^[0-9]+$/)) { &error("General&Please do not modify the URL's generated."); }


    if (! $inmembername) { $inmembername = cookie("amembernamecookie"); }
    if (! $inpassword) { $inpassword = cookie("apasswordcookie"); }

    if ($inmembername eq "") {
        $inmembername = "Guest";
        }
        else {
            &getmemberstime("$inmembername");
            }



# Begin Program

    my %Mode = ( 
    'edit'                 =>    \&editform,
    'lock'                 =>    \&lockthread,
    'unlock'               =>    \&unlockthread,        
    'delete'               =>    \&deletethread,
    'movetopic'            =>    \&movetopic
    );


    if($Mode{$action}) { 
        $Mode{$action}->();
        }
        elsif ($action eq "processedit" && $indeletepost eq "yes") { &deletepost;   }
        elsif ($action eq "processedit" && $previewfirst eq "no")  { &processedit;  }
        elsif ($action eq "processedit" && $previewfirst eq "yes") { &editform;     }
        else { &error("General&Please only access this script in the correct manner"); }


    &output(
    -Title   => $boardname, 
    -ToPrint => $output, 
    -Version => $versionnumber 
    );


############# subs

sub movetopic {
    
    &getmember("$inmembername");
    &moderator;

    $cleartomove = "no";
    
    &mischeader("Moving");
    
    if (($membercode eq "ad") && ($inpassword eq $password)) { $cleartomove = "yes"; }
    if (($inmembmod eq "yes") && ($inpassword eq $password)) { $cleartomove = "yes"; }
    unless ($cleartomove eq "yes") { $cleartomove = "no"; }
    
        if ($cleartomove eq "no" && $checked eq "yes") { &error("Moving Topic&You are not the forum moderator or board administrator or your password was incorrect"); }    
        
        if (($cleartomove eq "yes") && ($checked eq "yes") && ($movetoid)) {
        
                ### Get a new thread number.

                $dirtoopen = "$ikondir" . "forum$movetoid";
                opendir (DIR, "$dirtoopen"); 
                @numberdata = readdir(DIR);
                closedir (DIR);

                if ($movetoid == $inforum) { &error("Moving Topic&You cannot move the topic into the same forum it came from \!"); } 

                @sorteddirdata = grep(/thd/,@numberdata);
                @sorteddirdata = sort numerically(@sorteddirdata);
                @sorteddirdata = reverse(@sorteddirdata);

                $highestno = @sorteddirdata[0];
                $highestno =~ s/.thd//;
                $newthreadnumber = $highestno + 1;
                $currenttime = time;
                
                ### Get the old forum name
                
                $filetoopen = "$ikondir" . "data/allforums.cgi";
                open(FILE, "$filetoopen");
                @forums = <FILE>;
                close(FILE);

                foreach $forumline (@forums) { #start foreach @forums
                    ($tempno, $trash) = split(/\|/,$forumline);
                        if ($inforum eq $tempno) {
                        ($trash, $trash, $trash, $oldforumname, $trash) = split(/\|/,$forumline);
                        }
                    }
                
                ### Get the new forum name
                
                foreach $forumline (@forums) { #start foreach @forums
                    ($tempno, $trash) = split(/\|/,$forumline);
                        if ($movetoid eq $tempno) {
                        ($trash, $trash, $trash, $newforumname, $trash) = split(/\|/,$forumline);
                        }
                    }
                
                unless ($inleavemessage eq "no") {
                
                    $inpost = qq~#Moderation Mode<p>$inpost<p><a href="$boardurl/$threadprog?forum=$movetoid&topic=$newthreadnumber" target="_self">Moved here</a>~;
                
                    $filetoopen = "$ikondir" . "forum$inforum/$intopic.thd";
                    open(FILE, "$filetoopen");
                    @allmessages = <FILE>;
                    close(FILE);
                
                    $linetokeep = @allmessages[0];
                    chomp $linetokeep;
                    ($trash, $topictitle, $trash) = split(/\|/,$linetokeep);
        
                    $filetomake = "$ikondir" . "forum$inforum/$intopic.thd";
                    open(FILE, ">$filetomake");
                    flock(FILE, 2);
                        foreach $messages (@allmessages) {
                            chomp $messages;
                            print FILE "$messages\n";
                            }
                    print FILE "$inmembername|$topictitle|Moderation Mode|yes|yes|$currenttime|$inpost";
                    close(FILE);

                    
                    $threadposts = @allmessages;
                    
                    my $file = "$ikondir" . "forum$inforum/$intopic.pl";
                    open (ENT, $file);
                    $in = <ENT>;
                    close (ENT);

                    ($topicid, $topictitle, $topicdescription, $threadstate, $threadposts ,$threadviews, $startedby, $startedpostdate, $lastposter, $lastpostdate) = split(/\|/,$in);
        
        
                    open(FILE, ">$file");
                    flock(FILE, 2);
                    $threadposts++;
                    print FILE "$intopic|$topictitle|$topicdescription|closed|$threadposts|$threadviews|$startedby|$startedpostdate|$inmembername|$currenttime";
                    close(FILE);

                    
            } # end if inleavemessage eq yes

        my $file = "$ikondir" . "forum$inforum/$intopic.pl";
        open (ENT, $file);
        $in = <ENT>;
        close (ENT);

        ($topicid, $topictitle, $topicdescription, $threadstate, $threadposts ,$threadviews, $startedby, $startedpostdate, $lastposter, $lastpostdate) = split(/\|/,$in);
        
        
        my $file = "$ikondir" . "forum$movetoid/$newthreadnumber.pl";
        open(FILE, ">$file");
        flock(FILE, 2);
        print FILE "$newthreadnumber|$topictitle|$topicdescription|open|$threadposts|$threadviews|$startedby|$startedpostdate|$inmembername|$currenttime";
        close(FILE);

        ### Pick up old forum messages
        
        $filetoopen = "$ikondir" . "forum$inforum/$intopic.thd";
        open(FILE, "$filetoopen");
        @oldforummessages = <FILE>;
        close(FILE);

        $oldthreadposts = @oldforummessages - 1;
        
        ### Print to new forum message file
        
        $filetomake = "$ikondir" . "forum$movetoid/$newthreadnumber.thd";
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        foreach $message (@oldforummessages) {
            chomp $message;
            print FILE "$message\n";
            }
        
        close(FILE);


        ### Update the post counts and lastposter details.
        
        $filetoopen = "$ikondir" . "data/allforums.cgi";
        open(FILE, "$filetoopen");
        @allforums = <FILE>;
        close(FILE);
        
        $filetomake = "$ikondir" . "data/allforums.cgi";
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        foreach $forum (@allforums) { #start foreach @forums
        chomp($forum);
            ($tempno, $trash) = split(/\|/,$forum);
                if ($inforum eq $tempno) {
                    ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);
                    if ($inleavemessage eq "no") { $threads--; }
                    $currenttime = time;
                    $posts = $posts - $threadposts;
                    $posts++;
                    print FILE "$forumid|$category|$categoryplace|$forumname|$forumdescription|$forummoderator|$htmlstate|$idmbcodestate|$privateforum|$startnewthreads|$inmembername|$currenttime|$threads|$posts|$forumgraphic\n";
                }
                elsif ($movetoid eq $tempno) {
                    ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);
                    $currenttime = time;
                    $threads++;
                    $posts = $posts + $threadposts;
                    $posts--;
                    print FILE "$forumid|$category|$categoryplace|$forumname|$forumdescription|$forummoderator|$htmlstate|$idmbcodestate|$privateforum|$startnewthreads|$inmembername|$currenttime|$threads|$posts|$forumgraphic\n";
                    }
            else { print FILE "$forum\n"; }
        }
        close(FILE);
        
        
        
        if ($inleavemessage ne "yes") {
        
            ### Delete the old listings first delete the old thread file
            
            $filetounlink = "$ikondir" . "forum$inforum/$intopic.thd";
            unlink $filetounlink;
        
            ### Now we have to trash it from the list.cgi
            
            my $file = "$ikondir" . "forum$inforum/$intopic.pl";
            unlink $file;

            
            
            } # end unless statement
        
            rebuildLIST(-Forum=>"$inforum");

            rebuildLIST(-Forum=>"$movetoid");
        
        
        $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr>    
            <td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle align=center><font face="$font" color=$fontcolormisc size=2><b>Topic Moved</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
            Status:
            <ul>
            <li><a href="$forumsprog?forum=$inforum">Back to the original forum</a>
            <li><a href="$forumsprog?forum=$movetoid">Back to the new forum</a>
            <li><a href="$forumsummaryprog">Back to the forums index</a>
            </ul>
            </tr>
            </td>
            </table></td></tr></table>
            ~;
            $checked = "no";
        
        } # end clear to move if
        
        else {
        
            $filetoopen = "$ikondir" . "data/allforums.cgi";
            open(FILE, "$filetoopen");
            @forums = <FILE>;
            close(FILE);

            $jumphtml .= "<option value=\"\">Choose a forum\n";
            
            foreach $forum (@forums) { #start foreach @forums
                chomp $forum;
                ($movetoforumid, $category, $categoryplace, $forumname, $forumdescription) = split(/\|/,$forum);
                $rearrange = ("$categoryplace|$category|$forumname|$forumdescription|$movetoforumid");
                push (@rearrangedforums, $rearrange);
                } # end foreach (@forums)

            @finalsortedforums = sort numerically(@rearrangedforums);

            foreach $sortedforums (@finalsortedforums) { #start foreach 
            ($categoryplace, $category, $forumname, $forumdescription, $movetoforumid) = split(/\|/,$sortedforums);
    
            if ($categoryplace ne $lastcategoryplace) { #start if $categoryplace
                $jumphtml .= "<option value=\"\">\n";
                $jumphtml .= "<option value=\"\">-- &nbsp; $category\n";
                $jumphtml .= "<option value=\"$movetoforumid\"> $forumname\n";
                }
                else {
                    $jumphtml .= "<option value=\"$movetoforumid\"> $forumname\n";
                    }
                $lastcategoryplace = $categoryplace;
                } # end foreach 
     
            
            
            
            $output .= qq~

            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
                <tr>
                    <td>
                    <table cellpadding=6 cellspacing=1 border=0 width=100%>
                        <form action="$thisprog" method="post">
                        <input type=hidden name="action" value="movetopic">
                        <input type=hidden name="checked" value="yes">
                        <input type=hidden name="forum" value="$inforum">
                        <input type=hidden name="topic" value="$intopic">
                        <tr>
                        <td bgcolor=$miscbacktwo valign=middle align=center colspan=2><font face="$font" color=$fontcolormisc size=2><b>Please enter your details to enable moderation mode [ Move Topic ]</b></font></td></tr>
                            <tr>
                            <td bgcolor=$miscbackone valign=middle colspan=2><font face="$font" color=$fontcolormisc size=1><center><b>Please choose which options you wish to use.</font></td>
                                <tr>
                                <td bgcolor=$miscbackone valign=middle width=40%><font face="$font" color=$fontcolormisc size=1><b>Please enter your username</b></font></td>
                                <td bgcolor=$miscbackone valign=middle><input type=text name="membername" value="$inmembername" size=20</td></tr>
                                    <tr>
                                    <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1><b>Please enter your password</b></font></td>
                                    <td bgcolor=$miscbackone valign=middle><input type=password name="password" value="$inpassword" size=20> &nbsp; <font face="$font" color=$fontcolormisc size=1><a href="$profileprog?action=lostpass">Forgotten your password?</a></font></td></tr>
                                    <tr>
                                    <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
                                    <b>Topic move options</td>
                                    <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
                                    <input name="leavemessage" type="radio" value="yes" checked> Leave locked thread on the original forum<br><input name="leavemessage" type="radio" value="no"> Delete Thread in the original forum</font>
                                    </td>
                                    </tr>
                                <tr>
                                <td bgcolor=$miscbackone valign=top><font face="$font" color=$fontcolormisc size=1><b>Message:</b><p>
                                This is optional. The URL to the new location will automatically be entered into the post.<p>
                                Only enter a message if you wish the thread to remain in a locked state in the original forum.
                                </font></td>
                                <td bgcolor=$miscbackone valign=middle><textarea cols=45 rows=6 wrap="soft" name="inpost"></textarea></td>
                                </tr>
                            <tr>
                        <td bgcolor=$miscbackone valign=top><font face="$font" color=$fontcolormisc size=1><b>Moveto:</b></font></td>
                        <td bgcolor=$miscbackone valign=top><font face="$font" color=$fontcolormisc size=1><select name="movetoid">$jumphtml</select></font></td>
                        </tr>
                    <tr>
                <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center><input type=submit name="submit" value="Submit"></td></tr></form></table></td></tr></table>
            </table>
            </td></tr>
            </table>
            ~;
            
             } # end else

} # end movetopic










sub deletethread {
    
    &getmember("$inmembername");
    &moderator;

    $cleartoedit = "no";
    
    
    &mischeader("Deleting");

    if (($membercode eq "ad") && ($inpassword eq $password)) { $cleartoedit = "yes"; }
    if (($inmembmod eq "yes") && ($inpassword eq $password)) { $cleartoedit = "yes"; }
    unless ($cleartoedit eq "yes") { $cleartoedit = "no"; }
    
        if ($cleartoedit eq "no" && $checked eq "yes") { &error("Deleting Topic&You are not the forum moderator or board administrator or your password was incorrect"); }
        if (($cleartoedit eq "yes") && ($checked eq "yes")) {
        
        ### Now we have to trash it from the thd's
        
        $filetoopen = "$ikondir" . "forum$inforum/$intopic.thd";
        open(FILE, "$filetoopen");
        @threads = <FILE>;
        close(FILE);

        $postcount = @threads;
        $postcount--;
        

        $filetotrash = "$ikondir" . "forum$inforum/$intopic.thd";
        unlink "$filetotrash";

        $filetotrash = "$ikondir" . "forum$inforum/$intopic.mal";
        unlink "$filetotrash"; 

        
        ### Now we have to trash it from the list.cgi
            
        my $file = "$ikondir" . "forum$inforum/$intopic.pl";
        unlink $file;

        rebuildLIST(-Forum=>"$inforum");
        
        ### Get the new last forum poster, and post date.
        
        $filetoopen = "$ikondir" . "forum$inforum/list.cgi";
        open(FILE, "$filetoopen");
        @alltopics = <FILE>;
        close(FILE);
        
        $linetokeep = @alltopics[0];
        chomp $linetokeep;
        ($trash, $trash, $trash, $trash, $trash, $trash, $trash, $trash, $lastforumposter, $lastforumpostdate) = split(/\|/,$linetokeep);
        
        
        $filetoopen = "$ikondir" . "data/allforums.cgi";
        open(FILE, "$filetoopen");
        @allforums = <FILE>;
        close(FILE);
        
        $filetomake = "$ikondir" . "data/allforums.cgi";
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        foreach $forum (@allforums) { #start foreach @forums
        chomp($forum);
            ($tempno, $trash) = split(/\|/,$forum);
                if ($inforum eq $tempno) {
                    ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);
                    $posts = $posts - $postcount;
                    $threads--;
                    print FILE "$forumid|$category|$categoryplace|$forumname|$forumdescription|$forummoderator|$htmlstate|$idmbcodestate|$privateforum|$startnewthreads|$lastforumposter|$lastforumpostdate|$threads|$posts|$forumgraphic\n";
                }
            else { print FILE "$forum\n"; }
        }
        close(FILE);

        
        
        require "$ikondir" . "data/boardstats.cgi";
        
        $filetomake = "$ikondir" . "data/boardstats.cgi";
        
        $totalthreads--;
        $totalposts = $totalposts - $postcount;
        
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "\$lastregisteredmember = \"$lastregisteredmember\"\;\n";
        print FILE "\$totalmembers = \"$totalmembers\"\;\n";
        print FILE "\$totalthreads = \"$totalthreads\"\;\n";
        print FILE "\$totalposts = \"$totalposts\"\;\n";
        print FILE "\n1\;";
        close (FILE);
            
            
            $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr>    
            <td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle align=center><font face="$font" color=$fontcolormisc size=2><b>Thread Deleted</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
            Status:
            <ul>
            <li><a href="$forumsprog?forum=$inforum">Back to the forum</a>
            <li><a href="$forumsummaryprog">Back to the forums</a>
            </ul>
            </tr>
            </td>
            </table></td></tr></table>
            ~;

            } # end if clear to edit
            

            else {
            
            &mischeader("Delete thread");
            
            $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr><td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <form action="$thisprog" method="post">
            <input type=hidden name="action" value="delete">
            <input type=hidden name="checked" value="yes">
            <input type=hidden name="forum" value="$inforum">
            <input type=hidden name="topic" value="$intopic">
            <tr>
            <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center><font face="$font" color=$fontcolormisc size=2><b>Please enter your details to enable moderation mode [ Delete Thread ]</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle colspan=2><font face="$font" color=$fontcolormisc size=1><b>Only continue if you wish to delete this thread. You cannot reverse this action!</font></td>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your username</font></td>
            <td bgcolor=$miscbackone valign=middle><input type=text name="membername" value="$inmembername" size=20></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your password</font></td>
            <td bgcolor=$miscbackone valign=middle><input type=password name="password" value="$inpassword" size=20> &nbsp; <font face="$font" color=$fontcolormisc size=1><a href="$profileprog?action=lostpass">Forgotten your password?</a></font></td></tr>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center><input type=submit name="submit" value="Log in"></td></tr></form></table></td></tr></table>
            </table></td></tr></table>
            ~;
            
             }

} # end deletethread



###########################



sub lockthread {

    &getmember("$inmembername");
    
    &moderator;

    $cleartoedit = "no";
    
    
    &mischeader("Locking");

    if (($membercode eq "ad") && ($inpassword eq $password)) { $cleartoedit = "yes"; }
    if (($inmembmod eq "yes") && ($inpassword eq $password)) { $cleartoedit = "yes"; }
    unless ($cleartoedit eq "yes") { $cleartoedit = "no"; }
    
    if ($cleartoedit eq "no" && $checked eq "yes") { &error("Locking Topic&You are not the forum moderator or board administrator or your password was incorrect"); }
        
        if (($cleartoedit eq "yes") && ($checked eq "yes")) {
            
        my $file = "$ikondir" . "forum$inforum/$intopic.pl";
        open (ENT, $file);
        $in = <ENT>;
        close (ENT);

        ($topicid, $topictitle, $topicdescription, $threadstate, $threadposts ,$threadviews, $startedby, $startedpostdate, $lastposter, $lastpostdate) = split(/\|/,$in);
        
        open(FILE, ">$file");
        flock(FILE, 2);
        print FILE "$intopic|$topictitle|$topicdescription|closed|$threadposts|$threadviews|$startedby|$startedpostdate|$inmembername|$currenttime";
        close(FILE);

        rebuildLIST(-Forum=>"$inforum");
        
            $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr>    
            <td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle align=center><font face="$font" color=$fontcolormisc size=2><b>Thread Locked</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
            Status:
            <ul>
            <li><a href="$forumsprog?forum=$inforum">Back to the forum</a>
            <li><a href="$forumsummaryprog">Back to the forums</a>
            </ul>
            </tr>
            </td>
            </table></td></tr></table>
            ~;
            
            } # end if clear to edit
            
            else {
            
            $inmembername =~ s/\_/ /g;
            $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr><td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <form action="$thisprog" method="post">
            <input type=hidden name="action" value="lock">
            <input type=hidden name="checked" value="yes">
            <input type=hidden name="forum" value="$inforum">
            <input type=hidden name="topic" value="$intopic">
            <tr>
            <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center><font face="$font" color=$fontcolormisc size=2><b>Please enter your details to enable moderation mode [ Lock thread ]</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your username</font></td>
            <td bgcolor=$miscbackone valign=middle><input type=text name="membername" value="$inmembername" size=20> &nbsp; <a href="$registerprog"><font face="$font" color=$fontcolormisc size=1>Are you registered?</font></a></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your password</font></td>
            <td bgcolor=$miscbackone valign=middle><input type=password name="password" value="$inpassword" size=20> &nbsp; <font face="$font" color=$fontcolormisc size=1><a href="$profileprog?action=lostpass">Forgotten your password?</a></font></td></tr>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center><input type=submit name="submit" value="Log in"></form></td></tr></table></td></tr></table>
            </table></td></tr></table>
            ~;
            
             }

} # end lockthread



###########################



sub unlockthread {

    &getmember("$inmembername");
    &moderator;

    $cleartoedit = "no";
    
    
    &mischeader("Unlocking");

    if (($membercode eq "ad") && ($inpassword eq $password)) { $cleartoedit = "yes"; }
    if (($inmembmod eq "yes") && ($inpassword eq $password)) { $cleartoedit = "yes"; }
    unless ($cleartoedit eq "yes") { $cleartoedit = "no"; }
    
        if ($cleartoedit eq "no" && $checked eq "yes") { &error("Unlocking Topic&You are not the forum moderator or board administrator or your password was incorrect"); } 
        if (($cleartoedit eq "yes") && ($checked eq "yes")) {
            
        my $file = "$ikondir" . "forum$inforum/$intopic.pl";
        open (ENT, $file);
        $in = <ENT>;
        close (ENT);

        ($topicid, $topictitle, $topicdescription, $threadstate, $threadposts ,$threadviews, $startedby, $startedpostdate, $lastposter, $lastpostdate) = split(/\|/,$in);
        
        open(FILE, ">$file");
        flock(FILE, 2);
        print FILE "$intopic|$topictitle|$topicdescription|open|$threadposts|$threadviews|$startedby|$startedpostdate|$inmembername|$currenttime";
        close(FILE);

        rebuildLIST(-Forum=>"$inforum");
        
            $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr>    
            <td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle align=center><font face="$font" color=$fontcolormisc size=2><b>Thread Unlocked</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
            Status:
            <ul>
            <li><a href="$forumsprog?forum=$inforum">Back to the forum</a>
            <li><a href="$forumsummaryprog">Back to the forums index</a>
            </ul>
            </tr>
            </td>
            </table></td></tr></table>
            ~;
            } # end if clear to edit
            
            else {
            
            $inmembername =~ s/\_/ /g;
            $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr><td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <form action="$thisprog" method="post">
            <input type=hidden name="action" value="unlock">
            <input type=hidden name="checked" value="yes">
            <input type=hidden name="forum" value="$inforum">
            <input type=hidden name="topic" value="$intopic">
            <tr>
            <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center><font face="$font" color=$fontcolormisc size=2><b>Please enter your details to enable moderation mode [ Unlock thread ]</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your username</font></td>
            <td bgcolor=$miscbackone valign=middle><input type=text name="membername" value="$inmembername" size=20> &nbsp; <a href="$registerprog"><font face="$font" color=$fontcolormisc size=1>Are you registered?</font></a></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your password</font></td>
            <td bgcolor=$miscbackone valign=middle><input type=password name="password" value="$inpassword" size=20> &nbsp; <font face="$font" color=$fontcolormisc size=1><a href="$profileprog?action=lostpass">Forgotten your password?</a></font></td></tr>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center><input type=submit name="submit" value="Log in"></form></td></tr></table></td></tr></table>
            </table></td></tr></table>
            ~;
            
             }

} # end unlockthread



###########################



sub deletepost {

    $filetoopen = "$ikondir" . "forum$inforum/$intopic.thd";
    open(FILE, "$filetoopen");
    @allthreads = <FILE>;
    close(FILE);
    
    $posttodelete = $inpostno;
    $posttodelete--;
    $postcountcheck = 0;
    $totalposts = @allthreads;
    

    &getmember("$inmembername");
    &moderator;

    $cleartoedit = "no";

    if (($membercode eq "ad") && ($inpassword eq $password)) { $cleartoedit = "yes"; }
    if (($inmembmod eq "yes") && ($inpassword eq $password)) { $cleartoedit = "yes"; }
    unless ($cleartoedit eq "yes") { $cleartoedit = "no"; }
    
        if ($cleartoedit eq "no" && $checked eq "yes") { &error("Deleting post&You are not the forum moderator or board administrator or your password was incorrect"); }   
        if ($cleartoedit eq "yes") {
            
            if ($posttodelete eq "0") { &error("Deleting a post&You cannot delete the first post"); }
            
            ### First off, lets delete the post in the thread.
            
            $filetoopen = "$ikondir" . "forum$inforum/$intopic.thd";
            open(FILE, ">$filetoopen");
            flock(FILE, 2);
                foreach $postline (@allthreads) {
                chomp $postline;
                    unless ($postcountcheck eq $posttodelete) { print FILE "$postline\n"; }
                    $postcountcheck++;
                    }
            close(FILE);

        
        $filetoopen = "$ikondir" . "forum$inforum/$intopic.thd";
        open(FILE, "$filetoopen");
        @allthreads = <FILE>;
        close(FILE);
    
        
        $totalposts = @allthreads;
        $posttograb = $totalposts;
        $posttograb--;
            
        ($postermembername2, $topictitle2, $postipaddress2, $showemoticons2, $showsignature2 ,$postdate2, $post2) = split(/\|/, @allthreads[$posttograb]);

        
        ### Now we have to adjust the post counts.
            
        $filetoopen = "$ikondir" . "forum$inforum/list.cgi";
        open(FILE, "$filetoopen");
        @alltopics = <FILE>;
        close(FILE);
        
        $count = "0";
        foreach $line (@alltopics) { #start foreach @threads
            ($tempno, $trash) = split(/\|/, $line);
            if ($intopic eq $tempno) {
                $linetokeep = $line;
                $keepcounter = $count;
            }
        $count++;
        } # end foreach
            
        ($topicid, $topictitle, $topicdescription, $threadstate, $threadposts ,$threadviews, $startedby, $startedpostdate, $lastposter, $lastpostdate) = split(/\|/,$linetokeep);
        
        $threadposts = $totalposts - 1;
        
        $filetomake = "$ikondir" . "forum$inforum/list.cgi";
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        foreach $newline (@alltopics) { #start foreach @threads
        chomp($newline);
            ($tempno, $trash) = split(/\|/,$newline);
            if ($intopic eq $tempno) {
            print FILE "$topicid|$topictitle|$topicdescription|$threadstate|$threadposts|$threadviews|$startedby|$startedpostdate|$postermembername2|$postdate2\n";
            }
        else { print FILE "$newline\n"; }
        }   
        close(FILE);
        
        
        ### Get the new last forum poster, and post date.
        
        $filetoopen = "$ikondir" . "forum$inforum/list.cgi";
        open(FILE, "$filetoopen");
        @alltopics = <FILE>;
        close(FILE);
        
        $linetokeep = @alltopics[0];
        chomp $linetokeep;
        
        ($trash, $trash, $trash, $trash, $trash, $trash, $trash, $trash, $lastforumposter, $lastforumpostdate) = split(/\|/,$linetokeep);
        chomp $forumlastposter;
        chomp $forumlastpostdate;
        
        ### Adjust the variables in the Forums Summary Page.
        
        $filetoopen = "$ikondir" . "data/allforums.cgi";
        open(FILE, "$filetoopen");
        @allforums = <FILE>;
        close(FILE);
        
        $filetomake = "$ikondir" . "data/allforums.cgi";
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        foreach $forum (@allforums) { #start foreach @forums
        chomp($forum);
            ($tempno, $trash) = split(/\|/,$forum);
                if ($inforum eq $tempno) {
                    ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);
                    $posts--;
                    print FILE "$forumid|$category|$categoryplace|$forumname|$forumdescription|$forummoderator|$htmlstate|$idmbcodestate|$privateforum|$startnewthreads|$lastforumposter|$lastforumpostdate|$threads|$posts|$forumgraphic\n";
                }
            else { print FILE "$forum\n"; }
        }
        close(FILE);

        
        require "$ikondir" . "data/boardstats.cgi";
        
        $filetomake = "$ikondir" . "data/boardstats.cgi";
        $totalposts--;
        
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "\$lastregisteredmember = \"$lastregisteredmember\"\;\n";
        print FILE "\$totalmembers = \"$totalmembers\"\;\n";
        print FILE "\$totalthreads = \"$totalthreads\"\;\n";
        print FILE "\$totalposts = \"$totalposts\"\;\n";
        print FILE "\n1\;";
        close (FILE);
            
            &mischeader("Deleting");
            
            
            $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr>    
            <td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle align=center><font face="$font" color=$fontcolormisc size=2><b>Post Deleted</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
            Status:
            <ul>
            <li><a href="$threadprog?forum=$inforum&topic=$intopic">Back to the thread</a>
            <li><a href="$forumsprog?forum=$inforum">Back to the forum</a>
            <li><a href="$forumsummaryprog">Back to the forums index</a>
            </ul>
            </tr>
            </td>
            </table></td></tr></table>
            ~;

            } # end if clear to edit
            
            else { &error("Deleting a post&You are not the forum moderator or the board administrator"); }



} # end subdelete



###########################



sub editform { # start form



### Grab the post to edit

$filetoopen = "$ikondir" . "forum$inforum/$intopic.thd";
open(FILE, "$filetoopen");
@threads = <FILE>;
close(FILE);

$posttoget = $inpostno;
$posttoget--;

($membername, $topictitle, $postipaddress, $showemoticons, $showsignature ,$postdate, $post) = split(/\|/, @threads[$posttoget]);
        
$post =~ s/\<p\>/\n\n/g;
$post =~ s/\<br\>/\n/g;


### Print form

&getforum("$inforum");
&getmember("$inmembername");

if ($allowedentry{$inforum} eq "yes") { $allowed = "yes"; }

if (($privateforum eq "yes") && ($allowed ne "yes")) {
  &error("Posting&Sorry, you are not allowed to post in this forum");
}   

$rawpost = $post;

if ($previewfirst eq "yes") {
    $rawpost = $inpost;
    $rawpost =~ s/\<p\>/\n\n/g;
    $rawpost =~ s/\<br\>/\n/g;
    &preview;
    }
    else {
        &mischeader("Editing post in");
        }

if ($emoticons eq "on") {
    $emoticonslink = qq~<a href="javascript:openScript('$miscprog?action=showsmilies',300,350)">Emoticons are enabled</a>~;
    $emoticonsbutton =qq~<input type=checkbox name="inshowemoticons" value="yes" checked>Do you wish to <b>enable</b> emoticons in this post?<br>~;
    }


$output .= qq~
<table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
<tr><td>
<table cellpadding=4 cellspacing=1 border=0 width=100%>
<tr>
<td bgcolor=$titlecolor colspan=2><font face="$font" color=$titlefontcolor size=1>Topic: $topictitle</td>
</tr>
<tr><form action="$thisprog" method=post>
<input type=hidden name="action" value="processedit">
<input type=hidden name="postno" value="$inpostno">
<input type=hidden name="forum" value="$inforum">
<input type=hidden name="topic" value="$intopic">
</tr><tr>
<td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1><b>Username</b></font></td>
<td bgcolor=$miscbackone valign=middle><input type=text size=20 name="membername" value="$inmembername"><font face="$font" color=$fontcolormisc size=1><a ref="$registerprog">Are you registered?</a></font></td>
</tr><tr>
<td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1><b>Password</b></font></td>
<td bgcolor=$miscbackone valign=middle><input type=password size=20 name="password" value="$inpassword"><font face="$font" color=$fontcolormisc size=1><a ref="$profileprog?action=lostpass">Forgotten your password?</a></font></td>
</tr><tr>
<td bgcolor=$miscbackone valign=top><font face="$font" color=$fontcolormisc size=1><b>Post</b><p>
HTML is <b>$htmlstate</b> for this forum<p>IkonCode is <b>$idmbcodestate</b> for this forum<p>$emoticonslink</font></td>
<td bgcolor=$miscbackone valign=middle><textarea cols=45 rows=6 wrap="soft" name="inpost">$rawpost</textarea></td>
</tr><tr>
<td bgcolor=$miscbacktwo valign=top><font face="$font" color=$fontcolormisc size=1><b>Post Options</b>
</font></td>
<td bgcolor=$miscbacktwo valign=middle><input type=checkbox name="inshowsignature" value="yes" checked>
<font face="$font" color=$fontcolormisc size=1>Do you wish to add your signature?<br>
$emoticonsbutton
<b>Do you wish to preview before posting?</b><input name="previewfirst" type="radio" value="yes"> Yes &nbsp; <input name="previewfirst" type="radio" value="no" checked> No
</font></td>
</tr>
<tr>
<td bgcolor=$miscbackone valign=middle align=left valign=middle>
<font face="$font" color=$fontcolormisc size=1><b>Administration Options</b></td>
<td bgcolor=$miscbackone valign=middle align=left valign=middle>
<font face="$font" color=$fontcolormisc size=1>
<input type=checkbox name="deletepost" value="yes">Delete this post? Administration/Forum Moderator only
</font></td></tr>
<tr>
<td bgcolor=$miscbackone valign=middle colspan=2 align=center>
<input type=Submit value=Submit name=Submit> &nbsp; <input type="reset" name="Clear">
</form>
</td></tr></table></tr></td></table>
~;

} # end edit form



###########################



sub processedit {

            $posttoget = $inpostno;
            $posttoget--;
            $postcountcheck = 0;

            $filetoopen = "$ikondir" . "forum$inforum/$intopic.thd";
            open(FILE, "$filetoopen");
            @allthreads = <FILE>;
            close(FILE);
            
            ($postermembername, $topictitle, $postipaddress, $showemoticons, $showsignature ,$postdate, $post) = split(/\|/, @allthreads[$posttoget]);



            &getmember("$inmembername");
            &moderator;

            &getforum("$inforum");
            
            if ($allowedentry{$inforum} eq "yes") { $allowed = "yes"; }

            if (($privateforum eq "yes") && ($allowed ne "yes")) {
                &error("Posting&Sorry, you are not allowed to post in this forum");
                }   

            $cleartoedit = "no";

            if (($membercode eq "ad") && ($inpassword eq $password)) { $cleartoedit = "yes"; }
            if (($inmembmod eq "yes") && ($inpassword eq $password)) { $cleartoedit = "yes"; }
            if (($inmembername eq $postermembername) && ($inpassword eq $password)) { $cleartoedit = "yes"; }


        unless ($cleartoedit eq "yes") { $cleartoedit eq "no"; }
        
        if ($cleartoedit eq "yes") {
            
            $editpostdate = time;
            $editpostdate = $editpostdate + ($timezone*3600) + ($timedifferencevalue*3600);
            $editpostdate = &dateformat("$editpostdate");

            $inpost =~ s/\t//g;
            $inpost =~ s/\r//g;
            $inpost =~ s/  / /g;
            $inpost =~ s/\n\n/\<p\>/g;
            $inpost =~ s/\n/\<br\>/g;

            # Open the bad word filter
        
            $filetoopen = "$ikondir" . "data/badwords.cgi";
            open (FILE, "$filetoopen");
            $badwords = <FILE>;
            close (FILE);
            
            if ($badwords) {
            @pairs = split(/\&/,$badwords);
            foreach (@pairs) {
                ($bad, $good) = split(/=/,$_);
                $inpost =~ s/$bad/$good/g;
                }
             }
            unless ($membercode eq "ad") {
                $inpost = qq~$inpost<p>(Edited by $inmembername at $editpostdate)~;
                }
                
            $filetoopen = "$ikondir" . "forum$inforum/$intopic.thd";
            open(FILE, ">$filetoopen");
            flock(FILE, 2);
                foreach $postline (@allthreads) {
                chomp $postline;
                    if ($postcountcheck eq $posttoget) {
                        print FILE "$postermembername|$topictitle|$postipaddress|$inshowemoticons|$inshowsignature|$postdate|$inpost\n";
                        }
                    else { print FILE "$postline\n"; }
                    $postcountcheck++;
                    }
            close(FILE);

            &mischeader("Edit in");
            
            $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr>    
            <td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle align=center><font face="$font" color=$fontcolormisc size=2><b>Edit Successful</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
            Status:
            <ul>
            <li><a href="$threadprog?forum=$inforum&topic=$intopic">Back to the thread</a>
            <li><a href="$forumsprog?forum=$inforum">Back to the forum</a>
            <li><a href="$forumsummaryprog">Back to the forums index</a>
            </ul>
            </tr>
            </td>
            </table></td></tr></table>
            ~;
            
            } # end if clear to edit
            
            else { &error("Editing your post&Wrong Password/Username or you are not the original poster"); }

} # end routine



