#!/usr/bin/perl

#############################################################
# Ikonboard v2.1
# Copyright 2000 Ikondiscussion.com - All Rights Reserved
# Ikondiscussion is a trademark of Ikondiscussion.com
#
# Software Distributed by: Ikondiscussion.com
# Visit us online at http://www.ikondiscussion.com
# Email us on boards@ikondiscussion.com
#
# All files written by Matthew Mecham
#############################################################

use CGI::Carp "fatalsToBrowser";          # Output errors to browser
use CGI qw(:standard);                    # Saves loads of work
$CGI::POST_MAX=1024 * 150;                # limit post data
$CGI::DISABLE_UPLOADS = 1;                # Disable uploads

eval {
($0 =~ m,(.*)/[^/]+,)   and unshift (@INC, "$1");
($0 =~ m,(.*)\\[^\\]+,) and unshift (@INC, "$1");
require "ikon.lib";          # Require ikonboard ()
require "data/progs.cgi";    # Require prog names
require "data/boardinfo.cgi";# Require board info
require "data/styles.cgi";   # Require styles info
require "ikonmail.lib";      # Require email func ()
};
if ($@) {
    print header(); print start_html(-title=>"Ikonboard Error!");
    print "Could not find these files: $@\nIf you are running NT you may need to enter the full path in each require statement in each script";
    print end_html; exit;
}

$|++;                        # Unbuffer the output

#################--- Begin the program ---###################

$thisprog = "post.cgi";

$query = new CGI;

&checkVALIDITY;

$cookiepath = $query->url(-absolute=>1);
$cookiepath =~ s/$thisprog//sg;

for ('forum','topic','membername','password','action','postno','inshowsignature',
     'notify','inshowemoticons','previewfirst','intopictitle','intopicdescription',
     'inpost') {
    next unless defined $_;
    next if $_ eq 'SEND_MAIL';
    $tp = $query->param($_);
    $tp = &cleaninput("$tp");
    ${$_} = $tp;
    }



$inforum       = $forum;
$intopic       = $topic;
$inmembername  = $membername;
$inpassword    = $password;
$inpostno      = $postno;
$innotify      = $notify;
$currenttime   = time;
$postipaddress = $ENV{'REMOTE_ADDR'};


if ($inshowemoticons ne "yes") { $inshowemoticons eq "no"; }
if ($innotify ne "yes")        { $innotify eq "no"; }

    if (! $inmembername) { $inmembername = cookie("amembernamecookie"); }
    if (! $inpassword)   { $inpassword   = cookie("apasswordcookie"); }

    if ($inmembername eq "") {
        $inmembername = "Guest";
        }
        else {
            &getmemberstime("$inmembername");
            }

    if ($action eq "addnew" or $action eq "addreply") {

    $namecookie = cookie(-name    =>   "amembernamecookie",
                         -value   =>   "$inmembername",
                         -path    =>   "$cookiepath",
                         -expires =>   "+30d");
    $passcookie = cookie(-name    =>   "apasswordcookie",
                         -value   =>   "$inpassword",
                         -path    =>   "$cookiepath",
                         -expires =>   "+30d");
    print header(-cookie=>[$namecookie, $passcookie]);
    }
    else {
        print header();
        }

    if (($inforum)  && ($inforum !~ /^[0-9]+$/))  { &error("General&Please do not modify the URL's generated."); }
    if (($intopic ) && ($intopic  !~ /^[0-9]+$/)) { &error("General&Please do not modify the URL's generated."); }
    if (($inpostno) && ($inpostno !~ /^[0-9]+$/)) { &error("General&Please do not modify the URL's generated."); }


    $helpurl = &helpfiles("Making_a_post");
    $helpurl = qq~$helpurl<img src="$imagesurl/images/help_b.gif" border=0></a>~;

    my %Mode = ( 
    'new'                 =>    \&newthread,
    'reply'               =>    \&reply,        
    'replyquote'          =>    \&replyquote
    );


    if($Mode{$action}) { 
        $Mode{$action}->();
        }
        elsif ($action eq "addnew"   && $previewfirst eq "no")  { &addnewthread; }
        elsif ($action eq "addnew"   && $previewfirst eq "yes") { &newthread; }
        elsif ($action eq "addreply" && $previewfirst eq "no")  { &addreply; }
        elsif ($action eq "addreply" && $previewfirst eq "yes") { &reply; }
        else { &error("General&Please only access this script in the correct manner"); }


    &output(
    -Title   => "$boardname - Posting in $forumname", 
    -ToPrint => $output, 
    -Version => $versionnumber 
    );



############ New Thread side

sub newthread {

    

    ### Lets sort out the flood control

    &getmember("$inmembername");
        if (($floodcontrol eq "on") && ($membercode ne "ad") && ($membercode ne "mo")) {
        $currenttime = time;
        ($lastpost, $posturl, $posttopic) = split(/\%\%\%/,$lastpostdate);
        $lastpost = ($lastpost + $floodcontrollimit);
            if ($lastpost > $currenttime)  {
                &error("Starting a new thread&Flood control has been enabled on this board, you must wait for $floodcontrollimit seconds before making another post");
                }
            }

    &getforum("$inforum");

        if ($allowedentry{$inforum} eq "yes") { $allowed = "yes"; }
        
        if (($privateforum eq "yes") && ($allowed ne "yes")) {
            &error("Posting&Sorry, you are not allowed to post in this forum");
        }   

    # Emoticons routine

    if ($emoticons eq "on") {
        $emoticonslink = qq~<a href="javascript:openScript('$miscprog?action=showsmilies',300,350)">Emoticons are enabled</a>~;
        $emoticonsbutton =qq~<input type=checkbox name="inshowemoticons" value="yes" checked>Do you wish to <b>enable</b> emoticons in this post?<br>~;
        }


        
    # Add member to who's online    
        
    &whosonline("$inmembername|Starting a new thread in <a href=\"$forumsprog?forum=$inforum\">$forumname</a>|none") if ($privateforum ne "yes");



    # Set up are we previewing/emailing/start thread allowance

    if ($previewfirst eq "yes") {
        &preview;
        $inpost =~ s/\<p\>/\n\n/g;
        $inpost =~ s/\<br\>/\n/g;
        }
        else {
            &mischeader("Starting a new thread");
            }
        
    if ($emailfunctions eq "on") { 
           if ($innotify eq "yes") {
              $requestnotify = qq~<input type=checkbox name="notify" value="yes" checked>Do you want email notification of replies?<br>~;
              } 
              else {
                   $requestnotify = qq~<input type=checkbox name="notify" value="yes">Do you want email notification of replies?<br>~;
                   }
            }
        
    if ($startnewthreads eq "no") {
        $startthreads = "<b>Threads in this forum can only be started by the administrator or forum moderator</b>";
        }   
        else {
            $startthreads = "All registered members can start new threads in this forum";
            }


    # Output the form

    
    $output .= qq~
        <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr><td>
                <table cellpadding=4 cellspacing=1 border=0 width=100%>
                <tr>
                    <td bgcolor=$titlecolor colspan=2><font face="$font" color=$titlefontcolor size=1><b>Who can start new threads?</b>: $startthreads</td>
                </tr>
                <tr><form action="$thisprog" method=post>
                <input type=hidden name="action" value="addnew">
                <input type=hidden name="forum" value="$inforum">
                <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1><b>Topic Title</b></font></td>
                <td bgcolor=$miscbackone valign=middle><input type=text size=40 maxlength=60 name="intopictitle" value="$intopictitle"></td>
                </tr><tr>
                <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1><b>Topic Description</b></font></td>
                <td bgcolor=$miscbackone valign=middle><input type=text size=40 maxlength=60 name="intopicdescription" value="$intopicdescription"></td>
                </tr><tr>
                <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1><b>Username</b></font></td>
                <td bgcolor=$miscbackone valign=middle><input type=text size=20 name="membername" value="$inmembername"> &nbsp; <font face="$font" color=$fontcolormisc size=1><a href="$registerprog">Are you registered?</a></font></td>
                </tr><tr>
                <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1><b>Password</b></font></td>
                <td bgcolor=$miscbackone valign=middle><input type=password size=20 name="password" value="$inpassword"> &nbsp; <font face="$font" color=$fontcolormisc size=1><a href="$profileprog?action=lostpass">Forgotten your password?</a></font></td>
                </tr><tr>
                <td bgcolor=$miscbackone valign=top><font face="$font" color=$fontcolormisc size=1><b>Post</b><p>
                HTML is <b>$htmlstate</b> for this forum<p>IkonCode is <b>$idmbcodestate</b> for this forum<p>$emoticonslink</font></td>
                <td bgcolor=$miscbackone valign=middle><textarea cols=60 rows=6 wrap="soft" name="inpost">$inpost</textarea></td>
                </tr><tr>
                <td bgcolor=$miscbacktwo valign=top><font face="$font" color=$fontcolormisc size=1><b>Post Options</b><p>$helpurl</font></td>
                <td bgcolor=$miscbacktwo valign=middle><font face="$font" color=$fontcolormisc size=1><input type=checkbox name="inshowsignature" value="yes" checked>Do you wish to add your signature?<br>
                $requestnotify
                $emoticonsbutton
                <b>Do you wish to preview before posting?</b><input name="previewfirst" type="radio" value="yes"> Yes &nbsp; <input name="previewfirst" type="radio" value="no" checked> No</font>
                </font></td>
                </tr><tr>
                <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center>
                <input type=Submit value=Submit name=Submit"  onClick="return clckcntr();"> &nbsp; <input type="reset" name="Clear">
                </form>
                </td></tr>
            </table>
        </tr></td></table>
        ~;

        

        } # end newthread routine








############### sub addnewthread #############

sub addnewthread { # start routine


    ### Lets sort out the flood control, incase they used the back button...

    &getmember("$inmembername");
        if (($floodcontrol eq "on") && ($membercode ne "ad") && ($membercode ne "mo")) {
            $currenttime = time;
            ($lastpost, $posturl, $posttopic) = split(/\%\%\%/,$lastpostdate);
            $lastpost = ($lastpost + $floodcontrollimit);
            if ($lastpost > $currenttime)  {
                &error("Starting a new thread&Flood control has been enabled on this board, you must wait for $floodcontrollimit seconds before making another post");
                }
            }
        
            
    # Sort out the forum moderator

    &moderator;

    if ($startnewthreads eq "no") {
        unless ($membercode eq "ad" || $inmembmod eq "yes") {
            &error("Starting a thread&Threads in this forum can only be started by the administrator or forum moderator");
            }
        }

    
    
    
    if    ($userregistered eq "no")     { &error("Starting a thread&No user registered"); }
    elsif ($inpassword ne $password)    { &error("Starting a thread&Wrong Password"); }
    elsif ($membercode eq "banned")     { &error("adding a post&You are banned"); }
    elsif ($intopictitle eq "")         { &error("Starting a thread&You must enter a topic title"); }
    elsif ($inpost eq "")               { &error("Starting a thread&You must enter a post"); }
    else  { # start else

        &getforum("$inforum");

        if ($allowedentry{$inforum} eq "yes") { $allowed = "yes"; }
        
        if (($privateforum eq "yes") && ($allowed ne "yes")) {
            &error("Posting&Sorry, you are not allowed to post in this forum");
        }   

        
        ### Get a new thread number.

        $dirtoopen = "$ikondir" . "forum$inforum";
        opendir (DIR, "$dirtoopen"); 
        @dirdata = readdir(DIR);
        closedir (DIR);

        @sorteddirdata = grep(/thd/,@dirdata);
        @newdirdata = sort numerically(@sorteddirdata);
        @neworderdirdata = reverse(@newdirdata);

        $highest = @neworderdirdata[0];
        $highest =~ s/.thd//;
        $newthreadnumber = $highest + 1;

        # Open the bad word filter
        
        $filetoopen = "$ikondir" . "data/badwords.cgi";
        open (FILE, "$filetoopen");
        $badwords = <FILE>;
        close (FILE);
        
        if ($badwords) {
            @pairs = split(/\&/,$badwords);
            foreach (@pairs) {
                ($bad, $good) = split(/=/,$_);
                $inpost =~ s/$bad/$good/g;
                $intopictitle =~ s/$bad/$good/g;
                $intopicdescription =~ s/$bad/$good/g;
                }
            }
        

        # Write the list.threadnumber entry
        
        $filetoopen = "$ikondir" . "forum$inforum/$newthreadnumber.pl";
        $filetoopen = &stripMETA($filetoopen);
        open(FILE, ">$filetoopen");
        flock (FILE, 2);
        print FILE "$newthreadnumber|$intopictitle|$intopicdescription|open|0|0|$inmembername|$currenttime|$inmembername|$currenttime";
        close(FILE);

        # Create the new thread file
        
        $filetomake = "$ikondir" . "forum$inforum/$newthreadnumber.thd";
        $filetomake = &stripMETA($filetomake);
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "$inmembername|$intopictitle|$postipaddress|$inshowemoticons|$inshowsignature|$currenttime|$inpost";
        close(FILE);

        
        # Update stats for member, and board
        
        &getforum("$inforum");        

        $cleanmembername = $inmembername;
        $cleanmembername =~ s/ /\_/isg;
        $numberofposts++;
        $lastpostdate = "$currenttime\%\%\%$threadprog?forum=$inforum&topic=$newthreadnumber\%\%\%$intopictitle" if ($privateforum ne "yes");
        chomp $lastpostdate;
        
        $filetomake = "$ikondir" . "members/$cleanmembername.cgi";
        $filetomake = &stripMETA($filetomake);
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "$inmembername|$password|$membertitle|$membercode|$numberofposts|$emailaddress|$showemail|$ipaddress|$homepage|$aolname|$icqnumber|$location|$interests|$joineddate|$lastpostdate|$signature|$timedifference|$privateforums|$useravatar|$misc1|$misc2|$misc3";
        close(FILE);
        
        $filetoopen = "$ikondir" . "data/allforums.cgi";
        $filetoopen = &stripMETA($filetoopen);
        open(FILE, "$filetoopen");
        @allforums = <FILE>;
        close(FILE);
        
        $filetomake = "$ikondir" . "data/allforums.cgi";
        $filetomake = &stripMETA($filetomake);
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        foreach $forum (@allforums) { #start foreach @forums
        chomp($forum);
            ($tempno, $trash) = split(/\|/,$forum);
                if ($inforum eq $tempno) {
                    ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);
                    $lastposter = $inmembername;
                    $lastposttime = $currenttime;
                    $threads = $newthreadnumber;
                    print FILE "$forumid|$category|$categoryplace|$forumname|$forumdescription|$forummoderator|$htmlstate|$idmbcodestate|$privateforum|$startnewthreads|$lastposter|$lastposttime|$threads|$posts|$forumgraphic\n";
                }
            else { print FILE "$forum\n"; }
        }
        close(FILE);

        require "$ikondir" . "data/boardstats.cgi";
        
        $filetomake = "$ikondir" . "data/boardstats.cgi";
        $filetomake = &stripMETA($filetomake);
        
        $totalthreads++;
        
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "\$lastregisteredmember = \"$lastregisteredmember\"\;\n";
        print FILE "\$totalmembers = \"$totalmembers\"\;\n";
        print FILE "\$totalthreads = \"$totalthreads\"\;\n";
        print FILE "\$totalposts = \"$totalposts\"\;\n";
        print FILE "\n1\;";
        close (FILE);
        
        
        # if the user wants email notifications, lets add them.
        
        if (($emailfunctions eq "on") && ($innotify eq "yes")) { # start mail
        
            $filetomake = "$ikondir" . "forum$inforum/$newthreadnumber.mal";
            
            open (FILE, ">$filetomake");
            flock (FILE, 2);
            print FILE "$inmembername|$emailaddress\n";
            close (FILE);
        
            } # end if
            
        
        $relocurl = "$threadprog?forum=$inforum&topic=$newthreadnumber";
        
        &mischeader("New Topic Started");
                    
        $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr>    
            <td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle align=center><font face="$font" color=$fontcolormisc size=2><b>Thanks! your new thread has been started</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
            If your browser does not redirect you, please choose from the links below.
            <ul>
            <li><a href="$threadprog?forum=$inforum&topic=$newthreadnumber">Back to the new topic</a>
            <li><a href="$forumsprog?forum=$inforum">Back to the forum</a>
            <li><a href="$forumsummaryprog">Back to the forums index</a>
            </ul>
            </tr>
            </td>
            </table></td></tr></table>
            <meta http-equiv="refresh" content="5; url=$relocurl">
            ~;
            
     rebuildLIST(-Forum=>"$inforum");

    } # end else

} # end addnewthread







###########################################
############## reply side #################

sub reply {

    


    ### Lets sort out the flood control

    &getmember("$inmembername");
        if (($floodcontrol eq "on") && ($membercode ne "ad") && ($membercode ne "mo")) {
            $currenttime = time;
            ($lastpost, $posturl, $posttopic) = split(/\%\%\%/,$lastpostdate);
            $lastpost = ($lastpost + $floodcontrollimit);
            if ($lastpost > $currenttime)  {
                &error("Posting a reply&Flood control has been enabled on this board, you must wait for $floodcontrollimit seconds before making another post");
                }
            }

    &getforum("$inforum");

        if ($allowedentry{$inforum} eq "yes") { $allowed = "yes"; }
        
        if (($privateforum eq "yes") && ($allowed ne "yes")) {
            &error("Posting&Sorry, you are not allowed to post in this forum");
        }   

    if ($threadstate eq "locked") { &error("Posting a reply&Sorry, this thread has been locked"); }



    if ($emoticons eq "on") {
        $emoticonslink = qq~<a href="javascript:openScript('$miscprog?action=showsmilies',300,350)">Emoticons are enabled</a>~;
        $emoticonsbutton =qq~<input type=checkbox name="inshowemoticons" value="yes" checked>Do you wish to <b>enable</b> emoticons in this post?<br>~;
        }


    if ($emailfunctions eq "on") { 
           if ($innotify eq "yes") {
              $requestnotify = qq~<input type=checkbox name="notify" value="yes" checked>Do you want email notification of replies?<br>~;
              } 
              else {
                   $requestnotify = qq~<input type=checkbox name="notify" value="yes">Do you want email notification of replies?<br>~;
                   }
            }

    if ($previewfirst eq "yes") {
        &preview;
        $inpost =~ s/\<p\>/\n\n/g;
        $inpost =~ s/\<br\>/\n/g;
        }
        else {
            &mischeader("Post reply to")
            }


    $output .= qq~
        <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
        <tr><td>
            <table cellpadding=4 cellspacing=1 border=0 width=100%>
                <tr>
                    <td bgcolor=$titlecolor colspan=2><font face="$font" color=$titlefontcolor size=1>Topic: $topictitle</td>
                </tr>
                <tr><form action="$thisprog" method=post>
                    <input type=hidden name="action" value="addreply">
                    <input type=hidden name="forum" value="$inforum">
                    <input type=hidden name="topic" value="$intopic">
                </tr><tr>
                    <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1><b>Username</b></font></td>
                    <td bgcolor=$miscbackone valign=middle><input type=text size=20 name="membername" value="$inmembername"><font face="$font" color=$fontcolormisc size=1> &nbsp; <a href="$registerprog">Are you registered?</a></font></td>
                </tr><tr>
                    <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1><b>Password</b></font></td>
                    <td bgcolor=$miscbackone valign=middle><input type=password size=20 name="password" value="$inpassword"><font face="$font" color=$fontcolormisc size=1> &nbsp; <a href="$profileprog?action=lostpass">Forgotten your password?</a></font></td>
                </tr><tr>
                    <td bgcolor=$miscbackone valign=top><font face="$font" color=$fontcolormisc size=1><b>Post</b><p>
                    HTML is <b>$htmlstate</b> for this forum<p>IkonCode is <b>$idmbcodestate</b> for this forum<p>$emoticonslink</font></td>
                    <td bgcolor=$miscbackone valign=middle><textarea cols=60 rows=6 wrap="soft" name="inpost">$inpost</textarea></td>
                </tr><tr>
                    <td bgcolor=$miscbacktwo valign=top><font face="$font" color=$fontcolormisc size=1><b>Post Options</b><p>$helpurl</font></td>
                    <td bgcolor=$miscbacktwo valign=middle><font face="$font" color=$fontcolormisc size=1><input type=checkbox name="inshowsignature" value="yes" checked>Do you wish to add your signature?<br>
                    $requestnotify
                    $emoticonsbutton
                    <b>Do you wish to preview before posting?</b><input name="previewfirst" type="radio" value="yes"> Yes &nbsp; <input name="previewfirst" type="radio" value="no" checked> No</font>
                    </font></td>
                </tr><tr>
                    <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center>
                    <input type=Submit value=Submit name=Submit" onClick="return clckcntr();"> &nbsp; <input type="reset" name="Clear"></form>
                </td></tr>
            </table></tr></td>
        </table>
        ~;
        
        
        # Lets display the thread review

        $filetoopen = "$ikondir" . "forum$inforum/$intopic.thd";
        $filetoopen = &stripMETA($filetoopen);
        open(FILE, "$filetoopen");
        flock(FILE, 2);
        @threads = <FILE>;
        close(FILE);

        @sortedthreads = reverse(@threads);

        &threadreview;
    
    } # end add reply routine




##### Reply with quote

sub replyquote {

    


    ### Lets sort out the flood control

    &getmember("$inmembername");
        if (($floodcontrol eq "on") && ($membercode ne "ad") && ($membercode ne "mo")) {
            $currenttime = time;
            ($lastpost, $posturl, $posttopic) = split(/\%\%\%/,$lastpostdate);
            $lastpost = ($lastpost + $floodcontrollimit);
            if ($lastpost > $currenttime)  {
                &error("Posting a reply&Flood control has been enabled on this board, you must wait for $floodcontrollimit seconds before making another post");
                }
            }
    &getforum("$inforum");

        if ($allowedentry{$inforum} eq "yes") { $allowed = "yes"; }
        
        if (($privateforum eq "yes") && ($allowed ne "yes")) {
            &error("Posting&Sorry, you are not allowed to post in this forum");
        }   

    # Get the post to edit

    $filetoopen = "$ikondir" . "forum$inforum/$intopic.thd";
    $filetoopen = &stripMETA($filetoopen);
    open(FILE, "$filetoopen");
    flock(FILE, 2);
    @threads = <FILE>;
    close(FILE);

    $posttoget = $inpostno;
    $posttoget--;

    ($membername, $topictitle, $postipaddress, $showemoticons, $showsignature ,$postdate, $post) = split(/\|/, @threads[$posttoget]);
        
    $post =~ s/\<p\>/\n\n/g;
    $post =~ s/\<br\>/\n/g;
    
    $postdate = $postdate + ($timedifferencevalue*3600) + ($timezone*3600);   
    $postdate = &dateformat("$postdate");




### Print form



    $rawpost = $post;

    if ($previewfirst eq "yes") {
        $rawpost = $inpost;
        $rawpost =~ s/\<p\>/\n\n/g;
        $rawpost =~ s/\<br\>/\n/g;
        &preview;
        }
        else {
            &mischeader("Replying to post in");
            }


    if ($threadstate eq "closed") { &error("Posting a reply&Sorry, this thread has been locked"); }

    if ($emoticons eq "on") {
        $emoticonslink = qq~<a href="javascript:openScript('$miscprog?action=showsmilies',300,350)">Emoticons are enabled</a>~;
        $emoticonsbutton =qq~<input type=checkbox name="inshowemoticons" value="yes" checked>Do you wish to <b>enable</b> emoticons in this post?<br>~;
        }
    
    if ($emailfunctions eq "on") { $requestnotify = qq~<input type=checkbox name="notify" value="yes">Do you want email notification of replies?<br>~; }


    $temppost = qq~\[quote\]Quote: from $membername on $postdate\[br\]$rawpost\[\/quote\]~;

    $output .= qq~
        <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr><td>
                <table cellpadding=4 cellspacing=1 border=0 width=100%>
                <tr>
                    <td bgcolor=$titlecolor colspan=2><font face="$font" color=$titlefontcolor size=1>Topic: $topictitle</td>
                </tr>
                <tr><form action="$thisprog" method=post>
                    <input type=hidden name="action" value="addreply">
                    <input type=hidden name="forum" value="$inforum">
                    <input type=hidden name="topic" value="$intopic">
                </tr><tr>
                    <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1><b>Username</b></font></td>
                    <td bgcolor=$miscbackone valign=middle><input type=text size=20 name="membername" value="$inmembername"><font face="$font" color=$fontcolormisc size=1> &nbsp; <a href="$registerprog">Are you registered?</a></font></td>
                </tr><tr>
                    <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1><b>Password</b></font></td>
                    <td bgcolor=$miscbackone valign=middle><input type=password size=20 name="password" value="$inpassword"><font face="$font" color=$fontcolormisc size=1> &nbsp; <a href="$profileprog?action=lostpass">Forgotten your password?</a></font></td>
                </tr><tr>
                    <td bgcolor=$miscbackone valign=top><font face="$font" color=$fontcolormisc size=1><b>Post</b><p>
                    HTML is <b>$htmlstate</b> for this forum<p>IkonCode is <b>$idmbcodestate</b> for this forum<p>$emoticonslink</font></td>
                    <td bgcolor=$miscbackone valign=middle><textarea cols=60 rows=6 wrap="soft" name="inpost">$temppost</textarea></td>
                </tr><tr>
                    <td bgcolor=$miscbacktwo valign=top><font face="$font" color=$fontcolormisc size=1><b>Post Options</b></font></td>
                    <td bgcolor=$miscbacktwo valign=middle><font face="$font" color=$fontcolormisc size=1><input type=checkbox name="inshowsignature" value="yes" checked>Do you wish to add your signature?<br>
                    $requestnotify
                    $emoticonsbutton
                    <b>Do you wish to preview before posting?</b><input name="previewfirst" type="radio" value="yes"> Yes &nbsp; <input name="previewfirst" type="radio" value="no" checked> No</font>
                    </font></td>
                </tr><tr>
                    <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center>
                    <input type=Submit value=Submit name=Submit" onClick="return clckcntr();"> &nbsp; <input type="reset" name="Clear"></form>
                    </td></tr></table></tr></td></table>
                    ~;



    # Print the thread summary
    

    @sortedthreads = reverse(@threads);

    &threadreview;

} # end add reply quote









##### add the replyto the file.

sub addreply { # start routine


    ### Lets sort out the flood control, incase they used the back button...

    &getmember("$inmembername");
        if (($floodcontrol eq "on") && ($membercode ne "ad") && ($membercode ne "mo")) {
            $currenttime = time;
            ($lastpost, $posturl, $posttopic) = split(/\%\%\%/,$lastpostdate);
            $lastpost = ($lastpost + $floodcontrollimit);
            if ($lastpost > $currenttime)  {
                &error("Posting a reply&Flood control has been enabled on this board, you must wait for $floodcontrollimit seconds before making another post");
                }
            }

    
    if ($userregistered eq "no")     { &error("adding a post&No user registered"); }
    elsif ($inpassword ne $password) { &error("adding a post&Wrong Password"); }
    elsif ($membercode eq "banned")  { &error("adding a post&You are banned"); }
    elsif ($inpost eq "")            { &error("Starting a thread&You must enter a post"); }

    else { # start else

        &getforum("$inforum");

        if ($allowedentry{$inforum} eq "yes") { $allowed = "yes"; }

        if (($privateforum eq "yes") && ($allowed ne "yes")) {
            &error("Posting&Sorry, you are not allowed to post in this forum");
        }   
 
        # Grab the thread file
        
        $filetoopen = "$ikondir" . "forum$inforum/$intopic.thd";
        $filetoopen = &stripMETA($filetoopen);
        open(FILE, "$filetoopen");
        @allmessages = <FILE>;
        close(FILE);

        $totalthreadposts = @allmessages;
        
        ($trash, $topictitle) = split(/\|/,$allmessages[0]);

        # Open the bad word filter
        
        $filetoopen = "$ikondir" . "data/badwords.cgi";
        open (FILE, "$filetoopen");
        $badwords = <FILE>;
        close (FILE);
    
        if ($badwords) {
            @pairs = split(/\&/,$badwords);
            foreach (@pairs) {
                ($bad, $good) = split(/=/,$_);
                $inpost =~ s/$bad/$good/g;
                $intopictitle =~ s/$bad/$good/g;
                $intopicdescription =~ s/$bad/$good/g;
                }
            }
        
        $filetomake = "$ikondir" . "forum$inforum/$intopic.thd";
        $filetomake = &stripMETA($filetomake);
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        foreach $messages (@allmessages) {
            chomp $messages;
            print FILE "$messages\n";
            }
        print FILE "$inmembername|$topictitle|$postipaddress|$inshowemoticons|$inshowsignature|$currenttime|$inpost";
        close(FILE);
        
        
        my $file = "$ikondir" . "forum$inforum/$intopic.pl";
        open (ENT, $file);
        $in = <ENT>;
        close (ENT);

            
        ($topicid, $topictitle, $topicdescription, $threadstate, $threadposts ,$threadviews, $startedby, $startedpostdate, $lastposter, $lastpostdate) = split(/\|/,$in);
        
        $threadposts = @allmessages;
        
        open(FILE, ">$file");
        flock(FILE, 2);
        print FILE "$intopic|$topictitle|$topicdescription|$threadstate|$threadposts|$threadviews|$startedby|$startedpostdate|$inmembername|$currenttime";
        close(FILE);

        $cleanmembername = $inmembername;
        $cleanmembername =~ s/ /\_/isg;
        $numberofposts++;
        $lastpostdate = "$currenttime\%\%\%$threadprog?forum=$inforum&topic=$intopic\%\%\%$topictitle" if ($privateforum ne "yes");
        chomp $lastpostdate;
        
        $filetomake = "$ikondir" . "members/$cleanmembername.cgi";
        $filetomake = &stripMETA($filetomake);
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "$inmembername|$password|$membertitle|$membercode|$numberofposts|$emailaddress|$showemail|$ipaddress|$homepage|$aolname|$icqnumber|$location|$interests|$joineddate|$lastpostdate|$signature|$timedifference|$privateforums|$useravatar|$misc1|$misc2|$misc3";
        close(FILE);
        
        $filetoopen = "$ikondir" . "data/allforums.cgi";
        $filetoopen = &stripMETA($filetoopen);
        open(FILE, "$filetoopen");
        flock (FILE, 1);
        @allforums = <FILE>;
        close(FILE);
        
        $filetomake = "$ikondir" . "data/allforums.cgi";
        $filetomake = &stripMETA($filetomake);
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        foreach $forum (@allforums) { #start foreach @forums
        chomp($forum);
            ($tempno, $trash) = split(/\|/,$forum);
                if ($inforum eq $tempno) {
                    ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);
                    $lastposter = $inmembername;
                    $lastposttime = $currenttime;
                    $posts++;
                    print FILE "$forumid|$category|$categoryplace|$forumname|$forumdescription|$forummoderator|$htmlstate|$idmbcodestate|$privateforum|$startnewthreads|$lastposter|$lastposttime|$threads|$posts|$forumgraphic\n";
                }
            else { print FILE "$forum\n"; }
        }
        close(FILE);


        require "$ikondir" . "data/boardstats.cgi";
        
        $filetomake = "$ikondir" . "data/boardstats.cgi";
        $filetomake = &stripMETA($filetomake);
        
        $totalposts++;
        
        open(FILE, ">$filetomake");
        flock(FILE, 2);
        print FILE "\$lastregisteredmember = \"$lastregisteredmember\"\;\n";
        print FILE "\$totalmembers = \"$totalmembers\"\;\n";
        print FILE "\$totalthreads = \"$totalthreads\"\;\n";
        print FILE "\$totalposts = \"$totalposts\"\;\n";
        print FILE "\n1\;";
        close (FILE);
        
    ### email functions
        
            # First, lets open the maildata file, and add (if needed) the new requestee.
        
        if ($emailfunctions eq "on") { # start mail
        
            
            $filetoopen = "$ikondir" . "forum$inforum/$intopic.mal";
            open (FILE, "$filetoopen");
            @maildata = <FILE>;
            close (FILE);
        
            
            if ($innotify eq "yes") {
                open (FILE, ">$filetoopen");
                flock (FILE, 2);
                print FILE "$inmembername|$emailaddress\n";
                foreach $line (@maildata) {
                    chomp $line;
                    print FILE "$line\n";
                    }
                close (FILE);
                }
        
            # Lets sort the data (there's no point adding the new requestee at this point!)
        
            foreach $dataline (@maildata) {
                ($postersname,$posteremailaddress) = split(/\|/,$dataline);
                
                if ($lastemailsent ne $postersname) {
                
                # No point in getting your own post emailed to you, so...
                
                    if ($inmembername eq $postersname) { next; }
                
                    # If not,carry on!
                    
                        $output .= "\n\n<!-- Processing Emails --> \n\n";

                        $toemail = "$posteremailaddress";
                        chomp $toemail;
                        $toemail =~ s/\\//g;
                        $fromemail = "$adminemail_out";
                        chomp $fromemail;
                        $fromemail =~ s/\\//g;

                        $topictitle =~ s/&quot\;/\"/g;
                        $topicdescription =~ s/&quot\;/\"/g;
                        
                        $to = "$toemail";
                        $from = "$boardname <$fromemail>";
                        $subject = "[$forumname] Reply Post Notification";

                        $message .= "\n";
                        $message .= "$boardtitle\n";
                        $message .= "$boardurl/$forumsummaryprog\n";
                        $message .= "---------------------------------------------------------------------\n\n";
                        $message .= "$postersname, $inmembername just made a reply to this topic:\n\n";
                        $message .= "Category   : $category\n";
                        $message .= "Forum      : $forumname\n";
                        $message .= "Subject    : $topictitle\n";
                        $message .= "Description: $topicdescription\n\n";
                        $message .= "Click below to go straight to the discussion:\n\n";
                        $message .= "$boardurl/$threadprog?forum=$inforum&topic=$intopic\n\n";
                        $message .= "---------------------------------------------------------------------\n";
                        
                        &sendmail($from, $from, $to, $SMTP_SERVER, $subject, $message );
                    
                        $lastemailsent = "$postersname";
                    
                    # trash the details, just to be safe.
                    
                    $message = "";
                    $to = "";
                    $from = "";
                    $subject = "";
                  
                  } # end if       
                
                } # end foreach
             
             } # end email send.


    
    $numberofitems = $totalthreadposts + 1;
    $numberofpages = $numberofitems / $maxthreads;

        if ($numberofitems > $maxthreads) { #1
            if ($maxthreads < $numberofitems) { #2
                ($integer,$decimal) = split(/\./,$numberofpages);
                    if ($decimal > 0) { $numberofpages = $integer + 1; }
                        $pagestart = 0;
                        $counter = 0;
                        while ($numberofpages > $counter) { #3
                            $counter++;
                            $threadpages .= qq~<a href="$threadprog?forum=$inforum&topic=$topicid&start=$pagestart"> $counter </a>~;
                            $pagestart = $pagestart + $maxthreads;
                            } #e3
                        } #e2
                    $pagestoshow = qq~<font face="$font" color=$forumfontcolor size=1> &nbsp;[ Pages&nbsp;$threadpages ]~;
                    } #e1


        
        &mischeader("Post Successful");
        
        $relocurl = "$threadprog?forum=$inforum&topic=$intopic";
        
                    
        $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr>    
            <td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle align=center><font face="$font" color=$fontcolormisc size=2><b>Thanks! your post has been added to the topic</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
            If your browser does not redirect you, please choose from the links below.
            <ul>
            <li><a href="$threadprog?forum=$inforum&topic=$intopic">Back to the topic </a>$pages
            <li><a href="$forumsprog?forum=$inforum">Back to the forum</a>
            <li><a href="$forumsummaryprog">Back to the forums index</a>
            </ul>
            </tr>
            </td>
            </table></td></tr></table>
            <meta http-equiv="refresh" content="6; url=$relocurl">
            ~;


      rebuildLIST(-Forum=>"$inforum");      

    } # end else

    

} # end addreply


###########################
# Thread Review

sub threadreview {

    $output .= qq~
        <p>
        <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
        <tr><td>
        <table cellpadding=8 cellspacing=1 border=0 width=100%>
        <tr>
        <td bgcolor=$titlecolor colspan=2><font face="$font" color=$titlefontcolor size=2><b>Thread Review for $topictitle (newest post first)</b></td>
        ~;

    foreach $threadline (@sortedthreads) {

        ($membername, $topictitle, $postipaddress ,$showemoticons ,$showsignature ,$postdate ,$post) = split(/\|/, $threadline);
        $postdate = $postdate + ($timedifferencevalue*3600) + ($timezone*3600);
        $postdate = &dateformat("$postdate");

        $post = &ikoncode("$post");
        $post = &doemoticons("$post");
        $post =~ s/\:\)/<img src=\"$imagesurl\/emoticons\/smile.gif\" border=\"0\">/g;
        $post =~ s/\;\)/<img src=\"$imagesurl\/emoticons\/wink.gif\" border=\"0\">/g;
        $post =~ s/\:\(/<img src=\"$imagesurl\/emoticons\/sad.gif\" border=\"0\">/g;
        $post =~ s/\:\o/<img src=\"$imagesurl\/emoticons\/shocked.gif\" border=\"0\">/g;
        


    $output .= qq~
        <tr>
            <td bgcolor="$miscbackone" rowspan=2 valign="top" width=20%><font face="$font" color=$fontcolormisc size=2>
            <b>$membername</b></font></td>
            <td bgcolor="$miscbackone"><font face="$font" color=$fontcolormisc size=2><b>Posted on $postdate</b></td>
        </tr>
        <tr>
            <td bgcolor="$miscbackone"><font face="$font" color=$fontcolormisc size=2>$post</td>
        </tr>
        <tr>
            <td colspan=2 bgcolor="$miscbacktwo">&nbsp;</td>
        </tr>
        ~;

        } # end foreach
    $output .= qq~</table></td></tr></table>~;
} # end routine
   
