#!/usr/bin/perl

#############################################################
# Ikonboard v2.1
# Copyright 2000 Ikondiscussion.com - All Rights Reserved
# Ikondiscussion is a trademark of Ikondiscussion.com
#
# Software Distributed by: Ikondiscussion.com
# Visit us online at http://www.ikondiscussion.com
# Email us on boards@ikondiscussion.com
#
# All files written by Matthew Mecham
#############################################################

use CGI::Carp "fatalsToBrowser";          # Output errors to browser
use CGI qw(:standard);                    # Saves loads of work
$CGI::POST_MAX=1024 * 150;                # limit post data
$CGI::DISABLE_UPLOADS = 1;                # Disable uploads

eval {
($0 =~ m,(.*)/[^/]+,)   and unshift (@INC, "$1");
($0 =~ m,(.*)\\[^\\]+,) and unshift (@INC, "$1");
require "ikon.lib";          # Require ikonboard ()
require "data/progs.cgi";    # Require prog names
require "data/boardinfo.cgi";# Require board info
require "data/styles.cgi";   # Require styles info
require "ikonmail.lib";      # Require email func ()
};
if ($@) {
    print header(); print start_html(-title=>"Ikonboard Error!");
    print "Could not find these files: $@\nIf you are running NT you may need to enter the full path in each require statement in each script";
    print end_html; exit;
}

$|++;                        # Unbuffer the output

#################--- Begin the program ---###################

$thisprog = "ikonfriend.cgi";

$query = new CGI;

$inforum         = $query -> param('forum');
$intopic         = $query -> param('topic');
$action          = $query -> param('action');
$inrealname      = $query -> param('realname');
$intoname        = $query -> param('toname');
$infromemail     = $query -> param('fromemail');
$intoemail       = $query -> param('toemail');
$insubject       = $query -> param('subject');
$inemailmessage  = $query -> param('emailmessage');
$emailtopictitle = $query -> param('emailtopictitle');

$inrealname          = &cleaninput($inrealname);
$insubject           = &cleaninput($insubject);
$inemailmessage      = &cleaninput($inemailmessage);
$emailtopictitle     = &cleaninput($emailtopictitle);
$inforum             = &cleaninput($inforum);
$intopic             = &cleaninput($intopic);

$inmembername = cookie("amembernamecookie");
$inpassword   = cookie("apasswordcookie");

print header();

if (($inforum) && ($inforum !~ /^[0-9]+$/)) { &error("General&Please do not modify the URL's generated."); }
if (($intopic ) && ($intopic  !~ /^[0-9]+$/)) { &error("General&Please do not modify the URL's generated."); }


&title;


$output .= qq~
<table cellpadding=0 cellspacing=0 border=0 width=$tablewidth align=center>
    <tr>
        <td width=30% rowspan=2><img src="$imagesurl/images/$boardlogo" border=0></td>
        <td valign=middle align=left><font face="$font" color=$fontcolormisc size=2>
        &nbsp;&nbsp;<img src="$imagesurl/images/closedfold.gif" border=0><a href="$forumsummaryprog">&nbsp;&nbsp;$boardname</a>
	    <br>
        &nbsp;&nbsp;<img src="$imagesurl/images/bar.gif" border=0><img src="$imagesurl/images/openfold.gif" border=0>&nbsp;&nbsp;Send Topic to a friend
        </td>
    </tr>
</table>
<p>
<table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
    <tr>
        <td>
        <table cellpadding=6 cellspacing=1 border=0 width=100%>
        ~;



### Do we have email functions for this board?

if ($emailfunctions ne "on") { &error("Sending Email to a friend&Sorry, the board administrator has email functions disabled"); }



if ($action eq "send") {

    ### Check for blank fields and invalid email addresses
    $blankfields = "";
    if(!$inrealname)        { $blankfields = "yes"; }
    elsif(!$intoname)       { $blankfields = "yes"; }
    elsif(!$intoemail)      { $blankfields = "yes"; }
    elsif(!$infromemail)    { $blankfields = "yes"; }
    elsif(!$insubject)      { $blankfields = "yes"; }
    elsif(!$inemailmessage) { $blankfields = "yes"; }
    
    if ($blankfields) {
        &error("Sending Email to a friend&Please ensure that the form is fully completed before submitting");
        }
    
    if ($infromemail !~ /^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?)$/) { &error("Sending Email to a friend&Invalid Email Address"); }
    if ($intoemail !~ /^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?)$/) { &error("Sending Email to a friend&Invalid Email Address"); }
    
    ### If were still here, lets send the email
    
    $to = "$intoemail";
    $from = "$boardname <$infromemail>";
    $subject = "$insubject";

                
    $message .= "\n";
    $message .= "$boardname\n";
    $message .= "$boardurl/$forumsummaryprog\n";
    $message .= "Ikonfriend from Ikonboard\n";
    $message .= "---------------------------------------------------------------------\n\n";
    $message .= "$inrealname sent you this email from $homename\n";
    $message .= "---------------------------------------------------------------------\n\n";
    $message .= "$inemailmessage\n\n";
    $message .= "Topic Title: $emailtopictitle\n\n\n";
    $message .= "$boardurl/$threadprog?forum=$inforum&topic=$intopic\n";
    $message .= "---------------------------------------------------------------------\n\n";
    $message .= "$homename can take no liability for messages emailed by the users\n";
    $message .= "of the bulletin board.\n\n";
    $message .= "Ikonboard (c)2000 Ikondiscussion.com\n";
                

    &sendmail($from, $from, $to, $SMTP_SERVER, $subject, $message);

### Print message to user


            $output .= qq~
            <tr>
            <td bgcolor=$miscbacktwo valign=middle align=center><font face="$font" color=$fontcolormisc size=2><b>The email has been sent</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
            Status:
            <ul>
            <li><a href="$threadprog?forum=$inforum&topic=$intopic">Back to the topic</a>
            <li><a href="$forumsprog?forum=$inforum">Back to the forum</a>
            <li><a href="$forumsummaryprog">Back to the forums index</a>
            </ul>
            </tr>
            </td>
            </table></td></tr></table>
            ~;


} # end if action




else {

### Get Details

    $filetoopen = "$ikondir" . "data/allforums.cgi";
    $filetoopen = &stripMETA($filetoopen);
    open(FILE, "$filetoopen");
    @forums = <FILE>;
    close(FILE);

    foreach $forumline (@forums) { #start foreach @forums
        ($tempno, $trash) = split(/\|/,$forumline);
        if ($inforum eq $tempno) {
            ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forumline);
            }
        }

    $filetoopen = "$ikondir" . "forum$inforum/list.cgi";
    $filetoopen = &stripMETA($filetoopen);
    open(FILE, "$filetoopen");
    @allthreads = <FILE>;
    close(FILE);
    
    foreach $line (@allthreads) { #start foreach @threads
            ($tempno, $trash) = split(/\|/, $line);
            if ($intopic eq $tempno) {
                $linetokeep = $line;
            }
        } # end foreach
            
        
        ($topicid, $topictitle, $topicdescription, $threadstate, $threadposts ,$threadviews, $startedby, $startedpostdate, $lastposter, $lastpostdate) = split(/\|/,$linetokeep);
        


### print form

    $topictitle = &cleanarea("$topictitle");

    $output .= qq~
    <form action="$boardurl/$thisprog" method=post>
    <input type=hidden name="action" value="send">
    <input type=hidden name="forum" value="$inforum">
    <input type=hidden name="topic" value="$intopic">
    <tr>
    <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center><font face="$font" color=$fontcolormisc size=3><b>Send to a friend</b></font></td></tr>
    <tr>
    <td bgcolor=$miscbackone valign=middle colspan=2><font face="$font" color=$fontcolormisc size=2>
    <b>Ikonfriend</b>: Send topic <a href="$threadprog?forum=$inforum&topic=$intopic">$topictitle</a> to your friend via email.<br>
    Please ensure that you fill in all of the form, and include valid email addresses.
    <br>You may include a custom message to be added, the URL and Topic title are entered into the email automatically
    </td>
    <tr>
    <td bgcolor=$miscbackone><font face="$font" color=$fontcolormisc size=1><b>Your name:</b><br>Please enter your name</td>
    <td bgcolor=$miscbackone><input type=text size=40 name="realname"></td>
    </tr><tr>
    <td bgcolor=$miscbacktwo><font face="$font" color=$fontcolormisc size=1><b>Your email address:</b><br>Please enter a valid email address.</td>
    <td bgcolor=$miscbacktwo><input type=text size=40 name="fromemail"></td>
    </tr><tr>
    <td bgcolor=$miscbackone><font face="$font" color=$fontcolormisc size=1><b>Your friends name:</b><br>
    Please enter the name of your friend</td>
    <td bgcolor=$miscbackone><input type=text size=40 name="toname"></td>
    </tr><tr>
    <td bgcolor=$miscbacktwo><font face="$font" color=$fontcolormisc size=1><b>Your friends email address:</b><br>Please enter a valid email address for your friend.</td>
    <td bgcolor=$miscbacktwo><input type=text size=40 name="toemail"></td>
    </tr><tr>
    <td bgcolor=$miscbackone><font face="$font" color=$fontcolormisc size=1><b>Email Subject:</b><br>Please enter a subject line for the email</td>
    <td bgcolor=$miscbackone><input type=text size=40 name="subject" value="$topictitle"></td>
    </tr><tr>
    <td bgcolor=$miscbackone><font face="$font" color=$fontcolormisc size=1><b>Message:</b><br>Please enter a message for the email</td>
    <td bgcolor=$miscbackone><textarea name="emailmessage" cols="55" rows="6">I thought you would like to read '$topictitle' from '$homename'</textarea></td>
    </tr><tr>
    <td colspan=2 bgcolor=$miscbackone align=center><input type=hidden name="emailtopictitle" value="$topictitle"><input type=submit value="Send Email" name="Submit"></form></table></td></tr></table>
    ~;


} # end routine.


&output(
-Title   => $boardname, 
-ToPrint => $output, 
-Version => $versionnumber 
);

