#!/usr/bin/perl

#############################################################
# Ikonboard v2.1
# Copyright 2000 Ikondiscussion.com - All Rights Reserved
# Ikondiscussion is a trademark of Ikondiscussion.com
#
# Software Distributed by: Ikondiscussion.com
# Visit us online at http://www.ikondiscussion.com
# Email us on boards@ikondiscussion.com
#
# All files written by Matthew Mecham
#############################################################

use CGI::Carp "fatalsToBrowser";          # Output errors to browser
use CGI qw(:standard);                    # Saves loads of work
$CGI::POST_MAX=1024 * 150;                # limit post data
$CGI::DISABLE_UPLOADS = 1;                # Disable uploads
$CGI::HEADERS_ONCE = 1;                   # Kill redundant headers

eval {
($0 =~ m,(.*)/[^/]+,)   and unshift (@INC, "$1");
($0 =~ m,(.*)\\[^\\]+,) and unshift (@INC, "$1");
require "ikon.lib";          # Require ikonboard ()
require "data/progs.cgi";    # Require prog names
require "data/boardinfo.cgi";# Require board info
require "data/styles.cgi";   # Require styles info
};
if ($@) {
    print header(); print start_html(-title=>"Ikonboard Error!");
    print "Could not find these files: $@\nIf you are running NT you may need to enter the full path in each require statement in each script";
    print end_html; exit;
}

$|++;                                     # Unbuffer the output

#################--- Begin the program ---###################

$thisprog = "ikonboard.cgi";

$query = new CGI;
$action = $query->param('action');

$inmembername = cookie("amembernamecookie");
$inpassword   = cookie("apasswordcookie");


if ($inmembername eq "") {
    $inmembername = "Guest";
    }
    else {
        &getmemberstime("$inmembername");
        &getlastvisit;
        }

if ($action eq "resetall") {
    $filetoopen = "$ikondir" . "data/allforums.cgi";
    $filetoopen = &stripMETA($filetoopen);
    open(FILE, "$filetoopen") or die "Could not locate the needed files";
    flock(FILE, 2);
    @forums = <FILE>;
    close(FILE);
    $currenttime = time;
    foreach (@forums) { #start foreach @forums
        ($tempno, $trash) = split(/\|/,$_);
        $lvisit .= "$tempno-$currenttime--";
        }

    $cookie     = cookie(-name    =>   "lastvisit",
                         -value   =>   "$lvisit",
                         -path    =>   "$cookiepath",
                         -expires =>   "+30d");
            
    $tempcookie = cookie(-name    =>   "templastvisit",
                         -value   =>   "$lvisit",
                         -path    =>   "$cookiepath");
    print header(-cookie  =>[$cookie, $tempcookie]);
    }
    

    &title;


    require "$ikondir" . "data/boardstats.cgi";
    

    ### Set up the variables for the last registered Member

    $cleanlastregistered = $lastregisteredmember;
    $cleanlastregistered =~ y/ /_/;
    $cleanlastregistered = qq~<a href="$profileprog?action=show&member=$cleanlastregistered">$lastregisteredmember</a>~;




    #------- HTML

    $output .= qq~
    <!-- Cgi-bot Begin Board logo and navigation -->
    <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth align=center>
        <tr>
        <td width=30% rowspan=2><img src="$imagesurl/images/$boardlogo" border=0></td>
            <td valign=bottom align=right><font face="$font" color=$fontcolormisc size=2>
                $boardname welcomes its newest member $cleanlastregistered<br>
                $boardname has <b>$totalmembers</b> members with <b>$totalposts</b> posts in <b>$totalthreads</b> topics
            </td>
        </tr>
    </table>
    <br>
    <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
        <tr>
            <td>
                <table cellpadding=4 cellspacing=1 border=0 width=100%>
            <tr>
            <td bgcolor=$titlecolor width=5% align=center><font face="$font" color=$titlefontcolor size=2><b>&nbsp;</b></td>
            <td bgcolor=$titlecolor width=63%><font face="$font" color=$titlefontcolor size=1><b>Forum Info</b></td>
            <td bgcolor=$titlecolor width=4% nowrap align="center"><font face="$font" color=$titlefontcolor size=2><b>Replies</b></td>
            <td bgcolor=$titlecolor width=4% nowrap align="center"><font face="$font" color=$titlefontcolor size=2><b>Topics</b></td>
            <td bgcolor=$titlecolor width=25% align="center"><font face="$font" color=$titlefontcolor size=2><b>Last Post</b></td>
        </tr>
     <!-- Cgi-bot End Board logo and navigation -->
     ~;

#------- END OF HTML

if ($announcements eq 'yes') {

#------- HTML

        $output .= qq~
        <!-- Cgi-bot Announcements Title -->
        <tr>
            <td bgcolor=$catback colspan=5>
                <font face="$font" color=$catfontcolor size=3>
                <b>&raquo; Announcements</b>
                </font>
            </td>
        </tr>
        <!-- Cgi-bot End Announcements Title -->
        ~;

#------- END OF HTML

        my $filetoopen = "$ikondir" . "data/news.cgi";
        if (-e $filetoopen) {
            openFILE(-FH=>'FILE',-FN=>"$filetoopen",-MD=>'r');
            my @announcementdata = <FILE>;
            close(FILE);

            my $totalannouncements = @announcementdata;
            ($title, $dateposted, $trash) = split(/\|/, $announcementdata[0]);
            }
            else { $dateposted = time; $title = 'No current announcements'; }

        my $dateposted = $dateposted + ($timedifferencevalue*3600) + ($timezone*3600);
        $dateposted = &longdate("$dateposted");

#------- HTML
    
        $output .= qq~
        <!-- Cgi-Bot Announcements from $dateposted -->
        <tr>
            <td bgcolor=$forumcolortwo align=center>
              <img src="$imagesurl/images/announce.gif" border=0>
            </td>
            <td bgcolor=$forumcolortwo>
                <font face="$font" color=$forumfontcolor size=2>
                $title
                </font>
            </td>
            <td bgcolor=$forumcolortwo colspan=2 align="center">
                <font face="$font" color=$forumfontcolor size=2>
                [ <a href="$boardurl/$announceprog">Read</a> ]
                </font>
            </td>
            <td bgcolor=$forumcolorone>
                <font face="$font" color=$forumfontcolor size=1>
                    <b>$dateposted</b>
                </font>
            </td>
        </tr>
        <!-- Cgi-bot End of announcements -->
        ~;

#------- END OF HTML
    
        } 



### Open up the allforums file.

$filetoopen = "$ikondir" . "data/allforums.cgi";
$filetoopen = &stripMETA($filetoopen);
open(FILE, "$filetoopen") or die "Have you created any forums yet?";
@forums = <FILE>;
close(FILE);

foreach $forum (@forums) { #start foreach @forums
    chomp $forum;
    ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);
    $rearrange = ("$categoryplace|$category|$forumname|$forumdescription|$forummoderator|$htmlstate|$idmbcodestate|$privateforum|$startnewthreads|$lastposter|$lastposttime|$threads|$posts|$forumgraphic|$forumid");
    push (@rearrangedforums, $rearrange);

} # end foreach (@forums)

@finalsortedforums = sort numerically(@rearrangedforums);

foreach $sortedforums (@finalsortedforums) { #start foreach @finalsortedforums

    ($categoryplace, $category, $forumname, $forumdescription, $forummoderator, $htmlstate, $idmbcodestate, $privateforum, $startnewthreads, $lastposter, $lastposttime, $threads, $posts, $forumgraphic, $forumid) = split(/\|/,$sortedforums);

    if ($forummoderator) {
            $forummoderator =~ s/\, /\,/g;
            my @mods = split(/\,/,$forummoderator);
            my $tm = @mods; my $mc = 1;
            foreach (@mods) {
                my $cmodn = $_; $cmodn =~ y/ /_/;
                if ($mc != $tm) {
                    $modout .= qq~<a href="$boardurl/$profileprog?action=show&member=$cmodn">$_</a>, ~;
                    }
                    else { $modout .= qq~<a href="$profileprog?action=show&member=$cmodn">$_</a>~; }
                $mc++;
                }
            $modout = qq!(Moderated by: $modout)!;
            }

    if ($categoryplace ne $lastcategoryplace) {
        $output .= qq~<tr><td bgcolor=$catback colspan=5><font face="$font" color=$catfontcolor size=3><b>&raquo; $category</b></font></td></tr>~;
        }
    
    my $fm = $forumname; $forumname = qq~<a href="$forumsprog?forum=$forumid">$forumname</a>~;
        $forumlastvisit = $lastvisitinfo{$forumid};

        $folderpicture = qq(&nbsp;);
    
        if (($lastposttime > $forumlastvisit) and ($inmembername ne 'Guest')) {
            $folderpicture = qq~<img src="$imagesurl/images/foldernew.gif" border="0" align=center>~;
            $posts = qq~<font face="$font" size=2 color=$fonthighlight></b>$posts</b></font><font face="$font" color=$forumfontcolor size=2>~;
            }
            else {
                $folderpicture = qq~<img src="$imagesurl/images/folder.gif" border="0">~;
                $posts = qq~<font face="$font" color=$forumfontcolor size=2>$posts~;
                }
        
        if ($inmembername eq 'Guest') { $folderpicture = qq(&nbsp;); $loginmessage = "You must be logged in to view the post markers"; }

        $forumlastvisit = $forumlastvisit + ($timedifferencevalue*3600) + ($timezone*3600);
        $lastdate = &longdate("$forumlastvisit");
        $lasttime = &shorttime("$forumlastvisit");
    
    
        if ($lastposttime) {
            $lastposttime = $lastposttime + ($timedifferencevalue*3600) + ($timezone*3600);
            $longdate = &longdate("$lastposttime");
            $shorttime = &shorttime("$lastposttime");
            $forumlastpost = qq~<font size="1" face="$font" color="$lastpostfontcolor">Date: <b>$longdate</b><font size="1" face="$font" color="$lastpostfontcolor"><br>Time: $shorttime</font>~;
            }
        else { $forumlastpost = qq~<font size="1" face="$font" color="$lastpostfontcolor">N/A</font>~; }
        
    $lastposterfilename = $lastposter;
    $lastposterfilename =~ y/ /_/;
    $lastposter =~ y/_/ /;

#------- HTML
    
    $output .= qq~
    <!-- Cgi-bot Forum $fm entry -->
    <tr>
        <td bgcolor=$forumcolortwo align=center>
            $folderpicture
        </td>
        <td bgcolor=$forumcolortwo align="left">
            <font face="$font" color="$forumfontcolor" size=3>
            <b>$forumname</b>
            </font>
            <font face="$font" color="$forumfontcolor" size=2>
            <br>$forumdescription
            </font>
            <font face="$font" color="$fonthighlight" size=1>
            <br>$modout
            </font>
        </td>
        <td bgcolor=$forumcolortwo align="center" valign=middle>
            <font face="$font" color=$forumfontcolor size=2>
            $posts
        </td>
        <td bgcolor=$forumcolortwo align="center" valign=middle>
            <font face="$font" color=$forumfontcolor size=2>
            $threads
        </td>
        <td bgcolor=$forumcolorone align=left valign=middle>
            <font color=$lastpostfontcolor face="$face" size="2">
            $forumlastpost<br>by: <a href="$profileprog?action=show&member=$lastposterfilename">$lastposter</a>
            </font>
        </td>
    </tr>
    <!-- Cgi-bot End of Forum $fm entry -->
    ~;

#------- END OF HTML
    
    $lastcategoryplace = $categoryplace;
    undef $forumlastvisit; undef $forummoderator; undef $modout;
    }


    &whosonline("$inmembername|Main board page|both");
    my $total_users = $guests + $members;
    my $membersextra = qq~&nbsp;&nbsp;<a href="$onlineprog">[ View complete list ]</a>~ if ($members > 9);

#------- HTML

    $output .= qq~
    <!-- Cgi-bot Active Users -->
    <tr>
        <td bgcolor=$titlecolor colspan=5>
            <font face="$font" color=$titlefontcolor size=2>
             <b>$total_users user(s) active in the past 15 minutes</b>
            </font>
        </td>
    </tr>
    <tr>
        <td bgcolor=$forumcolortwo>
            <img src="$imagesurl/images/online.gif" border=0 width=20 height=20 align=center>
        </td>
        <td bgcolor=$forumcolortwo colspan=4>
            <font face="$font" color=$forumfontcolor size=1>
            Guests: $guests, Total members: $members
            <br><font face="$font" color=$forumfontcolor size=1>
            $memberoutput</font>
            $membersextra
        </td>
    </tr>
    <!-- Cgi-bot End of Active Users -->
    </table>
    </td>
    </tr>
    </table>
    ~;

#------- END OF HTML

    if ($loginmessage) {

#------- HTML

        $output .= qq~
        <!-- Cgi-bot Script page footer -->
        <p>
        <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth align=center>
            <tr>
                <td>
                    <font face="$font" color=$fontcolormisc size=1>
                    <p>All times are $basetimes<p>$loginmessage
                    </font>
                </td>
            </tr>
        </table>
        <!-- Cgi-bot End of script page footer -->
        ~;
    
        }
        else {

        $output .= qq~
        <!-- Cgi-bot Script page footer -->
        <p>
        <table cellpadding=0 cellspacing=4 border=0 width=$tablewidth align=center>
            <tr>
                <td align=left colspan=2 valign=top>
                    <font face="$font" color=$fontcolormisc size=1>
                    All times are $basetimes<p>
                    </font>
                </td>
            </tr>
            <tr>
                <td width=5% align=center>
                    <img src="$imagesurl/images/foldernew.gif" border=0>
                </td>
                <td align=left>
                    <font face="$font" color=$fontcolormisc size=1>
                    New posts since your last visit
                    </font>
                </td>
            </tr>
            <tr>
                <td width=5% align=center>
                    <img src="$imagesurl/images/folder.gif" border=0>
                </td>
                <td align=left>
                    <font face="$font" color=$fontcolormisc size=1>
                    No new posts since your last visit
                    </font>
                </td>
            </tr>
        </table>
        <!-- Cgi-bot End of script page footer -->
        ~;

#------- END OF HTML

        }

print header();
&output(
-Title   => $boardname, 
-ToPrint => $output, 
-Version => $versionnumber 
);







