#!/usr/bin/perl

#############################################################
# Ikonboard v2.1
# Copyright 2000 Ikondiscussion.com - All Rights Reserved
# Ikondiscussion is a trademark of Ikondiscussion.com
#
# Software Distributed by: Ikondiscussion.com
# Visit us online at http://www.ikondiscussion.com
# Email us on boards@ikondiscussion.com
#
# All files written by Matthew Mecham
#############################################################

use CGI::Carp "fatalsToBrowser";          # Output errors to browser
use CGI qw(:standard);                    # Saves loads of work
$CGI::POST_MAX=1024 * 150;                # limit post data
$CGI::DISABLE_UPLOADS = 1;                # Disable uploads

eval {
($0 =~ m,(.*)/[^/]+,)   and unshift (@INC, "$1");
($0 =~ m,(.*)\\[^\\]+,) and unshift (@INC, "$1");
require "ikon.lib";          # Require ikonboard ()
require "data/progs.cgi";    # Require prog names
require "data/boardinfo.cgi";# Require board info
require "data/styles.cgi";   # Require styles info
};
if ($@) {
    print header(); print start_html(-title=>"Ikonboard Error!");
    print "Could not find these files: $@\nIf you are running NT you may need to enter the full path in each require statement in each script";
    print end_html; exit;
}

$|++;                                     # Unbuffer the output

#################--- Begin the program ---###################

$thisprog = "forumoptions.cgi";



$query = new CGI;

&checkVALIDITY;
	
$checked        = $query -> param('checked');
$inforum        = $query -> param('forum');
$intopic        = $query -> param('topic');
$action         = $query -> param('action');
$prunedays      = $query -> param('prunedays');
$inmembername   = $query -> param('membername');
$inpassword     = $query -> param('password');

$inforum        = &stripMETA("$inforum");
$intopic        = &stripMETA("$intopic");
$action         = &stripMETA("$action");
$prunedays      = &stripMETA("$prunedays");
$inmembername   = &stripMETA("$inmembername");
$inpassword     = &stripMETA("$inpassword");

print header();

if (($inforum  !~ m|([0-9\G]+$)|g) or (!$inforum))  { &error("General&Please do not modify the URL's generated."); }
if (($prunedays) && ($prunedays !~ /^[0-9]+$/)) { &error("General&Please do not modify the URL's generated."); }


if (! $inmembername) { $inmembername = cookie("amembernamecookie"); }
if (! $inpassword)   { $inpassword   = cookie("apasswordcookie"); }


&moderator;
        


if ($action eq "prune") {

    &getmember("$inmembername");
    &moderator;

    &error("Using mass prune&Please complete the form fully") if (!$inmembername);
    &error("Using mass prune&Please complete the form fully") if (!$inpassword);
    &error("Using mass prune&No such user") if ($userregistered eq "no");

    $cleartoedit = "no";
    
    
    &mischeader("Mass Prune");

    if (($membercode eq "ad") && ($inpassword eq $password)) { $cleartoedit = "yes"; }
    if (($inmembmod eq "yes") && ($inpassword eq $password)) { $cleartoedit = "yes"; }
    unless ($cleartoedit eq "yes") { $cleartoedit = "no"; }
    
        if ($cleartoedit eq "no" && $checked eq "yes") { &error("Using Mass Prune&You are not the forum moderator or board administrator or your password was incorrect"); }
        if (($cleartoedit eq "yes") && ($checked eq "yes")) {
        
        if (! $prunedays) {  &error("Using Mass Prune&You must specify a prune number greater than 0"); }      

        ### Grab the list from the forum folder.

        $filetoopen = "$ikondir" . "forum$inforum/list.cgi";
        $filetoopen = &stripMETA($filetoopen);
        open(FILE, "$filetoopen") or die "Cannot locate the required files";
        @topics = <FILE>;
        close(FILE);

        foreach (@topics) {
            ($topicid, $tr, $tr, $tr, $tr, $tr, $tr, $tr, $tr, $lastpostdate) = split(/\|/,$_);
            $currenttime = time;
            $threadagelimit = $currenttime - ($prunedays * 86400);
            if ($lastpostdate < $threadagelimit) {
               
                  $filetoopen  = "$ikondir" . "forum$inforum/$topicid.thd";
                  $filetoopen = &stripMETA($filetoopen);
                  open (FILE, "$filetoopen");
                  @temppostcount = <FILE>;
                  close (FILE);

                  $postcount = @temppostcount;
                  $postcount--;
      
                  $filetotrash = "$ikondir" . "forum$inforum/$topicid.thd";
                  unlink $filetotrash;
                  $filetotrash = "$ikondir" . "forum$inforum/$topicid.mal";
                  unlink $filetotrash;
                  $filetotrash = "$ikondir" . "forum$inforum/$topicid.pl";
                  unlink $filetotrash;
                  $totaltopics_deleted++;
                  $totalposts_deleted = $totalposts_deleted + $postcount;
                  }
            }
  

        ### Recreate the list:

        rebuildLIST(-Forum=>"$inforum");

        ### Update the post counts
        
        $filetoopen = "$ikondir" . "data/allforums.cgi";
        $filetoopen = &stripMETA($filetoopen);
        open(FILE, "$filetoopen") or die "Cannot Locate the required fies";
        @allforums = <FILE>;
        close(FILE);
        
        $filetomake = "$ikondir" . "data/allforums.cgi";
        $filetomake = &stripMETA($filetomake);
        open(FILE, ">$filetomake") or die "Cannot locate the required files";
        flock(FILE, 2);
        foreach $forum (@allforums) { #start foreach @forums
        chomp($forum);
            ($tempno, $trash) = split(/\|/,$forum);
                if ($inforum eq $tempno) {
                    ($forumid, $category, $categoryplace, $forumname, $forumdescription, $forummoderator ,$htmlstate ,$idmbcodestate ,$privateforum, $startnewthreads ,$lastposter ,$lastposttime, $threads, $posts, $forumgraphic) = split(/\|/,$forum);
                    $posts = $posts - $totalposts_deleted;
                    $threads = $threads - $totaltopics_deleted;
                    print FILE "$forumid|$category|$categoryplace|$forumname|$forumdescription|$forummoderator|$htmlstate|$idmbcodestate|$privateforum|$startnewthreads|$lastposter|$lastposttime|$threads|$posts|$forumgraphic\n";
                }
            else { print FILE "$forum\n"; }
        }
        close(FILE);

        
        require "$ikondir" . "data/boardstats.cgi";
        
        $filetomake = "$ikondir" . "data/boardstats.cgi";
        
        $totalthreads = $totalthreads - $totaltopics_deleted;
        $totalposts = $totalposts - $totalposts_deleted;
        
        open(FILE, ">$filetomake") or die "Cannot locate the required files";
        flock(FILE, 2);
        print FILE "\$lastregisteredmember = \"$lastregisteredmember\"\;\n";
        print FILE "\$totalmembers = \"$totalmembers\"\;\n";
        print FILE "\$totalthreads = \"$totalthreads\"\;\n";
        print FILE "\$totalposts = \"$totalposts\"\;\n";
        print FILE "\n1\;";
        close (FILE);

            if (! $totaltopics_deleted) { $totaltopics_deleted = "no"; }
            if (! $totalposts_deleted)  { $totalposts_deleted  = "no"; }
            
            $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr>    
            <td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle align=center><font face="$font" color=$fontcolormisc size=2><b>This Forum has been pruned</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
            Status:
            <ul>
            <li>$totaltopics_deleted topics deleted
            <li>$totalposts_deleted replies to topics deleted
            <li><a href="$forumsprog?forum=$inforum">Back to the forum</a>
            <li><a href="$forumsummaryprog">Back to the forums</a>
            </ul>
            </tr>
            </td>
            </table></td></tr></table>
            ~;

            } # end if clear to edit
            

            else {
            
            &mischeader("Mass Prune");
            
            $output .= qq~
            <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
            <tr><td>
            <table cellpadding=6 cellspacing=1 border=0 width=100%>
            <form action="$thisprog" method="post">
            <input type=hidden name="action" value="prune">
            <input type=hidden name="checked" value="yes">
            <input type=hidden name="forum" value="$inforum">
            <tr>
            <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center><font face="$font" color=$fontcolormisc size=2><b>Please enter your details to enable moderation mode [ Mass prune ]</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle colspan=2><font face="$font" color=$fontcolormisc size=2><b>Only continue if you wish to prune this forum. You cannot reverse this action!</b>
            <br>Pruning will permanetly delete all the topics that haven't been posted in for more days than the amount you specify. Please double check all information, and only continue if you are happy to do so.</font></td>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your username</font></td>
            <td bgcolor=$miscbackone valign=middle><input type=text name="membername" value="$inmembername" size=20></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your password</font></td>
            <td bgcolor=$miscbackone valign=middle><input type=password name="password" value="$inpassword" size=20></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Enter the amount of days to prune<br>For example, entering '30' will remove all threads that have not been posted in for over 30 days.</font></td>
            <td bgcolor=$miscbackone valign=middle><input type=text name="prunedays" size=20></td></tr>
            <tr>
            <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center><input type=submit name="submit" value="Log in"></td></tr></form></table></td></tr></table>
            </table></td></tr></table>
            ~;
            
             }

} # end massprune

else { &error("General Error&No action specified"); }



&output(
    -Title   => "$boardname-Mass prune", 
    -ToPrint => $output, 
    -Version => $versionnumber 
    );


