#!/usr/bin/perl

#############################################################
# Ikonboard v2.1
# Copyright 2000 Ikondiscussion.com - All Rights Reserved
# Ikondiscussion is a trademark of Ikondiscussion.com
#
# Software Distributed by: Ikondiscussion.com
# Visit us online at http://www.ikondiscussion.com
# Email us on boards@ikondiscussion.com
#
# All files written by Matthew Mecham
#############################################################

use CGI::Carp "fatalsToBrowser";          # Output errors to browser
use CGI qw(:standard);                    # Saves loads of work
$CGI::POST_MAX=1024 * 150;                # limit post data
$CGI::DISABLE_UPLOADS = 1;                # Disable uploads
$CGI::HEADERS_ONCE = 1;                   # Kill redundant headers

eval {
($0 =~ m,(.*)/[^/]+,)   and unshift (@INC, "$1");
($0 =~ m,(.*)\\[^\\]+,) and unshift (@INC, "$1");
require "ikon.lib";          # Require ikonboard ()
require "data/progs.cgi";    # Require prog names
require "data/boardinfo.cgi";# Require board info
require "data/styles.cgi";   # Require styles info
};
if ($@) {
    print header(); print start_html(-title=>"Ikonboard Error!");
    print "Could not find these files: $@\nIf you are running NT you may need to enter the full path in each require statement in each script";
    print end_html; exit;
}

$|++;                                     # Unbuffer the output

#################--- Begin the program ---###################

$thisprog = "announcements.cgi";


$query = new CGI;

$cookiepath = $query->url(-absolute=>1);
$cookiepath =~ s/$thisprog//sg;

for ('membername','password','announcementtitle','announcementpost','action','checked','number') {
    next unless defined $_;
    next if $_ eq 'SEND_MAIL';
    $tp = $query->param($_);
    $tp = &cleaninput($tp);
    ${$_} = $tp;
    }

$inmembername           = $membername;
$inpassword             = $password;
$inannouncementtitle    = $announcementtitle;
$inannouncementpost     = $announcementpost;


if (! $inmembername) { $inmembername = cookie("amembernamecookie"); }
if (! $inpassword) { $inpassword = cookie("apasswordcookie"); }

if ($inmembername eq "") {
    $inmembername = "Guest";
    }
    else {
        &getmemberstime("$inmembername");
        }



	### Print Header for the page.

            print header();

	        &title;

	        $output .= qq~
	        <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth align=center>
	                <tr>
	                   <td width=30% rowspan=2>
	                    <img src="$imagesurl/images/$boardlogo" border=0>
	                   </td>
	                   <td valign=top align=left>
	                    <font face="$font" color=$fontcolormisc size=2>
	                    &nbsp;&nbsp;<img src="$imagesurl/images/closedfold.gif" border=0><a href="$forumsummaryprog">&nbsp;&nbsp;$boardname</a>
	                    <br>
                        &nbsp;&nbsp;<img src="$imagesurl/images/bar.gif" border=0><img src="$imagesurl/images/openfold.gif" border=0>&nbsp;&nbsp;Announcements
	                </tr>
                  </table>
	           <p>
	        <table cellpadding=0 cellspacing=0 border=0 width=$tablewidth bgcolor=$tablebordercolor align=center>
	                <tr>
	                    <td>
	                    <table cellpadding=3 cellspacing=1 border=0 width=100%>
	                ~;
	        
	### Startactions


	if ($action eq "delete") {

	        
	        if ($checked eq "yes") {
	        
	                # Validate user
	        
	                &getmember("$inmembername");
	        
	                if ($membercode ne "ad") { print header(); &error("Announcements&You are not an administrator."); }
	                elsif ($inpassword ne $password) { print header(); &error("Announcements&Your password was wrong."); }
	        
	                # Get the announcement to delete
	        
	                $filetoopen = "$ikondir" . "data/news.cgi";
                    $filetoopen = &stripMETA($filetoopen);
	                open(FILE, "$filetoopen") or die "Cannot locate the required file";
	                @announcements = <FILE>;
	                close(FILE);
	        
	                # Write it back minus the one to delete.
	        
	                $count = 0;
	        
	                $filetoopen = "$ikondir" . "data/news.cgi";
                    $filetoopen = &stripMETA($filetoopen);
	                open(FILE, ">$filetoopen") or die "Cannot locate the required file";
	                flock (FILE, 2);
	                foreach $line (@announcements) {
	                chomp $line;
	                        if ($count ne $number) {
	                                print FILE "$line\n";
	                                }
	                        $count++;
	                        }
	                close(FILE);

                    &doend("Announcement has been deleted");
                                   
	                exit;


	                } # end checked delete
	        
	                else {
	        
	                        &login("$thisprog?action=delete&number=$number&checked=yes");
	        
	                        } # end else
	                
	                  } # end action





	        elsif ($action eq "add") {

                            
	        
	                        # Present the form

	                        $output .= qq~
	                        <form action="$thisprog" method=post>
                            <input type=hidden name="action" value="addannouncement">
	                        <tr>
	                        <td bgcolor=$miscbacktwo colspan=2 align=center><font face="$font" color=$fontcolormisc size=3><b>Add announcement</b></td>
	                        </tr>
	                        <tr>
	                        <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your username</font></td>
	                        <td bgcolor=$miscbackone valign=middle><input type=text name="membername" value="$inmembername" size=20></a></td></tr>
	                        <tr>
	                        <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your password</font></td>
	                        <td bgcolor=$miscbackone valign=middle><input type=password name="password" value="$inpassword" size=20></td></tr>
	                        <tr>
	                        <td bgcolor=$miscbackone valign=top width=30%><font face="$font" color=$fontcolormisc size=1><b>Announcement Title</b></font></td>
	                        <td bgcolor=$miscbackone valign=middle><input type=text name="announcementtitle" size=60 maxlength=100></td>
	                        </tr>
	                        <tr>
	                        <td bgcolor=$miscbackone valign=top width=30%><font face="$font" color=$fontcolormisc size=1><b>Announcement</b><br>Please enter your announcement.<p>If emoticons are enabled on the board, then they will automatially be allowed in the announcement.<p>Ikoncode will be automatically converted.</font></td>
	                        <td bgcolor=$miscbackone valign=middle><textarea cols=60 rows=10 name="announcementpost"></textarea></td>
	                        </tr>
	                        <tr>
	                        <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center>
	                        <input type=Submit value=Submit name=Submit onClick="return clckcntr();"> &nbsp; <input type="reset" name="Clear"></form>
	                        </td></tr>
	                        ~;      
	        
	                        
	        } # end action






	        
	        elsif ($action eq "addannouncement") {
	                
	                $currenttime = time;
	                
	                # Validate user
	                
	                &getmember("$inmembername");
	        
	                if ($membercode ne "ad") { print header(); &error("Announcements&You are not an administrator."); }
	                elsif ($inpassword ne $password) { print header(); &error("Announcements&Your password was wrong."); }
	                
	                # Check for blanks.
	                
	                if ($inannouncementpost eq "") { print header(); &error("Announcements&You must enter an announcement."); }
	                if ($inannouncementtitle eq "") { print header(); &error("Announcements&You must enter an announcement title"); }
	                
	                # Get the announcement file
	        
	                $filetoopen = "$ikondir" . "data/news.cgi";
                    $filetoopen = &stripMETA($filetoopen);
	                open(FILE, "$filetoopen");
	                @announcements = <FILE>;
	                close(FILE);
	        
	                # Write it back with the new announcement at the top
	        
	                $newline = "$inannouncementtitle|$currenttime|$inannouncementpost";
	                chomp $newline;
	        
	                $filetoopen = "$ikondir" . "data/news.cgi";
                    $filetoopen = &stripMETA($filetoopen);
	                open(FILE, ">$filetoopen");
	                flock(FILE, 2);
	                print FILE "$newline\n";
	                foreach $line (@announcements) {
	                        chomp $line;
	                        print FILE "$line\n";
	                        }
	                close(FILE);
	                
	                &doend("Announcement has been added");
	                
	                } # end add announcement
	        
	        
	        
	        
	        
	        
	        
	        
	        
	        elsif ($action eq "edit") {

                    
	        
	                # Get the announcement file
	        
	                $filetoopen = "$ikondir" . "data/news.cgi";
                    $filetoopen = &stripMETA($filetoopen);
	                open(FILE, "$filetoopen") or die "Cannot locate the required file";
	                @announcements = <FILE>;
	                close(FILE);
	        
	                # Get the announcement to edit
	        
	                $count = 0;
	                
	                foreach (@announcements) {
	                        if ($count eq $number) {
	                                ($announcementtitle, $notneeded, $announcementpost) = split(/\|/,$_);
	                                }
	                        $count++;
	                        }
	                
	                # Clean the text area
	                
	                $announcementpost =~ s/\<p\>/\n\n/g;
	                $announcementpost =~ s/\<br\>/\n/g;
	                
	                        # Present the form

	                        $output .= qq~
	                        <form action="$thisprog" method=post>
                            <input type=hidden name="action" value="doedit">
                            <input type=hidden name="number" value="$number">
	                        <tr>
	                        <td bgcolor=$miscbacktwo colspan=2 align=center><font face="$font" color=$fontcolormisc size=3><b>Edit announcement</b></td>
	                        </tr>
	                        <tr>
	                        <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your username</font></td>
	                        <td bgcolor=$miscbackone valign=middle><input type=text name="membername" value="$inmembername" size=20></a></td></tr>
	                        <tr>
	                        <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your password</font></td>
	                        <td bgcolor=$miscbackone valign=middle><input type=password name="password" value="$inpassword" size=20></td></tr>
	                        <tr>
	                        <td bgcolor=$miscbackone valign=top width=30%><font face="$font" color=$fontcolormisc size=1><b>Announcement Title</b></font></td>
	                        <td bgcolor=$miscbackone valign=middle><input type=text name="announcementtitle" value="$announcementtitle"size=60 maxlength=100></td>
	                        </tr>
	                        <tr>
	                        <td bgcolor=$miscbackone valign=top width=30%><font face="$font" color=$fontcolormisc size=1><b>Announcement</b><br>Please enter your announcement.<p>If emoticons are enabled on the board, then they will automatially be allowed in the announcement.<p>Ikoncode will be automatically converted.</font></td>
	                        <td bgcolor=$miscbackone valign=middle><textarea cols=60 rows=10 name="announcementpost">$announcementpost</textarea></td>
	                        </tr>
	                        <tr>
	                        <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center>
	                        <input type=Submit value=Submit name=Submit onClick="return clckcntr();"> &nbsp; <input type="reset" name="Clear"></form>
	                        </td></tr>
	                        ~;      
	        
	                        
	        } # end action
	        








	        elsif ($action eq "doedit") {

	                $currenttime = time;
	                
	                # Make sure it's got all new lines converted
	                
	                # Validate user
	                
	                &getmember("$inmembername");
	        
	                if ($membercode ne "ad") { print header(); &error("Announcements&You are not an administrator."); }
	                elsif ($inpassword ne $password) { print header(); &error("Announcements&Your password was wrong."); }
	                
	                # Check for blanks.
	                
	                if ($inannouncementpost eq "") { print header(); &error("Announcements&You must enter an announcement."); }
	                if ($inannouncementtitle eq "") { print header(); &error("Announcements&You must enter an announcement title"); }
	                
	                # Get the announcement file
	        
	                $filetoopen = "$ikondir" . "data/news.cgi";
                    $filetoopen = &stripMETA($filetoopen);
	                open(FILE, "$filetoopen") or die "Cannot locate the file to open";
	                @announcements = <FILE>;
	                close(FILE);
	        
	                # Write it back with the new announcement at the top
	        
	                $count = 0;
	                
	                $newline = "$inannouncementtitle|$currenttime|$inannouncementpost";
	                chomp $newline;
	        
	                $filetoopen = "$ikondir" . "data/news.cgi";
                    $filetoopen = &stripMETA($filetoopen);
	                open(FILE, ">$filetoopen") or die "Cannot locate the file to open";
	                flock(FILE, 2);
	                foreach $line (@announcements) {
	                        chomp $line;
	                        if ($count eq $number) {
	                                print FILE "$newline\n";
	                                }
	                                else {
	                                        print FILE "$line\n";
	                                        }
	                        $count++;
	                        }
	                close(FILE);
	                
	                &doend("Announcement has been edited");
	                
	                exit;
	        
	                } # end edit announcement
	        
	        
	        
	        
	        
	        
	        

	        
	        else { # start last else
	        
	        
	                ### start displaying the announcements.
                    
                    
	                $filetoopen = "$ikondir" . "data/news.cgi";
                    $filetoopen = &stripMETA($filetoopen);
	                open(FILE, "$filetoopen");
	                @announcements = <FILE>;
	                close(FILE);
	        
	                $postcountcheck = 0;
	                
	                $totals = @announcements;
	                
	                if ($totals eq "0") { 
	                        $dateposted = time;             
	                        @announcements[0] = qq~There are no current announcements|$dateposted|Click on the <a href="$thisprog?action=add"><img src="$imagesurl/images/a_add.gif" border=0"></a> icon to make an announcement (Administrator only)<br>This announcement will self delete as soon as another announcement is made~;
	                        }               
	                                        
	                
	                        foreach $line (@announcements) {
	                        

	                                ($title, $dateposted, $post) = split(/\|/, $line);
	        
	                                $dateposted = $dateposted + ($timedifferencevalue*3600) + ($timezone*3600);
	                                $dateposted = &dateformat("$dateposted");
	        
	                                $post = &ikoncode("$post");
	                                $post = &doemoticons("$post");
	                                
                                    $post =~ s/\:\)/<img src=\"$imagesurl\/emoticons\/smile.gif\" border=\"0\">/g;
                                    $post =~ s/\;\)/<img src=\"$imagesurl\/emoticons\/wink.gif\" border=\"0\">/g;
                                    $post =~ s/\:\(/<img src=\"$imagesurl\/emoticons\/sad.gif\" border=\"0\">/g;
                                    $post =~ s/\:\o/<img src=\"$imagesurl\/emoticons\/shocked.gif\" border=\"0\">/g;
	                                
	                                
	                                # Allow HTML
	                                
	                                $post =~ s/&lt\;/\</g;
	                                $post =~ s/&gt\;/\>/g;
	                                $post =~ s/&quot\;/\"/g;
	        
	                        if ($count eq "1") {
	                           $postbackcolor = "$postcolorone";
	                           $postfontcolor = "$postfontcolorone";
	                           $count++;
	                           }
	                            else {
	                                 $postbackcolor = "$postcolortwo";
	                                 $postfontcolor = "$postfontcolortwo";
	                                 $count = 1;
	                                 }
	                
	        
	                        $post = qq~<p><blockquote>$post</blockquote><p>~;
	        
	                        $adminadd = qq~<a href="$thisprog?action=add"><img src="$imagesurl/images/a_add.gif" border=0"></a>~;
	                        $admindelete = qq~<a href="$thisprog?action=delete&number=$postcountcheck"><img src="$imagesurl/images/a_delete.gif" border=0"></a>~;
	                        $adminedit = qq~<a href="$thisprog?action=edit&number=$postcountcheck"><img src="$imagesurl/images/a_edit.gif" border=0"></a>~;
	        
	                        $output .= qq~
	                        <tr>
	                        <td bgcolor=$titlecolor align=center valign=top><font face="$font" color=$titlefontcolor size=3><b>&raquo; $title &laquo;</b></td></tr>
	                        <tr>
	                            <td bgcolor=$postbackcolor align=left>$admindelete &nbsp; $adminedit &nbsp; $adminadd</td>
	                        </tr>
	                        <tr>
	                            <td bgcolor="$postbackcolor" valign=top><font face="$font" color=$postfontcolor size=2>
	                        $post
	                        </td>
	                        </tr>
	                        <tr>
	                            <td bgcolor="$postbackcolor" valign=middle>
	                        <font face="$font" color=$postfontcolor size=2>Posted on:<b>$dateposted</b>
	                        </td>
	                        </font>
	                        </tr>
	                        
	                        ~;

	                        $postcountcheck++;
	        
	                        } # end foreach

	                    } # end last else



	                        $output .= qq~</table></td></tr></table>~;
                            
	                        &output(
                            -Title   => "$boardname - Announcements", 
                            -ToPrint => $output, 
                            -Version => $versionnumber 
                            );




	##############################################################
	### Sub route (login)

	        
	sub login {

	local($url) = @_;
	
    ($postto, $therest) = split(/\?/,$url);
    
    @pairs = split(/\&/,$therest);
    
    foreach (@pairs) {
        ($name, $value)=split(/\=/,$_);
        $hiddenvars .= qq~<input type=hidden name="$name" value="$value">\n~;
        }
           
	    
   
	    $output .= qq~
	    <form action="$postto" method="post">$hiddenvars
	        <tr>
	            <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center><font face="$font" color=$fontcolormisc size=2><b>Please enter your administrative details to log in</b><br>Please note that only administrators may add/delete or edit announcememnts.</font></td></tr>
	        <tr>
	            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your username</font></td>
	            <td bgcolor=$miscbackone valign=middle><input type=text name="membername" value="$inmembername" size=20></td></tr>
	        <tr>
	            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>Please enter your password</font></td>
	            <td bgcolor=$miscbackone valign=middle><input type=password name="password" value="$inpassword" size=20></td></tr>
	        <tr>
	            <td bgcolor=$miscbacktwo valign=middle colspan=2 align=center><input type=submit name="submit" value="Log in"></form></td></tr></table></td></tr></table>
	        ~;
	        
	 } # end routine        
	        
	sub doend {

    my $action_taken = shift;

    $relocurl = "$boardurl/$thisprog";    

    $output .= qq~
            <tr>
            <td bgcolor=$miscbacktwo valign=middle align=center><font face="$font" color=$fontcolormisc size=2><b>Announcements</b></font></td></tr>
            <tr>
            <td bgcolor=$miscbackone valign=middle><font face="$font" color=$fontcolormisc size=1>
            If your browser does not redirect you, please choose from the links below.
            <ul>
            <li><b>$action_taken</b>
            <li><a href="$relocurl">Back to Announcements</a>
            <li><a href="$forumsummaryprog">Back to the forums index</a>
            </ul>
            </tr>
            </td>
            </table></td></tr></table>
            <meta http-equiv="refresh" content="5; url=$relocurl">
            ~;
            &output(
            -Title   => "$boardname - Announcements", 
            -ToPrint => $output, 
            -Version => $versionnumber 
             );

}
