#!/usr/local/bin/perl
########################################################
##                                     
##             	HAMlibrary
##              by Tony Lee Huffman
##	             and HAMnet Consulting
##       (e-mail hamlibrary@hamnetcenter.com) 
## 
##             library version:  1.6   
##         last modified:  12-8-98
##           copyright (c) 1998        
##                                   			  
##  
########################################################

# COPYRIGHT NOTICE:
#
# Copyright 1998 HAMnet Consulting.  All Rights Reserved.
#
# This program may be used and modified free of charge by anyone, so
# long as this copyright notice and the header above remain intact.  By
# using this program you agree to indemnify HAMnet Consulting and any company
# programmers from any liability.  It would also be nice for you to let
# me know how and where you are using this script.
#
# Selling the code for this program without prior written consent is
# expressly forbidden.  Obtain permission before redistributing this
# program over the Internet or in any other medium.  In all cases
# copyright and header must remain intact.
#

#changes
#12-2-98 Corrected bug in renaming for non unix systems
#10-19-98 Added the ability to accept commandline args if $allow_command_line = 1
#9-26-98 Added the send_smtp_mail routine
#9-16-98 Added counter routine

$version_hamlib = "1.5";


##################################################################################
##		perform_rename
##################################################################################

sub perform_rename {

local ($temp_file, $database_file) = @_;

if ($OS eq "UNIX") {
    rename ( $temp_file,$database_file);
   chmod 0777, $database_file;
#   print "did a rename<br>";
  } # end if ($OS eq "UNIX")
else {

   #unlink ($database_file) || &cgidie(" I could not delete the database file  $database_file in rename sub for NT");
    #open (TEMPFILE, "$temp_file") || &CgiDie ("I am sorry, but I was unable
   #     to open the temp file in the Modify Item routine.  The value I
   #     have is $temp_file.  Would you check the path and permissions.");

   # open (DATABASE, ">$database_file") || &CgiDie ("I am sorry, but I was
	#unable to open the data file in the Modify Item routine.  The
	#value I have is $database_file.  Would you check the path and
	#permissions.");

   #  foreach (<TEMPFILE>) {
   #      print DATABASE $_;
   #   }  # end foreach
    
   # close (DATABASE);
   # close (TEMPFILE);

   # unlink ($temp_file) || &cgidie(" I could not delete the tempfile $temp_file in rename sub for NT");
   
   copy($temp_file, $database_file);
    } # end else
}

##################################################################################
##		parse_input
##################################################################################

sub parse_input {

    if ($ENV{'REQUEST_METHOD'} eq 'GET') {       
	 # Split the name-value pairs
   	@pairs = split(/&/, $ENV{'QUERY_STRING'});  
       }#end if

    elsif ($ENV{'REQUEST_METHOD'} eq 'POST') {    
	    # Get the input
	    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'}); 
	   # Split the name-value pairs       
 	   @pairs = split(/&/, $buffer);  
      } #end elseif
    elsif ($allow_command_line == 1) {
      @pairs = @ARGV;
      }

   foreach $pair (@pairs) {   
	($name, $value) = split(/=/, $pair);
	# Un-Webify plus signs and %-encoding  
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$value =~ s/<!--(.|\n)*-->//g;  
	if ($allow_br == 1) {
	    $value =~ s/<br>/%%br%%/gi;}
	if ($allow_html != 1 && $name ne "Coding") {
 	    $value =~ s/<([^>]|\n)*>//g;   } 
 	if ($allow_br == 1) {
 	    $value =~ s/%%br%%/<br>/gi;}

	# take out the "|" since this is used as a delimter 	    
 	$value =~ s/\|//g;
	$FORM{$name} = $value;
     }#end foreach
  
  	 
  } #end sub parse_input

##################################################################################
##		cgidie
##################################################################################

sub cgidie {
	@error_here = @_;
	
   
   if ($log_mode > 0) {
         my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =localtime(time);
         $year += 1900;
         $mon++;
      my ($current_time) ="$mon-$mday-$year  $hour:";
      if ($min > 9) {
         $current_time .= "$min:";
      }
      else {
         $current_time .= "0$min:";
      }
      if ($sec > 9) {
         $current_time .= "$sec";
      }
      else {
         $current_time .= "0$sec";
      }
      my ($log_line) = "$current_time : $error_here[0]\n";
      open (LOGFILE, ">>$log_file_path") || die;
      print LOGFILE "$log_line";
      close (LOGFILE);
      }
	
	print "Content-type: text/html\n\n";
	#print "<html><Title> Error</title>\n";
	#print "<body>\n";
	print "<br>Error: @error_here<br>\n";
	#print "</body></html>";

	exit;
	 }


#######################################################################
#                            GetFileLock                              #
#######################################################################

sub GetFileLock {  
    local ($lock_file) = @_;

    local ($endtime);  
    $endtime = 15;
    $endtime = time + $endtime;
#   We set endtime to wait 60 seconds

    while (-e $lock_file && time < $endtime) {
        # Do Nothing
    }
    open(LOCK_FILE, ">$lock_file");    
#    flock(LOCK_FILE, 2); # 2 exclusively locks the file
} # end of get_file_lock

#######################################################################
#                            ReleaseFileLock                          #
#######################################################################

sub ReleaseFileLock {
    local ($lock_file) = @_;
       
# 8 unlocks the file
#    flock(LOCK_FILE, 8);
    close(LOCK_FILE);
    unlink($lock_file);

} # end of ReleaseFileLock   

###########################################################################
#                                 counter                                 #
#     This routine borrowed from the Selena Sol cgi-lib.sol library file
###########################################################################

  sub counter
    {

# Assign to the local variable $counter_file, the filename that we passed 
# to this subroutine from the main script.

    local($counter_file) = @_;

# Open up the counter file.  If the counter file cannot be opened, 
# however, access the &open_error routine passing it the filename

    open (COUNTER_FILE, "$counter_file") || &open_error($counter_file);

# Check to see what number the counter is currently on and assign that 
# value to $_

    while (<COUNTER_FILE>)
      {
      $item_number = "$_";
      }
    close (COUNTER_FILE);

# Add one to that number, change the counter file to the new number, 
# return the number to the mian script, and close the counterfile.

    $item_number += 1;
    open (NOTE, ">$counter_file") || &open_error($counter_file);
    print NOTE "$item_number\n";
    close (NOTE);
    return $item_number;
    }


#######################################################################
#                            EncryptWrap                              #
#######################################################################

 
sub EncryptWrap {
    local ($field, $salt) = @_;
 
    $field = crypt ($field, $salt);
 
    $field;
 
} # end of encrypt


#######################################################################
#                            send_smtp_mail                          #
#######################################################################
#
# input
#     (mail_mode, smtp_server, email_from, recipient, replyto, subject, message)
# mail mode = 0  : use send mail or other mail prog (UNIX)
# mail mode = 1 use smtp server (NT)

sub send_smtp_mail {
   local( $ssm_mode, $ssm_smtp_server, $ssm_emailfrom, $ssm_recipient, $ssm_replyto, $ssm_subject, $ssm_message) = @_;
#print "I am in the mail routine<br>\n";
#print " $ssm_mode,  $ssm_smtp_server,  $ssm_emailfrom, $ssm_recipient, $ssm_replyto, $ssm_subject, $ssm_message<br>\n";


if ($ssm_recipient =~ /\&|\/|</ || $ssm_emailfrom =~/\&|\/</ || $ssm_replyto =~ /\&|\/|</) { 
   print "Email Failure : email address : $ssm_recipient, $ssm_emailfrom, or $ssm_replyto contain illegal characters";
}
else {

if ($ssm_mode == 0) {
       open (MAIL, "|$mailprog  -t") || &log_it($log_mode, $log_file_path,"Can't open mailprog: $mailprog in sub send_email!\n");

	print MAIL "To: $ssm_recipient\n";
	print MAIL "Reply-to: $ssm_replyto\n";
	print MAIL "From: $ssm_emailfrom\n";
	print MAIL "Subject: $ssm_subject\n\n";
	print MAIL "$ssm_message\n";
	
	close (MAIL)
} # end if
else {  
   
($x,$x,$x,$x, $here) = gethostbyname($null);
($x,$x,$x,$x, $there) = gethostbyname($ssm_smtp_server);
$thisserver = pack('S n a4 x8',2,0,$here);
$remoteserver = pack('S n a4 x8',2,25,$there);
#NOTE, if Solaris, uncomment the line below and delete the one below it...leave alone for NT
#(!(socket(S,2,2,6))) && (&log_it($log_mode, $log_file_path,"Connect error!"));
(!(socket(S,2,1,6))) && (&log_it($log_mode, $log_file_path,"Connect error! socket"));
(!(bind(S,$thisserver))) && (&log_it($log_mode, $log_file_path,"Connect error! bind"));
(!(connect(S,$remoteserver))) && (&log_it($log_mode, $log_file_path,"!! connection to $smtp_server has failed!"));

select(S);
$| = 1;
select(STDOUT);

$DATA_IN = <S>;	
($DATA_IN !~ /^220/) && (&log_it($log_mode, $log_file_path,"data in Connect error - 220")); 

print S "HELO $ENV{REMOTE_HOST}\r\n";
$DATA_IN = <S>;
($DATA_IN !~ /^250/) && (&log_it($log_mode, $log_file_path,"data in Connect error - 250")); 

print S "MAIL FROM:<$ssm_emailfrom>\n";
$DATA_IN = <S>;
($DATA_IN !~ /^250/) && (&log_it($log_mode, $log_file_path,"'From' address not valid ($ssm_emailfrom)")); 

print S "RCPT TO:<$ssm_recipient>\n";
$DATA_IN = <S>;
($DATA_IN !~ /^250/) && (&log_it($log_mode, $log_file_path,"'Recipient' address not valid ($ssm_recipient)")); 

print S "DATA\n";
$DATA_IN = <S>;
($DATA_IN !~ /^354/) && (&log_it($log_mode, $log_file_path,"Message send failed - 354")); 

print S <<MESSAGES;
From: $ssm_emailfrom
To: $ssm_recipient
Subject: $ssm_subject

$ssm_message
.
MESSAGES
$DATA_IN = <S>;
($DATA_IN !~ /^250/) && (&log_it($log_mode, $log_file_path,"Message send failed - try again - 250")); 

print S "QUIT\n";
#print "Content-type: text/html\n\n"; 
#print "<br>Email sucessfully sent\n";
}

}  #end else
#print "I am leaving the email routine<br>\n";
} # end sub


sub log_it {
   my ($log_mode, $log_file_path, $log_info) = @_;
  
   if ($log_mode > 0) {
         my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =localtime(time);
         $year += 1900;
         $mon++;
      my ($current_time) ="$mon-$mday-$year  $hour:";
      if ($min > 9) {
         $current_time .= "$min:";
      }
      else {
         $current_time .= "0$min:";
      }
      if ($sec > 9) {
         $current_time .= "$sec";
      }
      else {
         $current_time .= "0$sec";
      }
      my ($log_line) = "$current_time : $log_info\n";
      open (LOGFILE, ">>$log_file_path") || &cgidie ("I cannot open the log file $log_file_path in sub log_it in hamlib.pl");
      print LOGFILE "$log_line";
      close (LOGFILE);
   }
   
   
}

   


	 

1;
