########################################################
##                                      			 
##             	HAMcard               				 
##              by Tony Lee Huffman					 
##	             and HAMnet Consulting                
##       (e-mail hamcard@hamnetcenter.com)            
##                                      			 
##             version:  1.2   			  
##         last modified:  December 8, 1998
##           copyright (c) 1998         			  
##                                   			      
##    latest version is available from   			
##        http://www.hamnetcenter.com/  
##                                       			 
########################################################

# COPYRIGHT NOTICE:
#
# Copyright 1998 HAMnet Consulting.  All Rights Reserved.
#
# This program may be used and modified free of charge by anyone, so
# long as this copyright notice and the header above remain intact.  By
# using this program you agree to indemnify HAMnet Consulting and any company
# programmers from any liability.  It would also be nice for you to let
# me know how and where you are using this script.
#
# Selling the code for this program without prior written consent is
# expressly forbidden.  Obtain permission before redistributing this
# program over the Internet or in any other medium.  In all cases
# copyright and header must remain intact.
#


##################################################################################
##		Main Routine
##################################################################################
sub main_routine {

srand($$|time);



&process_input;

if ($delete_old_cards_mode == 1 && $FORM{'Do'} ne "") {
	$! = 1;
  print "Content-type: text/html\n\n";
 } # end if

if ($mail_method eq "") { $mail_method = 0}

if ($FORM{'Do'} eq "preview") {

	&check_input(1);
	&print_preview;
  } # end if
elsif ($FORM{'Do'} eq "send") {
         &check_input(1);
	&send_hamcard;
  } # end else if
elsif ($FORM{'Do'} eq "pickup" && $FORM{'CardID'} ne "") {
	&find_card;
	&print_hamcard;
	
	if ($CARDFIELDS{'PickupNotification'} ne "" && $FORM{'Review'} eq "") {
	   &send_notification;
	}
	
 }
elsif ($FORM{'Do'} eq "passvar") {

   &check_input(2);
   &pass_variables;
 } # end elsif ($FORM{'Do'} eq "passvar")
else {
   &delete_old_cards
 }
exit;
} # end sub main_routine


##################################################################################
##		sub process_input
##################################################################################
sub process_input {

$allow_br = 1;
&parse_input;


  foreach $formkey (keys %FORM) {
   $FORM{$formkey} =~ s/\n/<br>/g;
   $FORM{$formkey} =~ s/\r/ /g;
   $FORM{$formkey} =~ s/\|/ /g;
   $FORM{$formkey} =~ s/\"/\&quot;/g;
  } # end foreach
  
if ($ssm_recipient =~ /\&|\/|</ || $ssm_emailfrom =~/\&|\/</ || $ssm_replyto =~ /\&|\/|</) { 
   print "Email Failure : email address : $ssm_recipient, $ssm_emailfrom, or $ssm_replyto contain illegal characters";
}

   #if (defined $FORM{'REmail'}) { $FORM{'REmail'} =~ s/\&|\/|<//g;}
   #if (defined $FORM{'SEmail'}) { $FORM{'SEmail'} =~ s/\&|\/|<//g;}
      


  	if ($FORM{'Greeting'} eq "custom") {
  		$FORM{'Greeting'} = $FORM{'cGreeting'};
  	 } # end if
  	 
  	if ($FORM{'Closing'} eq "custom") {
  		$FORM{'Closing'} = $FORM{'cClosing'};
  	 } # end if
 }  # end sub process_input

##################################################################################
##		sub check_input
##################################################################################

sub check_input {
   # Get mode to run in 
   # 0 = check @required only;
   # 1 = check @ required and form field 'Require'
   # 2 = check form field 'Require' only
   local ($required_mode) = $_[0];

   local (@force_require);

   if ($required_mode < 2) {
	$bad = 0;
	foreach $req_field (@required)	
	{
		if($FORM{$req_field} eq "")
		{
			$bad++;
		}
             elsif (($req_field eq "REmail" || $req_field eq "SEmail") && !($FORM{$req_field} =~ /.*\@.*\..*/)) {
               $bad++;
            }

	}
   } # end if ($required_mode < 2)

   if ($required_mode >0) {

      if ($FORM{'Require'} ne "") {
         @force_require = split (/\,/, $FORM{'Require'});
   
         foreach $req_field (@force_require) {

            if ($FORM{$req_field} eq "") { $bad++;}
          }  #end foreach
       }  #end of ($FORM{'Required'}
      
   } # end ($required_mode >0
	if ($bad != 0) {

		open (BADINPUT, "$html_template_path/$required_template") || &cgidie ("I am sorry, but I was not able to open the data file $html_template_path/$required_template.");
			@bad_input = <BADINPUT>;
		close (BADINPUT);
		
		print @bad_input;
		exit;
	 } # end if ($bad !=0)

 } # end sub

##################################################################################
##		sub print_preview
##################################################################################

sub print_preview {
local ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =localtime(time);
local (@months) = ('January', 'Feburary', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');

     $year = $year + 1900;
      $mon++;

   open (PREVIEW, "$html_template_path/$preview_template") || &cgidie ("I am sorry, but I was not able to open the data file $html_template_path/$preview_template.");
	@preview_html = <PREVIEW>;
   close (PREVIEW);

	foreach $preview_line (@preview_html) {
		$preview_line =~ s/%%do%%/"Send"/g;
		$preview_line =~ s/%%scriptloc%%/$script_loc/g;
              $preview_line =~ s/%%CurrentMonth%%/$mon/g;
               $preview_line =~ s/%%CurrentMonthName%%/$months[$mon -1]/g;
               $preview_line =~ s/%%CurrentDay%%/$mday/g;
               $preview_line =~ s/%%CurrentYear%%/$year/g;
	
		foreach $formkey (keys %FORM) {
			$preview_line =~ s/%%$formkey%%/$FORM{$formkey}/g;

		 } # end foreach
	
		print $preview_line;
	   } # end foreach
   
  } # end sub print_preview

##################################################################################
##		sub send_later_card
##################################################################################

sub send_later_card {

   local ($current_id, @carditems) = @_;
   local (%SENDFIELDS);
   local ($i, $num_carditems, $cardline);
    # Lets see if it was a send later card ..if so send it....
      $num_carditems = @carditems;
      undef %CARDFIELDS;
	for ($i = 0; $i < $num_card_items; $i = $i +2) {
	   $SENDFIELDS{$carditems[$i]} = $card_items[$i+1];
	 }
#print "<br><b>Send Later..Sendt card</b><br>\n";

   #Send e-mail to recipient
   $recipient = "$SENDFIELDS{'REmail'}";
   $replyto = "$SENDFIELDS{'SEmail'}";
   $from_email = "$SENDFIELDS{'SEmail'}";
   $subject = "$SENDFIELDS{'Greeting'}";
   $message = "";
   
       open (PAGE, "$email_template_path/$mail_template") || &cgidie ("I am sorry, but I was unable to open the file $email_template_path/$mail_template.in sub send_email");
	@page_template = <PAGE>;
      close (PAGE);

	foreach $page_line (@page_template) {
		$page_line =~ s/%%scriptloc%%/$script_loc/g;
		$page_line =~s/%%sessionid%%/$current_id/g;	
		
		foreach $formkey (keys %SENDFIELDS) {
			$page_line =~ s/%%$formkey%%/$SENDFIELDS{$formkey}/g;
		 } # end foreach
            $message .= "$page_line";
	   } # end foreach

      if ($from_email eq "") {
        $from_email = $admin_email;
        $replyto = $admin_email;
      }
      
      &send_smtp_mail ($mail_mode, $smtp_server, $from_email, $recipient, $replyto, $subject, $message);
      
      $SENDFIELDS{'Sent'} = "True";
      $cardline = "";
      foreach $formkey (keys %SENDFIELDS) {
   	   $cardline .= "$formkey\|$SENDFIELDS{$formkey}\|";
       } # end for each

      return $cardline;
 } # end sub send_email


##################################################################################
##		sub delete_old_cards
##################################################################################

sub delete_old_cards {
  
  if ($OS ne "UNIX") {
    use File::Copy;
  }
  
  
#print "I am in the delete_old_cards routine";
local ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
local ($osec,$omin,$ohour,$omday,$omon,$oyear,$owday,$oyday,$oisdst);
local (@card_items, %CARDFIELDS);

if (-e "$card_dbase_path/update$dbase_name") {
   open (UPDATEFILE, "$card_dbase_path/update$dbase_name") || &cgidie("I cannot open the  update timer file $card_dbase_path/update$dbase_name in delete_old cards sub");
   my(@update)= <UPDATEFILE>;
   close(UPDATEFILE);
   my($last_update_time) = $update[0];
   my($current_time) = time;
#print "<br>last update time = $last_update_time<br>current time = $current_time<br>";   
   my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
   my($osec,$omin,$ohour,$omday,$omon,$oyear,$owday,$oyday,$oisdst) = localtime($last_update_time);
#print "today = $mday<br> last_update_day = $omday<br>";   
   if ($omday != $mday) {
      $do_update = 1;
   }
   else {
      $do_update = 0;
   }
}
else {
   $do_update = 1;
}

#print "<br>do_update = $do_update<br>\n";

if ($delete_old_cards_mode == 2) {
   print "<html><title>Deleting Out Of Date Cards</title>\n";
   if ($do_update == 0) {
      print "<body><h1>The database has already been updated today...cancelling update</h1></body></html>\n";
   }
   else {
      print "<body>Processing Card Database\n";
   }
} # en dif

if ($do_update == 1) {
      &log_it ($log_mode, $log_file_path, "Deleting old cards and sending sendlater cards");
      
      &GetFileLock("$lock_file_path/lock$dbase_name");
      open(UPDATEFILE, ">$card_dbase_path/update$dbase_name") || &cgidie("I cannot open the  update timer file $card_dbase_path/update$dbase_name in delete_old cards sub");
      my($current_time) = time;
      print UPDATEFILE "$current_time\n";
      close(UPDATEFILE);
      
      # lets get the current test date
      ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =localtime(time);
      $year = $year + 1900;
      $mon++;
      $current_test_jdate=&jday($mon, $mday,$year);
      $current_test_date= $current_test_jdate - $max_age;

   #lets set the lock file
   
   open (DATABASE, "$card_dbase_path/$dbase_name") || &cgidie("i am sorry, I was unable to open $card_dbase_path/$dbase_name in sub delete_old_cards");
   open (TEMP, ">$card_dbase_path/temp$dbase_name") || &cgidie ("i am sorry, I was unable to open $card_dbase_path/temp$dbase_name in sub delete_old_cards");

   while (<DATABASE>) {
     $card_line=$_;
      @card_items = split(/\|/, $card_line);
      chop($card_line_id = pop(@card_items));

      # Lets see if it was a send later card ..if so send it....
      undef %CARDFIELDS;
      $num_card_items = @card_items;
	for ($i = 0; $i < $num_card_items; $i = $i +2) {
	   $CARDFIELDS{$card_items[$i]} = $card_items[$i+1];

	 }

      if ($CARDFIELDS{'Sent'} eq "False") {
            $testjday = &jday($CARDFIELDS{'SendMonth'},$CARDFIELDS{'SendDay'},$CARDFIELDS{'SendYear'});
            if ($testjday <= $current_test_jdate) {
               #$old_cl_id = $card_line_id;
               $card_line_id = &make_id;
               $card_line = &send_later_card($card_line_id, @card_items);
               #$card_line_id = $old_cl_id;
               $card_line .= "$card_line_id\n";
             } # end if ($testjday == $current_test_jdate
            else {
               #we cant send it yet so lets set a flag
               $card_line_id = &make_id;
             } # end else
       } # end if ($CARDFIELDS{'Sent'} eq "False")
      
      #now back to see if we need to delete it.
      ($oldtime, $junk1, $junk2)= unpack("Nnn", pack("H*",$card_line_id));

      ($osec,$omin,$ohour,$omday,$omon,$oyear,$owday,$oyday,$oisdst) = localtime($oldtime);
      $oyear = $oyear + 1900;
      $omon++;
      $olddate= &jday($omon, $omday, $oyear);

      if ($olddate > $current_test_date || $CARDFIELDS{'Sent'} eq "False") {
         print TEMP "$card_line";
 
      }  #end if
if ($delete_old_cards_mode == 2) {
   print "...";
} # en dif
    } # end while

   close (TEMP);
   close (DATABASE);

   &perform_rename("$card_dbase_path/temp$dbase_name","$card_dbase_path/$dbase_name");
   &ReleaseFileLock("$lock_file_path/lock$dbase_name");
 
if ($delete_old_cards_mode == 2) {
   print "<br> Cleaning Database is Complete</body></html>\n";
} # en dif

}

 }  #end sub delete_old_cards


##################################################################################
##		sub make_id
##################################################################################

sub make_id {

local ($id);   

$id = int(rand(60000));
# pack the time, process id, and random $session into a
# hex number which will make up the session id.
$id = unpack("H*", pack("Nnn", time, $$, $id));

return $id;
} # end sub make_id

##################################################################################
##		sub send_hamcard
##################################################################################

sub send_hamcard	{


if ($delete_old_cards_mode == 0) {
#print"deleting old cards & checking for sendlaters<br>";
   &delete_old_cards;
 }  #end if

$sessionid = &make_id;

#flock (DATABASE, 2);
if (($FORM{'When'} eq "") || ($FORM{'When'} eq "Now")) {
   $FORM{'SendMonth'} = "";
   $FORM{'SendDay'} = "";
   $FORM{'SendYear'} = "";
   $FORM{'Sent'}="True";
 }
else {
   # lets get the send jday
   $senddate = &jday($FORM{'SendMonth'}, $FORM{'SendDay'}, $FORM{'SendYear'});
      # Now lets get todays jday
      ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =localtime(time);
      $year = $year + 1900;
      $mon++; 
      $current_jday=&jday($mon, $mday,$year);
#print"current_jday=$current_jday<br>senddate = $senddate<br>";
      #is send date same as today?  yes.. then send today. 
      if ($current_jday == $senddate) {
         $FORM{'SendMonth'} = "";
         $FORM{'SendDay'} = "";
         $FORM{'SendYear'} = "";
         $FORM{'Sent'}="True";
       } # end if ($current_jday == $senddate)
      # is send day before today date? if so then error
      elsif ($current_jday >$senddate) {
	  open (BADINPUT, "$html_template_path/$required_template") || &cgidie ("I am sorry, but I was not able to open the data file $html_template_path/$required_template.");
		@bad_input = <BADINPUT>;
	  close (BADINPUT);
         print @bad_input;
         exit;
      } # end ($current_jday < $senddate)
      # otherwise not send today
     else {
         $FORM{'Sent'} = "False";
      } # end else
   }  #end else


#Write form data to file
#lets set the lock file
&GetFileLock("$lock_file_path/lock$dbase_name");
open (DATABASE, ">>$card_dbase_path/$dbase_name") || &cgidie ("I am sorry, but I was unable to open the file $card_dbase_path/$dbase_name.");

foreach $formkey (keys %FORM) {
	print DATABASE "$formkey\|$FORM{$formkey}\|";
 } # end for each
print DATABASE "$sessionid\n";

#flock (DATABASE, 8);
close (DATABASE);
#release file lock
&ReleaseFileLock("$lock_file_path/lock$dbase_name");

#if ($FORM{'Sent'} ne "False") {print" sending normal card<br>";}
if ( $FORM{'Sent'} ne "False") {
#Send e-mail to recipient


$recipient = "$FORM{'REmail'}";
$from_email = "$FORM{'SEmail'}";
$replyto = "$FORM{'SEmail'}($FORM{'SName'})";
$subject = "A Card for you";
$message = "";

   
open (PAGE, "$email_template_path/$mail_template") || &cgidie ("I am sorry, but I was unable to open the file $email_template_path/$mail_template.");
	@page_template = <PAGE>;
close (PAGE);

	foreach $page_line (@page_template) {
		$page_line =~ s/%%scriptloc%%/$script_loc/g;
		$page_line =~s/%%sessionid%%/$sessionid/g;	
		
		foreach $formkey (keys %FORM) {
			$page_line =~ s/%%$formkey%%/$FORM{$formkey}/g;
		 } # end foreach
            $message .= "$page_line";
	   } # end foreach
	   
	   if ($from_email eq "") {
        $from_email = $admin_email;
        $replyto = $admin_email;
      }
     &send_smtp_mail ($mail_mode, $smtp_server, $from_email, $recipient, $replyto, $subject, $message);


} # end if 

#print card sent template
if ($FORM{'Sent'} eq "False") {
   open (CARDSENT, "$html_template_path/$sendlater_template") || &cgidie ("I am sorry, but I was unable to open the file $html_template_path/$sendlater_template.");
	@cardsent_template = <CARDSENT>;
   close (CARDSENT);
 } # end if
else {
   open (CARDSENT, "$html_template_path/$sent_template") || &cgidie ("I am sorry, but I was unable to open the file $html_template_path/$sent_template.");
	@cardsent_template = <CARDSENT>;
   close (CARDSENT);
 } # end if..else

	foreach $cardsent_line (@cardsent_template) {
		$cardsent_line =~ s/%%scriptloc%%/$script_loc/g;
		$cardsent_line =~s/%%sessionid%%/$sessionid/g;	
		
		foreach $formkey (keys %FORM) {
			$cardsent_line =~ s/%%$formkey%%/$FORM{$formkey}/g;
		 } # end foreach
	
		print $cardsent_line;
	 } # end foreach


}


##################################################################################
##		sub send_notification
##################################################################################
sub send_notification {

local ($page_line, $page_template);
local ($recipient, $from_email, $replyto, $subject, $message);

if ($CARDFIELDS{'SEmail'} =~ /.*\@.*\..*/) {
   $recipient = "$CARDFIELDS{'SEmail'}";
   $from_email = "$admin_email";
   $replyto = "$CARDFIELDS{'SEmail'}($CARDFIELDS{'SName'})";
   if ($notification_subject eq "") {
      $subject = "Card Pickup Notification";
   }
   else {
      $subject = "$notification_subject";
   } # end else
   
   $message = "";
   
      
   open (PAGE, "$email_template_path/$notify_template") || &cgidie ("I am sorry, but I was unable to open the file $email_template_path/$mail_template.");
   	@page_template = <PAGE>;
   close (PAGE);
   
   	foreach $page_line (@page_template) {
   		$page_line =~ s/%%scriptloc%%/$script_loc/g;
   		$page_line =~s/%%sessionid%%/$FORM{'CardID'}/g;	
   		
   		foreach $formkey (keys %CARDFIELDS) {
   			$page_line =~ s/%%$formkey%%/$CARDFIELDS{$formkey}/g;
   		 } # end foreach
               $message .= "$page_line";
   	   } # end foreach
   	    
   	    if ($recipient ne "") {
          &send_smtp_mail ($mail_mode, $smtp_server, $from_email, $recipient, $replyto, $subject, $message);
        }
        
  } # end if
      
   # Now that we have sent a notification we need to turn off notification on this
   # message.  This way a notification will not be sent out with each card viewing
   
   #lets set the lock file
   &GetFileLock("$lock_file_path/lock$dbase_name");
   open (DATABASE, "$card_dbase_path/$dbase_name") || &cgidie("i am sorry, I was unable to open $card_dbase_path/$dbase_name in sub delete_old_cards");
   open (TEMP, ">$card_dbase_path/temp$dbase_name") || &cgidie ("i am sorry, I was unable to open $card_dbase_path/temp$dbase_name in sub delete_old_cards");

   while (<DATABASE>) {
     $card_line=$_;
      @card_items = split(/\|/, $card_line);
      chop($line_id = pop(@card_items));
      if ($line_id eq $FORM{'CardID'}) {
         $card_line = "";
         %card_junk = @card_items;
         
         foreach $card_item (keys %card_junk) {
            if ($card_item ne "PickupNotification") {
               $card_line .= "$card_item\|$card_junk{$card_item}\|";
            } # end if
         } # end foreach
         $card_line .= "$line_id\n";
         undef (%card_junk);
      } # end if
      
      print TEMP $card_line;
   } # end while
   
   close (TEMP);
   close (DATABASE);
   &perform_rename ("$card_dbase_path/temp$dbase_name", "$card_dbase_path/$dbase_name");
   &ReleaseFileLock("$lock_file_path/lock$dbase_name");
   
         


} # end sub send_notification

##################################################################################
##		sub find_card
##################################################################################

sub find_card {
	local (@allcards);

	open (DATABASE, "<$card_dbase_path/$dbase_name") || &cgidie ("I am sorry, but I was unable to open the file $card_dbase_path/$dbase_name. In Find Card routine");
		@allcards = <DATABASE>;
	close (DATABASE);


	$flgfound = "";
	foreach $cardline (@allcards) {
	
		@card_items = split(/\|/, $cardline);
		chop($card_line_id = pop(@card_items));
		
		
		if ($FORM{'CardID'} eq $card_line_id) {
			
			$num_card_items = @card_items;
			for ($i = 0; $i < $num_card_items; $i = $i +2) {
				$CARDFIELDS{$card_items[$i]} = $card_items[$i+1];
				#print "@card_items[$i] = @card_items[$i+1]<br>\n";
			 }
							

			@found_card = @card_items;
			$flgfound = "true";
		 } # end if
	 } # end foreach

	if ($flgfound eq "") {
		&print_notfound;
#print "didnt find card";		
		exit;
	 }  # end if
	 
  } # end sub find_card	 
	 
##################################################################################
##		sub print_notfound
##################################################################################

sub print_notfound {
open (DISPLAY, "$html_template_path/$missing_req") || &cgidie ("I am sorry, but I was not able to open the data file $html_template_path/$missing_req.");
	@display_temp = <DISPLAY>;
   close (DISPLAY);
   	
   foreach $display_line (@display_temp) {

	$display_line =~ s/%%scriptloc%%/$script_loc/g;
	
	foreach $formkey (keys %FORM) {
		$display_line =~ s/%%$formkey%%/$FORM{$formkey}/g;
	 } # end foreach
	
	print $display_line;
   } # end foreach		
 }  # print not found

##################################################################################
##		sub print_hamcard
##################################################################################

sub print_hamcard {

   open (DISPLAY, "$html_template_path/$display_template") || &cgidie ("I am sorry, but I was not able to open the data file $html_template_path/$display_template.");
	@display_temp = <DISPLAY>;
   close (DISPLAY);
   	
   foreach $display_line (@display_temp) {

	$display_line =~ s/%%scriptloc%%/$script_loc/g;
	
	foreach $formkey (keys %CARDFIELDS) {
		$display_line =~ s/%%$formkey%%/$CARDFIELDS{$formkey}/g;
	 } # end foreach
	
	print $display_line;
   } # end foreach

  } # end sub print_hamcard

##################################################################################
##		sub pass_variables
##################################################################################

sub pass_variables {

#perform a securty check on  the nextpage tag
$FORM{'NextPage'} =~ s/\\/ /g;
$FORM{'NextPage'} =~ s/\.\./  /g;



   open (DISPLAY, "$html_template_path/$FORM{'NextPage'}") || &cgidie ("I am sorry, but I was not able to open $html_template_path/$FORM{'NextPage'} in sub pass_variables");
      @display_temp = <DISPLAY>;
   close (DISPLAY);

   foreach $display_line(@display_temp) {

      $display_line =~ s/%%scriptloc%%/$script_loc/g;

   foreach $formkey (keys %FORM) {
         $display_line =~ s/%%$formkey%%/$FORM{$formkey}/g;

         
    } # end foreach

   print $display_line;
  } # end for each $display_line
} # end sub pass_variables






1;
	 