#!/usr/local/bin/perl
########################################################
##                                      			 
##             	HAMcard               				 
##              by Tony Lee Huffman					 
##	             and HAMnet Consulting                
##       (e-mail hamcard@hamnetcenter.com)            
##                                      			 
##             version:  1.0      			  
##         last modified:  October 14, 1998			  
##           copyright (c) 1998         			  
##                                   			      
##    latest version is available from   			
##        http://www.hamnetcenter.com/
##                                       			 
########################################################

# COPYRIGHT NOTICE:
#
# Copyright 1998 HAMnet Consulting.  All Rights Reserved.
#
# This program may be used and modified free of charge by anyone, so
# long as this copyright notice and the header above remain intact.  By
# using this program you agree to indemnify HAMnet Consulting and any company
# programmers from any liability.  It would also be nice for you to let
# me know how and where you are using this script.
#
# Selling the code for this program without prior written consent is
# expressly forbidden.  Obtain permission before redistributing this
# program over the Internet or in any other medium.  In all cases
# copyright and header must remain intact.
#



##################################################################################
##		Initialize Variables
##################################################################################

# $OS should be set to either UNIX or NT (Win95/98 users use NT here)
$OS ="UNIX";

# HAMcards offers two modes for sending mail.  This is mainly for 
# compatibility between UNIX & Win 32 systems
# mode 0 : $mail_mode = 0 : HAMcards will use the the mail_prog (Sendmail)
#                          to send mail. This is good for UNIX systems
# mode 1 : $mail_mode = 1 : HAMcards will use a SMTP server to send the
#                          mail. Good for Win32 systems
$mail_mode = 0;

# $smtp_server is used when $mail_mode is set to 1.  Provide the 
# name of the smtp server to use to send mail
$smtp_server = "hamnetcenter.com";

# $mailprog is used when $mail_mode is set to 0
# $mailprog is set to the full path to the system mail program (sendmail?)
$mailprog = "/usr/sbin/sendmail";

# $admin_email is set to the admin email address for the card system
# this is also the return address used for the Pickup notifications
$admin_email = "hamcards\@hamnetcenter.com";

# $allow_pickup_notification is set to 1 if you want the system to be
# able to send notifications to the card senders that the card has
# been picked up. (also the form element 'PickupNotification' must be 
# set to any value when card is posted.. use a checkbox so sender
# can choose to have a notification sent to him.
# $allow_pickup_notification = 0  no notifications sent
# $allow_pickup_notification = 1 notifications sent
# remember this is a pickup notification that is sent to the card sender
# to let them know the card was picked up.  This is not the
# notification sent to the reciever(that notification can not be turned off)
$allow_pickup_notification = 1;

# $notification_subject is used to allow you to provide a custom subject for
# the pickup notification emails
$notification_subject = "Card Pickup Notification";

# $script_loc is set to the url of the postcard script.
$script_loc = "http://www.hamnetcenter.com/hamcards/hamcards.cgi";

# set $hamlin_path to the path of the HAMnet library files
$hamlib_path = "/usr/www/users/hamnet/hamcards/hamlib";

#set $html_template_path to the path of the html templates
$html_template_path = "/usr/www/users/hamnet/hamcards/templates";

#set email_template_path to the path of the email template
$email_template_path = "/usr/www/users/hamnet/hamcards/templates";

#set $card_dbase_path to the path of the card database
$card_dbase_path = "/usr/www/users/hamnet/hamcards/database";

#set $lock_file_path to the directory to  store the lock files
#the name fore the lockfile is derived from $dbase_name
#ie.. if $dbase_name = "cards.dbase" then lockfile name
# will be "lockcards.dbase"
$lock_file_path = "/usr/www/users/hamnet/hamcards/database";

# $mail_template is set to the name of the html template that is used
# for the email message sent to the user.
$mail_template = "mail.txt";

# $notify_template is set to the the name of the html mail template that
# is used to send a notification to the Card sender that the card
# was picked up.. Only used if $allow_pickup_notification is set to 1
$notify_template = "notify_email.txt";

#set preview_templatre to the name of the preview template
$preview_template = "preview.html";

# $display_template is set to the name of the html template that is used 
# to show the final card to user
$display_template = "display.html";

# $sent_template is set to the name of the html template that is used
# to let user know the card was sent
$sent_template = "cardsent.html";

# $sendlater_template is set to the name of the html template that is used
# to let user know the card will be sent later
$sendlater_template = "sendlater.html";


# $missing_req is set to the name of the html template that is used
# to show that the card was not found
$missing_req = "missing.html";

# $required_template is set to the name of the html template to induicate
# that not all required info was completed
$required_template = "required.html";


# $card_dbase is set to the name of the text file that holds all the
# database information
$dbase_name = "card.dbase";


#Set $allow_html to the 0 to not allow html coding in the cards
#set to 1 to allow html coding.  When this is set to 1 you do have
# a higher security risk.
$allow_html = 0;

# set max_age to the maximum number of days to keep cards for.
$max_age = 14;

#Set delete_old_cards_mode to mode for deleteig old cards
# 0 = delete out of date cards whenever a new card is posted
# 1 = only delete old card when script is with no Do..ie from telnet
#        this allows you to automate this process with a cron job
#        thus not wasting server usage whenever a card is posted.
# 2 = same as one but started froma web browser...you would
 #       just use the url to the script & it iwll delete out of date cards
$delete_old_cards_mode = 1;

#set $log_file_path to the fullpath to the error log
$log_file_path = "/usr/www/users/hamnet/hamcards/logs/logs.txt";

#set log mode to 1 if you want to log error and various script functions
#set to 0 to not log functions
$log_mode = 1;



# @required shoule be set to all field you want required on every use of 
# of the hamcards script.  This can be useful if you want to make sure
# the use enters certain information.. If you do not care to require anything
# special then this field can be left out
@required=('REmail', 'SEmail');


####################################################
#pritn out header if we need to

if ($delete_old_cards_mode != 1) {
   $! = 1;
  print "Content-type: text/html\n\n";
 } 

####################################################
#require library files

require ("$hamlib_path/hamcardslib.pl");
require("$hamlib_path/hamlib.pl");
require("$hamlib_path/date.pl");

####################################################

&main_routine;

exit;
