#! /usr/bin/perl

#########################################################
#                                                       #
#  Group Mailer Version: 1.2                            #
#  Last Modified: 2-09-98                               #
#  Written By: David Tsai                               #
#  http://www.web-consult.com/paradise/                 #
#                                                       #
#########################################################
#                                                       #
#  Copyright  1997 David Tsai, Web Consultant.         #
#  Permission to use this script granted.  This script  #
#  shall not be redistributed in anyway without the     #
#  written consent of David Tsai.  This script shall    #
#  not be modified in any way without the written       #
#  consent of David Tsai, although you may modify       #
#  the variables in the designated areas                #
#                                                       #
#########################################################

#############################
#  Edit Variables Here
#

    #- Path to the directory where the data files will be stored.
$base_dir = "/path/to/directory/";

    #- Hosts that are allowed to access this script.  Set this to the domain
    #- name or your server.  Example below:
@referers = ("web-consult.com","www.web-consult.com");


#
#  Stop Editing Here
#############################

&parse_form;

$ref = 0;

if(! @referers) {
	$ref = 1;
}

foreach $referer (@referers) {
    if($ENV{'HTTP_REFERER'} =~ /$referer/i) {
        $ref = 1;
        last;
    }
}

if(! $ref) {
    &error("The HTTP REFERER was not allowed to access this script.");
}

$database = "$base_dir/$FORM{'key'}\.dat";

if($FORM{'action'} =~ /add/i || $FORM{'action'} eq "") {
    &error("Form Incomplete") unless $FORM{'email'};
    &error("There was no list specified in the form.") unless $FORM{'key'};

    if($FORM{'email'} !~ /.*\@.*\..*/) {
        &error("You have entered an invalid email address");
    }

    if(! -e $database) {
        open(DAT, ">$database") || die "Can't create $database\n";
        print DAT "[Begin]\n";
        close(DAT);
    }

    foreach $field (keys %FORM) {
        if($field ne "key") {
            $data = "$data&$field=$FORM{$field}";
        }
    }

    open(DAT, "$database") || die "Can't open $database\n";
    @dat =<DAT>;
    close(DAT);

    foreach $dat (@dat) {
        if(($FORM{'email'} =~ /$dat/i) || ($dat =~ /$FORM{'email'}/i)) {
            &error("You are already in the mailing list!");
        }
    }

    open(DAT, ">>$database") || die "Can't open $database\n";
    print DAT "$data\n";
    close(DAT);

    &header("$FORM{'email'} has been added to the database");

}

elsif($FORM{'action'} =~ /delete/i) {

    $r = 0;
    open(DAT, "$database") || die "Can't open $database\n";
    @lines =<DAT>;
    close(DAT);

    open(DAT, ">$database") || die "Can't open $database\n";
    foreach $line (@lines) {
        if($line =~ /$FORM{'email'}/i) {
            $r = 1;
        }
        else {
            print DAT "$line";
        }
    }
    close(DAT);
    if($r) {
        &header("$FORM{'email'} has been removed from the database");
    }
    else {
        &header("$FORM{'email'} was not found in the database");
    }
}

else {
    &error("You did not enter a function");
}


sub error {
    local($msg) = @_;
    &header("$msg");
    exit;
}

sub header {

    local($msg) = @_;
    print "Content-Type: text/html\n\n";
    print "<CENTER><H2>$msg</H2></CENTER>\n";

}

sub parse_form {

	if($ENV{'REQUEST_METHOD'} eq "POST") {
   		read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
	}
	
	if($ENV{'REQUEST_METHOD'} eq "GET") {
		$buffer = $ENV{'QUERY_STRING'};
	}
   
   @pairs = split(/&/, $buffer);
   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $name =~ tr/+/ /;
      $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ s/<!--(.|\n)*-->//g;

      if(! $allow_html) {
        $value =~ s/<([^>]|\n)*>//g;
      }

      $FORM{$name} = $value;
   }

}
