#!/usr/bin/perl

##############################################################################
# Picture.cgi                     Version 1.5                                #
# Copyright 2001  Glenn Dempsey   webmaster@clovenfoot.com                   #
# Created 07/25/01                Last Modified 12/17/01                     #
# Cloven Foot:                    http://clovenfoot.com                      #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 2001  Glenn Dempsey   All Rights Reserved.                       #
#                                                                            #
# Picture.cgi may be used and modified free of charge by anyone so long as   #
# this copyright notice and the comments above remain intact.  By using this #
# code you agree to indemnify Glenn Dempsey from any liability that          #
# might arise from its use.                                                  #
#                                                                            #
# Selling the code for this program without prior written consent is         #
# expressly forbidden.  In other words, please ask first before you try and  #
# make money off of my program.                                              #
#                                                                            #
# Obtain permission before redistributing this software over the Internet or #
# in any other medium.	In all cases copyright and header must remain intact #
##############################################################################

#Variables
require "config.pl";
my $number_of_images = 0; #value should always start off as zero
my $nop;
my $pagenum;
my $forloopvar = 0; 
my $forloopimages;
my @image_array;
my $nop_l;
my $last_images;
my $prev_images;
my $prev_pagenum;
#End Variables

#Get rid of "#" from color codes.
$bgcolor =~ s/^#//g;
$pic_border =~ s/^#//g;
$text =~ s/^#//g;
$link_color =~ s/^#//g;
$darkened_links =~ s/^#//g;

#Get rid of trailing "/" from $directory, and create a variable for the location of picture.html
my $pic_directory = $directory . "\/" . $nameofpicfolder . "\/";

if ($pages_displayed == (int $pages_displayed / 2) * 2){
	print "Content-type: text/html\n\n";
	print "You must use an odd number for the \$page_displayed variable.  Try again by modifying the config.pl file.\n";
	exit;
}

&parse_form;
&read_dir;

@image_array = reverse sort @unsortedfiles;
@image_array = grep /\d\-.*?\.($media)/gi, @image_array;

$number_of_images = @image_array; #Total number of images

$pagenum += 1;
$nop = $number_of_images/$images_per_page; #this tells the script how many pages are needed to display all of the pictures
					   #nop means number of pages

if ($nop =~ /\./){  #this if statement rounds any decimal number up
	@yonop = split(/\./, $nop);
	$nop = $yonop[0] + 1;
}

print "Content-type: text/html\n\n";
print <<GALLERYHEADER;
	<HTML>
	<HEAD>
	<TITLE>picture gallery</TITLE>
	</HEAD>
	<BODY bgcolor="$bgcolor" text="$text" link="$pic_border" vlink="$pic_border" alink="$pic_border">
	<center>
	<table align="center" border="0"><tr><td width="500">
GALLERYHEADER

$forloopimages = $images_per_page - 1;

#The heart of the script
for ($image_array = $forloopvar; $image_array <= ($forloopimages + $forloopvar); $image_array++){

	(local $firstsplit1, local $firstsplit2) = split(/\.($media)/, $image_array[$image_array]);
	(local $secondsplit1, local $secondsplit2) = split(/\-/, $firstsplit1);
	$secondsplit2 =~ s/\_/ /g;
	last if ($image_array > ($number_of_images - 1));
	print "<a href=\"$directory/picture.html?name=$image_array[$image_array]&alt=$secondsplit2&picdirectory=$pic_directory&bgcolor=$bgcolor&text=$text&linkcolor=$link_color\"><img src=\"$directory/$nameofpicfolder/$nameofthumbfolder/$image_array[$image_array]\" alt=\"$secondsplit2\" title=\"$secondsplit2\" border=\"2\" width=\"120\" height=\"120\"></a>";

}
#End heart of the script

if (@image_array == ""){

	$pagenum = 0;

}

print "</td></tr><tr><td align=\"right\">";
print "<font size=2 face=arial,helvetica color=$text>Page $pagenum out of $nop</font><br>";
print "<font size=2 face=arial,helvetica color=$text>Total number of images: $number_of_images</font><br>";

$forloopvar += $images_per_page;
$nop_l = $nop - 1; #for the last button
$last_images = $nop_l * $images_per_page; #for the last button
$prev_images = $forloopvar - ($images_per_page * 2); #for the previous button
$prev_pagenum = $pagenum - 2; #for the previous button

if (($nop == 1) || ($nop == 0)) {
	print "<font size=2 face=arial,helvetica color=\"$darkened_links\"><u>first</u></font><font size=2 face=arial,helvetica color=\"$darkened_links\">&nbsp;&nbsp;|&nbsp;&nbsp;</font><font size=2 face=arial,helvetica color=\"$darkened_links\"><u>last</u></font><br>";
	print "&nbsp;<font size=2 face=arial,helvetica color=\"$darkened_links\"><u>previous</u></font><font size=2 face=arial,helvetica color=\"$darkened_links\"> | </font>";
	print "<font size=2 face=arial,helvetica color=\"$darkened_links\"><u>next</u></font>";
	print "</td></tr></table>";
	print "</center>";
	print "</BODY>";
	print "</HTML>";
	exit;
}
elsif ($pagenum == 1) {
	print "<font size=2 face=arial,helvetica color=\"$darkened_links\"><u>first</u></font><font size=2 face=arial,helvetica color=\"$text\">&nbsp;&nbsp;|&nbsp;";
	&page_numbers;
	print "|&nbsp;&nbsp;</font><a href=\"$cgi_location/$cgi_script?pagen=$nop_l&images=$last_images\"><font size=2 face=arial,helvetica color=\"$link_color\">last</font></a><br>";
	print "&nbsp;<font size=2 face=arial,helvetica color=\"$darkened_links\"><u>previous</u></font><font size=2 face=arial,helvetica color=\"$text\"> | </font>";
	print "<a href=\"$cgi_location/$cgi_script?pagen=$pagenum&images=$forloopvar\"><font size=2 face=arial,helvetica color=\"$link_color\">next</font></a>";
	print "</td></tr></table>";
	print "</center>";
	print "</BODY>";
	print "</HTML>";
	exit;
}
elsif ($pagenum < $nop) {
	print "<a href=\"$cgi_location/$cgi_script\"><font size=2 face=arial,helvetica color=\"$link_color\">first</font></a><font size=2 face=arial,helvetica color=\"$text\">&nbsp;&nbsp;|&nbsp;";
	&page_numbers;
	print "|&nbsp;&nbsp;</font><a href=\"$cgi_location/$cgi_script?pagen=$nop_l&images=$last_images\"><font size=2 face=arial,helvetica color=\"$link_color\">last</font></a><br>";
	print "&nbsp;<a href=\"$cgi_location/$cgi_script?pagen=$prev_pagenum&images=$prev_images\"><font size=2 face=arial,helvetica color=\"$link_color\">previous</a></font><font size=2 face=arial,helvetica color=\"$text\"> | </font>";
	print "<a href=\"$cgi_location/$cgi_script?pagen=$pagenum&images=$forloopvar\"><font size=2 face=arial,helvetica color=\"$link_color\">next</font></a>";
	print "</td></tr></table>";
	print "</center>";
	print "</BODY>";
	print "</HTML>";
	exit;  
}
elsif ($pagenum == $nop){
	print "<a href=\"$cgi_location/$cgi_script\"><font size=2 face=arial,helvetica color=\"$link_color\">first</font></a><font size=2 face=arial,helvetica color=\"$text\">&nbsp;&nbsp;|&nbsp;";
	&page_numbers;
	print "|&nbsp;&nbsp;</font><font size=2 face=arial,helvetica color=\"$darkened_links\"><u>last</u></font><br>";
	print "&nbsp;<a href=\"$cgi_location/$cgi_script?pagen=$prev_pagenum&images=$prev_images\"><font size=2 face=arial,helvetica color=\"$link_color\">previous</a></font><font size=2 face=arial,helvetica color=\"$text\"> | </font>";
	print "<font size=2 face=arial,helvetica color=\"$darkened_links\"><u>next</u></font>";
	print "</td></tr></table>";
	print "</center>";
	print "</BODY>";
	print "</HTML>";
	exit;
}
else {
	print "</td></tr></table>";
	print "</center>";
	print "</BODY>";
	print "</HTML>";
	exit;
}

sub parse_form {
	$method = $ENV{'REQUEST_METHOD'};
	read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
	if (length($buffer) < 5) {
		$buffer = $ENV{QUERY_STRING};
	}
	@pairs = split(/&/, $buffer);
	foreach $pair (@pairs) {
		($name, $value) = split(/=/, $pair);
		$value =~ tr/+/ /;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$FORM{$name} = $value;
	}
	$pagenum = $FORM{'pagen'};
	$forloopvar = $FORM{'images'};
}

sub read_dir {

	opendir(THISDIR, $pathtogallery) or die "cannot open $pathtogallery: $!";
	@unsortedfiles = grep { $_ ne '.' and $_ ne '..' } readdir THISDIR;
	closedir THISDIR;

}

sub page_numbers {
	local $pages_d = ($pages_displayed - 1) / 2;
	local $pagenumadd = $pagenum + $pages_d;
	local $pagenumminus = $pagenum - $pages_d;

	if ($pagenumadd > $nop){
		$pagenumadd = $nop;
	}
	
	if ($pagenumminus < 1){
		$pagenumminus = 1;
	}

	local $loopvar = $images_per_page * ($pagenumminus - 1); 

	for (my $i = $pagenumminus; $i <= $pagenumadd; $i++){
		local $i_minus = $i - 1;
		if ($i == $pagenum){
			print "<font color=\"$darkened_links\">$i</font>&nbsp;";
		}else{
			print "<a href=\"$cgi_location/$cgi_script?pagen=$i_minus&images=$loopvar\"><font color=\"$link_color\">$i</font></a>&nbsp;";
		}
		$loopvar += $images_per_page;
	}
}