#!/usr/bin/perl
########################################################
#                      Imagex 1.0                      #
#               By Thomas Tsoi 26.4.2001               #
#                    cgi@cgihk.com                     #
########################################################
#                                                      #
# CGIHK.com:                                           #
#   http://www.cgihk.com/                              #
# ThomasTsoi.com                                       #
#   http://www.ThomasTsoi.com                          #
# Winapi.com                                           #
#   http://www.winapi.com                              #
# Astronomy.org.hk                                     #
#   http://www.astronomy.org.hk/                       #
#                                                      #
# #################################################### #
#                                                      #
# You can distribute this script and use it freely as  #
# long as this header is not edited in the script.     #
#                                                      #
# #################################################### #
#                                                      #
#      Knowledge is worth a billion bucks              #
#        But it shouldn't cost you a single buck       #
#                                                      #
########################################################

# Path to the HTML template
$template  = './template.txt';

# Path to the directory containing all the images
$imagedir  = '/virtual/lasalle.uhome.net/cgi-bin/imagex/images';

# Format of the table displaying thumbnails
# The value should be in the format of '(c)x(r)'
# where (c) is the number of colomns and (r) is that of rows. 
# e.g. '5x4', '6x6', etc.
$format    = '5x3';

# The maximum dimension of thumbnails, (width)x(height)
$dimension = '120x120';

# Default thumbnail format: jpeg or png
$thumbformat = "jpg"; # jpg recommended

# Parameters of the table containing thumbnails
# Set the values of parameters if you want
# Leave it blank if you just don't care
$table{'width'}       = '';
$table{'height'}      = '';
$table{'border'}      = '1';
$table{'bordercolor'} = '#ffffff';
$table{'bgcolor'}     = '#ddddff';
$table{'background'}  = '';
$table{'cellspacing'} = '0';
$table{'cellpadding'} = '0';
$table{'align'}       = 'center';

# Parameters of the font
# Leave it blank if you just don't care
$font{'face'}         = 'Arial';
$font{'size'}         = '2';
$font{'color'}        = '#000000';

# Customization ends here.

#######################################################################
# Initialization
#######################################################################

chop($imagedir) if $imagedir =~ /\/$/;

($colomn, $row) = parseFormat($format);
if (uc($row) ne 'A') {
	$imgperpage = $colomn * $row;
	}

($width, $height) = parseDimension($dimension);

$table_para .= " width=$table{'width'}" if $table{'width'} ne "";
$table_para .= " height=$table{'height'}" if $table{'height'} ne "";
$table_para .= " border=$table{'border'}" if $table{'border'} ne "";
$table_para .= " bordercolor=$table{'bordercolor'}" if $table{'bordercolor'} ne "";
$table_para .= " bgcolor=$table{'bgcolor'}" if $table{'bgcolor'} ne "";
$table_para .= " background=$table{'background'}" if $table{'background'} ne "";
$table_para .= " cellspacing=$table{'cellspacing'}" if $table{'cellspacing'} ne "";
$table_para .= " cellpadding=$table{'cellpadding'}" if $table{'cellpadding'} ne "";
$table_para .= " align=$table{'align'}" if $table{'align'} ne "";

$font_para  .= " face=\"$font{'face'}\"" if $font{'face'} ne "";
$font_para  .= " size=$font{'size'}" if $font{'size'} ne "";
$font_para  .= " color=$font{'color'}" if $font{'color'} ne "";

$page = param('page') || 1;

#######################################################################
# Main program
#######################################################################

use CGI ':standard';
use GD;

if (param('file')) {
	if (param('thumb')) {
		getThumb(param('file'));
		}
	elsif (param('full')) {
		getFullImage(param('file'));
		}
	else {
		viewFullImage(param('file'));
		}
	}
else {
	printIndex();
	}


#######################################################################
# printIndex
#######################################################################

sub printIndex {

print header;

open(TEMP, $template) or die("Cannot open $template");

while (my $line = <TEMP>) {
	if ($line =~ /(.*)<IMAGEX>(.*)/i) {
		print $1;
		runImagex();
		print $2;
		}
	else {
		print $line;
		}
	}

close(TEMP);

}

#######################################################################
# runImagex
#######################################################################

sub runImagex {

opendir(DIR, $imagedir) or die("Cannot open $imagedir");
my @temp = readdir(DIR);
closedir(DIR);

foreach my $file (@temp) {
	push (@files, $file) if ($file =~ /\.jpe?g$/i);
	push (@files, $file) if ($file =~ /\.png$/i);
	push (@files, $file) if ($file =~ /\.gif$/i);
	}
undef @temp;

@files = sort(@files);

$numfile = $#files + 1;
$totalpage = ($numfile % $imgperpage) == 0 ? int($numfile / $imgperpage) : int($numfile / $imgperpage)+1;

print "<table$table_para>\n";


my $index = ($page-1) * $imgperpage;
my $firstimg = $index +1;

$font4_para = $font_para;
$font4_para =~ s/size=\d/size=4/i;

print "\t<tr><td colspan=$colomn><font$font4_para><b>/IMAGEX</b></font></td></tr>\n";

for ($i=0;$i<$row;$i++) {
	print "\t<tr>\n";
	for ($j=0;$j<$colomn;$j++) {
		print "\t\t<td align=center>";
		if ($index <= $#files) {
			print "<table border=0 cellspacing=0 cellpadding=0><tr><td align=center valign=middle height=$height width=$width>";
			$t_imgpara = "";
			if ($files[$index] !~ /\.gif$/i) {
				($t_width, $t_height) = getThumbDimension($files[$index]);
				$t_imgpara = " width=$t_width height=$t_height";
				}
			print "<a href=\"$ENV{'SCRIPT_NAME'}?file=$files[$index]\"><img src=\"$ENV{'SCRIPT_NAME'}?file=$files[$index]&thumb=true\"$t_imgpara border=0 alt=\"$files[$index]\"></a>";
			print "</td></tr><tr><td align=center valign=bottom>";
			print "<font$font_para>$files[$index++]</font>";
			print "</td></tr></table>";
			}
		else {
			print "-";
			}
		print "</td>\n";				
		}
	print "\t</tr>\n";
	last if $index > $#files;
	}


print "\t<tr><td colspan=$colomn>\n";
print "\t\t<table cellspacing=0 cellpadding=0 border=0 width=100%>\n";
print "\t\t\t<tr>\n";
print "\t\t\t<td align=left valign=top><font$font4_para><small>Totally $numfile images <i>(Displaying $firstimg - $index)</i></small></font></td>\n";
print "\t\t\t<td align=right valign=top><font$font4_para><small>";
print "<form name=\"imagex\"><select name=\"page\">";
for ($i=1;$i<=$totalpage;$i++) {
	print "<option value=\"$i\"";
	print " selected" if $i == $page;
	print ">Page $i";
	}
print "</select> <input type=submit value=\"GO!\" onSubmit=\"window.location.href = '$ENV{'SCRIPT_NAME'}?page=' + document.imagex.page.options[document.imagex.page.selectedIndex].value;\"></form>";
print "</small></font></td>\n";
print "\t\t\t</tr>\n";
print "\t\t</table>\n";
print "\t</td></tr>\n";

print "</table>";

}


#######################################################################
# getThumb
#######################################################################

sub getThumb {

my $file = shift;

if ($file =~ /\.png$/i) {
	$SrcImg = newFromPng GD::Image("$imagedir/$file");
	}
if ($file =~ /\.jpe?g$/i) {
	$SrcImg = newFromJpeg GD::Image("$imagedir/$file");
	}
if ($file =~ /\.gif$/i) {
	$im = new GD::Image(80,80);
	
	$white = $im->colorAllocate(255,255,255);
	$black = $im->colorAllocate(0,0,0);       
	$red = $im->colorAllocate(255,0,0);      

	$im->transparent($white);
	$im->interlaced('true');

	$im->string(gdGiantFont, 28, 15, 'GIF', $red);
	$im->string(gdMediumBoldFont, 10, 35, 'thumbnail', $red);
	$im->string(gdMediumBoldFont, 30, 45, 'not', $red);
	$im->string(gdMediumBoldFont, 10, 55, 'available', $red);

	binmode STDOUT;
	print "Content-type: image/png; name=\"gif_thumb\.png\"\n";
	print "Content-Disposition: inline; filename=\"gif_thumb\.png\"\n\n";
	print $im->png;

	}
else {
	($SrcImgW, $SrcImgH) = $SrcImg->getBounds();

	if ($SrcImgW <= $width && $SrcImgH <= $height) {
		$FinalImg = $SrcImg;
		}
	else {

		$ratio = ($SrcImgW / $width);
		if ($SrcImgH/$ratio > $height) {
			$ratio = $SrcImgH / $height;
		}

		$FinalImgW = int($SrcImgW/$ratio);
		$FinalImgH = int($SrcImgH/$ratio);

		$FinalImg = new GD::Image($FinalImgW,$FinalImgH);
		$FinalImg->copyResized($SrcImg,0,0,0,0,$FinalImgW,$FinalImgH,$SrcImgW,$SrcImgH);
		}

	binmode STDOUT;

	$file = substr($file, 0, rindex($file, '.'));

	if ($thumbformat =~ /^png$/i) {
		print "Content-type: image/png; name=\"${file}_thumb\.png\"\n";
		print "Content-Disposition: inline; filename=\"${file}_thumb\.png\"\n\n";
		print $FinalImg->png;
		}
	elsif ($thumbformat =~ /^jpe?g$/i) {
		print "Content-type: image/jpeg; name=\"${file}_thumb\.jpg\"\n";
		print "Content-Disposition: inline; filename=\"${file}_thumb\.jpg\"\n\n";
		print $FinalImg->jpeg;
		}
	}
}

#######################################################################
# viewFullImage
#######################################################################

sub viewFullImage {
my $file = shift;

print header;

open(TEMP, $template) or die("Cannot open $template");

while (my $line = <TEMP>) {
	if ($line =~ /(.*)<IMAGEX>(.*)/i) {
		print $1;
		
		print "<table$table_para>\n";
		$font_para =~ s/size=\d/size=4/i;
		
		if ($file =~ /\.png$/i) {
			$SrcImg = newFromPng GD::Image("$imagedir/$file");
			}
		if ($file =~ /\.jpe?g$/i) {
			$SrcImg = newFromJpeg GD::Image("$imagedir/$file");
			}

		if ($file =~ /\.png$/i || $file =~ /\.jpe?g$/i) {
			($SrcImgW, $SrcImgH) = $SrcImg->getBounds();
			$img_size = " width=$SrcImgW height=$SrcImgH";
			}

		print "\t<tr><td align=center><font$font_para><b>$file</b></font></td></tr>\n";
		print "\t<tr><td align=center><img src=\"$ENV{'SCRIPT_NAME'}?file=$file&full=true\"$img_size></td></tr>\n";
		print "</table>\n";
		
		print $2;
		}
	else {
		print $line;
		}
	}

close(TEMP);
}

#######################################################################
# getFullImage
#######################################################################

sub getFullImage {
my $file = shift;

print "Content-type: image/gif; name=\"$file\"\n" if ($file =~ /\.gif$/i);
print "Content-type: image/jpeg; name=\"$file\"\n" if ($file =~ /\.jpe?g$/i);
print "Content-type: image/png; name=\"$file\"\n" if ($file =~ /\.png$/i);
print "Content-Disposition: inline; filename=\"$file\"\n\n";

open(FILE, "$imagedir/$file");
print <FILE>;
close(FILE);

}

#######################################################################
# parseFormat
#######################################################################

sub parseFormat {
if (shift =~ /^(\d)x(\d|A)$/i) {
	return ($1, $2);
	}
else {
	return (undef, undef);
	}
}

#######################################################################
# parseDimension
#######################################################################

sub parseDimension {
if (shift =~ /^(\d+)x(\d+)$/i) {
	return ($1, $2);
	}
else {
	return (undef, undef);
	}
}

#######################################################################
# getThumbDimension
#######################################################################

sub getThumbDimension {
my $file = shift;

if ($file =~ /\.png$/i) {
	$t_SrcImg = newFromPng GD::Image("$imagedir/$file");
	}
if ($file =~ /\.jpe?g$/i) {
	$t_SrcImg = newFromJpeg GD::Image("$imagedir/$file");
	}

($t_SrcImgW, $t_SrcImgH) = $t_SrcImg->getBounds();

undef $t_SrcImg;


if ($t_SrcImgW <= $width && $t_SrcImgH <= $height) {
	return ($t_SrcImgW, $t_SrcImgH);
	}
else {

	$t_ratio = ($t_SrcImgW / $width);
	if ($t_SrcImgH/$t_ratio > $height) {
		$t_ratio = $t_SrcImgH / $height;
		}
		
	return (int($t_SrcImgW/$t_ratio), int($t_SrcImgH/$t_ratio));	
	}

}