/***************************************************************************
                          bwi.h  -  description
                             -------------------
    begin                : Sun Aug 20 2000
    copyright            : (C) 2000 by Eric Phillips
    email                : eric@command-o.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/file.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <dirent.h>

#ifndef NO_STDLIB_H
#include <stdlib.h>
#else
char *getenv();
#endif

#include <string.h>

#define LF 10
#define CR 13

typedef struct
{
  char name[128];
  char val[1024];
} entry;

entry entries[50];
int NUM_ENTRIES;
int VIA_SHELL;

/* BWI Structures */

struct banner {
	long int ID;
	long int CID;
	char name[30];
	char bfile[200];
	char url[200];
	char alt[100];
	char ltext[100];
	char iother[100];
	char lother[100];
	int width;
	int height;
	int border;
	int type;
	long int max;
	int ratio;
	long int bonus;
	char bdate[15];
	long int clicks;
	long int imps;
	long int tclicks;
	long int timps;
	int method;
	/* HTML field taken out so there is not max length */
	//char html[500];
	char login[20];
	char passwd[20];
	char edate[15];
	char lreset[15];
	char ledited[15];
} binput,bsubmit;

struct client {
	long int ID;
	int lenabled;
	char name[40];
	char login[30];
	char contact[50];
	char company[30];
	char email[35];
	char address1[40];
	char address2[40];
	char city[20];
	char state[20];
	char country[35];
	char zip[15];
	char passwd[30];
	char phone[15];
	char comments[250];
} cinput,csubmit;

struct RENTRY {
	long int ID;
} rentry,centry,bentry;

struct realms {
	long int ID;
	char name[100];
	char bdate[15];
	long int clicks;
	long int imps;
} realms;

struct maxs {
	long int val;
} maxs;

struct config {
	char log_dir[500];
	char html_dir[500];
	char d_key[15];
	char ascript[200];
	char rscript[200];
	char sscript[200];
	char bandir[200];
	char banpath[200];
	char hpage[200];
	int httph;
	char sendmail[100];
	/* BETA TESTING ONLY */
	//char bdate[10];
	int tmout_period;
	// option for IP logging
	int iplogging;
} config;

struct admin {
	char login[50];
	char passwd[50];
	char llogin[100];
	time_t oldTime;
} admin,acheck;

struct dstats {
	long int ID;
	long int RID;
	char date[15];
	long int imps;
	long int clicks;
} dstats;
	
/* For daily IP Stats */
struct IPdstats
{
	char IP[35];
	char date[15];
	long int hits; // number of times this IP hit the rotation
} ipstats;

struct srvcfg {
	int status;
	char fullpath[200];
	char lstart[100];
	int port;
	int total_connections;
	char server[500];
} srvcfg;

struct remind {
	char sendmail[200];
	int imuch; // Percentage (not in percentage form!) of clicks left before reminding
	int dmuch; // Days left before reminding
	char aemail[50];
	char subject[50];
} remind;

/* End BWI Structures */

void parse_form(void);
void getfield(char * buf, char *s);
int getfasint(char *s);
void getms(char * buf, char *s);
int printfile_nocheck(char * filename);
void dump(char * filename);
int checkemail(char * addr);
void error(char * reason);
int LockFile(FILE *stream);
int UnlockFile(FILE *stream);
int check_field(char *field);
char *GetCurrentDate(void);
void NumToStr(unsigned num,char *str);
void RecordRealms(int id);
int LoadConfig(char *file);
char *getpath(char *argument);

void getword(char *word, char *line, char stop)
{
  int x, y;
  
  for(x = 0; ((line[x]) && (line[x] != stop)); x++)
    word[x] = line[x];
  
  word[x] = '\0';
  if (line[x])
    ++x;
  y=0;
  
  while (line[y++] = line[x++]);
}

char *makeword(char *line, char stop)
{
  int x,y;
  char *word = (char *) malloc(sizeof(char) * (strlen(line) + 1));
  
  for(x = 0; ((line[x]) && (line[x] != stop)); x++)
    word[x] = line[x];

  word[x] = '\0';
  if (line[x])
    ++x;
  y=0;
  
  while (line[y++] = line[x++]);
  
  return word;
}

char *fmakeword(FILE *f, char stop, int *cl)
{
  int wsize;
  char *word;
  int ll;
  
  wsize = 102400;
  ll=0;
  word = (char *) malloc(sizeof(char) * (wsize + 1));
  
  while (1)
    {
      word[ll] = (char)fgetc(f);
      if (ll==wsize)
        {
          word[ll+1] = '\0';
          wsize += 102400;
          word = (char *)realloc(word,sizeof(char)*(wsize+1));
        }
      --(*cl);
      if ((word[ll] == stop) || (feof(f)) || (!(*cl)))
        {
          if (word[ll] != stop)
            ll++;
          word[ll] = '\0';
          return word;
        }
      ++ll;
    }
}

char x2c(char *what)
{
  register char digit;
  
  digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
  digit *= 16;
  digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
  return (digit);
}

void unescape_url(char *url)
{
  register int x,y;
  
  for (x=0, y=0; url[y]; ++x, ++y)
    {
      if ((url[x] = url[y]) == '%')
        {
          url[x] = x2c(&url[y+1]);
          y+=2;
        }
    }
  url[x] = '\0';
}

void plustospace(char *str)
{
  register int x;
  
  for (x=0; str[x]; x++)
    if (str[x] == '+')
      str[x] = ' ';
}

int rind(char *s, char c)
{
  register int x;
  
  for (x = strlen(s) - 1; x != -1; x--)
    if(s[x] == c) return x;
  return -1;
}

int getline(char *s, int n, FILE *f)
{
  register int i=0;
  
  while(1)
    {
      s[i] = (char)fgetc(f);
      
      if (s[i] == CR)
        s[i] = fgetc(f);
      
      if ((s[i] == 0x4) || (s[i] == LF) || (i == (n-1)))
        {
          s[i] = '\0';
          return (feof(f) ? 1 : 0);
        }
      ++i;
    }
}

void send_fd(FILE *f, FILE *fd)
{
  int num_chars=0;
  char c;
  
  while (1)
    {
      c = fgetc(f);
      if(feof(f))
        return;
      fputc(c,fd);
    }
}

int ind(char *s, char c)
{
  register int x;
  
  for (x=0; s[x]; x++)
    if(s[x] == c)
      return x;
  
  return -1;
}

void escape_shell_cmd(char *cmd)
{
  register int x,y,l;
  
  l=strlen(cmd);
  for (x=0; cmd[x]; x++)
    {
      if (ind("&;`'\"|*?~<>^()[]{}$\\",cmd[x]) != -1)
        {
          for(y = l + 1; y > x; y--)
            cmd[y] = cmd[y-1];
          l++;
          cmd[x] = '\\';
          x++;
        }
    }
}
/* End NCSA's code */

void parse_form(void)
{
  register int x;
  int cl;
  char * qcl;
  
  
  if (getenv("REQUEST_METHOD") == NULL)
    {
      VIA_SHELL = 1;
      NUM_ENTRIES = 0;
    }
  else
    {
      VIA_SHELL = 0;

      if (strcmp(getenv("REQUEST_METHOD"),"POST") == 0)
        {
          if(strcmp(getenv("CONTENT_TYPE"),
                    "application/x-www-form-urlencoded"))
            {
              printf("Content-type: text/html\n\n");
              printf("<h1>Incorrect Type</h1>\n");
              printf("Type must be 'application/x-www-form-urlencoded'.\n");
              
              exit(0);
            }
          
          cl = atoi(getenv("CONTENT_LENGTH"));
          
          for (x = 0; cl && (!feof(stdin)); x++)
            {
              NUM_ENTRIES = x;
              strcpy(entries[x].val, fmakeword(stdin,'&',&cl));
              plustospace(entries[x].val);
              unescape_url(entries[x].val);
              strcpy(entries[x].name, makeword(entries[x].val,'='));
            }
        }
      else if (strcmp(getenv("REQUEST_METHOD"),"GET") == 0)
        {
          qcl = getenv("QUERY_STRING");
          if (qcl == NULL)
            exit(0);
          
          for (x = 0; qcl[0] != '\0'; x++)
            {
              NUM_ENTRIES = x;
              getword(entries[x].val, qcl, '&');
              plustospace(entries[x].val);
              unescape_url(entries[x].val);
              getword(entries[x].name, entries[x].val, '=');
            }
        }
      else
        {
          printf("Content-type: text/html\n\n");
          printf("<h1>Unknown method</h1>\n");
          printf("The form was submitted with an unknown method!\n");
          
          exit(0);
        }
    }
}

void getfield(char * buf, char *s)
{
  int x;
  
  strcpy(buf,"");
  
  if (VIA_SHELL == 0)
    {
      for (x = 0; x <= NUM_ENTRIES; x++)
        if (strcmp(entries[x].name,s) == 0)
          strcpy(buf,entries[x].val);
    }
  else
    {
		printf("bwe(input): \"%s\" ? ", s);
      fgets(buf, 512, stdin);
      buf[strlen(buf) - 1] = '\0';
    }
}

int getfasint(char *s)
{
  char buf[512];
  int x, v;
  
  v = 0;

  if (VIA_SHELL == 0)
    {
      for (x = 0; x <= NUM_ENTRIES; x++)
        if (strcmp(entries[x].name,s) == 0)
          v = atoi(entries[x].val);
    }
  else
    {
		printf("bwe(input): \"%s\" ? ", s);
      fgets(buf, 512, stdin);
      buf[strlen(buf) - 1] = '\0';
      v = atoi(buf);
    }
  
  return(v);
}

void getms(char * buf, char *s)
{
  int x;
  
 if (VIA_SHELL == 0)
    {
      for (x = 0; x <= NUM_ENTRIES; x++)
		  if (strcmp(entries[x].name,s) == 0) {
			 strcat(buf,entries[x].val);
			 strcat(buf,", ");
		  }
        else continue;
    }
  else
    {
		printf("bwe(input): \"%s\" ? ", s);
      fgets(buf, 512, stdin);
      buf[strlen(buf) - 1] = '\0';
	 }
}

int printfile_nocheck(char * filename)
{
  FILE * fi;
  int c;
  
  fi = fopen(filename, "r");
  if (fi == NULL)
    return(-1);
  else
    {
      do
        {
          c = fgetc(fi);
          if (c != EOF)
            fputc(c, stdout);
        }
      while (c != EOF);
      fclose(fi);
      
      return(0);
    }
}


/* Same as above, except check for stdout errors */

void dump(char * filename)
{
  if (printfile_nocheck(filename) == -1)
    {
      return;
    }
}

void error(char * reason)
{
	printf("Content-type:  text/html\n\n");
	printf("<font face=\"Arial\"><h1>Error</h1></font>\n");
	printf("<font face=\"Arial\">%s</font>\n", reason);

  exit(0);
}

int checkemail(char * addr)
{
  if (strchr(addr, '@') == NULL)
    return 0;
  
  if (addr[strlen(addr - 1)] == '@' ||
      addr[strlen(addr - 1)] == '.')
    return 0;
  
  if (strchr(strchr(addr, '@'), '.') == NULL)
    return 0;
  
  if (strchr(addr, ' ') != NULL)
    return 0;
  
  if (addr[0] == '@' || addr[0] == '.')
    return 0;
  
  return 1;
}

int LockFile(FILE *stream)
{
        if(flock(fileno(stream),LOCK_EX)==0)
                return 0;
        else {
		return 1;
        }
}
                
int UnlockFile(FILE *stream)
{
        if(flock(fileno(stream),LOCK_UN)==0)
                return 0;
        else {
		return 1;
        }
}

int check_field(char *field)
{
int i = 0;
 
        for(i = 0; i <= NUM_ENTRIES; i++) {
                if(strcmp(entries[i].name,field)==0 &&
		   strcmp(entries[i].val,"")!=0) {
                        return (1);
                }
        }
        return (0);
}

void NumToStr(unsigned num,char *str)
{
	str[0]=(num/10)+48;
	num=num%10;
	str[1]=num+48;
	str[2]='\0';
}

char *GetCurrentDate(void)
{
time_t TIME_T;
struct tm *TM;
char *Stime,temp[30];
char str[5];

	Stime=(char *)malloc(11);
	TIME_T=time(NULL);
	TM=localtime(&TIME_T);
	NumToStr((*TM).tm_mon+1,temp);
        strcpy(Stime,temp);
	strcat(Stime,"/");
	NumToStr((*TM).tm_mday,temp);
        strcat(Stime,temp);
	strcat(Stime,"/");
	sprintf(temp,"%s",ctime(&TIME_T));
	str[0]=temp[20],str[1]=temp[21];
	str[2]=temp[22],str[3]=temp[23];
	str[4]='\0';
	strcat(Stime,str);
	Stime[10]='\0';
	return Stime;
}

int LoadConfig(char *file)
{
FILE *conf;
char ffile[50];
char numdate[10];
long int cdate=0,bdate=0;
char *currdate;
int month=0,day=0,year=0;

	currdate=GetCurrentDate();
	sprintf(ffile,"config.ini");
	if((conf=fopen(file,"rb"))==NULL && (conf=fopen(ffile,"rb"))==NULL)
		return (0);
	fread(&config,sizeof(config),1,conf);
	fclose(conf);
	/* BETA TESTING ONLY */
	/*  create current date in an integer  */
	/*  format:  "yyyymmdd"  */
	/*numdate[0]=currdate[0],numdate[1]=currdate[1], numdate[2]=0;
	month=atol(numdate);
	numdate[0]=currdate[3],numdate[1]=currdate[4],numdate[2]=0;
	day=atol(numdate);
	numdate[0]=currdate[6],numdate[1]=currdate[7];
	numdate[3]=currdate[8],numdate[2]=currdate[9];
	numdate[4]='\0';
	year=atol(numdate);
	cdate=( (year * 365) + (month * 30) + day );*/
	/* now for the starting date -> long */
	/*numdate[0]=config.bdate[0],numdate[1]=config.bdate[1], numdate[2]=0;
	month=atol(numdate);
	numdate[0]=config.bdate[3],numdate[1]=config.bdate[4],numdate[2]=0;
	day=atol(numdate);
	numdate[0]=config.bdate[6],numdate[1]=config.bdate[7];
	numdate[3]=config.bdate[8],numdate[2]=config.bdate[9];
	numdate[4]='\0';
	year=atol(numdate);
	bdate=( (year * 365) + (month * 30) + day );
	if((cdate - bdate) >=30)
		error("Your 30 days are up.  Please contact <a href=\"mailto:  bwi@command-o.com\"><b>bwi@command-o.com</b></a> for more info!"),exit(1);*/
	return (1);
}

char *getpath(char *argument)
{
int i=0;

	for(i=strlen(argument); i>=0; i--) {
		if(argument[i-1]=='/') {
			argument[i]=0;
			break;
		}
	}
	return (argument);
}       	
