/***************************************************************************
                                  banner.c 
                             -------------------
    begin                : Mon Mar 20 2000
    copyright            : (C) 2000 by Eric Phillips - Command-O Software
    email                : eric@command-o.com
 ***************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <math.h>
#include "bwi.h"

#define FALSE 0
#define TRUE 1

FILE *bwi;
char file[300];
int loop=0;
char REALM[25];
char CLIENT[25];
long int max=0;
char *currdate;
int found=0;
long int total=0;
long int RID=0;
long int last=0;
time_t t;

void LoadRealm(char *rlm);		/*  Load realm information  */
void LoadClient(char *clt);		/*  Load client information  */
void CreditRealm(long int id);		/*  Give credit to the realm for showing banner */
void GetRBanner();			/*  Find a random account under the realm  */
void DumpBanner(long int id);		/*  Dump out the selected ad's contents (ie, the banner HTML)  */
void GetBanner(); 			/*  Find a random account under the default (entire) rotation  */
void CreditBanner(long int id);		/*  Give credit to the ad account for its display  */
void GetCBanner();			/*  Find a random account under the client  */
void DumpDefault(int which); 		/*  If some sort of error, dump the default ad  */
void DumpUserHTML(long int);

/*  Load realm information  */
void LoadRealm(char *rlm)
{
int found=0;

	/* open the Realms DB to load the realm we want */
	sprintf(file,"%srealms.bwi",config.log_dir);
	if((bwi=fopen(file,"rb"))==NULL)
		DumpDefault(1),exit(0);
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&realms,sizeof(realms),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* Names match! */
			if(strcmp(realms.name,rlm)==0) {
				found=TRUE;
				break;
			}
			else continue;
		}
	}
	fclose(bwi);
	if(found==TRUE)
		return;	
	else {
		printf("The <B>\"%s\"</B> realm could not be loaded!",REALM);
		exit(0);
	}
}

/*  Load client information  */
void LoadClient(char *clt)
{
	found=FALSE;
	/* open the Client's DB to load the client we want */
	sprintf(file,"%sclients.bwi",config.log_dir);
	if((bwi=fopen(file,"rb"))==NULL)
		DumpDefault(2),exit(0);
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&cinput,sizeof(cinput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* names match! */
			if(strcmp(clt,cinput.name)==0) {
				found=TRUE;
				break;
			}
			else continue;
		}
	}
	fclose(bwi);
	if(found==TRUE)
		return;
	else printf("The <B>\"%s\"</B> client could not be loaded!",CLIENT),exit(0);
}

/*  Give credit to the realm for showing banner  */
void CreditRealm(long int id)
{
	/* open the Realm's DB, and credit the Realm */
	/* for the ad they just showed */
	sprintf(file,"%srealms.bwi",config.log_dir);
	if((bwi=fopen(file,"rb+"))==NULL)
		DumpDefault(3),exit(0);
	LockFile(bwi);
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&realms,sizeof(realms),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* found the realm */
			if(realms.ID==id) {
				/* add to their exposures */
				realms.imps++;
				fseek(bwi,ftell(bwi)-sizeof(realms),SEEK_SET);
				fwrite(&realms,sizeof(realms),1,bwi);
			}
			else continue;
		}
	}
	UnlockFile(bwi);
	fclose(bwi);
	return;
}

/*  Find a random account under the realm  */
void GetRBanner()
{
long int count=0;

	/* add to total.  This is a securtiy */
	/* feature so that the program will only */
	/* try the rotation so many times */
	total++;
	RID=0;
	currdate=GetCurrentDate();
	max=0;
	/* open the realm's random file */
	sprintf(file,"%sR%ld.rlm",config.log_dir,realms.ID);
	bwi=fopen(file,"rb");
	/*  read the number that holds the max number of ads under this realm  */
	fread(&max,sizeof(long),1,bwi);
	fclose(bwi);
	/*  If we have gone through the rotation 5 times and found nothing,  */
	/*  or there are no ad accounts under this realm, then dump the  */
	/*  default banner  */
	if(total==(5*max) || max<=0) {
		DumpDefault(4);
		exit(0);
	}
	/*  Select the random number from the rand() random number generator  */
	RID=(rand()%max)+1;
	/*  Now lets open the DB and find the account in the RID place in the */
	/*  DB.  For example, if RID==3, then we'd use the 3rd accounts  */
	bwi=fopen(file,"rb");
	fseek(bwi,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&rentry,sizeof(rentry),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			count++;
			/*  Found it!  */
			if(count==RID) 
				break;
			else continue;
		}
	}
	fclose(bwi);
	/*  Dump the ads contents to the browser  */
	DumpBanner(rentry.ID);
	return;
}

/*  Dump out the selected ad's contents (ie, the banner HTML)  */
void DumpBanner(long int id)
{
char numdate[15];
long int cdate=0;
long int edate=0;
long int bdate=0;
long int CID=0;
long int last=0;
 
	sprintf(file,"%sbanners.bwi",config.log_dir);
	if((bwi=fopen(file,"rb+"))==NULL)
		DumpDefault(5),exit(0);
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/*  Found ad, now let's see if it's eligible to be shown  */
			if(binput.ID==id) {
				/*  create current date in an integer  */
				/*  format:  "yyyymmdd"  */
				numdate[0]=currdate[6],numdate[1]=currdate[7];
				numdate[2]=currdate[8],numdate[3]=currdate[9];
				numdate[4]=currdate[0],numdate[5]=currdate[1];
				numdate[6]=currdate[3],numdate[7]=currdate[4];
				numdate[8]='\0',cdate=atol(numdate);
				
				/*  create expiration date in an integer  */
				/*  format:  "yyyymmdd"  */
				numdate[0]=binput.edate[6],numdate[1]=binput.edate[7];
				numdate[2]=binput.edate[8],numdate[3]=binput.edate[9];
				numdate[4]=binput.edate[0],numdate[5]=binput.edate[1];
				numdate[6]=binput.edate[3],numdate[7]=binput.edate[4];
				numdate[8]='\0',edate=atol(numdate);
				
				/*  create start date in an integer  */
				/*  format:  "yyyymmdd"  */
				numdate[0]=binput.bdate[6],numdate[1]=binput.bdate[7];
				numdate[2]=binput.bdate[8],numdate[3]=binput.bdate[9];
				numdate[4]=binput.bdate[0],numdate[5]=binput.bdate[1];
				numdate[6]=binput.bdate[3],numdate[7]=binput.bdate[4];
				numdate[8]='\0',bdate=atol(numdate);
				
				/*  Now let's test to see what kind of account it is,  */
				/*  and by that see if it's eligible  */
				/*  Key:  */
				/*  Type  */
				/*  ====  */
				/*  1 = "Maximum Exposures Reached"  */
				/*  2 = "Unlimited Exposures"  */
				/*  3 = "Unlimited Exposures Until End Date"  */
				/*  4 = "Maximum Clicks Reached"  */
				/*=============================================*/
				/*  Method  */
				/*  ======  */
				/*  1 = "Use Set Image Parameters"  */
				/*  2 = "Use HTML"  */
				/*  3 = "Use Both"  */
				/*=============================================*/
				
				
				/*  NOTE:  Bonus impressions are free exposures and clicks, and they  */
				/*  will be taken before anything, even if the account otherwise is  */
				/*  inactive  */
				
				/*  If ad is unlimited exposures, or is unlimited exposures and has  */
				/*  some bonus credits  */
				if(binput.type==2 || (binput.bonus>0 && binput.type==2)) {
					/*  If ad is just a banner, or if ad is both banner + HTML  */
					if(binput.method==1 || binput.method==3) {
						printf("<a href=\"%s?ID=%ld&RID=%ld\" %s><img src=\"%s%s\" %s border=%d",config.rscript,binput.ID,realms.ID,binput.lother,config.bandir,binput.bfile,binput.iother,binput.border);
						printf(" width=%d height=%d alt=\"%s\"><br>%s</a>",binput.width,binput.height,binput.alt,binput.ltext);
					}
					/*  If ad is just HTML  */
					if(binput.method==2 || binput.method==3)
						DumpUserHTML(binput.ID);
					/*  Hold the ID of the ad in CID, for later use with stats  */
					CID=binput.ID;
					found=TRUE;
					break;
				}
				/*  If ad is maximum exposures and their max exposures is greater than  */
				/*  their total exposures, or if the ad is maximum exposures and they  */
				/*  have any bonus credits  */
				if(binput.type==1 && binput.max>binput.timps  || (binput.bonus>0 && binput.type==1)) {
					/*  If ad is just a banner, or if ad is both banner + HTML  */
					if(binput.method==1 || binput.method==3) {
						printf("<a href=\"%s?ID=%ld&RID=%ld\" %s><img src=\"%s%s\" %s border=%d",config.rscript,binput.ID,realms.ID,binput.lother,config.bandir,binput.bfile,binput.iother,binput.border);
						printf(" width=%d height=%d alt=\"%s\"><br>%s</a>",binput.width,binput.height,binput.alt,binput.ltext);
					}
					/*  If ad is just HTML  */
					if(binput.method==2 || binput.type==3)
						DumpUserHTML(binput.ID);
					/*  Hold the ID of the ad in CID, for later use with stats  */
					CID=binput.ID;
					found=TRUE;
					break;
				}
				/*  If ad ends by date and the current date is BEFORE the end date and the start date  */
				/*  is BEFORE the current date, or has bonus credits  */
				if(binput.type==3 && cdate<edate  && bdate<cdate  || (binput.bonus>0 && binput.type==3)) {
					/*  If ad is just a banner, or if ad is both banner + HTML  */
					if(binput.method==1 || binput.method==3) {
						printf("<a href=\"%s?ID=%ld&RID=%ld\" %s><img src=\"%s%s\" %s border=%d",config.rscript,binput.ID,realms.ID,binput.lother,config.bandir,binput.bfile,binput.iother,binput.border);
						printf(" width=%d height=%d alt=\"%s\"><br>%s</a>",binput.width,binput.height,binput.alt,binput.ltext);
					}
					/*  If ad is just HTML  */
					if(binput.method==2 || binput.method==3)
						DumpUserHTML(binput.ID);
					/*  Hold the ID of the ad in CID, for later use with stats  */
					CID=binput.ID;
					found=TRUE;
					break;
				}
				/*  If ad ends on max clicks and the total clicks is less than max clicks, or has  */
				/*  bonus impressions  */
				if(binput.type==4 && binput.tclicks<binput.max  || (binput.bonus>0 && binput.type==4)) {
					/*  If ad is just a banner, or if ad is both banner + HTML  */
					if(binput.method==1 || binput.method==3) {
						printf("<a href=\"%s?ID=%ld&RID=%ld\" %s><img src=\"%s%s\" %s border=%d",config.rscript,binput.ID,realms.ID,binput.lother,config.bandir,binput.bfile,binput.iother,binput.border);
						printf(" width=%d height=%d alt=\"%s\"><br>%s</a>",binput.width,binput.height,binput.alt,binput.ltext);
					}
					/*  If ad is just HTML  */
					if(binput.method==2 || binput.type==3)
						DumpUserHTML(binput.ID);
					/*  Hold the ID of the ad in CID, for later use with stats  */
					CID=binput.ID;
					found=TRUE;
					break;
				}
			}
		}
	}
	UnlockFile(bwi);
	fclose(bwi);
	/*  If the ad was found and was eligible, give it credit  */
	if(found==TRUE)
		CreditBanner(CID);
	return;
}

/*  Find a random account under the default (entire) rotation  */
void GetBanner()
{
char numdate[15];
long int cdate=0;
long int edate=0;
long int bdate=0;
long int last=0;
long int CID=0;
int count=0;

	total++;
	RID=0;
	currdate=GetCurrentDate();
	max=0;
	/*  Open the random number file, then read the max  */
	/*  number of ads there are  */
	sprintf(file,"%srandom.bwi",config.log_dir);
	if((bwi=fopen(file,"rb"))==NULL)
		DumpDefault(6),exit(0);
	fread(&max,sizeof(long),1,bwi);
	fclose(bwi);
	/*  If we've gone through the total rotation 5 times,  */
	/*  or there are no accounts, dump the default banner  */
	if(total==(5*max) || max<=0) {
		DumpDefault(7);
		exit(0);
	}
	/*  Generate random number with rand() random number generator  */
	RID=(rand()%max)+1;
	bwi=fopen(file,"rb");
	fseek(bwi,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&centry,sizeof(centry),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			count++;
			/*  Found it!  */
			if(RID==count)
				break;
			else continue;
		}
	}
	fclose(bwi);
	/*  Dump the ad to the browser  */
	DumpBanner(centry.ID);
	return;
}

/*  Give credit to the ad account for its display  */
void CreditBanner(long int id)
{
char buf[10];
int month=0;
int year=0,found=0;

	sprintf(file,"%sbanners.bwi",config.log_dir);
	if((bwi=fopen(file,"rb+"))==NULL)
		DumpDefault(8),exit(0);
	LockFile(bwi);
	fseek(bwi,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/*  Found the account we want to credit, now let's  */
			/*  credit  */
			if(binput.ID==id) {
				/*  If any bonus credits available, as long  */
				/*  as the account is not end by max clicks,  */
				/*  subtract a bonus credit  */
				if(binput.bonus>0 && binput.type!=4)
					--binput.bonus;
				/*  Add to the total exposures, and current exposures  */
				++binput.timps, ++binput.imps;
				/*  Write new stats back to file  */
				fseek(bwi,ftell(bwi)-sizeof(binput),SEEK_SET);
				fwrite(&binput,sizeof(binput),1,bwi);
			}
			else continue;
		}
	}
	UnlockFile(bwi);
	fclose(bwi);
	return;
}

/*  Find a random account under the client  */                              
void GetCBanner()
{
long int count=0;

	total++;
	RID=0;
	currdate=GetCurrentDate();
	max=0;
	sprintf(file,"%sC%ld.clt",config.log_dir,cinput.ID);
	if((bwi=fopen(file,"rb"))==NULL)
		DumpDefault(9),exit(0);
	/*  read the number that holds the max number of ads under this client  */
	fread(&max,sizeof(long),1,bwi);
	fclose(bwi);
	/*  If we have gone through the rotation 5 times and found nothing,  */
	/*  or there are no ad accounts under this client, then dump the  */
	/*  default banner  */
	if(total==(5*max) || max<=0) {
		DumpDefault(10);
		exit(0);
	}
	/*  Select the random number from the rand() random number generator  */
	RID=(rand()%max)+1;
	/*  Now lets open the DB and find the account in the RID place in the */
	/*  DB.  For example, if RID==3, then we'd use the 3rd account  */
	bwi=fopen(file,"rb");
	fseek(bwi,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&centry,sizeof(centry),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			count++;
			/*  Found it!  */
			if(RID==count)
				break;
			else continue;
		}
	}
	fclose(bwi);
	/*  Dump the ads contents to the browser  */
	DumpBanner(centry.ID);
	return;
}

/*  If some sort of error, dump the default ad  */
void DumpDefault(int which)
{
	sprintf(file,"%sdefault.bwi",config.log_dir);
	/*  If we can't open default.bwi, we can go no further, so  */
	/*  we have this ugly error  */
	if((bwi=fopen(file,"rb+"))==NULL)
		error("Fatal I/O error!");
	LockFile(bwi);
	fread(&binput,sizeof(binput),1,bwi);
	/*  Credit the default banner for the impression  */
	binput.timps++;
	rewind(bwi);
	fwrite(&binput,sizeof(binput),1,bwi);
	/*  Dump out the hidden error number (to debug the error)  */
	printf("\n\n<!-- Error #:  %d -->\n",which);
	/*  Now dump the default ad  */
	printf("<a href=\"%s?ID=0\" %s><img src=\"%s%s\" %s border=%d",config.rscript,binput.lother,config.bandir,binput.bfile,binput.iother,binput.border);
	printf(" width=%d height=%d alt=\"%s\"><br>%s</a>",binput.width,binput.height,binput.alt,binput.ltext);
	UnlockFile(bwi);
	fclose(bwi);
	return;
}

void DumpUserHTML(long int id)
{
FILE * fi;
int c;
  
	sprintf(file,"%sB%ld.html",config.log_dir,id);
  fi = fopen(file, "r");
  if (fi == NULL)
    error("Could not load user's HTML data!"),exit(1);
  else
    {
      do
        {
          c = fgetc(fi);
          if (c != EOF)
            fputc(c, stdout);
        }
      while (c != EOF);
      fclose(fi);
      
      return;
  	}		
}

int main(int argc, char *argv[])
{
int i=0;
char temp[10];

	parse_form();
	sprintf(file,"%sconfig.ini",getpath(argv[0]));
	LoadConfig(file);
	srand((unsigned)time(&t));
	if(config.httph==1)
		printf("Content-type:  text/html\n\n");
	if(argc>=2) {
		for(i=0; i<=strlen(argv[1]); i++) {
			if(argv[1][i]==':')
				break;
			else temp[i]=argv[1][i];
		}
		temp[i]=0;
		/*  If a realm was requested  */
		if(strcasecmp(temp,"realm")==0) {
			sprintf(REALM,"%s",&argv[1][++i]);
			/*  Watch for spaces in the realm  */
			for(i=2; i<=argc-1; i++) {
				strcat(REALM," ");
				strcat(REALM,argv[i]);
			}
			LoadRealm(REALM);
			/*  Give credit to the realm for the exposure  */
			CreditRealm(realms.ID);
			LoadRealm(REALM);
			sprintf(file,"%sR%ld.rlm",config.log_dir,realms.ID);
			if((bwi=fopen(file,"rb"))==NULL)
				printf("Could not load the <b>\"%s's\"</b> entries!<br>",REALM),exit(0);
			fclose(bwi);
			found=0;
			/*  In this loop until we find an eligible banner.  If  */
			/*  we go through the rotation 5 times or more, the  */
			/*  default banner is shown  */
			while(found==0)
				GetRBanner();
			exit(0);
		}
		/*  If a client was requested  */
		if(strcasecmp(temp,"client")==0) {
			sprintf(CLIENT,"%s",&argv[1][++i]);
			/*  Watch for spaces in the client  */
   		for(i=2; i<=argc-1; i++) {
      	strcat(CLIENT," ");
        strcat(CLIENT,argv[i]);
      }
			LoadClient(CLIENT);
			found=0;
			/*  In this loop until we find an eligible banner.  If  */
			/*  we go through the rotation 5 times or more, the  */
			/*  default banner is shown  */
			while(found==0)
				GetCBanner();
			exit(0);
		}
		/*  Entire rotation was requested  */
		else {
			found=0;
			/*  In this loop until we find an eligible banner.  If  */
			/*  we go through the rotation 5 times or more, the  */
			/*  default banner is shown  */
			while(found==0)
				GetBanner();
			exit(0);
		}
	}
	/*  No arguments to the program, so just go with the entire rotation  */
	else {
		found=0;
		/*  In this loop until we find an eligible banner.  If  */
		/*  we go through the rotation 5 times or more, the  */
		/*  default banner is shown  */
		while(found==0)
			GetBanner();
		exit(0);
	}
}
