/***************************************************************************
                          badmin.c  -  description
                             -------------------
    begin                : Sun Aug 20 2000
    copyright            : (C) 2000 by Eric Phillips
    email                : eric@command-o.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/stat.h>
#include <errno.h>
#include "bwi.h"

void CheckPasswd();					/* check and log login information */
void PrintFile(char*);					/* print a file to the browser, parsing certain flags */
void DeleteBanner(long int);				/* delete an ad from the entire DB */
void DeleteClient(long int);				/* delete a client (and export it's ads) form the entire DB */
void DeleteRealm(long int);				/* delete a realm from the entire DB */
void SaveBanner();					/* add a new banner */
void PrintCharts();					/* dump out the "View Charts" command */
void MainStuff();					/* used for printing out the client list(s) */
void MainStuff2(int);					/* used for printing out the ads list(s) */
void LoadBanner(long int);				/* load an ad's info into memory */
void LoadClient(long int);				/* load a client's info into memory */
void LoadRealm(long int);				/* load a realm's info into memory */
void PrintMonths(long int,char*,int);			/* print the selection lists for months (and select if required) */
void PrintDays(long int,char*,int);			/* print the selection lists for days (and select if required) */
void PrintYears(long int,char*,int);			/* print the selection lists for years (and select if required) */
void DumpRealms();					/* dump out the realms list(s) */
void SaveRealm();					/* add a new realm */
void SaveClient();					/* add a new client */
void UpdateClient();					/* modify a client */
void UpdateBanner();					/* modify an ad */
void EnableBanner(long int);				/* enable an ad in the rotation */
void DumpBanners();					/* dump the banner list(s) in "Define Realms" */
void DumpIBanners();					/* dump the banner list(s) in "Define Realms", and select */ 
void UpdateRealm(long int);				/* modify a realm */
void DumpStats();					/* dump the "View Stats" command */
void ResetCount(long int);				/* reset the current count on the ad */
void DumpRStats();					/* dump the "View Realms Stats" command */
void DumpFiles();					/* dump the list of files in the banner dir, and select item if in memory */
void DupFile();						/* duplicate file */
void CheckRotations();					/* check all rotation files to make sure they are aligned correctly */
void Maintain(char *);					/* if the rotation file isn't aligned correctly, fix it */
void PrintConfigFile(char *);				/* print a file to the browser, parsing certain flags */
void SaveConfig();					/* save new configuration */
void PrintDefault();					/* dump out the default banner modify form */
void LoadDefault();                                     /* load the default banner's info into memory */
void UpdateDBanner();					/* modify default banner */
void PrintAdmPass();					/* print out the change admin passwd form */
void SaveAdmPass();					/* save the admin login information */
void ResetDBs();					/* re-align all DBs so that they are all reset */
void DumpMonths(char *);				/* dump all monthly stats available */
void DumpYears(char *);					/* dump all years available */
void SaveReminderEmail();				/* save all Reminder Email Information into "remind.msg" */
void DisableBanner(long int);				/* automatically disable banner */
int CheckCDisabled(long int,int);			/* check if the client has any disable banners */
int HasBanners(long int);				/* checks if the client has any banners */
int HasDisableBanners(long int);			/* checks all clients for any disabled banners */
void DumpExportBanners(long int);			/* dump the export banners form for the client */
void DoExportBans(long int);				/* do the actual exporting */
void FixRandomFiles(long int,long int,long int);	/* fix the random file(s) from the old client to the new one */
void PrintMainPageStats();
void PrintTodaysStats(long int cid);
long int GetTodaysImps(long int bid);
long int GetTodaysClicks(long int bid);
void PrintStatsFile(char *);
void DumpGraphStats(long int id);
int IsEnabled();
void DumpUserHTML(long int);
void SaveUserHTML(long int);
void PrintIPLogs();

/* define the max number of years we want to hold (as for summarizing stats) */
#define MAX_YEARS 50
#define TRUE 1
#define FALSE 0

FILE *bwi;						/* file pointer globally used for file administration */
FILE *mailer;						/* file pointer for sendmail program */
char file[500];						/* char array used for specifying filenames */
int loop=0;						/* variable used to tell when we've reached EOF */
long int ID=0;						/* variable used to hold the ID of certain BWI objects */
long int max=0;						/* variable to read the max # at the beginning of certain DBs */
char passwd[100];					/* variable used to hold the admin password */
char login[100];					/* variable used to hold the admin login */
char llogin[100];					/* variable used to hold the last time logged in */
int iloop=0;						/* yet another variable used to tell when we've reached EOF */
char *currdate;						/* variable used to determine current date (format:  mm/dd/yyyy) */
int firstl=0;						/* variable used to determine if this is the first time loggin in */
char flag[100];						/* variable used to determine the function called to the program */
char cmd[100];						/* yet another variable used to determine the function called to the program */
long int many=0;					/* used in the mailing */

/* check and log login information */
void CheckPasswd()
{
FILE *pass;
char temp[50];
time_t t;
struct tm *ttm;
char lcurtime[100];

	t=time(NULL);
	/* gather current time and date */
	ttm=localtime(&t);
	/* get login information from browser */
	getfield(acheck.passwd,"passwd");
	getfield(acheck.login,"login");
	sprintf(file,"%spasswd",config.log_dir);
	/* if we can't open the file, and there is a command, return */
	if((pass=fopen(file,"rb"))==NULL && strcmp(cmd,"")!=0)
   		return;
   	/* if we CAN open the file and there ISN'T a command, print the config form */
	if((pass=fopen(file,"rb"))==NULL && strcmp(cmd,"")==0) {
		printf("Content-type:  text/html\n\n");
		sprintf(file,"bconfig.html");
		PrintConfigFile(file);
		exit(0);
	}
	/* read the admin information into memory */
	fread(&admin,sizeof(admin),1,pass);
	fclose(pass);
	/* now let's check if the user hasn't done anything */
	/* in 15 minutes (ie, 15 * 60) */
	if(strcmp(flag, "printre-login")==0 && config.tmout_period!=0)
	{
		printf("Content-type:  text/html\n\n");
		sprintf(file,"%sbslogin.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(flag, "login")!=0 && strcmp(flag, "re-login")!=0 && difftime(t, admin.oldTime) > (config.tmout_period * 60)  && config.tmout_period!=0 && strcasecmp((char*)getenv("REQUEST_METHOD"),"get")==0)
	{
	char *qs;
		
		strcpy(login, admin.login);
		strcpy(passwd, "");	
		qs = (char*) getenv("REQUEST_URI");
		printf("Content-type:  text/html\n\n");
		printf("<title>Login expired - please re-login</title>\n");
		printf("<script language=\"JavaScript\">\n");
		printf("var popupWindow;\n\n");
		printf("popupWindow=window.open(\"http://%s%s&flag=printre-login\",\"bwismpu\",\"status=no,width=375,height=150\");\n",(char*)getenv("SERVER_NAME"),qs);
    printf("if (popupWindow.opener == null ) {\n");
    printf("\tpopupWindow.opener = self;\n");
    printf("}\n</script>\n\n");
		exit(0);
	} 
	/* if all login information is correct */
	if(strcmp(admin.passwd,(char*)crypt(acheck.passwd,config.d_key))==0 && strcmp(acheck.login,admin.login)==0 && strcmp(flag,"login")==0 || strcmp(flag,"re-login")==0) {
		/* activate first login variable */
		firstl=TRUE;
		/* copy login information into global variabled */
		strcpy(passwd,admin.passwd);
		strcpy(login,admin.login);
		strcpy(llogin,admin.llogin);
		admin.oldTime = t;
		/* now let's write back the updated login info (last time logged in)*/
		/* since there's only one entry in this file, we can just open it as "wb" */
		sprintf(file,"%spasswd",config.log_dir);
		pass=fopen(file,"wb");
		LockFile(pass);
		sprintf(admin.llogin,"%s",asctime(ttm));
		fwrite(&admin,sizeof(admin),1,pass);
		UnlockFile(pass);
		fclose(pass);
		return;
	}
	if(strcmp(admin.passwd,acheck.passwd)==0 && strcmp(acheck.login,admin.login)==0 && strcmp(flag,"login")!=0) {
		/* activate first login variable */
		firstl=TRUE;
		/* copy login information into global variabled */
		strcpy(passwd,admin.passwd);
		strcpy(login,admin.login);
		strcpy(llogin,admin.llogin);
		admin.oldTime = t;
		/* now let's write back the updated login info (last time logged in)*/
		/* since there's only one entry in this file, we can just open it as "wb" */
		sprintf(file,"%spasswd",config.log_dir);
		pass=fopen(file,"wb");
		LockFile(pass);
		sprintf(admin.llogin,"%s",asctime(ttm));
		fwrite(&admin,sizeof(admin),1,pass);
		UnlockFile(pass);
		fclose(pass);
		return;
	}
	/* if the login information ISN'T correct */
	else error("Incorrect admin login information!  Access is denied!");
}

/* print a file to the browser, parsing certain flags */
void PrintFile(char *fileid)
{
char filedone;
char filedata;
FILE *fp;
int iloop;
char next;

	/* set filedone to FALSE, therefore when it is TRUE, we've reached EOF */
	filedone=FALSE;
	fp=fopen(fileid,"rb");
        if(fp!=NULL) {
		while(filedone==FALSE) {
			filedata=fgetc(fp);
			if(!feof(fp)) {
				/* if the char is not the beginning of a flag in the file, print it out */
				if(filedata!='|')
					printf("%c",filedata);
				/* if it is the beginning of a flag, let's determine which flag */
				else {
					filedata=fgetc(fp);
					if(filedata=='u')
						PrintMainPageStats();
					if(filedata=='C')
						printf("%s",config.ascript);
					if(filedata=='y')
						printf("%ld",binput.bonus);
					if(filedata=='P')
						printf("%s",passwd);
					if(filedata=='L')
						printf("%s",login);
					if(filedata=='I' && firstl==1)
						printf("<font face=\"Verdana\"><small><small><b>%s</b> successfully logged in.  Last login:  %s</font></small></small><p>",login,llogin);
					if(filedata=='Q')
						MainStuff();
					if(filedata=='e')
						DumpExportBanners(cinput.ID);
					if(filedata=='Z') {
						filedata=fgetc(fp);
						if(filedata=='1')
							MainStuff2(1);
						if(filedata=='2')
							MainStuff2(2);
						if(filedata=='3') {
							sprintf(file,"%sclients.bwi",config.log_dir);
							bwi=fopen(file,"rb");
							loop=0;
							fseek(bwi,sizeof(long),SEEK_SET);
							while(loop==0) {
								fread(&cinput,sizeof(cinput),1,bwi);
								if(feof(bwi)) loop=1;
								else {
									if(CheckCDisabled(cinput.ID,1)) {
										if(ID==cinput.ID) printf("<option value=\"%ld\" selected>%s",cinput.ID,cinput.name);
										if(ID!=cinput.ID) printf("<option value=\"%ld\">%s",cinput.ID,cinput.name);
									}
									else continue;
								}
							}
							fclose(bwi);
						}
						if(filedata=='4') {
							sprintf(file,"%sclients.bwi",config.log_dir);
							bwi=fopen(file,"rb");
							loop=0;
							fseek(bwi,sizeof(long),SEEK_SET);
							while(loop==0) {
								fread(&cinput,sizeof(cinput),1,bwi);
								if(feof(bwi)) loop=1;
								else {
									if(CheckCDisabled(cinput.ID,2)) {
										if(ID==cinput.ID) printf("<option value=\"%ld\" selected>%s",cinput.ID,cinput.name);
										if(ID!=cinput.ID) printf("<option value=\"%ld\">%s",cinput.ID,cinput.name);
									}
									else continue;
								}
							}
							fclose(bwi);
						}
						if(filedata=='5') {
							sprintf(file,"%sclients.bwi",config.log_dir);
							bwi=fopen(file,"rb");
							loop=0;
							fseek(bwi,sizeof(long),SEEK_SET);
							while(loop==0) {
								fread(&cinput,sizeof(cinput),1,bwi);
								if(feof(bwi)) loop=1;
								else {
									if(HasBanners(cinput.ID)) {
										if(ID==cinput.ID) printf("<option value=\"%ld\" selected>%s",cinput.ID,cinput.name);
										if(ID!=cinput.ID) printf("<option value=\"%ld\">%s",cinput.ID,cinput.name);
									}
									else continue;
								}
							}
							fclose(bwi);
						}	
					}
					if(filedata=='E') {
						filedata=fgetc(fp);
						if(filedata=='a')
							printf("%ld",binput.ID);
						if(filedata=='b')
							printf("%s",binput.bdate);
						if(filedata=='c')
							printf("%s",binput.bfile);
						if(filedata=='d')
							printf("%d",binput.width);
						if(filedata=='e')
							printf("%d",binput.height);
						if(filedata=='f')
							printf("%d",binput.border);
						if(filedata=='g')
							printf("%s",binput.ltext);
						if(filedata=='h')
							printf("%s",binput.alt);
						if(filedata=='i')
							printf("%s",binput.url);
						if(filedata=='j')
							printf("%s",binput.iother);
						if(filedata=='k')
							printf("%s",binput.lother);
						if(filedata=='l')
							DumpUserHTML(binput.ID);
						if(filedata=='m') {
							if(binput.method==1) {
								printf("<select NAME=\"method\" size=\"1\"><option value=\"1\" selected>Use Image Parameters Set Below</option>");
								printf("<option value=\"2\">Use HTML Ad Entered Below</option>");
								printf("<option value=\"3\">Use Both the Image and the HTML</option></select>");
							}
							if(binput.method==2) {
								printf("<select NAME=\"method\" size=\"1\"><option value=\"1\">Use Image Parameters Set Below</option>");
								printf("<option value=\"2\" selected>Use HTML Ad Entered Below</option>");
								printf("<option value=\"3\">Use Both the Image and the HTML</option></select>");
							}
							if(binput.method==3) {
								printf("<select NAME=\"method\" size=\"1\"><option value=\"1\">Use Image Parameters Set Below</option>");
								printf("<option value=\"2\">Use HTML Ad Entered Below</option>");
								printf("<option selected value=\"3\">Use Both the Image and the HTML</option></select>");
							}
						}
						if(filedata=='n')
							printf("%ld",binput.bonus);
						if(filedata=='3')
							PrintMonths(binput.ID,binput.edate,2);
						if(filedata=='4')
							PrintDays(binput.ID,binput.edate,2);
						if(filedata=='5')
							PrintYears(binput.ID,binput.edate,2);
						if(filedata=='0')
							PrintMonths(binput.ID,binput.bdate,1);
						if(filedata=='1')
							PrintDays(binput.ID,binput.bdate,1);
						if(filedata=='2')
							PrintYears(binput.ID,binput.bdate,1);
						if(filedata=='o') {
							if(binput.type==1) {
								printf("<select name=\"type\" size=\"1\">");
								printf("<option value=\"1\" selected>Maximum Exposures Reached</option>");
								printf("<option value=\"3\">Unlimited Exposures Until End Date</option>");
								printf("<option value=\"2\">Unlimited Exposures</option>");
								printf("<option value=\"4\">Maximum Clicks Reached</select>");
							}
							if(binput.type==2) {
								printf("<select name=\"type\" size=\"1\">");
								printf("<option value=\"1\">Maximum Exposures Reached</option>");
								printf("<option value=\"3\">Unlimited Exposures Until End Date</option>");
								printf("<option value=\"2\" selected>Unlimited Exposures</option>");
								printf("<option value=\"4\">Maximum Clicks Reached</select>");
							}
							if(binput.type==3) {
								printf("<select name=\"type\" size=\"1\">");
								printf("<option value=\"1\">Maximum Exposures Reached</option>");
								printf("<option value=\"3\" selected>Unlimited Exposures Until End Date</option>");
								printf("<option value=\"2\">Unlimited Exposures</option>");
								printf("<option value=\"4\">Maximum Clicks Reached</select>");
							}
							if(binput.type==4) {
								printf("<select name=\"type\" size=\"1\">");
								printf("<option value=\"1\">Maximum Exposures Reached</option>");
								printf("<option value=\"3\" selected>Unlimited Exposures Until End Date</option>");
								printf("<option value=\"2\">Unlimited Exposures</option>");
								printf("<option value=\"4\" selected>Maximum Clicks Reached</select>");
							}
						}
						if(filedata=='p') {
							printf("%s",binput.name);
							continue;
						}
						if(filedata=='q') {
							printf("<select name=\"ratio\">");
							if(binput.ratio==1) printf("<option value=1 selected>1:1");
							if(binput.ratio==2) printf("<option value=2 selected>2:1");
							if(binput.ratio==3) printf("<option value=3 selected>3:1");
							if(binput.ratio==4) printf("<option value=4 selected>4:1");
							if(binput.ratio==5) printf("<option value=5 selected>5:1");
							if(binput.ratio==6) printf("<option value=6 selected>6:1");
							if(binput.ratio==7) printf("<option value=7 selected>7:1");
							if(binput.ratio==8) printf("<option value=8 selected>8:1");
							if(binput.ratio==9) printf("<option value=9 selected>9:1");
							if(binput.ratio==10) printf("<option value=10 selected>10:1");
							if(binput.ratio==15) printf("<option value=15 selected>15:1");
							if(binput.ratio==25) printf("<option value=25 selected>25:1");
							if(binput.ratio==50) printf("<option value=50 selected>50:1");
							if(binput.ratio==100) printf("<option value=100 selected>100:1");
							if(binput.ratio==500) printf("<option value=500 selected>500:1");
							if(binput.ratio!=1) printf("<option value=1>1:1");
							if(binput.ratio!=2) printf("<option value=2>2:1");
							if(binput.ratio!=3) printf("<option value=3>3:1");
							if(binput.ratio!=4) printf("<option value=4>4:1");
							if(binput.ratio!=5) printf("<option value=5>5:1");
							if(binput.ratio!=6) printf("<option value=6>6:1");
							if(binput.ratio!=7) printf("<option value=7>7:1");
							if(binput.ratio!=8) printf("<option value=8>8:1");
							if(binput.ratio!=9) printf("<option value=9>9:1");
							if(binput.ratio!=10) printf("<option value=10>10:1");
							if(binput.ratio!=15) printf("<option value=15>15:1");
							if(binput.ratio!=25) printf("<option value=25>25:1");
							if(binput.ratio!=50) printf("<option value=50>50:1");
							if(binput.ratio!=100) printf("<option value=100>100:1");
							if(binput.ratio!=500) printf("<option value=500>500:1");
							printf("</select>");
						}
					}
					if(filedata=='p')
						printf("%s",realms.name);
					if(filedata=='z') {
						printf("<select name=\"max\">\n");
						printf("\t<option %s>1000\n",binput.max==1000 ? "selected":"");
						printf("\t<option %s>2500\n",binput.max==2500 ? "selected":"");
						printf("\t<option %s>5000\n",binput.max==5000 ? "selected":"");
						printf("\t<option %s>7500\n",binput.max==7500 ? "selected":"");
						printf("\t<option %s>10000\n",binput.max==10000 ? "selected":"");
						printf("\t<option %s>15000\n",binput.max==15000 ? "selected":"");
						printf("\t<option %s>20000\n",binput.max==20000 ? "selected":"");
						printf("\t<option %s>25000\n",binput.max==25000 ? "selected":"");
						printf("\t<option %s>50000\n",binput.max==50000 ? "selected":"");
						printf("\t<option %s>100000\n",binput.max==100000 ? "selected":"");
						printf("\t<option %s>500000\n",binput.max==500000 ? "selected":"");
						printf("</select>\n");
					}
					if(filedata=='R')
						DumpRealms();
					if(filedata=='U')
						printf("%s",cinput.name);
					if(filedata=='A')
						printf("%ld",cinput.ID);
					if(filedata=='B')
						MainStuff2(0);
					if(filedata=='D') {
						next=fgetc(fp);
						if(next=='a')
							printf("%s",cinput.name);
						if(next=='b')
							printf("%s",cinput.contact);
						if(next=='c')
							printf("%s",cinput.company);
						if(next=='d')
							printf("%s",cinput.email);
						if(next=='e')
							printf("%s",cinput.address1);
						if(next=='f')
							printf("%s",cinput.address2);
						if(next=='g')
							printf("%s",cinput.city);
						if(next=='h')
							printf("%s",cinput.state);
						if(next=='i')
							printf("%s",cinput.country);
						if(next=='j')
							printf("%s",cinput.zip);
						if(next=='k')
							printf("%s",cinput.phone);
						if(next=='l')
							printf("%s",cinput.comments);
						if(next=='m')
							printf("%s",cinput.passwd);
						if(next=='n') {
							if(cinput.lenabled==1)
								printf("checked");
						}
						if(next=='o')
							printf("%s",cinput.login);
					}
					if(filedata=='T')
						DumpBanners();
					if(filedata=='S')
						DumpIBanners();
					if(filedata=='V')
						printf("%ld",realms.ID);
					if(filedata=='F')
						DumpFiles();
					if(filedata=='G')
						printf("%s",config.bandir);
					if(filedata=='X')
						printf("%sbannerheader.gif",config.bandir);
					if(filedata=='W' && ID==-10) {
						printf("<font face=\"Verdana\" size=2><b>Requested File:</b></font><br>");
						printf("<img src=\"%s%s\"><p>",config.bandir,binput.bfile);
					}
					
				}
			}
			else
				filedone=TRUE;
		}
		fclose(fp);
	}
	else {
		printf("Couldn't open <b>'%s'</b> to read!\n",fileid);
		exit(0);
	}
}
                 
/* delete an ad from the entire DB */
void DeleteBanner(long int id)
{
FILE *temp;
char file2[300];
int found=FALSE;
int temprat=0; // holds the ratio of the ad, so we can subtract this number from the client's DB

	/* open the current banners DB, and a temp DB so that we can dump the updated */
	/* contents to the new DB, then rename it back to the banners.bwi filename */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	sprintf(file2,"%stemp.bwi",config.log_dir);
	temp=fopen(file2,"wb");
	LockFile(temp);
	max=0;
	/* read the max number of banners from banners.bwi */
	fread(&max,sizeof(long),1,bwi);
	/* write the SAME max, don't subtract from it until */
	/* we know we've found this ad */
	fwrite(&max,sizeof(long),1,temp);
	/* seek past the max long int, so we can begin looking */
	fseek(bwi,sizeof(long),SEEK_SET);
	fseek(temp,sizeof(long),SEEK_SET);
	loop=FALSE;
	/* begin looking */
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* matching IDs, found it! */
			if(binput.ID==id) {
				found=TRUE;
				temprat=binput.ratio;
			}
			else
				fwrite(&binput,sizeof(binput),1,temp);
		}
	}
	fclose(bwi);
	UnlockFile(temp);
	fclose(temp);
	/* remove and rename the old file to the banners.bwi file */
	remove(file),rename(file2,file);
	/* if we found the ad */
	if(found==TRUE) {
		sprintf(file,"%sbanners.bwi",config.log_dir);
		bwi=fopen(file,"rb+");
		LockFile(bwi);
		max=0;
		/* subtract the max, so the max reads correctly */
		fread(&max,sizeof(long),1,bwi);
		--max;
		rewind(bwi);
		fwrite(&max,sizeof(long),1,bwi);
		UnlockFile(bwi);
		fclose(bwi);
	}
	found=FALSE;
	/* now let's take the ad out of it's client's DB */
	sprintf(file,"%sC%ld.clt",config.log_dir,cinput.ID);
	bwi=fopen(file,"rb");
	sprintf(file2,"%stemp.clt",config.log_dir);
	temp=fopen(file2,"wb");
	LockFile(temp);
	/* first, let's take the max and put it in the temp file */
	max=0;
	fread(&max,sizeof(long),1,bwi);
	fwrite(&max,sizeof(long),1,temp);
	loop=FALSE;
	/* now let's take the actual ad info out */
	while(loop==FALSE) {
		fread(&centry,sizeof(centry),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* ID's match, don't write it back to the DB */
			if(binput.ID==centry.ID)
				found=TRUE;
			else
				fwrite(&centry,sizeof(centry),1,temp);
		}
	}
	UnlockFile(temp);
	fclose(temp);
	fclose(bwi);
	/* remove and rename the files */
	remove(file),rename(file2,file);
	/* now let's subtract from the max */
	if(found==TRUE) {
		sprintf(file,"%sC%ld.clt",config.log_dir,cinput.ID);
		bwi=fopen(file,"rb+");
		LockFile(bwi);
		fread(&max,sizeof(long),1,bwi);
		/* subtract the ad's ratio from the max */
		max=max-temprat;
		rewind(bwi);
		fwrite(&max,sizeof(long),1,temp);
		UnlockFile(bwi);
		fclose(bwi);
	}
		found=FALSE;
	/* now let's take the ad out of it's random DB */
	sprintf(file,"%srandom.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	sprintf(file2,"%stemp.clt",config.log_dir);
	temp=fopen(file2,"wb");
	LockFile(temp);
	/* first, let's take the max and put it in the temp file */
	max=0;
	fread(&max,sizeof(long),1,bwi);
	fwrite(&max,sizeof(long),1,temp);
	loop=FALSE;
	/* now let's take the actual ad info out */
	while(loop==FALSE) {
		fread(&centry,sizeof(centry),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* ID's match, don't write it back to the DB */
			if(centry.ID==id)
				found=TRUE;
			else
				fwrite(&centry,sizeof(centry),1,temp);
		}
	}
	UnlockFile(temp);
	fclose(temp);
	fclose(bwi);
	/* remove and rename the files */
	remove(file),rename(file2,file);
	/* now let's subtract from the max */
	if(found==TRUE) {
		sprintf(file,"%srandom.bwi",config.log_dir);
		bwi=fopen(file,"rb+");
		LockFile(bwi);
		fread(&max,sizeof(long),1,bwi);
		/* subtract the ad's ratio from the max */
		max=max-temprat;
		rewind(bwi);
		fwrite(&max,sizeof(long),1,temp);
		UnlockFile(bwi);
		fclose(bwi);
	}
	return;
}

/* delete a client (and export it's ads) form the entire DB */
void DeleteClient(long int id)
{
FILE *temp;
char file2[300];
int found=FALSE;
int loop2=FALSE;

	/* this is relatively easy.  Just open the main clients */
	/* and find the client we want to delete, and then don't */
	/* add it to the modified DB */
	/* open clients database */
	sprintf(file,"%sclients.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	/* open what will be temporarily the updated DB */
	sprintf(file2,"%stemp.bwi",config.log_dir);
	temp=fopen(file2,"wb");
	LockFile(temp);
	max=0;
	/* read the max number of clients we have, not subtracting */
	/* from yet until we know that we've found it */
	fread(&max,sizeof(long),1,bwi);
	/* write the same max to the updated DB */
	fwrite(&max,sizeof(long),1,temp);
	fseek(bwi,sizeof(long),SEEK_SET);
	fseek(temp,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&cinput,sizeof(cinput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* Found IT!  Don't write */
			if(cinput.ID==id)
				found=TRUE;
			else
				fwrite(&cinput,sizeof(cinput),1,temp);
		}
	}
	fclose(bwi);
	UnlockFile(temp);
	fclose(temp);
	/* now let't rename the updated DB to the filename it should be */
	remove(file),rename(file2,file);
	/* if we found the client that we need to delete */
	if(found==TRUE) {
		sprintf(file,"%sclients.bwi",config.log_dir);
		bwi=fopen(file,"rb+");
		LockFile(bwi);
		max=0;
		/* read the old max */
		fread(&max,sizeof(long),1,bwi);
		/* subtract from the old max */
		--max;
		/* write the new max back to the beginning of the DB */
		rewind(bwi);
		fwrite(&max,sizeof(long),1,bwi);
		UnlockFile(bwi);
		fclose(bwi);
	}
	/* this part is in BWI V2.02 and previous */
	/* in > BWI V2.02, we will export the banners */
	/* For EXPORTING BANNERS, the banners will be */
	/* exported before the client is even touched. */
	/* If a banner is not exported by the time we get */
	/* to the DeleteClient() function, they will be */
	/* DELETED.  Therefore, the old code proceeds here */
	
	/* open the banners DB */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	temp=fopen(file,"rb");
	fseek(temp,sizeof(long),SEEK_SET);
	loop2=FALSE;
	while(loop2==FALSE) {
		fread(&binput,sizeof(binput),1,temp);
		if(feof(temp)) loop2=TRUE;
		else {
			if(binput.CID==id)
				DeleteBanner(binput.ID);
			else continue;
		}
	}
	fclose(temp);
	/* now delete the random file */
	sprintf(file,"%sC%ld.clt",config.log_dir,id);
	remove(file);
	return;
}

/* delete a realm from the entire DB */
void DeleteRealm(long int id)
{
FILE *temp;
char file2[300];
int found=FALSE;

	/* open the realms DB, and a temporary one to write the new data to */
	sprintf(file,"%srealms.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	sprintf(file2,"%stemp.bwi",config.log_dir);
	temp=fopen(file2,"wb");
	LockFile(temp);
	max=0;
	/* read the max from the current, and write the */
	/* same max to the updated DB.  We will subtract */
	/* from the max when we are sure we found the realm */
	fread(&max,sizeof(long),1,bwi);
	fwrite(&max,sizeof(long),1,temp);
	fseek(bwi,sizeof(long),SEEK_SET);
	fseek(temp,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&realms,sizeof(realms),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* found the realm we wanted to delete, don't write back to updated DB! */
			if(realms.ID==id)
				found=TRUE;
			else
				fwrite(&realms,sizeof(realms),1,temp);
		}
	}
	fclose(bwi);
	UnlockFile(temp);
	fclose(temp);
	/* remove the old DB, and rename the new DB to the old DB */
	remove(file),rename(file2,file);
	/* since we've found the realm and deleted it, we */
	/* can subtract from the max now */
	if(found==TRUE) {
		sprintf(file,"%srealms.bwi",config.log_dir);
		bwi=fopen(file,"rb+");
		LockFile(bwi);
		max=0;
		fread(&max,sizeof(long),1,bwi);
		--max;
		rewind(bwi);
		fwrite(&max,sizeof(long),1,bwi);
		UnlockFile(bwi);
		fclose(bwi);
	}
	return;
}

/* add a new banner */
void SaveBanner()
{
char temp[10];
char month[5];
char day[5];
char year[5];
char bmonth[5];
char bday[5];
char byear[5];
int i=0;

	currdate=GetCurrentDate();
	/* first let's get all the date from the form for the new banner ad */
	bsubmit.CID=cinput.ID; bsubmit.method=getfasint("method");
	getfield(bsubmit.name,"nick");getfield(bsubmit.bfile,"bfile");
	bsubmit.width=getfasint("width");bsubmit.height=getfasint("height");
	bsubmit.border=getfasint("border");getfield(bsubmit.ltext,"ltext");
	getfield(bsubmit.alt,"alt");getfield(bsubmit.url,"URL");
	getfield(bsubmit.iother,"iother");getfield(bsubmit.lother,"lother");
	getfield(temp,"max");bsubmit.max=atol(temp);
	getfield(temp,"bonus");bsubmit.bonus=atol(temp);bsubmit.type=getfasint("type");
	getfield(bmonth,"BIRTHMonth");getfield(bday,"BIRTHDay");getfield(byear,"BIRTHYear");
	sprintf(bsubmit.bdate,"%s/%s/%s",bmonth,bday,byear);getfield(month,"month");
	getfield(day,"day");getfield(year,"year");sprintf(bsubmit.edate,"%s/%s/%s",month,day,year);
	bsubmit.ratio=getfasint("ratio");
	strcpy(bsubmit.lreset, currdate);
	strcpy(bsubmit.ledited, currdate);
	/* now let's open the ID database to determine which unique */
	/* ID the ad will be given */
	sprintf(file,"%sID.bwi",config.log_dir);
	max=0;
	bwi=fopen(file,"rb+");
	LockFile(bwi);
	fread(&max,sizeof(long),1,bwi);
	/* add to the max, and write back to the ID DB because */
	/* we don't want any other ad to have the same ID */
	max++;
	bsubmit.ID=max;
	/* rewind and write back */
	rewind(bwi);
	fwrite(&max,sizeof(long),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	/* record HTML field */
	SaveUserHTML(bsubmit.ID);
	/* now let's open the banners DB, and all to the max since */
	/* we are adding a new ad to it */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb+");
	LockFile(bwi);
	max=0;
	fread(&max,sizeof(long),1,bwi);
	max++;
	rewind(bwi);
	fwrite(&max,sizeof(long),1,bwi);
	fseek(bwi,sizeof(long),SEEK_SET);
	UnlockFile(bwi);
	fclose(bwi);
	/* now that all the maxes and IDs are taken care of, let's */
	/* write the ad info to the banners DB */
	bwi=fopen(file,"ab");
	LockFile(bwi);
	fwrite(&bsubmit,sizeof(bsubmit),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	/* now that all the ad info is saved, let's take care of the */
	/* rotation stuff.  Each client has a rotation file, and we */
	/* will write the ad's ID to it x many of times, according */
	/* to what ratio was set */
	sprintf(file,"%sC%ld.clt",config.log_dir,cinput.ID);
	if((bwi=fopen(file,"rb"))==NULL) {
		/* if file doesn't exist, let's create it */
		bwi=fopen(file,"wb");
		LockFile(bwi);
		max=0;
		max=bsubmit.ratio;
		fwrite(&max,sizeof(long),1,bwi);
		bentry.ID=bsubmit.ID;
		for(i=1; i<=bsubmit.ratio; i++)
			fwrite(&bentry,sizeof(bentry),1,bwi);
		UnlockFile(bwi);
		fclose(bwi);
	}
	else {
		/* otherwise, let's add to the max the number of times */
		/* we are going to write to it, then write the IDs to it */
		fclose(bwi);
		bwi=fopen(file,"rb+");
		LockFile(bwi);
		max=0;
		fread(&max,sizeof(long),1,bwi);
		/* add to the max the number of times were writing to the DB */
		max+=bsubmit.ratio;
		rewind(bwi);
		fwrite(&max,sizeof(long),1,bwi);
		UnlockFile(bwi);
		fclose(bwi);
		/* now write the IDs to the DB according to the ratio */
		bwi=fopen(file,"ab");
		LockFile(bwi);
		bentry.ID=bsubmit.ID;
		for(i=1; i<=bsubmit.ratio; i++)
			fwrite(&bentry,sizeof(bentry),1,bwi);
		UnlockFile(bwi);
		fclose(bwi);
	}
	/* do the same as we just did for the client, except put it in */
	/* the entire rotation file */
	sprintf(file,"%srandom.bwi",config.log_dir);
	if((bwi=fopen(file,"rb"))==NULL) {
		bwi=fopen(file,"wb");
		LockFile(bwi);
		max=0;
		max=bsubmit.ratio;
		fwrite(&max,sizeof(long),1,bwi);
		bentry.ID=bsubmit.ID;
		for(i=1; i<=bsubmit.ratio; i++)
			fwrite(&bentry,sizeof(bentry),1,bwi);
		UnlockFile(bwi);
		fclose(bwi);
	} else {
		fclose(bwi);
		bwi=fopen(file,"rb+");
		LockFile(bwi);
		max=0;
		fread(&max,sizeof(long),1,bwi);
		max+=bsubmit.ratio;
		rewind(bwi);
		fwrite(&max,sizeof(long),1,bwi);
		UnlockFile(bwi);
		fclose(bwi);
		bwi=fopen(file,"ab");
		LockFile(bwi);
		bentry.ID=bsubmit.ID;
		for(i=1; i<=bsubmit.ratio; i++)
			fwrite(&bentry,sizeof(bentry),1,bwi);
		UnlockFile(bwi);
		fclose(bwi);
	}
	return;
}

/* dump out the "View Charts" command */
void PrintCharts()
{
long int i=0;
long int cbiggest=0;
float n1=0,n2=0;

	/* first dump out the View Charts header */
	sprintf(file,"%sbvcheader.html",config.html_dir);
	PrintFile(file);
	/* first, for the ratio of the ad, we must find which */
	/* ad has the most exposures or clicks (usually most exposures) */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	fseek(bwi,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			if(binput.timps>cbiggest)
				cbiggest=binput.timps;
			if(binput.tclicks>cbiggest)
				cbiggest=binput.tclicks;
		}
	}
	loop=FALSE;
	/* now that we have the denominator for the ratio, let's */
	/* print out the chart for each ad */
	/* back @ beginning */
	rewind(bwi);
	fseek(bwi,sizeof(long),SEEK_SET);
	/* open table */
	printf("<table border=0><tr><td colspan=\"2\"><center><font face=\"Verdana\" size=\"2\"><b>Key</b></font></center></td></tr>");
	printf("<tr><td align=\"right\"><font face=\"Verdana\" size=\"1\">Clicks:</font></td><td><img src=\"%spics/mright.gif\" width=\"2\" height=\"13\"><img src=\"%spics/m.gif\" height=\"13\" width=\"30\"><img src=\"%spics/mright.gif\" width=\"2\" height=\"13\"></td></tr>",config.bandir,config.bandir,config.bandir);
	printf("<tr><td align=\"right\"><font face=\"Verdana\" size=\"1\">Impressions:</font></td><td><img src=\"%spics/mright.gif\" width=\"2\" height=\"13\"><img src=\"%spics/m2.gif\" height=\"13\" width=\"30\"><img src=\"%spics/mright.gif\" width=\"2\" height=\"13\"></td></tr></table>",config.bandir,config.bandir,config.bandir);
	printf("<table border=0 width=\"85%%\" cellspacing=\"10\" cellpadding=\"3\">");
	printf("<tr><td width=\"25%%\" align=\"right\"><font face=\"Verdana\" size=\"2\">Banner</font></td><td width=\"75%%\"><font face=\"Verdana\" size=\"2\">Chart</font></td></tr>");
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* use float so we can get a whole number */
			n1=(float)binput.timps/(float)cbiggest;
			n2=(float)binput.tclicks/(float)cbiggest;
			printf("<tr><td width=\"25%%\" align=\"right\"><font face=\"Verdana\" size=\"1\"><a href=\"%s?BID=%ld&command=fromcharts\">%s</font><br></td><td width=\"75%%\">\n",config.sscript,binput.ID,binput.name);
			printf("<img src=\"%spics/mright.gif\" width=\"2\" height=\"13\">",config.bandir);
			printf("<nobr><img src=\"%spics/m.gif\" height=\"13\" width=\"%d\">",config.bandir,(int)(n2*200));
			printf("<img src=\"%spics/mright.gif\" width=\"2\" height=\"13\">&nbsp;&nbsp;<b><font face=\"Verdana\" size=\"1\">%d</font></b></nobr><br>\n",config.bandir,binput.tclicks);
			printf("<img src=\"%spics/m2right.gif\" width=\"2\" height=\"13\">",config.bandir);
			printf("<nobr><img src=\"%spics/m2.gif\" height=\"13\" width=\"%d\">",config.bandir,(int)(n1*200));
			printf("<img src=\"%spics/m2right.gif\" width=\"2\" height=\"13\">&nbsp;&nbsp;<b><font face=\"Verdana\" size=\"1\">%d</font></b></nobr>",config.bandir,binput.timps);
			printf("</td></tr>\n\n");
		}
	}
	/* close table */
	printf("</table>");
	/* now finish with the View Charts footer */
	sprintf(file,"%sbvcfooter.html",config.html_dir);
	PrintFile(file);
	return;
}

/* used for printing out the client list(s) */
void MainStuff()
{
char numdate[15];

	/* first, let's determine if we need to select a client on the */
	/* list, load client info if there is an ID != 0 */
	getfield(numdate,"CID");
	ID=atol(numdate);
	if(ID!=0) LoadClient(ID);
	/* open the client's DB so we can print out the list */
	sprintf(file,"%sclients.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&cinput,sizeof(cinput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* used for DumpExportBanners(), don't print the client we're deleting */
			if(strcmp(flag,cinput.name)==0)
				continue;
			/* if we need to select this client, print the "selected" tag in <option> */
			if(ID==cinput.ID) printf("<option value=\"%ld\" selected>%s",cinput.ID,cinput.name);
			/* otherwise, print it regular */
			if(ID!=cinput.ID) printf("<option value=\"%ld\">%s",cinput.ID,cinput.name);
		}
	}
	fclose(bwi);
	return;
}

/* used for printing out the ads list(s) */
void MainStuff2(int which)
{
char numdate[15];
long int cdate=0;
long int edate=0;
long int bdate=0;

	LoadClient(ID);
	currdate=GetCurrentDate();
	/* if there is no banners DB, just print an empty list */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	if((bwi=fopen(file,"rb"))==NULL) {
		printf("<select name=\"BID\"></select>");
		return;
	}
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	printf("<select name=\"BID\">");
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* develop a long int representation of the date(s) */
			/* yyyymmdd */
			/* current date to long int */
			numdate[0]=currdate[6],numdate[1]=currdate[7];
			numdate[2]=currdate[8],numdate[3]=currdate[9];
			numdate[4]=currdate[0],numdate[5]=currdate[1];
			numdate[6]=currdate[3],numdate[7]=currdate[4];
			numdate[8]='\0',cdate=atol(numdate);
			/* expiration date to long int */
			numdate[0]=binput.edate[6],numdate[1]=binput.edate[7];
			numdate[2]=binput.edate[8],numdate[3]=binput.edate[9];
			numdate[4]=binput.edate[0],numdate[5]=binput.edate[1];
			numdate[6]=binput.edate[3],numdate[7]=binput.edate[4];
			numdate[8]='\0',edate=atol(numdate);
			/* start date to long int */
			numdate[0]=binput.bdate[6],numdate[1]=binput.bdate[7];
			numdate[2]=binput.bdate[8],numdate[3]=binput.bdate[9];
			numdate[4]=binput.bdate[0],numdate[5]=binput.bdate[1];
			numdate[6]=binput.bdate[3],numdate[7]=binput.bdate[4];
			numdate[8]='\0',bdate=atol(numdate);
			/* if expires by max imps and has some left, or has bonus credits */
			if(which==0 && binput.CID==cinput.ID && binput.type==1 && binput.timps<binput.max || (which==0 && binput.CID==cinput.ID && binput.bonus>0 && binput.type==1))
			{
				printf("<option value=\"%ld\">%s",binput.ID,binput.name);
				continue;
			}
			/* if expires by date and birth is before current, and end is after current, or has bonus credits */
			if(which==0 && binput.CID==cinput.ID && binput.type==3 && cdate<edate && bdate<cdate  || (which==0 && binput.CID==cinput.ID && binput.bonus>0 && binput.type==3))
			{
				printf("<option value=\"%ld\">%s",binput.ID,binput.name);
				continue;
			}
			/* if has unlimited exposures */
			if(which==0 && binput.CID==cinput.ID && binput.type==2)
			{
				printf("<option value=\"%ld\">%s",binput.ID,binput.name);
				continue;
			}
			/* if expires by max imps and has none left, or has no bonus credits */
			if(which==0 && binput.CID==cinput.ID && binput.type==1 && binput.timps>=binput.max || (which==0 && binput.CID==cinput.ID && binput.bonus<=0 && binput.type==1 && binput.timps>=binput.max))
			{
				printf("<option value=\"%ld\">%s*",binput.ID,binput.name);
				continue;
			}
			/* if expires by date, and birth hasn't occured yet or death has occured */
			if(which==0 && binput.CID==cinput.ID && binput.type==3 && cdate>edate || (which==0 && binput.CID==cinput.ID && bdate>cdate && binput.type==3) || (binput.CID==cinput.ID && binput.bonus>0 && binput.type==3 && cdate>edate && bdate>cdate))
			{
				printf("<option value=\"%ld\">%s*",binput.ID,binput.name);
				continue;
			}
			/* if expires by max clicks and has some left, or has bonus credits */
			if(which==0 && binput.CID==cinput.ID && binput.type==4 && binput.tclicks<binput.max || (which==0 && binput.CID==cinput.ID && binput.type==4 && binput.bonus>0))
			{
				printf("<option value=\"%ld\">%s",binput.ID,binput.name);
				continue;
			}
			/* if expires by max clicks, and has none left, nor any bonus credits */
			if(which==0 && binput.CID==cinput.ID && binput.type==4 && binput.tclicks>=binput.max || (which==0 && binput.CID==cinput.ID && binput.type==4 && binput.bonus<=0 && binput.tclicks>=binput.max))
			{
				printf("<option value=\"%ld\">%s*",binput.ID,binput.name);
				continue;
			}
	
			/*  Only for disable banner and enable banner functions (new GUI) */
			/* if expires by max imps and has some left, or has bonus credits */
			if(which==2 && binput.CID==cinput.ID && binput.type==1 && binput.timps<binput.max || (which==2 && binput.CID==cinput.ID && binput.bonus>0 && binput.type==1))
			{
				printf("<option value=\"%ld\">%s",binput.ID,binput.name);
				continue;
			}
			/* if expires by date and birth is before current, and end is after current, or has bonus credits */
			if(which==2 && binput.CID==cinput.ID && binput.type==3 && cdate<edate && bdate<cdate  || (which==2 && binput.CID==cinput.ID && binput.bonus>0 && binput.type==3))
			{
				printf("<option value=\"%ld\">%s",binput.ID,binput.name);
				continue;
			}
			/* if has unlimited exposures */
			if(which==2 && binput.CID==cinput.ID && binput.type==2)
			{
				printf("<option value=\"%ld\">%s",binput.ID,binput.name);
				continue;
			}
			/* if expires by max imps and has none left, or has no bonus credits */
			if(which==1 && binput.CID==cinput.ID && binput.type==1 && binput.timps>=binput.max || (which==1 && binput.CID==cinput.ID && binput.bonus<=0 && binput.type==1))
			{
				printf("<option value=\"%ld\">%s*",binput.ID,binput.name);
				continue;
			}
			/* if expires by date, and birth hasn't occured yet or death has occured */
			if(which==1 && binput.CID==cinput.ID && binput.type==3 && cdate>edate || (which==1 && binput.CID==cinput.ID && bdate>cdate && binput.type==3) || (binput.CID==cinput.ID && binput.bonus>0 && binput.type==3))
			{
				printf("<option value=\"%ld\">%s*",binput.ID,binput.name);
				continue;
			}
			/* if expires by max clicks and has some left, or has bonus credits */
			if(which==2 && binput.CID==cinput.ID && binput.type==4 && binput.tclicks<binput.max || (which==2 && binput.CID==cinput.ID && binput.type==4 && binput.bonus>0))
			{
				printf("<option value=\"%ld\">%s",binput.ID,binput.name);
				continue;
			}
			/* if expires by max clicks, and has none left, nor any bonus credits */
			if(which==1 && binput.CID==cinput.ID && binput.type==4 && binput.tclicks>=binput.max || (which==1 && binput.CID==cinput.ID && binput.type==4 && binput.bonus<=0))
			{
				printf("<option value=\"%ld\">%s*",binput.ID,binput.name);
				continue;
			}
		}
	}
	printf("</select>");
	fclose(bwi);
}

/* load an ad's info into memory */
void LoadBanner(long int id)
{
int found=0;

	/* open the banners DB and search with the ad */
	/* with the same ID as id */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	fseek(bwi,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* ad's ID is the same as we need */
			if(binput.ID==id) {
				found=TRUE;
				break;
			}
			else continue;
		}
	}
	fclose(bwi);
	/* if the ad was found (and loaded into memory) then */
	/* return */
	if(found==TRUE) return;
	else error("That account was not found!");
}

/* load a client's info into memory */
void LoadClient(long int id)
{
int found=FALSE;

	/* open the client's DB, and let's find the client */
	/* with the same id as we're given */
	sprintf(file,"%sclients.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&cinput,sizeof(cinput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* found the one we need, break */
			if(cinput.ID==id) {
				found=TRUE;
				break;
			}
			else continue;
		}
	}
	fclose(bwi);
	/* if we found the client we needed, just return */
	if(found==TRUE) return;
	else error("That Client was not found!");
}

/* load a realm's info into memory */
void LoadRealm(long int id)
{
int found=FALSE;

	/* open the realm's DB, and let's find the client */
	/* with the same id as we're given */
	sprintf(file,"%srealms.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&realms,sizeof(realms),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* found the one we need, break */
			if(realms.ID==id) {
				found=TRUE;
				break;
			}
			else continue;
		}
	}
	fclose(bwi);
	/* if we found the realm we needed, just return */
	if(found==TRUE) return;
	else error("That Realm was not found!");
}

/* print the selection lists for months (and select if required) */
void PrintMonths(long int id,char *str,int mode)
{
int i = 0;
char curmonth[10];
char months[20];
char tst[5];
int out=0;
int IsFound=FALSE;

	/* if mode == 1, then we are printing out the birthmonth list */
	if(mode==1) printf("<SELECT NAME=\"BIRTHMonth\">");
	/* otherwise, it's the end month list */
	else printf("<SELECT NAME=\"month\">");
	/* gather the month from the date string in the format:  mm/dd/yyyy */
	curmonth[0] = str[0];
	curmonth[1] = str[1];
	curmonth[2] = '\0';
	for(i = 1; i <= 12; i++) {
		sprintf(tst,"%.2d",i);
		if(i==1) strcpy(months,"January");
		if(i==2) strcpy(months,"February");
		if(i==3) strcpy(months,"March");
		if(i==4) strcpy(months,"April");
		if(i==5) strcpy(months,"May");
		if(i==6) strcpy(months,"June");
		if(i==7) strcpy(months,"July");
		if(i==8) strcpy(months,"August");
		if(i==9) strcpy(months,"September");
		if(i==10) strcpy(months,"October");
		if(i==11) strcpy(months,"November");
		if(i==12) strcpy(months,"December");
		/* if we need to select the current month */
		if(strcmp(curmonth,tst)==0) {
			out=atoi(tst);
			printf("<OPTION VALUE=\"%.2d\" SELECTED>%s</OPTION>\n",out,months);
			IsFound=TRUE;
		}
		else {
			out=atoi(tst);
			printf("<OPTION VALUE=\"%.2d\">%s</OPTION>\n",out,months);
		}
	}
	printf("</SELECT>");
	return;
}

/* print the selection lists for days (and select if required) */
void PrintDays(long int id,char *str,int mode)
{
char day2[5];
int i=0;
int IsFound=FALSE;
char tst[10];

	/* if mode == 1, then we are printing out the birth day list */
	if(mode==1) printf("<SELECT NAME=\"BIRTHDay\">");
	/* otherwise, it's the end day list */
	else printf("<SELECT NAME=\"day\">");
	/* gather the day from the date string in the format:  mm/dd/yyyy */
	day2[0] = str[3];
	day2[1] = str[4];
	day2[2] = '\0';
	for(i=1; i<=31; i++) {
		sprintf(tst,"%.2d",i);
		/* if we need to select the current day */
		if(strcmp(tst,day2)==0) {
			printf("<OPTION VALUE=\"%.2d\" SELECTED>%.2d</OPTION>\n",i,i);
			IsFound=TRUE;
		}
		else {
			printf("<OPTION VALUE=\"%.2d\">%.2d</OPTION>\n",i,i);
		}
	}
	printf("</SELECT>");
	return;
}

/* print the selection lists for years (and select if required) */
void PrintYears(long int id,char *str,int mode)
{
char year2[5];
int i=0;
int IsFound =FALSE;
char tst[10];

	/* if mode == 1, then we are printing out the birth year list */
	if(mode==1) printf("<SELECT NAME=\"BIRTHYear\">");
	/* otherwise, it's the end year list */
	else printf("<SELECT NAME=\"year\">");
	/* gather the year from the date string in the format:  mm/dd/yyyy */
	year2[0] = str[6];
	year2[1] = str[7];
	year2[2] = str[8];
	year2[3] = str[9];
	year2[4] = '\0';
	for(i = 1998; i <= 2038; i++) {
		sprintf(tst,"%.2d",i);
		/* if we need to select the current year */
		if(strcmp(tst,year2)==0) {
			printf("<OPTION VALUE=\"%.2d\" SELECTED>%.2d</OPTION>\n",i,i);
			IsFound=TRUE;
		}
		else {
			printf("<OPTION VALUE=\"%.2d\">%.2d</OPTION>\n",i,i);
		}
	}
	printf("</SELECT>");
	return;
}

/* dump out the realms list(s) */
void DumpRealms()
{
	/* open the realms DB, and dump all entries into a list */
	sprintf(file,"%srealms.bwi",config.log_dir);
	if((bwi=fopen(file,"rb"))!=NULL) {
		loop=FALSE;
		fseek(bwi,sizeof(long),SEEK_SET);
		while(loop==FALSE) {
			fread(&realms,sizeof(realms),1,bwi);
			if(feof(bwi)) loop=TRUE;
			else {
				printf("<option value=\"%ld\">%s",realms.ID,realms.name);
			}
		}
		fclose(bwi);
		return;
	}
	else return;
}

/* add a new realm */
void SaveRealm()
{
FILE *temp;
int i=0,j=0;
char buf[10];
long int last=0;
long int f=0;

	/* first let's open the Realm's ID DB, so we can determine */
	/* a unique ID for this realm */
	max=0;
	sprintf(file,"%sRID.bwi",config.log_dir);
	bwi=fopen(file,"rb+");
	LockFile(bwi);
	fread(&max,sizeof(long),1,bwi);
	/* add to max, and rewrite to Realm's ID DB, so it's unique */
	max++;
	realms.ID=max;
	rewind(bwi);
	fwrite(&max,sizeof(long),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	/* gather all realm information from form */
	currdate=GetCurrentDate();
	strcpy(realms.bdate,currdate);
	getfield(realms.name,"name");
	/* now let's open the Realms DB, and add to the max */
	sprintf(file,"%srealms.bwi",config.log_dir);
	bwi=fopen(file,"rb+");
	LockFile(bwi);
	max=0;
	fread(&max,sizeof(long),1,bwi);
	max++;
	rewind(bwi);
	fwrite(&max,sizeof(long),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	/* now append to the Realm's DB, and ad the realm's info */
	bwi=fopen(file,"ab");
	LockFile(bwi);
	fwrite(&realms,sizeof(realms),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	/* create the Realm's include file, and put one entry per */
	/* each included account in it */
	sprintf(file,"%s%ld.rlm",config.log_dir,realms.ID);
	temp=fopen(file,"wb");
	LockFile(temp);
	max=0;
	for(i=0; i<=NUM_ENTRIES; i++) {
		if(strcmp(entries[i].name,"include")==0) {
			rentry.ID=atol(entries[i].val);
			fwrite(&rentry,sizeof(rentry),1,temp);
			LoadBanner(atol(entries[i].val));
			max+=binput.ratio;
		}
		else continue;
	}
	UnlockFile(temp);
	fclose(temp);
	/* create the Realm's random file, and put the entries */
	/* of each included account in it */	
	sprintf(file,"%sR%ld.rlm",config.log_dir,realms.ID);
	temp=fopen(file,"wb");
	LockFile(temp);
	fwrite(&max,sizeof(long),1,temp);
	for(i=0; i<=NUM_ENTRIES; i++) {
		if(strcmp(entries[i].name,"include")==0) {
			rentry.ID=atol(entries[i].val);
			LoadBanner(rentry.ID);
			for(j=0; j<=binput.ratio; j++)
				fwrite(&rentry,sizeof(rentry),1,temp);
		}
		else continue;
	}
	UnlockFile(temp);
	fclose(temp);
	return;	
}

/* add a new client */
void SaveClient()
{
char temp[100];

	/* gather all client information from the form */
	getfield(csubmit.name,"name");getfield(csubmit.login,"clogin");getfield(csubmit.contact,"contact");
	getfield(csubmit.company,"company");getfield(csubmit.email,"email");
	getfield(csubmit.address1,"address1");getfield(csubmit.address2,"address2");
	getfield(csubmit.city,"city");getfield(csubmit.state,"state");getfield(csubmit.zip,"zip");
	getfield(csubmit.country,"country");getfield(csubmit.phone,"phone");
	getfield(csubmit.comments,"comments");getfield(temp,"password");
	strcpy(csubmit.passwd,(char*)crypt(temp,config.d_key));
	csubmit.lenabled=getfasint("active");
	/* now let's open the Client's ID DB, to get a unique ID */
	sprintf(file,"%sCID.bwi",config.log_dir);
	bwi=fopen(file,"rb+");
	LockFile(bwi);
	max=0;
	fread(&max,sizeof(long),1,bwi);
	/* add to the last ID, and rewrite so it's unique */
	max++;
	csubmit.ID=max;
	rewind(bwi);
	fwrite(&max,sizeof(long),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	/* add to the max in the Client's DB */
	sprintf(file,"%sclients.bwi",config.log_dir);
	bwi=fopen(file,"rb+");
	LockFile(bwi);
	max=0;
	fread(&max,sizeof(long),1,bwi);
	max++;
	rewind(bwi);
	fwrite(&max,sizeof(long),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	/* now add the actual client info to the Client's DB */
	bwi=fopen(file,"ab");
	LockFile(bwi);
	fwrite(&csubmit,sizeof(csubmit),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	/* now create the client's rotation file, for later use */
	sprintf(file,"%sC%ld.clt",config.log_dir,csubmit.ID);
	bwi=fopen(file,"wb");
	fclose(bwi);
	return;
}

/* modify a client */
void UpdateClient()
{
FILE *temp;
char file2[300];
char temps[100];

	/* gather all update client info from form */
	getfield(temps,"CID");ID=atol(temps);
	csubmit.ID=ID;
	getfield(csubmit.name,"name");getfield(csubmit.login,"clogin");getfield(csubmit.contact,"contact");
	getfield(csubmit.company,"company");getfield(csubmit.email,"email");
	getfield(csubmit.address1,"address1");getfield(csubmit.address2,"address2");
	getfield(csubmit.city,"city");getfield(csubmit.state,"state");getfield(csubmit.zip,"zip");
	getfield(csubmit.country,"country");getfield(csubmit.phone,"phone");
	getfield(csubmit.comments,"comments");getfield(temps,"password");
	/* if they entered a password, then we'll change it */
	/* otherwise, it remains the same */
	if(strcmp(temps,"")!=0)
		strcpy(csubmit.passwd,(char*)crypt(temps,config.d_key));
	csubmit.lenabled=getfasint("active");
	/* open up the Client's DB for reading, to find the old info */
	sprintf(file,"%sclients.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	/* open up a temp DB for writing, to write updated info to */
	sprintf(file2,"%stemp.bwi",config.log_dir);
	temp=fopen(file2,"wb");
	LockFile(temp);
	max=0;
	/* copy old max count from old DB to updated DB */
	fread(&max,sizeof(long),1,bwi);
	fwrite(&max,sizeof(long),1,temp);
	fseek(bwi,sizeof(long),SEEK_SET);
	fseek(temp,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&cinput,sizeof(cinput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* old info found, write updated info to new DB */
			if(cinput.ID==ID) {
				if(strcmp(csubmit.passwd,"")==0) strcpy(csubmit.passwd,cinput.passwd);
				strcpy(csubmit.login,cinput.login);
				fwrite(&csubmit,sizeof(csubmit),1,temp);
			}
			/* no need to update, keep old info to new DB */
			else fwrite(&cinput,sizeof(cinput),1,temp);
		}
	}
	fclose(bwi);
	UnlockFile(temp);
	fclose(temp);
	/* delete the OLD db, and rename the new DB to the Client's DB */
	remove(file),rename(file2,file);
	return;
}

/* modify an ad */
void UpdateBanner()
{
FILE *temp;
char file2[300];
char temps[10];
char month[5];
char day[5];
char year[5];
char bmonth[5];
char bday[5];
char byear[5];
int i=0;
int oldrat=0;

	currdate=GetCurrentDate();
	/* gather updated ad info from form */
	getfield(temps,"CID");ID=atol(temps);LoadClient(ID);
	getfield(temps,"BID");bsubmit.ID=atol(temps);
	bsubmit.CID=cinput.ID;bsubmit.method=getfasint("method");
	getfield(bsubmit.name,"nick");getfield(bsubmit.bfile,"bfile");
	bsubmit.width=getfasint("width");bsubmit.height=getfasint("height");
	bsubmit.border=getfasint("border");getfield(bsubmit.ltext,"ltext");
	getfield(bsubmit.alt,"alt");getfield(bsubmit.url,"URL");
	getfield(bsubmit.iother,"iother");getfield(bsubmit.lother,"lother");
	getfield(temps,"max");bsubmit.max=atol(temps);
	getfield(temps,"bonus");bsubmit.bonus=atol(temps);bsubmit.type=getfasint("type");
	getfield(bmonth,"BIRTHMonth");getfield(bday,"BIRTHDay");getfield(byear,"BIRTHYear");
	sprintf(bsubmit.bdate,"%s/%s/%s",bmonth,bday,byear);getfield(month,"month");
	getfield(day,"day");getfield(year,"year");sprintf(bsubmit.edate,"%s/%s/%s",month,day,year);
	bsubmit.ratio=getfasint("ratio");
	strcpy(bsubmit.ledited, currdate);
	/* record new HTML data */
	SaveUserHTML(bsubmit.ID);
	/* open the banners DB for reading to find old info */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	/* open temp DB for writing to write updated info to */
	sprintf(file2,"%stemp.bwi",config.log_dir);
	temp=fopen(file2,"wb");
	LockFile(temp);
	/* copy old max from old DB to updated DB */
	fread(&max,sizeof(long),1,bwi);
	fwrite(&max,sizeof(long),1,temp);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* found the old ad info, write updated */
			if(binput.ID==bsubmit.ID) {
				bsubmit.clicks=binput.clicks,bsubmit.imps=binput.imps;
				bsubmit.tclicks=binput.tclicks,bsubmit.timps=binput.timps;
				strcpy(bsubmit.lreset,binput.lreset);
				oldrat=binput.ratio;
				fwrite(&bsubmit,sizeof(bsubmit),1,temp);
			}
			/* no need to update, write old info to new DB */
			else fwrite(&binput,sizeof(binput),1,temp);
		}
	}
	fclose(bwi);
	UnlockFile(temp);
	fclose(temp);
	/* delete OLD db, and rename updated DB to old DB */
	remove(file),rename(file2,file);
	/* open the client's rotation file for reading to find old info */
	sprintf(file,"%sC%ld.clt",config.log_dir,cinput.ID);
	bwi=fopen(file,"rb");
	/* open a temp rotatin file for writing to update into */
	sprintf(file2,"%stemp.clt",config.log_dir);
	temp=fopen(file2,"wb");
	LockFile(temp);
	loop=FALSE;
	max=0;
	/* read the max, the subtract the old ratio, and the new ratio */
	fread(&max,sizeof(long),1,bwi);
	max-=oldrat;
	max+=bsubmit.ratio;
	fwrite(&max,sizeof(long),1,temp);
	while(loop==FALSE) {
		fread(&bentry,sizeof(bentry),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* write all entries back EXCEPT the one we just updated */
			if(bentry.ID!=bsubmit.ID)
				fwrite(&bentry,sizeof(bentry),1,temp);
			else continue;
		}
	}
	fclose(bwi);
	UnlockFile(temp);
	fclose(temp);
	/* remove the OLD db, and rename the updated DB to the old DB */
	remove(file),rename(file2,file);
	sprintf(file,"%sC%ld.clt",config.log_dir,cinput.ID);
	/* write the new entries to the rotation file */
	bwi=fopen(file,"ab");
	LockFile(bwi);
	bentry.ID=bsubmit.ID;
	for(i=1; i<=bsubmit.ratio; i++)
		fwrite(&bentry,sizeof(bentry),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	/* do the same as above, except for the main rotation file */
	sprintf(file,"%srandom.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	sprintf(file2,"%stemp.bwi",config.log_dir);
	temp=fopen(file2,"wb");
	LockFile(temp);
	loop=0;
	max=0;
	fread(&max,sizeof(long),1,bwi);
	max-=oldrat;
	max+=bsubmit.ratio;
	fwrite(&max,sizeof(long),1,temp);
	while(loop==0) {
		fread(&bentry,sizeof(bentry),1,bwi);
		if(feof(bwi)) loop=1;
		else {
			if(bentry.ID!=bsubmit.ID)
				fwrite(&bentry,sizeof(bentry),1,temp);
			else continue;
		}
	}
	fclose(bwi);
	UnlockFile(temp);
	fclose(temp);
	remove(file),rename(file2,file);
	sprintf(file,"%srandom.bwi",config.log_dir);
	bwi=fopen(file,"ab");	
	LockFile(bwi);
	bentry.ID=bsubmit.ID;
	for(i=1; i<=bsubmit.ratio; i++)
		fwrite(&bentry,sizeof(bentry),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	return;
}

/* enable an ad in the rotation */
void EnableBanner(long int id)
{
	/* open the banners DB to find the ad we want to enable */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	loop=FALSE;
	bwi=fopen(file,"rb+");
	LockFile(bwi);
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* we've found the ad we want to enable, now */
			/* let's set the type to Unlimited so it's now */
			/* active */
			if(binput.ID==id) {
				binput.type=2;
				fseek(bwi,ftell(bwi)-sizeof(binput),SEEK_SET);
				fwrite(&binput,sizeof(binput),1,bwi);
			}
			else continue;
		}
	}
	UnlockFile(bwi);
	fclose(bwi);
	return;
}

/* dump the banner list(s) in "Define Realms" */
void DumpBanners()
{
	/* open the banners DB to dump for the Add Realm command */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	printf("<select name=\"include\" size=\"6\" multiple>");
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			printf("<option name=\"include\" value=\"%ld\">%s&nbsp;&nbsp;",binput.ID,binput.name);
		}
	}
	fclose(bwi);
	printf("</select>");
	return;
}

/* dump the banner list(s) in "Define Realms", and select */ 
void DumpIBanners()
{
char file2[300];
FILE *temp;
int loop2=0;

	/* open the banners DB for Modify Realm, and select */
	/* the included accounts */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	printf("<select name=\"include\" size=\"6\" multiple>");
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			printf("<option value=\"%ld\"",binput.ID);
			sprintf(file2,"%s%ld.rlm",config.log_dir,realms.ID);
			if((temp=fopen(file2,"rb"))!=NULL) {
				loop2=FALSE;
				while(loop2==FALSE) {
					fread(&rentry,sizeof(rentry),1,temp);
					if(feof(temp)) loop2=TRUE;
					else {
						if(binput.ID==rentry.ID)
							printf(" selected");
						else continue;
					}
				}
				fclose(temp);
				printf(">%s&nbsp;&nbsp;",binput.name);
			}
			else {
				printf(">%s&nbsp;&nbsp;",binput.name);
				continue;
			}
		}
	}
	fclose(bwi);
	printf("</select>");
	return;
}

/* modify a realm */
void UpdateRealm(long int id)
{
int i=0,j=0;
char buf[10];
char file2[300];
FILE *temp;
char temps[300];
long int last=0;
long int f=0;

	max=0;
	/* open the realms DB for reading, to find old info */
	sprintf(file,"%srealms.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	/* open a temp DB for writing, to write updated info to */
	sprintf(file2,"%stemp.bwi",config.log_dir);
	temp=fopen(file2,"wb");
	LockFile(temp);
	/* copy the same max from old DB to updated DB */
	fread(&max,sizeof(long),1,bwi);
	fwrite(&max,sizeof(long),1,temp);
	fseek(bwi,sizeof(long),SEEK_SET);
	fseek(temp,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&realms,sizeof(realms),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* we found the realm we want to update */
			if(realms.ID==id) {
				/* remove the realm's rotation file */
				sprintf(temps,"%sR%ld.rlm",config.log_dir,realms.ID);
				remove(temps);
				/* get realm info from form */
				getfield(realms.name,"name");
				getfield(buf,"RID");
				realms.ID=atol(buf);
				/* write to updated DB */
				fwrite(&realms,sizeof(realms),1,temp);
			}
			else fwrite(&realms,sizeof(realms),1,temp);
		}
	}
	fclose(bwi);
	UnlockFile(temp);
	fclose(temp);
	/* remove old DB, and rename updated DB to old DB */
	remove(file),rename(file2,file);                    
	/* now let's take care of the accounts file */
	getfield(buf,"RID");
	realms.ID=atol(buf);
	/* create a new accounts file to write to */
	sprintf(file,"%s%ld.rlm",config.log_dir,realms.ID);
	temp=fopen(file,"wb");
	LockFile(temp);
	max=0;
	/* go through all form data, load each include account */
	/* selected, then add that ad's ratio to the max count */
	for(i=0; i<=NUM_ENTRIES; i++) {
		if(strcmp(entries[i].name,"include")==0) {
			rentry.ID=atol(entries[i].val);
			fwrite(&rentry,sizeof(rentry),1,temp);
			LoadBanner(atol(entries[i].val));
			max+=binput.ratio;
		}
		else continue;
	}
	UnlockFile(temp);
	fclose(temp);
	/* now that we have one copy of each entry in the */
	/* accounts DB, let's make the rotation file */
	sprintf(file,"%sR%ld.rlm",config.log_dir,realms.ID);
	temp=fopen(file,"wb");
	LockFile(temp);
	/* write the max we added up above */
	/* this max is the total of all the included ad's */
	/* ratios */
	fwrite(&max,sizeof(long),1,temp);
	for(i=0; i<=NUM_ENTRIES; i++) {
		if(strcmp(entries[i].name,"include")==0) {
			rentry.ID=atol(entries[i].val);
			LoadBanner(rentry.ID);
			for(j=0; j<=binput.ratio; j++)
				fwrite(&rentry,sizeof(rentry),1,temp);
		}
		else continue;
	}
	UnlockFile(temp);
	fclose(temp);
	return;	
}

/* dump the "View Stats" command */
void DumpStats(void)
{
	/* now let's open the banners DB to find the ad */
	/* we want, and print out it's stats */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* found the ad w/the stats we want */
			if(binput.CID==cinput.ID) {
				/* now print out stats */
				sprintf(file,"%sbvstats_entry.html",config.html_dir);
				PrintStatsFile(file);
				printf("<p><table width=\"488\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
				printf("<tr bgcolor=\"#FFFFCC\"><td width=\"60\"><img src=\"%spics/spacer.gif\" width=\"60\" height=\"5\"></td>\n",config.bandir);
				printf("<td>\n\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
				printf("<tr><td><a href=\"%s?command=showvsgraphs&CID=%ld&BID=%ld&login=%s&passwd=%s\" onMouseOver=\"window.status='View Account Graph(s)'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\"><img src=\"%spics/graphtitle1.gif\" width=\"61\" height=\"19\" border=\"0\"></a></td>\n",config.ascript,binput.CID,binput.ID,login,passwd,config.bandir);
				printf("<td><a href=\"%s?command=showvsgraphs&CID=%ld&BID=%ld&login=%s&passwd=%s\" onMouseOver=\"window.status='View Account Graph(s)'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\"><img src=\"%spics/graphtitle2a.gif\" width=\"13\" height=\"19\" border=\"0\"></a></td>\n",config.ascript,binput.CID,binput.ID,login,passwd,config.bandir);
				printf("<td><img src=\"%spics/graphtitle3.gif\" width=\"353\" height=\"19\"></td></tr>\n",config.bandir);
				printf("<tr><td colspan=\"3\" align=\"right\"> <font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\"><b>");
				printf("<a href=\"%s?command=Modify+Banner&CID=%ld&BID=%ld&login=%s&passwd=%s\" onMouseOver=\"window.status='Edit This Banner'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\">Edit this banner</a></font></b>",config.ascript,binput.CID,binput.ID,login,passwd);
				printf("&nbsp;<img src=\"%spics/modarrow.gif\" width=\"8\" height=\"8\"></b></font></td>\n",config.bandir);
				printf("<td><img src=\"%spics/spacer.gif\" width=\"4\" height=\"4\"></td></tr>\n",config.bandir);
				printf("</table>\n</td></tr></table>\n");
			}
			else continue;
		}
	}
	fclose(bwi);
	return;
}

/* reset the current count on the ad */
void ResetCount(long int id)
{
	/* determine the current date (mm/dd/yyyy) */
	/* so we can tell the last time we reset the count */
	currdate=GetCurrentDate();
	/* now open the banners DB for an update, to reset */
	/* all the current (not total) statistics */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb+");
	LockFile(bwi);
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* found the ad we want to reset */
			if(binput.ID==id) {
				strcpy(binput.lreset,currdate);
				binput.imps=0,binput.clicks=0;
				fseek(bwi,ftell(bwi)-sizeof(binput),SEEK_SET);
				fwrite(&binput,sizeof(binput),1,bwi);
			}
			else continue;
		}
	}
	UnlockFile(bwi);
	fclose(bwi);
	return;
}

/* dump the "View Realms Stats" command */
void DumpRStats()
{
float cratio=0;
char file2[300];
FILE *temp;
int loop2=FALSE;
int month=0;
char buf[20];
char buf2[10];

	/* first let's determine the month */
	currdate=GetCurrentDate();
	buf[0]=currdate[0],buf[1]=currdate[1],buf[2]=0;
	month=atoi(buf);
	buf2[0]=currdate[6],buf2[1]=currdate[7],buf2[2]=currdate[8],buf2[3]=currdate[9],buf2[4]=0;
	/* now open the realm's accounts file to print out */
	/* the stats for each included account */
	sprintf(file,"%s%ld.rlm",config.log_dir,realms.ID);
	bwi=fopen(file,"rb");
	loop=FALSE;
	while(loop==FALSE) {
		fread(&rentry,sizeof(rentry),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* now, let's open the banners DB to load the included account */
			sprintf(file2,"%sbanners.bwi",config.log_dir);
			temp=fopen(file2,"rb");
			fseek(temp,sizeof(long),SEEK_SET);
			loop2=FALSE;
			while(loop2==FALSE) {
				fread(&binput,sizeof(binput),1,temp);
				if(feof(temp)) loop2=TRUE;
				else {
					/* found the ad we want the stats for */
					if(binput.ID==rentry.ID) {
						/* now print out stats */
						sprintf(file,"%sbvstats_entry.html",config.html_dir);
						PrintStatsFile(file);
					}
					else continue;
				}
			}
			fclose(temp);
		}
	}
	fclose(bwi);
	return;
}

/* dump the list of files in the banner dir, and select item if in memory */
void DumpFiles()
{
DIR *bd;
struct dirent *flist;

	printf("<select name=\"bfile\">");
	printf("<option value=\"NoValue\"> - select\n");
	/* if we can't open the banner dir, return */
	if((bd=opendir(config.banpath))==NULL) {
		printf("</select>");
		return;
	}
	/* read each file in the dir */
	while(flist=readdir(bd)) {
		/* ignore self and parent and pics dir */
		if(strcmp(flist->d_name,".")==0 || strcmp(flist->d_name,"..")==0 || strcmp(flist->d_name,"pics")==0)
			continue;
		/* if the filename is in memory (elsewhere), the select it */
		if(strcmp(binput.bfile,flist->d_name)==0)
			printf("<option value=\"%s\" selected>%s",flist->d_name,flist->d_name);
		else printf("<option value=\"%s\">%s",flist->d_name,flist->d_name);
	}
	closedir(bd);
	printf("</select>");
	return;
}

/* duplicate file */
void DupFile()
{
int ofd,nfd,n;
char file2[300];
char buf[4096];
int i=0;
char ext[10];

	/* get file information from form */
	getfield(bsubmit.bfile,"newf");
	getfield(binput.bfile,"bfile");
	/* if you try and rename a file to the same filename */
	/* just return (do nothing) */
	if(strcmp(bsubmit.bfile,binput.bfile)==0)
		return;
	/* If they did not enter a new filename, replace */
	/* it with <filename_copy>.<extension> */
	if(strcmp(bsubmit.bfile,"")==0) {
		for(i=strlen(binput.bfile); i>=0; i--) {
			if(binput.bfile[i]=='.') {
				strcpy(ext,&binput.bfile[i+1]);
				binput.bfile[i]=0;
				break;
			}
		}
		sprintf(bsubmit.bfile,"%s_copy.%s",binput.bfile,ext);
		getfield(binput.bfile,"bfile");
	}
	/* now let's do the actual duplicating */
	sprintf(file,"%s%s",config.banpath,binput.bfile);
	sprintf(file2,"%s%s",config.banpath,bsubmit.bfile);
	ofd=open(file,O_RDONLY);
	nfd=open(file2,O_WRONLY|O_CREAT,S_IRUSR|S_IWUSR);
	while(1) {
		n=read(ofd,buf,sizeof(buf));
		if(n<=0) break;
		write(nfd,buf,n);
	}
	close(ofd);
	close(nfd);
	return;
}

/* check all rotation files to make sure they are aligned correctly */
void CheckRotations()
{
long int count=0;
char file2[300];

	/* first, open the main random file to fix */
	sprintf(file,"%srandom.bwi",config.log_dir);
	if((bwi=fopen(file,"rb+"))==NULL)
		return;
	LockFile(bwi);
	fseek(bwi,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&bentry,sizeof(bentry),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else count++;
	}
	rewind(bwi);
	/* now that we know how many entries are in */
	/* the man random file, write the correct max */
	/* count to the file */
	fwrite(&count,sizeof(long),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	/*  Main random database is done, now to the secondary ones  */
	sprintf(file,"%sclients.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&cinput,sizeof(cinput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			sprintf(file2,"%sC%ld.clt",config.log_dir,cinput.ID);
			Maintain(file2);
		}
	}
	fclose(bwi);
	/*  Done maintaining all clients  */
	sprintf(file,"%srealms.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	fseek(bwi,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&realms,sizeof(realms),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			sprintf(file2,"%sR%ld.rlm",config.log_dir,realms.ID);
			Maintain(file2);
		}
	}
	fclose(bwi);
	/*  Done maintaining all realms, now return  */
	return;
}

/* if the rotation file isn't aligned correctly, fix it */
void Maintain(char *fileid)
{
FILE *fp;
long int loop2=0;
long int count=0;

	count=0;
	if((fp=fopen(fileid,"rb+"))==NULL)
		return;
	LockFile(fp);
	max=0;
	fseek(fp,sizeof(long),SEEK_SET);
	loop2=FALSE;
	while(loop2==FALSE) {
		fread(&rentry,sizeof(rentry),1,fp);
		if(feof(fp)) loop2=TRUE;
		else count++;
	}
	rewind(fp);
	/* now that we know how many entries are in */
	/* the random file, write the correct max */
	/* count to the file */
	fwrite(&count,sizeof(long),1,fp);
	UnlockFile(fp);
	fclose(fp);
	return;
}

/* print a file to the browser, parsing certain flags */
void PrintConfigFile(char *fileid)
{
char data;
char filedata;

	if((bwi=fopen(file,"rb"))==NULL)
		printf("Couldn't open '%s'!",fileid),exit(1);
	loop=0;
	while(loop==0) {
		data=fgetc(bwi);
		if(!feof(bwi)) {
			if(data!='|')
				printf("%c",data);
			else {
				filedata=fgetc(bwi);
				if(filedata=='1')
					printf("%s",config.sendmail);
				if(filedata=='2')
						printf("%d",config.tmout_period);
				if(filedata=='a')
					printf("%s",config.log_dir);
				if(filedata=='b')
					printf("%s",config.html_dir);
				if(filedata=='c')
					printf("%s",config.d_key);
				if(filedata=='d')
					printf("%s",config.ascript);
				if(filedata=='e')
					printf("%s",config.sscript);
				if(filedata=='g')
					printf("%s",config.rscript);
				if(filedata=='h')
					printf("%s",config.bandir);
				if(filedata=='j')
					if(config.httph==1)
						printf(" checked");
				if(filedata=='k')
					if(config.httph==0)
						printf(" checked");
				if(filedata=='A')
				{
					filedata=fgetc(bwi);
					if(filedata=='1' && config.iplogging==1)
						printf("checked");
					if(filedata=='2' && config.iplogging==0)
						printf("checked");
				}
				if(filedata=='E') {
					filedata=fgetc(bwi);
					if(filedata=='c')
						printf("%s",binput.bfile);
					if(filedata=='d')
						printf("%d",binput.width);
					if(filedata=='e')
						printf("%d",binput.height);
					if(filedata=='f')
						printf("%d",binput.border);
					if(filedata=='g')
						printf("%s",binput.ltext);
					if(filedata=='h')
						printf("%s",binput.alt);
					if(filedata=='i')
						printf("%s",binput.url);
					if(filedata=='j')
						printf("%s",binput.iother);
					if(filedata=='k')
						printf("%s",binput.lother);
					if(filedata=='m')
						DumpUserHTML(binput.ID);
				}
				if(filedata=='C')
					printf("%s",config.ascript);
				if(filedata=='l')
					printf("%s",config.banpath);
				if(filedata=='z')
					printf("Clicks:  %ld&nbsp;&nbsp;Impressions:  %ld",binput.tclicks,binput.timps);
				if(filedata=='L')
					printf("%s",login);
				if(filedata=='P')
					printf("%s",passwd);
				if(filedata=='S') {
					filedata=fgetc(bwi);
					/*if(filedata=='a')
						printf("%s",PrintServerStatus());*/
				}
				if(filedata=='B') {
					filedata=fgetc(bwi);
					if(filedata=='a')
						printf("%s",srvcfg.fullpath);
					if(filedata=='b')
						printf("%d",srvcfg.port);
					if(filedata=='c')
						printf("%d",srvcfg.total_connections);
					if(filedata=='d')
						printf("%s",srvcfg.server);
				}
				if(filedata=='X')
					printf("%sbannerheader.gif",config.bandir);
				if(filedata=='y')
					printf("%s",config.hpage);
				if(filedata=='D') {
					filedata=fgetc(bwi);
					if(filedata=='a')
						printf("%s",remind.sendmail);
					if(filedata=='b') {
						printf("<input type=text size=3 name=\"dmuch\" value=\"%d\">&nbsp;Days before banner expiration<br>",remind.dmuch);
						printf("<input type=text size=3 name=\"imuch\" value=\"%d\">&nbsp;%% of their max exposures or clicks are left",remind.imuch);
					}
					if(filedata=='c')
						printf("%s",remind.aemail);
					if(filedata=='d')
						printf("%s",remind.subject);
					if(filedata=='e') {
						sprintf(file,"%simessage.msg",config.log_dir);
						dump(file);
					}
					if(filedata=='f') {
						sprintf(file,"%sdmessage.msg",config.log_dir);
						dump(file);
					}
				}
				if(filedata=='G')
					printf("%s",config.bandir);
				if(filedata=='W')
				{
					/*  If ad is just a banner, or if ad is both banner + HTML  */
					if(binput.method==1 || binput.method==3) {
						printf("<a href=\"%s\" %s><img src=\"%s%s\" %s border=%d",binput.url,binput.lother,config.bandir,binput.bfile,binput.iother,binput.border);
						printf(" width=%d height=%d alt=\"%s\"><br>%s</a>",binput.width,binput.height,binput.alt,binput.ltext);
					}
					/*  If ad is just HTML  */
					if(binput.method==2 || binput.method==3)
						DumpUserHTML(binput.ID);
				}
				//else printf("%c",filedata);
			}
		}
		else loop=1;
	}
	fclose(bwi);
	return;
}

/* save new configuration */
void SaveConfig()
{
	/* create the config.ini file */
	sprintf(file,"config.ini");
	if((bwi=fopen(file,"wb"))!=NULL) {
		/* gather config info from form */
		getfield(config.log_dir,"log_dir");getfield(config.html_dir,"html_dir");
		getfield(config.d_key,"d_key");getfield(config.ascript,"ascript");
		getfield(config.rscript,"rscript");getfield(config.sscript,"sscript");
		getfield(config.bandir,"bandir");getfield(config.banpath,"banpath");
		config.httph=getfasint("httph");
		config.iplogging = getfasint("iplogging");
		getfield(config.hpage,"hpage");
		getfield(config.sendmail,"sendmail");
		config.tmout_period = getfasint("tmout_period");
		/* now write, and save */
		fwrite(&config,sizeof(config),1,bwi);
		fclose(bwi);
		return;
	}
	else printf("Could not create config file!  Make sure permissions are set correctly to the current directory!"),exit(0);
}

/* dump out the default banner modify form */
void PrintDefault()
{
	/* load info for Default Banner Account */
	LoadDefault();
	/* print out modify form */
	sprintf(file,"%sbdefault.html",config.html_dir);
	PrintFile(file);
	exit(0);
}

/* load the default banner's info into memory */
void LoadDefault()
{
	/* open default banner DB, the load from it */
	sprintf(file,"%sdefault.bwi",config.log_dir);
	if((bwi=fopen(file,"rb"))==NULL)
		return;
	fread(&binput,sizeof(binput),1,bwi);
	fclose(bwi);
	return;
}

/* modify default banner */
void UpdateDBanner()
{
	bsubmit.ID=0;
	/* gather default banner info from form */
	getfield(bsubmit.bfile,"bfile");
	bsubmit.width=getfasint("width");bsubmit.height=getfasint("height");
	bsubmit.border=getfasint("border");getfield(bsubmit.ltext,"ltext");
	getfield(bsubmit.alt,"alt");getfield(bsubmit.url,"URL");
	getfield(bsubmit.iother,"iother");getfield(bsubmit.lother,"lother");
	bsubmit.type=getfasint("type");
	/* save HTML info */
	SaveUserHTML(bsubmit.ID);
	/* now create the Default Banner DB, and write info to it */
	sprintf(file,"%sdefault.bwi",config.log_dir);
	bwi=fopen(file,"wb");
	LockFile(bwi);
	fwrite(&bsubmit,sizeof(bsubmit),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
}

/* print out the change admin passwd form */
void PrintAdmPass()
{
	/* load current admin login info */
	sprintf(file,"%spasswd",config.log_dir);
	if((bwi=fopen(file,"rb"))!=NULL)
		fread(&admin,sizeof(admin),1,bwi),fclose(bwi);
	/* print out form to change admin login info */
	printf("<title>BannerWheel Industrial : Set Admin Password</title>");
	printf("<body bgcolor=white><form method=POST action=\"%s\">",config.ascript);
	printf("<input type=hidden name=\"login\" value=\"%s\"><input type=hidden name=\"passwd\" value=\"%s\">",login,passwd);
	printf("<input type=hidden name=\"command\" value=\"saveadmpass\">");
	printf("<table border=0 align=left><tr><td align=right>");
	printf("<font face=Helvetica><b>Admin Login: </b></font></td><td align=left><input type=text name=\"nlogin\" size=50 value=\"%s\"></td></tr>",admin.login);
	printf("<tr><td align=right><font face=Helvetica><b>(New) Admin Password:</b></font></td><td align=left><input type=password name=\"npasswd\" size=50></td></tr>");
	printf("<tr><td align=right><font face=Helvetica><b>Verify Password:</b></font></td><td align=left><input type=password name=\"verify\" size=50></td></tr>");
	printf("<tr><td colspan=2><center><input type=submit value=\"Save Admin Login Information\"><input type=reset value=\"Clear\"></center></td></tr>\n");
	printf("</table></form></body>");
}

void SaveAdmPass()
{
char temp[50];

	getfield(admin.login,"nlogin");
	getfield(temp,"npasswd");
	sprintf(file,"%spasswd",config.log_dir);
	getfield(admin.passwd,"verify");
	if(strcmp(admin.passwd,temp)!=0)
		error("The two password do not match!");
	if((bwi=fopen(file,"wb"))==NULL)
		error("Could not create a 'passwd' file in the Log Directory!  Make sure the correct permissions are set!");
	LockFile(bwi);
	strcpy(admin.passwd,(char*)crypt(temp,config.d_key));
	fwrite(&admin,sizeof(admin),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	strcpy(login,admin.login);
	strcpy(passwd,admin.passwd);
	return;
}

void ResetDBs()
{
	max=0;
	sprintf(file,"%sID.bwi",config.log_dir);
	if((bwi=fopen(file,"wb"))==NULL)
		printf("Could not reset the '%s' file!\n",file),exit(0);
	fwrite(&max,sizeof(long),1,bwi);
	fclose(bwi);
	sprintf(file,"%sRID.bwi",config.log_dir);
	if((bwi=fopen(file,"wb"))==NULL)   
		printf("Could not reset the '%s' file!\n",file),exit(0);
	fwrite(&max,sizeof(long),1,bwi);
	fclose(bwi);
	sprintf(file,"%sbanners.bwi",config.log_dir);
	if((bwi=fopen(file,"wb"))==NULL)   
		printf("Could not reset the '%s' file!\n",file),exit(0);
	fwrite(&max,sizeof(long),1,bwi);
	fclose(bwi);
	sprintf(file,"%sclients.bwi",config.log_dir);
	if((bwi=fopen(file,"wb"))==NULL)   
		printf("Could not reset the '%s' file!\n",file),exit(0);
	fwrite(&max,sizeof(long),1,bwi);
	/* for LE Version */
	cinput.ID = 1;
	strcpy(cinput.name, "BWI Ads");
	cinput.lenabled = 0;
  	fwrite(&cinput,sizeof(cinput),1,bwi);
	fclose(bwi);
	/* End LE Edit */

	sprintf(file,"%sCID.bwi",config.log_dir);
	if((bwi=fopen(file,"wb"))==NULL)
		printf("Could not reset the '%s' file!\n",file),exit(0);
	fwrite(&max,sizeof(long),1,bwi);
	fclose(bwi);
	/* now for the LE Version's random file */
	sprintf(file,"%sC1.clt", config.log_dir);
	if((bwi=fopen(file,"wb"))==NULL)   
		printf("Could not reset the '%s' file!\n",file),exit(0);
	fclose(bwi);
	/* End LE */

	sprintf(file,"%srandom.bwi",config.log_dir);
	if((bwi=fopen(file,"wb"))==NULL)   
		printf("Could not reset the '%s' file!\n",file),exit(0);
	fwrite(&max,sizeof(long),1,bwi);
	fclose(bwi);
	sprintf(file,"%srealms.bwi",config.log_dir);
	if((bwi=fopen(file,"wb"))==NULL)   
		printf("Could not reset the '%s' file!\n",file),exit(0);
	fwrite(&max,sizeof(long),1,bwi);
	fclose(bwi);
	return;
}

char * PrintServerStatus()
{
FILE *temp;
char *ret;

	sprintf(file,"bwi.srv");
	if((temp=fopen(file,"rb"))==NULL)
		return ("Inactive");
	fread(&srvcfg,sizeof(srvcfg),1,temp);
	fclose(temp);
	if(srvcfg.status==1) {
		sprintf(ret,"Active!");// since <b>%s</b>",srvcfg.lstart);
		return (ret);
	}
	else return ("Inactive");
}

/* dump all monthly stats available */
void DumpMonths(char *date)
{
char newdate[3];
int month=0;

	/* if no month is specified, use current month */
	if(date==NULL) {
		currdate=GetCurrentDate();
		newdate[0]=currdate[0],newdate[1]=currdate[1],newdate[2]=0;
		month=atoi(newdate);
	}
	/* if a month IS specified, use that month */
	if(date!=NULL) {
		newdate[0]=date[0],newdate[1]=date[1],newdate[2]=0;
		month=atoi(newdate);
	}
	/* print out months list */
	printf("<select name=\"month\">");
	printf("<option value=\"1\"%s>January<option value=\"2\"%s>February",month==1 ? " selected" : " ",month==2 ? " selected" : " ");
	printf("<option value=\"3\"%s>March<option value=\"4\"%s>April",month==3 ? " selected" : " ",month==4 ? " selected" : " ");
	printf("<option value=\"5\"%s>May<option value=\"6\"%s>June",month==5 ? " selected" : " ",month==6 ? " selected" : " ");
	printf("<option value=\"7\"%s>July<option value=\"8\"%s>August",month==7 ? " selected" : " ",month==8 ? " selected" : " ");
	printf("<option value=\"9\"%s>September<option value=\"10\"%s>October",month==9 ? " selected" : " ",month==10 ? " selected" : " ");
	printf("<option value=\"11\"%s>November<option value=\"12\"%s>December</select>",month==11 ? " selected" : " ",month==12 ? " selected" : " ");
	return;
}

/* dump all years available */
void DumpYears(char *date)
{
int year=0,i=0,found=0,next=-1;
char buf[10];
int years[MAX_YEARS];
DIR *bd;
struct dirent *flist;
char buf2[10];

	year=atoi(date);
	/* set years array to NULL (all members) */
	for(i=0; i<=MAX_YEARS; i++) years[i]=0;
	printf("<select name=\"years\">");
	if((bd=opendir(config.log_dir))==NULL) {
		printf("</select>");
		return;
	}
	/* read each file in dir */
	while(flist=readdir(bd)) {
		if(strcmp(flist->d_name,".")==0 || strcmp(flist->d_name,"..")==0)
			continue;
		/* if there is a file with the ".sts" extension, it's */
		/* a daily stats file */
		if(strstr(flist->d_name,".sts")!=NULL) { 
			buf[0]=flist->d_name[0],buf[1]=flist->d_name[1],buf[2]=flist->d_name[2],buf[3]=flist->d_name[3];
			buf[4]=0,year=atoi(buf);
			i=found=FALSE;
			/* find out if the year is already in the array */
			while((i<=MAX_YEARS) && (years[i]!=0)) {
				if(years[i]==year) found=TRUE;
				++i;
			}
			/* if the year isn't already in the array */
			/* then let's add it */
			if(found!=TRUE) years[++next]=year;
		}
		else continue;
	}
	closedir(bd);
	next=0;
	/* now let's go through the years array, and print */
	/* out each member in list form */
	while((years[next]!=0) && (next<=MAX_YEARS)) {
		if(years[next]==0) break;
		if(years[next]!=0 && years[next]==year)
			printf("<option value=\"%d\" selected>%d",years[next],years[next]);
		if(years[next]!=0 && years[next]!=year)
			printf("<option value=\"%d\">%d",years[next],years[next]);
		next++;
	}
	printf("</select>");
	return;
}

/* save all Reminder Email Information into "remind.msg" */
void SaveReminderEmail()
{
char message[1000];

	/* gather reminder info from form */
	getfield(remind.sendmail,"sendmail");
	getfield(remind.aemail,"aemail");
	getfield(remind.subject,"subject");
	getfield(message,"imessage");
	/* write messages to their files */
	sprintf(file,"%simessage.msg",config.log_dir);
	bwi=fopen(file,"w");
	LockFile(bwi);
	fprintf(bwi,"%s",message);
	UnlockFile(bwi);
	fclose(bwi);
	getfield(message,"dmessage");
	sprintf(file,"%sdmessage.msg",config.log_dir);
	bwi=fopen(file,"w");
	LockFile(bwi);
	fprintf(bwi,"%s",message);
	UnlockFile(bwi);
	fclose(bwi);
	/* now write all other reminder info to Reminders DB */
	remind.imuch=getfasint("imuch");
	remind.dmuch=getfasint("dmuch");
	sprintf(file,"%sremind.msg",config.log_dir);
	bwi=fopen(file,"wb");
	LockFile(bwi);
	fwrite(&remind,sizeof(remind),1,bwi);
	UnlockFile(bwi);
	fclose(bwi);
	return;
}

/* automatically disable banner */
void DisableBanner(long int id)
{
	/* open the banners DB to find the ad we want to disable */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb+");
	LockFile(bwi);
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* found the ad we want */
			if(binput.ID==id) {
				/* set termination method to max imps */
				binput.type=1;
				/* set max imps to 0 */
				binput.max=0; 
				/* take away all bonus exposures */
				binput.bonus=0;
				fseek(bwi,ftell(bwi)-sizeof(binput),SEEK_SET);
				fwrite(&binput,sizeof(binput),1,bwi);
			}
			else continue;
		}
	}
	UnlockFile(bwi);
	fclose(bwi);
	return;
}

/* check if the client has any disable banners */
int CheckCDisabled(long int id,int which)
{
FILE *temp;
char file2[300];
int loop2=0;
int found=0;
char numdate[15];
long int cdate=0;
long int edate=0;
long int bdate=0;

	currdate=GetCurrentDate();
	/* open the banners DB to find disabled ads */
	sprintf(file2,"%sbanners.bwi",config.log_dir);
	temp=fopen(file2,"rb");
	loop2=FALSE;
	fseek(temp,sizeof(long),SEEK_SET);
	while(loop2==FALSE) {
		fread(&binput,sizeof(binput),1,temp);
		if(feof(temp)) loop2=TRUE;
		else {
			/* found the ad we want */
			if(binput.CID==id) {
				/* create current date */
				numdate[0]=currdate[6],numdate[1]=currdate[7];
				numdate[2]=currdate[8],numdate[3]=currdate[9];
				numdate[4]=currdate[0],numdate[5]=currdate[1];
				numdate[6]=currdate[3],numdate[7]=currdate[4];
				numdate[8]='\0',cdate=atol(numdate);
				/* create end date */
				numdate[0]=binput.edate[6],numdate[1]=binput.edate[7];
				numdate[2]=binput.edate[8],numdate[3]=binput.edate[9];
				numdate[4]=binput.edate[0],numdate[5]=binput.edate[1];
				numdate[6]=binput.edate[3],numdate[7]=binput.edate[4];
				numdate[8]='\0',edate=atol(numdate);
				/* create start date */
				numdate[0]=binput.bdate[6],numdate[1]=binput.bdate[7];
				numdate[2]=binput.bdate[8],numdate[3]=binput.bdate[9];
				numdate[4]=binput.bdate[0],numdate[5]=binput.bdate[1];
				numdate[6]=binput.bdate[3],numdate[7]=binput.bdate[4];
				numdate[8]='\0',bdate=atol(numdate);
				
				/* Active Ads */
				/* if expires by max imps and has some left, or has bonus credits */
				if(which==2 && binput.type==1 && binput.timps<binput.max || (binput.CID==cinput.ID && binput.bonus>0 && binput.type==1)) {
					found=TRUE;
					break;
				}
				/* if expires by date and birth is before current, and end is after current, or has bonus credits */
				if(which==2 && binput.type==3 && cdate<edate && bdate<cdate  || (binput.CID==cinput.ID && binput.bonus>0 && binput.type==3)) {
					found=TRUE;
					break;
				}
				/* if has unlimited exposures */
				if(which==2 && binput.type==2) {
					found=TRUE;
					break;
				}
				/* if expires by max clicks, and has somee left, or bonus credits */
				if(which==2 && binput.type==4 && binput.tclicks<binput.max || (binput.type==4 && binput.bonus>0)) {
					found=TRUE;
					break;
				}
				/* End Active Ads */
				
				/* Inactive Ads */
					
				/* if expires by max imps and has none left, or has no bonus credits */
				if(which==1 && binput.type==1 && binput.timps>=binput.max || (which==1 && binput.bonus<=0 && binput.type==1)) {
					found=TRUE;
					break;
				}
				/* if expires by date, and birth hasn't occured yet or death has occured */
				if(which==1 && binput.type==3 && cdate>edate || (which==1 && bdate>cdate && binput.type==3) || (which==1 && binput.bonus>0 && binput.type==3)) {
					found=TRUE;
					break;
				}
				/* if expires by max clicks, and has none left, nor any bonus credits */
				if(which==1 && binput.type==4 && binput.tclicks>=binput.max || (which==1 && binput.type==4 && binput.bonus<=0)) {
					found=TRUE;
					break;
				}
				
				/* End Inactive Ads */
			}
			else continue;
		}
	}
	fclose(temp);
	return (found);		
}

/* checks if the client has any banners */
int HasBanners(long int id)
{
FILE *temp;
char file2[300];
int loop2=0;
int found=0;

	/* open the banners DB to find out if the client */
	/* has ads */
	sprintf(file2,"%sbanners.bwi",config.log_dir);
	temp=fopen(file2,"rb");
	fseek(temp,sizeof(long),SEEK_SET);
	loop2=FALSE;
	while(loop2==FALSE) {
		fread(&binput,sizeof(binput),1,temp);
		if(feof(temp)) loop2=TRUE;
		else {
			/* found one!  break */
			if(binput.CID==id) {
				found=TRUE;
				break;
			}
			else continue;
		}
	}
	fclose(temp);
	if(found==TRUE)
		return (1);
	else return (0);
}

/* checks all clients for any disabled banners */
int HasDisableBanners(long int id)
{
FILE *temp;
char file2[300];
int loop2=0;
int found=0;

	/* open the banners DB to find disabled banners*/
	sprintf(file2,"%sbanners.bwi",config.log_dir);
	temp=fopen(file,"rb");
	loop2=FALSE;
	fseek(temp,sizeof(long),SEEK_SET);
	while(loop2==FALSE) {
		fread(&binput,sizeof(binput),1,temp);
		if(feof(temp)) loop2=TRUE;
		else {
			/* found one, break */
			if(binput.CID==id) {
				found=TRUE;
				break;
			}
			else continue;
		}
	}
	fclose(temp);
	if(found==TRUE)
		return (1);
	else return (0);
}

/* dump the export banners form for the client */
void DumpExportBanners(long int id)
{
FILE *temp;
long int loop2=FALSE;

	strcpy(flag,cinput.name);
	printf("<tr><td><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\">");
	printf("<b>Export (yes)?</b></font></td><td><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\">");
	printf("<b>Banner Name</b></font></td><td><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\"><b>Export To</b></font></td></tr>");
	/* now let's find which banners need to be exported */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	temp=fopen(file,"rb");
	fseek(temp,sizeof(long),SEEK_SET);
	loop2=FALSE;
	while(loop2==FALSE) {
		fread(&binput,sizeof(binput),1,temp);
		if(feof(temp)) loop2=TRUE;
		else {
			/* found one */
			if(binput.CID==id) {
				printf("<tr><td><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\"><input type=checkbox name=\"export%ld\" value=\"yes\"></td></font>",binput.ID);
				printf("<td><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\"><a href=\"%s?BID=%ld&command=fromcharts\" target=\"new\">%s</a></font>",config.sscript,binput.ID,binput.name);
				printf("</td><td><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\"><select name=\"CID%ld\">",binput.ID);
				strcpy(cinput.name,"");
				MainStuff();
				printf("</select></td></tr>");
			}
			else continue;
		}
	}
	fclose(temp);
	return;
}

/* do the actual exporting */
void DoExportBans(long int id)
{
FILE *temp;
char file2[300];
char buf1[20];
char buf2[20];
long int cid=0;		/* hold new client ID */

	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb+");
	LockFile(bwi);
	fseek(bwi,sizeof(long),SEEK_SET);
	loop=FALSE;
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			if(binput.CID==id) {
				sprintf(buf1,"export%ld",binput.ID);
				getfield(buf2,buf1);
				/* if banner was chosen to export */
				if(strcmp(buf2,"yes")==0) {
					sprintf(buf1,"CID%ld",binput.ID);
					getfield(buf2,buf1);
					cid=atol(buf2);
					/* fix the random files */
					FixRandomFiles(binput.ID,binput.CID,cid);
					binput.CID=cid;
					/* now update the DB */
					fseek(bwi,ftell(bwi)-sizeof(binput),SEEK_SET);
					fwrite(&binput,sizeof(binput),1,bwi);
				}
				/* if not selected to export, continue and let DeleteClient() take care of it */
				else continue;
			}
			else continue;
		}
	}
	UnlockFile(bwi);
	fclose(bwi);
	return;
}

/* fix the random file(s) from the old client to the new one */
void FixRandomFiles(long int id, long int oldcid, long int newcid)
{
FILE *temp;
FILE *temp2;
FILE *temp3;
char file2[300];
char file3[300];
long int loop2=FALSE;
int i=0;

	/* open old client's random file */
	sprintf(file,"%sC%ld.clt",config.log_dir,oldcid);
	temp=fopen(file,"rb");
	/* open temp random file to write old client's info for non-exported banners */
	sprintf(file3,"%stemp.clt",config.log_dir);
	temp3=fopen(file3,"wb");
	LockFile(temp3);
	/* open the new client's random file for updating */
	sprintf(file2,"%sC%ld.clt",config.log_dir,newcid);
	temp2=fopen(file2,"rb+");
	LockFile(temp2);
	/* read old max from old client, and write to temp file */
	max=0;
	fread(&max,sizeof(long),1,temp);
	max-=binput.ratio;
	fwrite(&max,sizeof(long),1,temp3);
	/* now read the max from the new client, and add to it */
	max=0;
	fread(&max,sizeof(long),1,temp2);
	max+=binput.ratio;
	rewind(temp2);
	fwrite(&max,sizeof(long),1,temp2);
	UnlockFile(temp2);
	fclose(temp2);
	temp2=fopen(file2,"ab");
	LockFile(temp2);
	fseek(temp,sizeof(long),SEEK_SET);
	/* now let's search through the old db and move the entries to the new db */
	loop2=FALSE;
	while(loop2==FALSE) {
		fread(&centry,sizeof(centry),1,temp);
		if(feof(temp)) loop2=TRUE;
		else {
			if(centry.ID==id) {
				/* write to new client */
				for(i=1; i<=binput.ratio; i++)
					fwrite(&centry,sizeof(centry),1,temp2);
			}
			/* write back to old client */
			else {
				for(i=1; i<=binput.ratio; i++)
					fwrite(&centry,sizeof(centry),1,temp3);
			}
		}
	}
	UnlockFile(temp2);
	fclose(temp2);
	UnlockFile(temp3);
	fclose(temp3);
	fclose(temp);
	remove(file3),rename(file3,file);
	return;
}

void PrintMainPageStats()
{             
FILE *temp;
int loop2=FALSE;

	sprintf(file,"%sclients.bwi",config.log_dir);
	temp=fopen(file,"rb");
	if( temp == NULL )
		return;
		
	/* print out the opening table info */
 	printf("\n\n<p><img src=\"%spics/bwi-ataglancetitle.gif\" width=\"428\" height=\"19\"><br>\n",config.bandir);
 	// thorn edit
  printf("<img src=\"%spics/bwi-atag-stats.gif\" width=\"118\" height=\"11\"><br><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>\n",config.bandir);
  printf("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#FF9900\">\n");
  printf("<tr><td>\n");
  printf("\t<table  border=\"0\" cellspacing=\"1\" cellpadding=\"3\">\n");
  /* now print out each clients stats */
  fseek(temp, sizeof(long), SEEK_SET);
  loop2=FALSE;
  while(loop2==FALSE)
  {
  	fread(&cinput, sizeof(cinput), 1, temp);
   	if(feof(temp)) loop2=TRUE;
    else
    {
    	printf("\n<!-- Begin Daily Stats (Brief) for '%s' -->\n",cinput.name);
     	printf("\t\t<tr><td bgcolor=\"#FFFF66\" colspan=\"3\">\n");
      printf("\t\t\t<table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
      printf("\t\t\t\t<tr><td width=\"26\">\n");
      printf("\t\t\t\t\t<font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\">\n");
      printf("\t\t\t\t\t<a href=\"javascript:  openContactInfo(%ld);\" onMouseOver=\"window.status='View Contact Information'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\"><img src=\"%spics/bwi-icon-client.gif\" width=\"26\" height=\"32\" border=\"0\"></a></font>\n",cinput.ID,config.bandir);
      printf("\t\t\t\t</td>\n");
      printf("\t\t\t\t<td width=\"8\">\n");
      printf("\t\t\t\t\t<img src=\"%spics/spacer.gif\" width=\"8\" height=\"8\">\n",config.bandir);
      printf("\t\t\t\t</td>\n");
      printf("\t\t\t\t<td>\n");
      printf("\t\t\t\t\t<font face=\"Verdana, Arial, Helvetica, sans-serif\"><b>%s</b><br>\n",cinput.name);
      printf("\t\t\t\t\t<a href=\"mailto:%s\" onMouseOver=\"window.status='E-Mail Client'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\"><font size=\"1\">%s</font></a></font><br>\n",cinput.email,cinput.email);
      printf("\t\t\t\t\t<img src=\"%spics/spacer.gif\" width=\"250\" height=\"2\">\n",config.bandir);
      printf("\t\t\t\t</td>\n");
      printf("\t\t\t\t<td align=\"right\">\n");
      printf("\t\t\t\t\t<font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\"><b><font size=\"1\">");
      printf("<a href=\"%s?command=View+Stats&CID=%ld&login=%s&passwd=%s\" onMouseOver=\"window.status='View Stats'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\">View Stats</a></font></b></font>",config.ascript,cinput.ID,login,passwd);
      printf("&nbsp;<img src=\"%spics/modarrow.gif\" width=\"8\" height=\"8\"><br>\n",config.bandir);
      printf("\t\t\t\t\t<img src=\"%spics/spacer.gif\" width=\"130\" height=\"1\">\n",config.bandir);
      printf("\t\t\t\t</td>\n");
      printf("\t\t\t\t</tr>\n");
      printf("\t\t\t</table>\n");
      printf("\t\t</td></tr>\n");
      if(HasBanners(cinput.ID))
      {
	      printf("\t\t<tr><td bgcolor=\"#FF9900\" width=\"*\">\n");
  	    printf("\t\t\t<font size=\"2\" face=\"Verdana, Arial, Helvetica, sans-serif\"><b><font size=\"1\"><img src=\"%spics/spacer.gif\" width=\"19\" height=\"8\">BANNER NAME <br>\n",config.bandir);
    	  printf("\t\t\t</font><font size=\"1\"> </font></b></font>\n");
	      printf("\t\t</td>\n");
  	    printf("\t\t<td bgcolor=\"#FF9900\" width=\"40\">\n");
    	  printf("\t\t\t<font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\">EXP</font>\n");
	      printf("\t\t</td>\n");
  	    printf("\t\t<td bgcolor=\"#FF9900\" width=\"40\">\n");
    	  printf("\t\t\t<font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\">CT</font>\n");
	     	printf("\t\t</td>\n");
  	    printf("\t\t</tr>\n");
    	  PrintTodaysStats(cinput.ID);
    	}
		}
  }
  printf("\t</table>\n");
 	printf("</td></tr>\n");
  // thorn edit
  printf("</table></td><td><img src=\"%spics/spacer.gif\" width=\"4\" height=\"4\"></td></tr></table>\n",config.bandir);
  fclose(temp);
  return;
}

void PrintTodaysStats(long int cid)
{
	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	if(bwi==NULL)
		return;
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE)
	{
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else
		{
			if(binput.CID==cid)
			{
				 printf("<!-- Today's stats for '%s' - owned by '%s' -->\n\n",binput.name,cinput.name);
				 printf("\t\t<tr><td bgcolor=\"#FFFF99\">\n");
				 printf("\t\t\t<table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
				 printf("\t\t\t\t<tr><td>\n");
				 printf("\t\t\t\t\t<font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\"><img src=\"%spics/docicon.gif\" width=\"11\" height=\"11\" hspace=\"4\">", config.bandir);
				 if(!IsEnabled(binput.ID))
				 {
				 	printf("<b><font color=\"#CCCCCC\">%s</font></b></font>\n",binput.name);
				 }
				 else
				 {
				 	printf("<b>%s</b></font>\n",binput.name);
				 }
				 printf("\t\t\t\t</td>\n");
				 printf("\t\t\t\t<td align=\"right\">\n");
				 printf("\t\t\t\t\t<font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\">[&nbsp;");
				 printf("<a href=\"javascript:toViewBanner(%ld,%ld);\" onMouseOver=\"window.status='View Banner'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\">view</a>", binput.CID,binput.ID);
				 printf(" | <a href=\"%s?command=Modify+Banner&BID=%ld&CID=%ld&login=%s&passwd=%s\" onMouseOver=\"window.status='Edit Banner'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\">edit</a>",config.ascript,binput.ID,binput.CID,login,passwd);
				 if(IsEnabled(binput.ID))
				 {
				 	printf(" | <a href=\"%s?command=Disable+Banner2&BID=%ld&CID=%ld&login=%s&passwd=%s\" onMouseOver=\"window.status='Disable Banner'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\">disable</a>",config.ascript,binput.ID,binput.CID,login,passwd);
				 }
				 else
				 {
				 	printf(" | <a href=\"%s?command=Enable+Banner2&BID=%ld&CID=%ld&login=%s&passwd=%s\" onMouseOver=\"window.status='Enable Banner'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\">enable</a>",config.ascript,binput.ID,binput.CID,login,passwd);
				 }
				 printf(" | <a href=\"%s?command=Delete+Banner2&BID=%ld&CID=%ld&login=%s&passwd=%s\" onMouseOver=\"window.status='Delete Banner'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\">delete</a> ]</font>\n",config.ascript,binput.ID,binput.CID,login,passwd);
				 printf("\t\t\t\t</td></tr>\n");
				 printf("\t\t\t</table>\n");
				 printf("\t\t</td>\n\t\t<td bgcolor=\"#FFFFCC\">\n");
				 if( !IsEnabled(binput.ID) )
				 {
				 	printf("\t\t\t<font size=\"1\"><font face=\"Verdana, Arial, Helvetica, sans-serif\">n/a</font></font>\n");
				 }
				 else
				 {
				 	printf("\t\t\t<font size=\"1\"><font face=\"Verdana, Arial, Helvetica, sans-serif\">%ld</font></font>\n",GetTodaysImps(binput.ID));	
				 }
				 printf("\t\t</td>\n");
				 printf("\t\t<td bgcolor=\"#FFFFCC\">\n");
				 if( !IsEnabled(binput.ID) )
				 {
				 	printf("\t\t\t<font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\">n/a</font>\n");
				 }
				 else
				 {
				  printf("\t\t\t<font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\">%ld</font>\n", GetTodaysClicks(binput.ID));
				 }
				 printf("\t\t</td>\n");
 				 printf("\t\t</tr>\n");
 				 printf("\t\t<!-- End Today's Stats --> \n\n");
			}
			else continue;
		}
	}
	fclose(bwi);
	return;
}

long int GetTodaysImps(long int bid)
{
FILE *temp;
char file2[300];
int loop2=FALSE;
long int tot_imps=0;
char *currdate;
char numdate[15];
int month=0,day=0,year=0;

	currdate=GetCurrentDate();
	numdate[0]=currdate[0],numdate[1]=currdate[1],numdate[2]=0;
	month=atol(numdate);
	numdate[0]=currdate[3],numdate[1]=currdate[4],numdate[2]=0;
	day=atol(numdate);
	numdate[0]=currdate[6],numdate[1]=currdate[7],numdate[2]=currdate[8],numdate[3]=currdate[9],numdate[4]=0;
	year=atol(numdate);
	sprintf(file2,"%s%d-%d.sts",config.log_dir,year,month);
	if((temp=fopen(file2,"rb"))==NULL)
		return (0);
	loop2=FALSE;
	while(loop2==FALSE)
	{
		fread(&dstats,sizeof(dstats),1,temp);
		if(feof(temp)) loop2=TRUE;
		else
		{
			if(dstats.ID==bid && strcmp(dstats.date,currdate)==0)
			{
				tot_imps = dstats.imps;
				break;
			}
			else continue;
		}
	}
	fclose(temp);
	return (tot_imps);
}

long int GetTodaysClicks(long int bid)
{
FILE *temp;
char file2[300];
int loop2=FALSE;
long int tot_clicks=0;
char *currdate;
char numdate[15];
int month=0,day=0,year=0;

	currdate=GetCurrentDate();
	numdate[0]=currdate[0],numdate[1]=currdate[1],numdate[2]=0;
	month=atol(numdate);
	numdate[0]=currdate[3],numdate[1]=currdate[4],numdate[2]=0;
	day=atol(numdate);
	numdate[0]=currdate[6],numdate[1]=currdate[7],numdate[2]=currdate[8],numdate[3]=currdate[9],numdate[4]=0;
	year=atol(numdate);
	sprintf(file2,"%s%d-%d.sts",config.log_dir,year,month);
	if((temp=fopen(file2,"rb"))==NULL)
		return (0);
	loop2=FALSE;
	while(loop2==FALSE)
	{
		fread(&dstats,sizeof(dstats),1,temp);
		if(feof(temp)) loop2=TRUE;
		else
		{
			if(dstats.ID==bid && strcmp(dstats.date,currdate)==0)
			{
				tot_clicks = dstats.clicks;
				break;
			}
			else continue;
		}
	}
	fclose(temp);
	return (tot_clicks);
}

void PrintStatsFile(char *fileid)
{
char filedone;
char filedata;
FILE *fp;
int iloop;
char next;

	/* set filedone to FALSE, therefore when it is TRUE, we've reached EOF */
	filedone=FALSE;
	fp=fopen(fileid,"rb");
    if(fp!=NULL) {
		while(filedone==FALSE) {
			filedata=fgetc(fp);
			if(!feof(fp)) {
				/* if the char is not the beginning of a flag in the file, print it out */
				if(filedata!='|')
					printf("%c",filedata);
				/* if it is the beginning of a flag, let's determine which flag */
				else {
					filedata=fgetc(fp);
					if(filedata=='G')
						printf("%s",config.bandir);
					if(filedata=='L')
						printf("%s",login);
					if(filedata=='P')
						printf("%s",passwd);
					if(filedata=='C')
						printf("%s",config.ascript);
					if(filedata=='A')
						printf("%ld",cinput.ID);
					if(filedata=='B')
						printf("%ld",binput.ID);
					if(filedata=='S') {
						next=fgetc(fp);
						if(next=='a')
							printf("%s",binput.name);
						if(next=='b')
							printf("%s",binput.bdate);
						if(next=='c')
							printf("%s",binput.ledited);
						if(next=='d') {
							if(binput.method==1 || binput.method==3) {
								printf("<a href=\"%s\" %s><img src=\"%s%s\" %s border=%d width=%d height=%d alt=\"%s\"><br>%s</a>",binput.url,binput.lother,config.bandir,binput.bfile,binput.iother,binput.border,binput.width,binput.height,binput.alt,binput.ltext);
							}
							if(binput.method==2 || binput.method==3)
								DumpUserHTML(binput.ID);
						}
						if(next=='e')
						{
							if(binput.type==1 || binput.type==2)
								printf("%ld",binput.timps);
							if(binput.type==3)
								printf("%s",binput.edate);
							if(binput.type==4)
								printf("%ld",binput.tclicks);
						}
						if(next=='f') {
							if(binput.type==2)
								printf("<img src=\"%spics/infinity.gif\" width=\"9\" height=\"5\">",config.bandir);
							if(binput.type==3)
								printf("<img src=\"%spics/infinity.gif\" width=\"9\" height=\"5\">&nbsp; until %s",config.bandir,binput.edate);
							if(binput.type==1)
								printf("%ld", (binput.max - binput.timps) > 0 ? binput.max-binput.timps : 0);
							if(binput.type==4)
								printf("%ld", (binput.max - binput.tclicks) > 0 ? binput.max-binput.tclicks : 0);
						}
						if(next=='g')
							printf("%ld",binput.tclicks);
						if(next=='h') {	
							if(binput.timps>0 && binput.tclicks>0 && binput.type!=4)
							{
								printf("1:%d", (int)((long double)binput.timps/(long double)binput.tclicks) );
								continue;
							}
							if(binput.type==4)
							{
								printf("%ld",binput.timps);
								continue;
							}
							else printf("n/a");
						}
						if(next=='i')
							printf("%ld",binput.bonus);
						if(next=='j')
							printf("%ld",binput.imps);
						if(next=='k')
							printf("%ld",binput.clicks);
						if(next=='l') {
							if(binput.imps>0 && binput.clicks>0)
								printf("1:%d", (int)((long double)binput.imps/(long double)binput.clicks) );
							else printf("n/a");
						}
						if(next=='m')
							printf("%s",binput.lreset);
						if(next=='n')
						{
							if(binput.type==1 || binput.type==2)
								printf("Exposures to date");
							if(binput.type==3)
								printf("Expires on");
							if(binput.type==4)
								printf("Clicks-Throughs to date");
						}
						if(next=='o')
						{
							if(binput.type==1 || binput.type==2 || binput.type==3)
								printf("Exposures Remaining");
							if(binput.type==4)
								printf("Clicks-Throughs Remaining");
						}
						if(next=='p')
						{
							if(binput.type==1 || binput.type==2 || binput.type==3)
								printf("Click-Throughs");
							if(binput.type==4)
								printf("Exposures");
						}
						if(next=='q')
						{
							if(binput.type==1 || binput.type==2 || binput.type==3)
								printf("Click-Through Ratio");
							if(binput.type==4)
								printf("Click-Through Ratio");
						}
					}
				}
			}
			else
				filedone=TRUE;
		}
		fclose(fp);
	}
	else {
		printf("Couldn't open <b>'%s'</b> to read!\n",fileid);
		exit(0);
	}
}

void DumpGraphStats(long int id)
{
int month=0,year=0,loop2=0;
char graphby[50];
long int tclicks[30],timps[30],i=0;
char dates[30][15];
float ratio[30];
FILE *temp;
int next=-1;
char buf[20];
float cratio;
long double n=0,rn=0;
long int biggest=0;
char buf2[10];

	for(i=0; i<=30; i++)
	{
		strcpy(dates[i],"");
		timps[i] = tclicks[i] = 0;
	}
	currdate=GetCurrentDate();
	getfield(buf,"years");
	if(strcmp(cmd,"showvsgraphs")==0 && strcmp(buf,"")==0)
	{
		buf[0]=currdate[0],buf[1]=currdate[1],buf[2]=0;
		month=atoi(buf);
		buf2[0]=currdate[6],buf2[1]=currdate[7],buf2[2]=currdate[8],buf2[3]=currdate[9],buf2[4]=0;
		year=atoi(buf2);
	}
	else
	{
		getfield(buf,"years");
		year=atol(buf);
		getfield(buf2,"month");
		month=atol(buf2);
	}
	getfield(graphby,"graphby");
	if(strcmp(graphby,"")==0)
		strcpy(graphby,"imps");
	/* now let's open the banners DB to find the ad */
	/* we want, and print out it's stats */
	sprintf(file,"%sbanners.bwi",config.log_dir);
	bwi=fopen(file,"rb");
	loop=FALSE;
	fseek(bwi,sizeof(long),SEEK_SET);
	while(loop==FALSE) {
		fread(&binput,sizeof(binput),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else {
			/* found the ad w/the stats we want */
			if(binput.ID==id) {
				sprintf(file,"%sbvstats_entry.html",config.html_dir);
				PrintStatsFile(file);
				printf("<br><table width=\"488\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
				printf("<tr bgcolor=\"#FFFFCC\"><td width=\"60\"><img src=\"%spics/spacer.gif\" width=\"60\" height=\"5\"></td>\n",config.bandir);
				printf("<td>\n\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
				printf("<tr><td><a href=\"%s?command=View+Stats&CID=%ld&BID=%ld&login=%s&passwd=%s\" onMouseOver=\"window.status='Collapse Account Graph(s)'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\"><img src=\"%spics/graphtitle1.gif\" width=\"61\" height=\"19\" border=\"0\"></a></td>\n",config.ascript,binput.CID,binput.ID,login,passwd,config.bandir);
				printf("<td><a href=\"%s?command=View+Stats&CID=%ld&BID=%ld&login=%s&passwd=%s\" onMouseOver=\"window.status='Collapse Account Graph(s)'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\"><img src=\"%spics/graphtitle2b.gif\" width=\"13\" height=\"19\" border=\"0\"></a></td>\n",config.ascript,binput.CID,binput.ID,login,passwd,config.bandir);
				printf("<td><img src=\"%spics/graphtitle3.gif\" width=\"353\" height=\"19\"></td>\n",config.bandir);
				printf("</tr></table></td></tr></table>\n\n");
				/* now print out stats */
				sprintf(file,"%s%d-%d.sts",config.log_dir,year,month);
				if((temp=fopen(file,"rb"))==NULL)
				{
					printf("<center><b><font face=\"Verdana\" size=\"1\">No Stats found in that month!</font></b></center><p>");
					break;
				}
				printf("<p><table width=\"488\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n\n");
				printf("<tr bgcolor=\"#FFFFCC\"><td width=\"60\"><img src=\"%spics/spacer.gif\" width=\"60\" height=\"5\"></td>\n",config.bandir);
				printf("<td>\n\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
				printf("<tr><td bgcolor=\"#FF9900\">\n");
				printf("<table border=\"0\" cellspacing=\"1\" cellpadding=\"0\">\n");
				printf("<tr bgcolor=\"#FFFFCC\">\n");
				printf("<td bgcolor=\"#FFFF99\"><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\"><b>IP Log</b></td>\n");
				printf("<td bgcolor=\"#FFFF99\"><img src=\"%spics/col-date.gif\" width=\"32\" height=\"16\"><img src=\"%spics/spacer.gif\" width=\"78\" height=\"16\"></td>\n",config.bandir,config.bandir);
				if(strcmp(graphby,"imps")==0)
					printf("<td><font color=\"#FFFFFF\"><img src=\"%spics/col-exp1.gif\" width=\"61\" height=\"16\"></font></td>\n",config.bandir);
				else
					printf("<td><font color=\"#FFFFFF\"><a href=\"%s?command=showvsgraphs&BID=%ld&CID=%ld&graphby=imps&login=%s&passwd=%s\" onMouseOver=\"window.status='Graph By Exposures'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\"><img border=\"0\" src=\"%spics/col-exp.gif\" width=\"61\" height=\"16\"></a></font></td>\n",config.ascript,binput.ID,binput.CID,login,passwd,config.bandir);
				if(strcmp(graphby,"clicks")==0)
					printf("<td><img src=\"%spics/col-ct1.gif\" width=\"61\" height=\"16\"></td>\n",config.bandir);
				else
					printf("<td><font color=\"#FFFFFF\"><a href=\"%s?command=showvsgraphs&BID=%ld&CID=%ld&graphby=clicks&login=%s&passwd=%s\" onMouseOver=\"window.status='Graph By Click-Throughs'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\"><img border=\"0\" src=\"%spics/col-ct.gif\" width=\"61\" height=\"16\"></a></font></td>\n",config.ascript,binput.ID,binput.CID,login,passwd,config.bandir);
				if(strcmp(graphby,"percent")==0)
					printf("<td><img src=\"%spics/col-ctp1.gif\" width=\"66\" height=\"16\"></td>\n",config.bandir);
				else
					printf("<td><font color=\"#FFFFFF\"><a href=\"%s?command=showvsgraphs&BID=%ld&CID=%ld&graphby=percent&login=%s&passwd=%s\" onMouseOver=\"window.status='Graph By Percent'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\"><img border=\"0\" src=\"%spics/col-ctp.gif\" width=\"66\" height=\"16\"></a></font></td>\n",config.ascript,binput.ID,binput.CID,login,passwd,config.bandir);
				printf("<td bgcolor=\"#FFFF99\"><br></td></tr>\n",config.bandir);
				loop2=0;
				next=0;
				while(loop2==0) {
					fread(&dstats,sizeof(dstats),1,temp);
					if(feof(temp)) loop2=1;
					else {
						if(dstats.ID==ID) {
							strcpy(dates[next],dstats.date);
							timps[next]=dstats.imps;
							tclicks[next]=dstats.clicks;
							ratio[next]=(float)tclicks[next]/timps[next];
							next++;
						}
						else continue;
					}
				}
				fclose(temp);
				next=0;
				n=0;
				while((next<=30) && (strcmp(dates[next],"")!=0)) {
					if(strcmp(graphby,"imps")==0 && timps[next]>biggest)
						biggest=timps[next];
					if(strcmp(graphby,"clicks")==0 && tclicks[next]>biggest)
						biggest=tclicks[next];
					if(strcmp(graphby,"percent")==0 && (((long double)(ratio[next]*100))/(long double)biggest)>biggest)
						biggest=(((int)((long double)ratio[next]*100))/(long double)biggest);
					next++;
				}
				next=0;
				while((next<=30) && (strcmp(dates[next],"")!=0)) {
					if(strcmp(graphby,"imps")==0) {
						if(timps[next]==0 || biggest==0)
							n=0;
						else
							n=((long double)timps[next]/(long double)biggest);
						printf("<tr><td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						if(config.iplogging==0)
						{
							printf("<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\"><img src=\"%spics/docicon.gif\" width=\"11\" height=\"11\" hspace=\"4\"></font></td></tr>\n</table>\n</td>\n",config.bandir);
						}
						if(config.iplogging==1)
						{
							printf("<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\"><a href=\"%s?command=printiplogs&date=%s&passwd=%s&login=%s\"><img src=\"%spics/docicon.gif\" width=\"11\" height=\"11\" hspace=\"4\" border=\"0\"></a></font></td></tr>\n</table>\n</td>\n",config.ascript,dates[next],passwd,login,config.bandir);
						}
						printf("<td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\">%s</font></td>\n",dates[next]);
						printf("</tr>\n</table>\n</td>\n<td bgcolor=\"#FFFFFF\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						printf("<tr><td><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\"><b><font size=\"1\">%ld</font></b></font></td>\n",timps[next]);
						printf("</tr>\n</table>\n<font color=\"#FFFFFF\"> </font></td>\n<td bgcolor=\"#FFFFCC\">\n");
						printf("<table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						printf("<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\">%ld</font></td>\n",tclicks[next]);
						printf("</tr>\n</table>\n</td>\n<td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						printf("<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\">%.1f %%</font></td>\n",ratio[next] * 100);
						printf("</tr>\n</table>\n</td><td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						printf("<tr><td><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
						printf("<tr><td><img src=\"%spics/mleft.gif\" width=\"2\" height=\"13\"></td>\n",config.bandir);
						printf("<td><img src=\"%spics/m.gif\" width=\"%ld\" height=\"13\"></td>\n",config.bandir,(int)(n*75));
						printf("<td><img src=\"%spics/mright.gif\" width=\"2\" height=\"13\"></td>\n",config.bandir);
						printf("</tr>\n</table>\n</td>\n</tr>\n</table>\n");
						printf("</td></tr>\n");
					}
					if(strcmp(graphby,"clicks")==0) {
						if(tclicks[next]==0 || biggest==0)
							n=0;
						else
							n=((long double)tclicks[next]/(long double)biggest);
						printf("<tr><td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						if(config.iplogging==0)
						{
							printf("<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\"><img src=\"%spics/docicon.gif\" width=\"11\" height=\"11\" hspace=\"4\"></font></td></tr>\n</table>\n</td>\n",config.bandir);
						}
						if(config.iplogging==1)
						{
							printf("<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\"><a href=\"%s?command=printiplogs&date=%s&passwd=%s&login=%s\"><img src=\"%spics/docicon.gif\" width=\"11\" height=\"11\" hspace=\"4\" border=\"0\"></a></font></td></tr>\n</table>\n</td>\n",config.ascript,dates[next],passwd,login,config.bandir);
						}
						printf("<td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\">%s</font></td>\n",dates[next]);
						printf("</tr>\n</table>\n</td>\n<td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						printf("<tr><td><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\"><b><font size=\"1\">%ld</font></b></font></td>\n",timps[next]);
						printf("</tr>\n</table>\n<font color=\"#FFFFFF\"> </font></td>\n<td bgcolor=\"#FFFFFF\">\n");
						printf("<table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						printf("<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\">%ld</font></td>\n",tclicks[next]);
						printf("</tr>\n</table>\n</td>\n<td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						printf("<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\">%.1f %%</font></td>\n",ratio[next] * 100);
						printf("</tr>\n</table>\n</td><td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						printf("<tr><td><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
						printf("<tr><td><img src=\"%spics/mleft.gif\" width=\"2\" height=\"13\"></td>\n",config.bandir);
						printf("<td><img src=\"%spics/m.gif\" width=\"%ld\" height=\"13\"></td>\n",config.bandir,(int)(n*75));
						printf("<td><img src=\"%spics/mright.gif\" width=\"2\" height=\"13\"></td>\n",config.bandir);
						printf("</tr>\n</table>\n</td>\n</tr>\n</table>\n");
						printf("</td></tr>\n");
					}
					if(strcmp(graphby,"percent")==0) {
						if(ratio[next]==0 || rn==0)
							n=0;
						else
							n=(long double)((int)(ratio[next]*100))/(long double)biggest;
						printf("<tr><td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						if(config.iplogging==0)
						{
							printf("<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\"><img src=\"%spics/docicon.gif\" width=\"11\" height=\"11\" hspace=\"4\"></font></td></tr>\n</table>\n</td>\n",config.bandir);
						}
						if(config.iplogging==1)
						{
							printf("<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\"><a href=\"%s?command=printiplogs&date=%s&passwd=%s&login=%s\"><img src=\"%spics/docicon.gif\" width=\"11\" height=\"11\" hspace=\"4\" border=\"0\"></a></font></td></tr>\n</table>\n</td>\n",config.ascript,dates[next],passwd,login,config.bandir);
						}
						printf("<td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\">%s</font></td>\n",dates[next]);
						printf("</tr>\n</table>\n</td>\n<td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						printf("<tr><td><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\"><b><font size=\"1\">%ld</font></b></font></td>\n",timps[next]);
						printf("</tr>\n</table>\n<font color=\"#FFFFCC\"> </font></td>\n<td bgcolor=\"#FFFFCC\">\n");
						printf("<table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						printf("<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\">%ld</font></td>\n",tclicks[next]);
						printf("</tr>\n</table>\n</td>\n<td bgcolor=\"#FFFFFF\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						printf("<tr><td><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\">%.1f %%</font></td>\n",ratio[next] * 100);
						printf("</tr>\n</table>\n</td><td bgcolor=\"#FFFFCC\"><table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
						printf("<tr><td><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
						printf("<tr><td><img src=\"%spics/mleft.gif\" width=\"2\" height=\"13\"></td>\n",config.bandir);
						printf("<td><img src=\"%spics/m.gif\" width=\"%ld\" height=\"13\"></td>\n",config.bandir,(int)(n*75));
						printf("<td><img src=\"%spics/mright.gif\" width=\"2\" height=\"13\"></td>\n",config.bandir);
						printf("</tr>\n</table>\n</td>\n</tr>\n</table>\n");
						printf("</td></tr>\n");
					}
					next++;
				}
				printf("</table>\n</td>\n<td bgcolor=\"#FFFFCC\"><img src=\"%spics/spacer.gif\" width=\"4\" height=\"1\"></td>\n",config.bandir);
				printf("</tr></table>\n");
				/* month & year form (stats) */
				printf("<br><form method=POST action=\"%s\"><input type=hidden name=\"login\" value=\"%s\">\n",config.ascript,login);
				printf("<input type=hidden name=\"command\" value=\"showvsgraphs\"><input type=hidden name=\"passwd\" value=\"%s\">\n",passwd);
				printf("<input type=hidden name=\"CID\" value=\"%ld\"><input type=hidden name=\"BID\" value=\"%ld\">\n",binput.CID,binput.ID);
				printf("<input type=hidden name=\"graphby\" value=\"%s\">\n",graphby);
				printf("<table width=\"100%%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
				printf("<tr><td> <img src=\"%spics/spacer.gif\" width=\"242\" height=\"4\">\n",config.bandir);
				printf("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
				printf("<tr><td valign=\"top\">\n");
				DumpMonths(buf);
				printf("<img src=\"%spics/spacer.gif\" width=\"20\" height=\"8\"></td><td valign=\"top\">\n",config.bandir);
				DumpYears(buf2);
				printf("</td><td valign=\"top\"><img src=\"%spics/spacer.gif\" width=\"20\" height=\"8\"><input type=\"image\" border=\"0\" name=\"imageField\" src=\"%spics/bwi-btn-go.gif\" width=\"38\" height=\"20\">\n",config.bandir,config.bandir);
				printf("</td></tr></table></td><td align=\"right\"> <font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\"><b>");
				printf("<a href=\"%s?command=Modify+Banner&CID=%ld&BID=%ld&login=%s&passwd=%s\" onMouseOver=\"window.status='Edit This Banner'\" onMouseOut=\"window.status='BWI Admin Module:  Ready.'\">Edit this banner</a>&nbsp;",config.ascript,binput.CID,binput.ID,login,passwd);
				printf("<img src=\"%spics/modarrow.gif\" width=\"8\" height=\"8\"></b></font></td>\n",config.bandir);
				printf("<td><img src=\"%spics/spacer.gif\" width=\"4\" height=\"4\"></td></tr></table></form>\n\n\n",config.bandir);
				printf("</td></tr></table>\n\n");
			}
			else continue;
		}
	}
	fclose(bwi);
	return;
}

int IsEnabled()
{
char numdate[15];
long int cdate=0;
long int edate=0;
long int bdate=0;

	currdate=GetCurrentDate();
	/* develop a long int representation of the date(s) */
	/* yyyymmdd */
	/* current date to long int */
	numdate[0]=currdate[6],numdate[1]=currdate[7];
	numdate[2]=currdate[8],numdate[3]=currdate[9];
	numdate[4]=currdate[0],numdate[5]=currdate[1];
	numdate[6]=currdate[3],numdate[7]=currdate[4];
	numdate[8]='\0',cdate=atol(numdate);
	/* expiration date to long int */
	numdate[0]=binput.edate[6],numdate[1]=binput.edate[7];
	numdate[2]=binput.edate[8],numdate[3]=binput.edate[9];
	numdate[4]=binput.edate[0],numdate[5]=binput.edate[1];
	numdate[6]=binput.edate[3],numdate[7]=binput.edate[4];
	numdate[8]='\0',edate=atol(numdate);
	/* start date to long int */
	numdate[0]=binput.bdate[6],numdate[1]=binput.bdate[7];
	numdate[2]=binput.bdate[8],numdate[3]=binput.bdate[9];
	numdate[4]=binput.bdate[0],numdate[5]=binput.bdate[1];
	numdate[6]=binput.bdate[3],numdate[7]=binput.bdate[4];
	numdate[8]='\0',bdate=atol(numdate);
	
	/*  Only for disable banner and enable banner functions (new GUI) */
	/* if expires by max imps and has some left, or has bonus credits */
	if(binput.CID==cinput.ID && binput.type==1 && binput.timps<binput.max || (binput.CID==cinput.ID && binput.bonus>0 && binput.type==1))
		return TRUE;
	/* if expires by date and birth is before current, and end is after current, or has bonus credits */
	if(binput.CID==cinput.ID && binput.type==3 && cdate<edate && bdate<cdate  || (binput.CID==cinput.ID && binput.bonus>0 && binput.type==3))
		return TRUE;
	/* if has unlimited exposures */
	if(binput.CID==cinput.ID && binput.type==2)
		return TRUE;
	/* if expires by max imps and has none left, or has no bonus credits */
	if(binput.CID==cinput.ID && binput.type==1 && binput.timps>=binput.max || (binput.CID==cinput.ID && binput.bonus<=0 && binput.type==1))
		return FALSE;
	/* if expires by date, and birth hasn't occured yet or death has occured */
	if(binput.CID==cinput.ID && binput.type==3 && cdate>edate || (binput.CID==cinput.ID && bdate>cdate && binput.type==3) || (binput.CID==cinput.ID && binput.bonus>0 && binput.type==3))
		return FALSE;
	/* if expires by max clicks and has some left, or has bonus credits */
	if(binput.CID==cinput.ID && binput.type==4 && binput.tclicks<binput.max || (binput.CID==cinput.ID && binput.type==4 && binput.bonus>0))
		return TRUE;
	/* if expires by max clicks, and has none left, nor any bonus credits */
	if(binput.CID==cinput.ID && binput.type==4 && binput.tclicks>=binput.max || ( binput.CID==cinput.ID && binput.type==4 && binput.bonus<=0))
		return FALSE;
	return FALSE;
}

void DumpUserHTML(long int id)
{
FILE * fi;
int c;
  
	sprintf(file,"%sB%ld.html",config.log_dir,id);
  fi = fopen(file, "r");
  if (fi == NULL)
    return;
  else
    {
      do
        {
          c = fgetc(fi);
          if (c != EOF)
            fputc(c, stdout);
        }
      while (c != EOF);
      fclose(fi);
      
      return;
  	}		
}

void SaveUserHTML(long int id)
{
char html[1024];
FILE *fp;

	getfield(html, "html");
	sprintf(file, "%sB%ld.html",config.log_dir,id);
	fp=fopen(file,"w");
	fprintf(fp,"%s", html);
	fclose(fp);
	return;
}

void PrintIPLogs()
{
char cdate[15];
char tbuf[10];
int month=0, year=0;

	getfield(cdate,"date");
	tbuf[0]=cdate[0],tbuf[1]=cdate[1];tbuf[2]=0;
	month=atoi(tbuf);
	tbuf[0]=cdate[6],tbuf[1]=cdate[7],tbuf[2]=cdate[8],tbuf[3]=cdate[9],tbuf[4]=0;
	year=atoi(tbuf);
	sprintf(file,"%s%d-%d.IPsts",config.log_dir,year,month);	
	if((bwi=fopen(file,"rb"))==NULL)
	{
		printf("<center><b><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\">No IP Stats for that month!</b></font></center>\n");
		return;
	}
	loop=FALSE;
	printf("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" width=\"75%%\">\n");
	printf("<tr><td bgcolor=\"#FF9900\">\n");
	printf("<table border=\"0\" cellspacing=\"1\" cellpadding=\"0\"  width=\"100%%\">\n");
	printf("<tr><td bgcolor=\"#FFFF99\"><b><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\"><b>Hits</font></b></td>\n");
	printf("<td bgcolor=\"#FFFF99\"><b><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\"><b>Date</font></b></td>\n");
	printf("<td bgcolor=\"#FFFF99\"><b><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\"><b>IP Address</font></b></td></tr>\n");
	while(loop==FALSE)
	{
		fread(&ipstats,sizeof(ipstats),1,bwi);
		if(feof(bwi)) loop=TRUE;
		else
		{
			printf("<tr><td bgcolor=\"#FFFFCC\"><b><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\">%ld</font></b></td>\n", ipstats.hits);
			printf("<td bgcolor=\"#FFFFCC\"><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\">%s</font></td>\n", ipstats.date);
			printf("<td bgcolor=\"#FFFFCC\"><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"2\">%s</font></td></tr>\n", ipstats.IP);
		}	
	}
	printf("</table>\n</td><td>&nbsp;</td></tr></table>");
	fclose(bwi);
	return;
}

int main(int argc, char *argv[])
{
char rcmd[100];
char buf[50];
int yes=0,i=0;

	parse_form();
	getfield(cmd,"command");
	getfield(rcmd,"rcmd");
	getfield(flag,"flag");
	sprintf(file,"config.ini");
	LoadConfig(file);
	if(strcmp(cmd,"Logout")==0 || (strcmp(cmd,"")==0 && strcmp(rcmd,"")==0 && strcmp(flag,"")==0)) {
		printf("Content-type:  text/html\n\n");
		sprintf(file,"%sblogin.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	CheckPasswd();
	if(strcmp(cmd,"Help")==0)
		printf("Location:  %s\n\n",config.hpage),exit(0);
	printf("Content-type:  text/html\n\n");
	CheckRotations(); // Maintain the random order
	if(strcmp(cmd,"Save Client")==0) {
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Update Client")==0) {
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Update Banner")==0) {
		UpdateBanner();
		sprintf(file,"%sbmain.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Reset Count")==0) {
		getfield(buf,"BID");
		ID=atol(buf);
		LoadBanner(ID);
		ResetCount(binput.ID);
		getfield(buf,"CID");
		ID=atol(buf);
		LoadClient(ID);
		sprintf(file,"%ssheader.html",config.html_dir);
		PrintFile(file);
		DumpStats();
		sprintf(file,"%ssfooter.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Change Configuration")==0) {
		sprintf(file,"bconfig.html");
		PrintConfigFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Save Configuration")==0) {
		SaveConfig();
		sprintf(file,"bconfig.html");
		PrintConfigFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Edit Default Banner Account")==0)
		PrintDefault(),exit(0);
	if(strcmp(cmd,"Update Default Banner")==0) {
		UpdateDBanner();
		sprintf(file,"bconfig.html");
		PrintConfigFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Set Admin Password")==0) {
		PrintAdmPass();
		exit(0);
	}
	if(strcmp(cmd,"saveadmpass")==0) {
		SaveAdmPass();
		sprintf(file,"bconfig.html");
		PrintConfigFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Reset Main Databases")==0) {
		ResetDBs();
		sprintf(file,"bconfig.html");
		PrintConfigFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Modify Banner")==0) {
		getfield(buf,"CID");
		if(strcmp(buf,"")==0) {
			sprintf(file,"%sbmodbclient.html",config.html_dir);
			PrintFile(file);
			exit(0);
		}
		ID=atol(buf);
		LoadClient(ID);
		getfield(buf,"BID");
		ID=atol(buf);
		if(ID!=0) LoadBanner(ID);
		// if the user has selected a different client
		if(binput.CID!=cinput.ID) {
			getfield(buf,"CID");
			ID=atol(buf);
			LoadClient(ID);
			sprintf(file,"%sbmodbban.html",config.html_dir);
	 		PrintFile(file);
	 		exit(0);
	 	}
	 	sprintf(file,"%sbmodbform.html",config.html_dir);
	 	PrintFile(file);
	 	exit(0);
	}
	if(strcmp(cmd,"dumpenabclients")==0) {
		sprintf(file,"%sclients.bwi",config.log_dir);
		bwi=fopen(file,"rb");
		loop=0;
		fseek(bwi,sizeof(long),SEEK_SET);
		while(loop==0) {
			fread(&cinput,sizeof(cinput),1,bwi);
			if(feof(bwi)) loop=1;
			else {
				if(CheckCDisabled(cinput.ID,1)) {
					yes=1;
					break;
				}
				else continue;
			}
		}
		fclose(bwi);
		if(yes==0) {
			printf("<script language=\"JavaScript\">\n");
			printf("alert(\"Sorry, there are no banners to enable!\");\n");
			printf("window.close();\n</script>");
			exit(0);
		}
		sprintf(file,"%sbenaclient.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"dumpenabans")==0) {
		getfield(buf,"CID");
		if(strcmp(buf,"")==0) {
			sprintf(file,"%sbenaban.html",config.html_dir);
			PrintFile(file);
			exit(0);
		}
		ID=atol(buf);
		LoadClient(ID);
		if(binput.CID!=cinput.ID && binput.CID!=0) {
			getfield(buf,"CID");
			ID=atol(buf);
			LoadClient(ID);
			sprintf(file,"%sbenaban.html",config.html_dir);
	 		PrintFile(file);
	 		exit(0);
	 	}
		sprintf(file,"%sbenaban.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Enable Banner")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		LoadClient(ID);
		getfield(buf,"BID");
		ID=atol(buf);
		LoadBanner(ID);
		if(binput.CID!=cinput.ID) {
			getfield(buf,"CID");
			ID=atol(buf);
			LoadClient(ID);
			sprintf(file,"%sbenaban.html",config.html_dir);
	 		PrintFile(file);
	 		exit(0);
	 	}
		EnableBanner(ID);		
		printf("<script language=\"JavaScript\">\n");
		printf("alert(\"'%s' under the %s was successfully enabled!\")\nwindow.close();\n</script>\n",binput.name,cinput.name);
		exit(0);
	}
	if(strcmp(cmd,"dumpdisbclients")==0) {
		sprintf(file,"%sclients.bwi",config.log_dir);
		bwi=fopen(file,"rb");
		loop=0;
		fseek(bwi,sizeof(long),SEEK_SET);
		while(loop==0) {
			fread(&cinput,sizeof(cinput),1,bwi);
			if(feof(bwi)) loop=1;
			else {
				if(CheckCDisabled(cinput.ID,2)) {
					yes=1;
					break;
				}
				else continue;
			}
		}
		fclose(bwi);
		if(yes==0) {
			printf("<script language=\"JavaScript\">\n");
			printf("alert(\"Sorry, there are no banners to disable!\");\n");
			printf("window.close();\n</script>");
			exit(0);
		}
		sprintf(file,"%sbdisclient.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"dumpdisbans")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		LoadClient(ID);
		if(ID==0) {
			sprintf(file,"%sbdisban.html",config.html_dir);
			PrintFile(file);
			exit(0);
		}
		sprintf(file,"%sbdisban.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Disable Banner")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		LoadClient(ID);
		getfield(buf,"BID");
		ID=atol(buf);
		LoadBanner(ID);
		if(binput.CID!=cinput.ID) {
			getfield(buf,"CID");
			ID=atol(buf);
			LoadClient(ID);
			sprintf(file,"%sbdisban.html",config.html_dir);
	 		PrintFile(file);
	 		exit(0);
	 	}
		DisableBanner(ID);
		printf("<script language=\"JavaScript\">\n");
		printf("alert(\"'%s' under the %s was successfully disabled!\")\nwindow.close();\n</script>\n",binput.name,cinput.name);
		exit(0);
	}
	if(strcmp(cmd,"Disable Banner2")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		LoadClient(ID);
		getfield(buf,"BID");
		ID=atol(buf);
		LoadBanner(ID);
		DisableBanner(ID);
		sprintf(file,"%sbmain.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Enable Banner2")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		LoadClient(ID);
		getfield(buf,"BID");
		ID=atol(buf);
		LoadBanner(ID);
		EnableBanner(ID);
		sprintf(file,"%sbmain.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"dumpdelbclients")==0) {
		sprintf(file,"%sclients.bwi",config.log_dir);
		bwi=fopen(file,"rb");
		loop=0;
		fseek(bwi,sizeof(long),SEEK_SET);
		while(loop==0) {
			fread(&cinput,sizeof(cinput),1,bwi);
			if(feof(bwi)) loop=1;
			else {
				if(HasBanners(cinput.ID)) {
					yes=1;
					break;
				}
				else continue;
			}
		}
		fclose(bwi);
		if(yes==0) {
			printf("<script language=\"JavaScript\">\n");
			printf("alert(\"Sorry, there are no banners to delete!\");\n");
			printf("window.close();\n</script>");
			exit(0);
		}
		sprintf(file,"%sbdelclient.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"dumpdelbbans")==0) {
		getfield(buf,"CID");
		if(strcmp(buf,"")==0) {
			sprintf(file,"%sbdelclient.html",config.html_dir);
			PrintFile(file);
			exit(0);
		}
		ID=atol(buf);
		LoadClient(ID);
	 	sprintf(file,"%sbdelban.html",config.html_dir);
	 	PrintFile(file);
	 	exit(0);
	}
	if(strcmp(cmd,"Delete Banner")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		LoadClient(ID);
		getfield(buf,"BID");
		ID=atol(buf);
		LoadBanner(ID);
		strcpy(buf,binput.name);
		if(binput.CID!=cinput.ID) {
			getfield(buf,"CID");
			ID=atol(buf);
			LoadClient(ID);
			sprintf(file,"%sbdelban.html",config.html_dir);
	 		PrintFile(file);
	 		exit(0);
	 	}
		DeleteBanner(ID);
		printf("<script language=\"JavaScript\">\n");
		printf("alert(\"'%s' under the '%s' was successfully deleted!\")\nwindow.close();\n</script>\n",buf,cinput.name);
		exit(0);
	}
	if(strcmp(cmd,"Delete Banner2")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		LoadClient(ID);
		getfield(buf,"BID");
		ID=atol(buf);
		LoadBanner(ID);
		strcpy(buf,binput.name);
		DeleteBanner(ID);
		sprintf(file,"%sbmain.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Add Banner")==0) {
		sprintf(file,"%sbaddbform.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Add Client")==0) {
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"dumpmodclients")==0) {
		sprintf(file,"%sbmodcclient.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"dumpmodcform")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		if(ID==0) {
			sprintf(file,"%sbmodcclient.html",config.html_dir);
			PrintFile(file);
			exit(0);
		}
		LoadClient(ID);
	 	printf("<script language=\"JavaScript\">\n");
	 	printf("\topener.window.location.href = \"%s?login=%s&passwd=%s&command=Modify+Client&CID=%ld\";\n",config.ascript,login,passwd,cinput.ID);
	 	printf("\twindow.close();\n");
	 	printf("</script>\n");
	 	exit(0);
	}
	if(strcmp(cmd,"Modify Client")==0) {
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"dumpdelclients")==0) {
		sprintf(file,"%sbdelcclient.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Delete Client")==0) {
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"dumpvsclients")==0) {
		sprintf(file,"%sbvscclient.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"dumpcstats")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		if(ID==0) {
			sprintf(file,"%sbvscclient.html",config.html_dir);
			PrintFile(file);
			exit(0);
		}
		LoadClient(ID);
	 	printf("<script language=\"JavaScript\">\n");
	 	printf("\topener.window.location.href = \"%s?login=%s&passwd=%s&command=View+Stats&CID=%ld\";\n",config.ascript,login,passwd,cinput.ID);
	 	printf("\twindow.close();\n");
	 	printf("</script>\n");
	 	exit(0);
	}	
	if(strcmp(cmd,"View Stats")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		if(ID==0) {
			sprintf(file,"%sbvscclient.html",config.html_dir);
			PrintFile(file);
			exit(0);
		}
		LoadClient(ID);
		sprintf(file,"%ssheader.html",config.html_dir);
		PrintFile(file);
		DumpStats();
		sprintf(file,"%ssfooter.html",config.html_dir);
		PrintFile(file);
		exit(0);	
	}
	if(strcmp(cmd,"Save Banner")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		LoadClient(ID);
		SaveBanner(ID);
		sprintf(file,"%sbmain.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"Define Realms")==0) {
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(rcmd,"Add New Realm")==0) {
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(rcmd,"Save Realm")==0) {
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(rcmd,"Modify Realm")==0) {
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(rcmd,"Update Realm")==0) {
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(rcmd,"Delete Realm")==0) {
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(rcmd,"View Realms Stats")==0) {
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"dumpexportbans")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		LoadClient(ID);
		sprintf(file,"%sbexportbanners.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"doexportbans")==0) {
		getfield(buf,"CID");
		ID=atol(buf);
		/* first try and export all banners */
		DoExportBans(ID);
		/* when done, delete the client */
		DeleteClient(ID);
		sprintf(file,"%sbmain.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"dumpcontactinfo")==0)
	{
		getfield(buf,"CID");
		ID=atol(buf);
		LoadClient(ID);
		sprintf(file,"%sbcontactinfo.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"showvsgraphs")==0)
	{
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);
	}
	if(strcmp(cmd,"main")==0)
	{
		sprintf(file,"%sbmain.html",config.html_dir);
		PrintFile(file);
		exit(0);	
	}
	if(strcmp(cmd, "View Banner")==0)
	{
		getfield(buf,"CID");
		ID=atol(buf);
		LoadClient(ID);
		getfield(buf,"BID");
		ID=atol(buf);
		LoadBanner(ID);
		sprintf(file,"%sbviewban.html",config.html_dir);
		PrintConfigFile(file);
		exit(0);
	}
	if(strcmp(cmd, "printiplogs")==0)
	{
		sprintf(file,"upgrade.html");
		PrintFile(file);
		exit(0);	
	}
	/*  End BWI GUI Code */
	else {
		sprintf(file,"%sbmain.html",config.html_dir);
		PrintFile(file);
		exit(0);
	}
}
