#!/usr/bin/perl
##############################################################################
# Genie!   Online Magic Trick  Version 1.5                                   #
# Copyright 1997 Puppet Master  pmaster@ravensclaw.com                       #
# Created 05/04/97              Last Modified 10/08/99                       #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1997 Puppet Master      All Rights Reserved.                     #
#                                                                            #
# This script may be used & modified free of charge by anyone as long as     #
# this copyright notice and the comments above remain intact.  By using this #
# code you agree to indemnify Puppet Master from any liability that          #  
# might arise from it's use.                                                 #  
#                                                                            #
# Selling the code for this program without prior written consent is         #
# expressly forbidden.  In other words, please ask first before you try and  #
# make money off of my program.                                              #
#                                                                            #
# Obtain permission before redistributing this software over the Internet or #
# in any other medium.  In all cases copyright and header must remain intact.#
##############################################################################
# Define Variables

$baseurl = "http://www.server.com/~yourname/index.shtml";
$genieurl = "http://www.server.com/~yourname/graphics";
$METHOD = "GET";    ## Use POST if return button gives an error.

# Done
###########################################################################


# Initialize Guess Variable
$num=0;

# Get Form Information  
&parse_form;

# Check for required fields
&missing_fields unless $FORM{'box1'};
&missing_fields unless $FORM{'box2'};
&missing_fields unless $FORM{'box3'};
&missing_fields unless $FORM{'box4'};
&missing_fields unless $FORM{'box5'};
&missing_fields unless $FORM{'box6'};

# Calculate Answer
&calc_ans;

# Check to see if all boxes are NO
if ($num eq "0") {
   &trick;
}

# Display Answer
&answer;

#######################
# Parse Form Subroutine

sub parse_form {

   # Get the input
   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

   # Split the name-value pairs
   @pairs = split(/&/, $buffer);

   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      # Un-Webify plus signs and %-encoding
      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ s/<!--(.|\n)*-->//g;

      if ($allow_html != 1) {
         $value =~ s/<([^>]|\n)*>//g;
      }
      else {
         unless ($name eq 'body') {
	    $value =~ s/<([^>]|\n)*>//g;
         }
      }

      $FORM{$name} = $value;
   }

}


########################
# Do the calculations!

sub calc_ans {

   if ($FORM{'box1'} eq 'Y') {
      $num = $num + 1;
   }
   if ($FORM{'box2'} eq 'Y') {
      $num = $num + 2;
   }
   if ($FORM{'box3'} eq 'Y') {
      $num = $num + 4;
   }
   if ($FORM{'box4'} eq 'Y') {
      $num = $num + 8;
   }
   if ($FORM{'box5'} eq 'Y') {
      $num = $num + 16;
   }
   if ($FORM{'box6'} eq 'Y') {
      $num = $num + 32;
   }


}   

#######################
# Generate the HTML with the answer

sub answer {
   print "Content-type: text/html\n\n";
   print "<html><head><title>Your Answer Is...</title></head>\n";
   print "<center><body bgcolor=#FFFFFF text=#000000><h1>Your Answer Is</h1>\n";
   print "<font size=+6>\n";
   print "$num\n";
   print "<p>\n";
   print "<img src=\"$genieurl/genie.gif\" border=0>\n";
   print "<p></font>\n";
   print "<p>\n";
   print "<center>\n";
   print "<form method=\"$METHOD\" action=\"$baseurl\">\n";
   print "<input type=submit value=\" Click Here To Return To Main Magic Page \">\n";
   print "</form></center></font></body></html>\n";

   exit;
}

######################
# Generate a missing fields error page

sub missing_fields {

   print "Content-type: text/html\n\n";
   print "<html><head><title>Missing Fields</title></head>\n";
   print "<center><body bgcolor=#FFFFFF text=#000000><h1>Oops!</h1>\n";
   print "<font size=+2>\n";
   print "It would appear that you accidentally left a field blank\n";
   print "<p>\n";
   print "Please use your browsers back button to return to the previous ";
   print "page and fill in the missing sections.<p>\n";
   print "<img src=\"$genieurl/genie.gif\" border=0>\n";
   print "</center></font></body></html>\n";

   exit;
}



######################
# All tables were checked as NO which is invalid, explain this to the 
# inDUHvidual! 

sub trick {

   print "Content-type: text/html\n\n";
   print "<html><head><title>It's Not Wise To Try And Fool The Genie!</title></head>\n";
   print "<center><body bgcolor=#FFFFFF text=#000000><h1>Say - What are you? - A Wise Guy?</h1>\n";
   print "<font size=+2>\n";
   print "Who do you think you're trying to fool? <br> I said to pick\n";
   print "a number between 1 and 63... <br>Answering NO on each one of the\n";
   print "tables is just like choosing 0, <br>which if you didn't know, \n";
   print "doesn't fall within that number range.\n";
   print "<p>\n";
   print "Hey Wise Guy, use your browsers back button to return to the previous ";
   print "page and try again.<p>\n";
   print "<img src=\"$genieurl/genie.gif\" border=0>\n";
   print "</center></font></body></html>\n";

   exit;
}
