#!/usr/bin/perl
##############################################################################
# FastAward - The Easiest Way To Give Awards                                 #
# Copyright (c) 1998 - All Rights Reserved by Amusive Communications         #
# Version 1.2a (Public Release #4)                                           #
#  http://www.amusive.com/scripts/                  jim@amusive.com          #
##############################################################################
# This file can not be redistributed in any way, shape, or form              #
# without prior written consent from Jim Reardon.  If somebody wants         #
# the script, have them get it from my site.                                 #
#                                                                            #
# You are not allowed to profit from this script in any way, shape, or       #
# form.  You may not use this script on a CGI Hosting service.               #
#                                                                            #
# Fixed/Added in Version 1.2a:                                               #
#     * Re-added dependency on cgi-lib.pl...  now it works.                  #
#                                                                            #
# Fixed/Added in Version 1.2:                                                #
#     * Removed dependency on cgi-lib.pl									 #
#     * Small updates fixing things I didn't realize were broken             #
#                                                                            #
# Fixed in Version 1.1:                                                      #
#     * Fixed blatent and obvious security hole.                             #
#     * Removed advertisment.  What was I thinking, anyway?!                 #
#                                                                            #
# Use or like this script?  Donations are always accepted.  If you're just   #
# as poor as I am, you can just choose to link to one of my ever-expanding   #
# empire of websites:                                                        #
#                                                                            #
#     * http://www.freecenter.com/                                           #
#     * http://www.humorplanet.com/                                          #
#                                                                            #
# Or the script archive itself:                                              #
#                                                                            #
#     * http://www.amusive.com/scripts/                                      #
#                                                                            #
##############################################################################
require "cgi-lib.pl";

# $fullpath must be the FULL path to where FastAward will keep it's data.
#  This path must exist, and must be chmod'ded to 777.

$fullpath = "/usr/username/fastaward";

# $emailtxt is a text file in the above directory that contains the message
#  to send to users when you award them your award.  If you wish to attach
#  a file, you must MIME or UUEncode it first, and add it to the end of
#  the file.

$emailtxt = "email.txt";

# $youremail is your email address.  This will be the 'from' field in the
#  email, and is also where notification will be sent if a user applies.

$youremail = 'youremail@yoursite.com';

# $yourname is your name, this will be what the E-mail is set to come
#  from.

$yourname = 'Jim Reardon';

# $notify - if this variable is set to 1, you will receive an E-mail each
#  time somebody applies for your award.  Set this to 0 to not receive an
#  email.

$notify = "0";

# $showemail - if this is set to 1, award winner's email addressess will
#  be shown on the link page.

$showemail = "1";

# $forward - this is where the user is sent to after they have applied.

$forward = "http://yourserver.com/index.html";

# $dupeforward - this is where people that have entered a duplicate site
#  will be forwarded to.

$dupeforward = "http://yourserver.com/fastaward/dupe.html";

# $cgiurl - this is where fastaward.cgi is located.  You may need to specify
#   the http:// path to the CGI if you experience problems.

$cgiurl = "http://yourserver.com/fastaward/fastaward.cgi";

# $mailprog defines the location of the program that will send mail.

$mailprog = '/usr/sbin/sendmail -t';

# $password is your password.  Keep it safe.  Change it NOW.

$password = 'fastaward';

# Done!
##############################################################################

$numberterms = &ReadParse(*input);
$cpass = crypt($password, $ENV{'REMOTE_ADDR'});

if ($input{'dosearch'}) {
   open (DATA, "$fullpath/awarded.db") || &ErrorOut;
   @data = <DATA>;
   close (DATA);

   &HTMLTop("Results of Your Search");

   print "<H1 ALIGN=CENTER>Search Results</H1>\n";

   print "<HR><BR>\n";

   foreach $data (@data) {
     @info = split("::", $data);
     if ($info[0] =~ /$input{'string'}/i || $info[1] =~ /$input{'string'}/i || $info[2] =~ /$input{'string'}/i || $info[3] =~ /$input{'string'}/i || $info[4] =~ /$input{'string'}/i) {
       chomp($info[0]);
       chomp($info[1]);
       chomp($info[2]);
       chomp($info[3]);
       chomp($info[4]);
       &ShowRecord;
     }
   }

   print "<HR><BR><CENTER><I>New Search</I></CENTER>\n";
   print "<FORM METHOD=POST ACTION=$cgiurl>\n";
   print "<INPUT TYPE=HIDDEN NAME=dosearch VALUE=1>\n";
   print "<CENTER>Search For: <INPUT TYPE=TEXT NAME=string><BR><BR>\n";
   print "<INPUT TYPE=SUBMIT VALUE=Search></CENTER>\n";
   print "</FORM>\n";

   &HTMLBot;
}

if ($input{'search'}) {
   &HTMLTop("Search Winners List");
   print "<H1 ALIGN=CENTER>Search The Winners List</H1>\n";
   print "<FORM METHOD=POST ACTION=$cgiurl>\n";
   print "<INPUT TYPE=HIDDEN NAME=dosearch VALUE=1>\n";
   print "<CENTER>Search For: <INPUT TYPE=TEXT NAME=string><BR><BR>\n";
   print "<INPUT TYPE=SUBMIT VALUE=Search></CENTER>\n";
   print "</FORM>\n";
   &HTMLBot;
}

if ($input{'view'}) {
   open (DATA, "$fullpath/awarded.db") || &ErrorOut;
   @data = <DATA>;
   close (DATA);

   &HTMLTop("Winners Listing");

   print "<H1 ALIGN=CENTER>Winners List</H1>\n";

   print "<HR><BR>\n";

   foreach $data (@data) {
     @info = split("::", $data);
     chomp($info[0]);
     chomp($info[1]);
     chomp($info[2]);
     chomp($info[3]);
     chomp($info[4]);
	 &ShowRecord;
   }

   print "<HR><BR><CENTER><I>Search The Winners List</I></CENTER>\n";
   print "<FORM METHOD=POST ACTION=$cgiurl>\n";
   print "<INPUT TYPE=HIDDEN NAME=dosearch VALUE=1>\n";
   print "<CENTER>Search For: <INPUT TYPE=TEXT NAME=string><BR><BR>\n";
   print "<INPUT TYPE=SUBMIT VALUE=Search></CENTER>\n";
   print "</FORM>\n";

   &HTMLBot;
}

if ($input{'award'}) {
   &WrongPassword unless ($input{'password'} eq $cpass);

   open (DATA, "$fullpath/applications.db") || &ErrorOut;
   @data = <DATA>;
   close (DATA);

   $counter = 0;
   open (DATA, ">$fullpath/applications.db") || &ErrorOut;
   foreach $data (@data) {
     print (DATA $data) unless ($counter == $input{num});
     $keepline = $data if ($counter == $input{num});
     $counter++;
   }
   close (DATA);
   open (DATA, ">>$fullpath/awarded.db") || &ErrorOut;
   print DATA $keepline;
   close (DATA);

   open (EMAIL, "$fullpath/email.txt") || &ErrorOut;
   @email = <EMAIL>;
   close (EMAIL);

   open(MAIL,"|$mailprog ");

   print MAIL "To: $input{'email'}\n";
   print MAIL "From: $youremail ($yourname)\n";
   print MAIL "Subject: You've Won An Award!\n\n";
   foreach $email (@email) {
     chomp($email);
     print MAIL "$email\n";
   }
   close MAIL;

   print "Location: ${cgiurl}?review=1&cpassword=$cpass\n\n";
}

if ($input{'delete'}) {
   &WrongPassword unless ($input{'password'} eq $cpass);

   # Delete num.
   open (DATA, "$fullpath/applications.db") || &ErrorOut;
   @data = <DATA>;
   close (DATA);

   $counter = 0;
   open (DATA, ">$fullpath/applications.db") || &ErrorOut;
   foreach $data (@data) {
     print (DATA $data) unless ($counter == $input{num});
     $counter++;
   }
   close (DATA);
   print "Location: ${cgiurl}?review=1&cpassword=$cpass\n\n";
}

if ($input{'review'}) {
   &GetPassword unless ((defined($input{'password'})) || (defined($input{'cpassword'})));
   &WrongPassword unless (($input{'password'} eq $password) || ($input{'cpassword'} eq $cpass));

   # List people that have applied, list them, and offer to Award or Delete
   open (DATA, "$fullpath/applications.db") || &NoApplications;
   @data = <DATA>;
   close (DATA);

   &NoApplications if (($throw = @data) == 0);

   &HTMLTop("FastAward Administration...");
   print "<H2 ALIGN=CENTER>Review The Following Sites:</H2>\n";
   $counter = 0;
   foreach $data (@data) {
     @info = split(/::/, $data);
     print "<BR><HR><BR>\n";
     print "<FORM METHOD=POST ACTION=\"$cgiurl\">\n";
     print "<INPUT TYPE=HIDDEN NAME=password VALUE=\"$cpass\">\n";
     print "<INPUT TYPE=HIDDEN NAME=email VALUE=\"$info[3]\">\n";
     print "<INPUT TYPE=HIDDEN NAME=num VALUE=$counter>\n";
     print "<INPUT TYPE=HIDDEN NAME=award VALUE=1>";
     print "Site Title: <INPUT TYPE=TEXT SIZE=75 NAME=title VALUE=\"$info[0]\"><BR>\n";
     print "Site URL: <INPUT TYPE=TEXT NAME=url SIZE=75 VALUE=\"$info[1]\"><BR>\n";
     print "<A HREF=\"$info[1]\" TARGET=\"_new\">Click To Visit</A><BR>\n";
     print "Name: <A HREF=\"mailto:$info[3]\">$info[2] ($info[3])</A><BR>\n";
     print "Description: $info[4]<BR><BR>\n";
     print "<CENTER><INPUT TYPE=SUBMIT VALUE=\"Award This Person\"></CENTER>\n";
     print "</FORM>\n";
     print "<FORM METHOD=POST ACTION=\"$cgiurl\">\n";
     print "<INPUT TYPE=HIDDEN NAME=num VALUE=$counter>\n";
     print "<INPUT TYPE=HIDDEN NAME=delete VALUE=1>\n";
     print "<INPUT TYPE=HIDDEN NAME=password VALUE=\"$cpass\">\n";
     print "<CENTER><INPUT TYPE=SUBMIT VALUE=\"Delete This Person\"></CENTER>\n";
     print "</FORM>\n";
     $counter++;
   }   
   print "<BR>\n";
   &HTMLBot;
}

if ($input{'apply'}) {

   # Die if duplicates are found, we don't need to save 'em.
   if (!(&CheckDupe)) { print "Location: $dupeforward\n\n";  die; }

   # It's not a duplicate, let's save.
      # title, url, name, email, desc
   $input{'desc'} =~ s/\n/<BR>/g;
   @siteinfo[0] = $input{'title'};
   @siteinfo[1] = $input{'url'};
   @siteinfo[2] = $input{'name'};
   @siteinfo[3] = $input{'email'};
   @siteinfo[4] = $input{'desc'};
   $siteinfo = join("::", @siteinfo);

   open (DATA, ">>$fullpath/applications.db") || die ("Could not append to datafile!");
   print DATA "$siteinfo\n";
   close(DATA);

   open (DUPE, ">>$fullpath/dupelog.db");
   print DUPE "$input{url}\n";
   close(DUPE);

   if ($notify) {
     open(MAIL,"|$mailprog ");

     print MAIL "To: $youremail\n";
     print MAIL "From: $input{'email'}\n";
     print MAIL "Subject: FastAward Notification!\n\n";
     print MAIL "Somebody has applied for your award!\n";
     print MAIL "  $input{'title'} at $input{url}\n";
     close MAIL;
   }

   print "Location: $forward\n\n";
   
}

sub CheckDupe() {  # used by the application process

if (open(DUPE, "$fullpath/dupelog.db")) {
    @dupe = <DUPE>;
    $found = 0;
    foreach $dupe (@dupe) {
      chomp($dupe);
      if ($dupe eq $input{url}) { $found = 1; }
    }
    if ($found == 1) { 0; } else { 1; }
  } else {
    1;
  }
}

sub NoApplications() { # used by verification process

  &HTMLTop("Sorry: No Applications");
  print "<H2 ALIGN=CENTER>Sorry!</H2>\n\n";
  print "<P>There are no applications to review.  Why not check out one of my sites?</P>\n";
  print "<UL><LI><A HREF=\"http://www.freecenter.com/\">Free Center</A></li>\n";
  print "<LI><A HREF=\"http://www.humorplanet.com/\">Humor Planet</A></li></ul>\n";
  print "<BR>\n";
  &HTMLBot;
  die;
}

sub HTMLTop($htmltitle) { # Any time we need to show HTML

  print "Content-type: text/html\n\n";
  print "<HTML><HEAD><TITLE>$htmltitle</TITLE></HEAD>\n";
  print "<BODY>\n";
}

sub HTMLBot {

  print "<HR>\n";
  print "This award maintained through the <I>free</I> FastAward system.  Check it out - <A HREF=\"http://www.amusive.com/scripts/\">click here</A>!\n";
  print "</BODY></HTML>";
}

sub ErrorOut {

  &HTMLTop("Danger!  Danger!");
  print "<H1 ALIGN=CENTER>Error!</H1>\n";
  print "You have encountered a file error.  Either a necessary file is not present, or you have specified the path wrong, or did not set the permissions correctly.<BR><BR>\n";
  &HTMLBot;
  die;
}

sub WrongPassword {

  &HTMLTop("Bad Password");
  print "<H1 ALIGN=CENTER>Incorrect Password</H1>\n";
  print "The password you entered is incorrect.  Please hit the back button and try again.<BR><BR>\n";
  &HTMLBot;
  die;
}

sub ShowRecord {

     print "<A HREF=\"$info[1]\">$info[0]</A> - $info[4].";
	 print "<SMALL><I>Webmaster: <A HREF=\"mailto:$info[3]\">$info[2]</A></I></SMALL>" if ($showemail);	 
	 print "<BR><BR>\n";

}

sub GetPassword {

  &HTMLTop("Enter Your Password");
  print "<H1 ALIGN=CENTER>Enter Administrative Password</H1>\n";
  print "<BR>\n";
  print "<FORM METHOD=POST ACTION=$cgiurl>\n";
  print "<INPUT TYPE=HIDDEN NAME=review VALUE=1>\n";
  print "Password: <INPUT TYPE=PASSWORD NAME=password><BR>\n";
  print "<INPUT TYPE=SUBMIT VALUE=\"Enter\">\n";
  print "</FORM>\n";
  &HTMLBot;
  die;
}