#!/usr/bin/perl
# 
# ezauctgn.cgi - EZ Auction Generator - by Manny Juan <manny@jps.net> 4/3/99
# http://www.inet-images.com/manny/clad/
#
# this program was adapted from easy auction
#
# This will give your visitors the opportunity to set up an auction page on your
# site. the generated classified ad page uses ezauct.$cgi, patterned after greg mathews'  
# classified.cgi script, and modified so it could automatically generate the required
# files from a fill-in form.
#####################################################################################
$SIG{__DIE__} = \&Error_Msg;
$cgi="pl";
sub Error_Msg {
    $msg = "@_";
    print "\ncontent-type: text/html\n\n";
    print "The following error occurred : $msg\n";
    exit;
}

# Get the input
read(STDIN, $input, $ENV{'CONTENT_LENGTH'});

    # split the input
    @pairs = split(/&/, $input);

    # split the name/value pairs
    foreach $pair (@pairs) {

    ($name, $value) = split(/=/, $pair);

    $name =~ tr/+/ /;
    $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ s/<([^>]|\n)*>//g;
    if ($name eq 'cat') {
       push (@{$FORM{$name}}, $value);
       }
    else {
        $FORM{$name} = $value;
        }
    }
$userdir = $FORM{'userdir'};

######################################################################################
# set variables HERE

$win95=0;

# Set this to your base HTML directory. This is a PATH not a URL
# $base_dir = "/home/htdocs/your.isp.com/website/auction";
# $base_dir = "../webpages/auction";
$base_dir = "/iiw/htdocs/www.inet-images.com/manny/auction";

# $cgiurl = "http://www.isp.com/website/cgi-bin";
# $cgiurl = "/cgi-bin";
$cgiurl = "http://www.inet-images.com:8080/manny/cgi-bin";

# This is your URL of where the new HTML pages will be kep
# $baseurl = "http://www.isp.com/website/$userdir";
# $baseurl = "/auction";
$baseurl = "http://www.inet-images.com/manny/auction";

# This is a URL and dir for the images sub directory in the userpages directory.
# Create the images directory in the userpages directory.
$imageurl = $baseurl;

# This is the path for user pages. You don't really need to change this
# Just make sure to create a directory: userpages and chmod it 777
$page_dir = "$base_dir/";

# This is the index list of all generated auctions
# $indexpage = "../webpages/auction/index.html";
$indexpage = "/iiw/htdocs/www.inet-images.com/manny/auction/index.html";


# This is the location of the data.txt file. This holds each user's
# login name and e-mail address for confirmation
$data = "$base_dir/data.txt";

# This contains the master list of auction categories
$catlist = "/iiw/htdocs/www.inet-images.com/manny/auction/catlist.txt";

#Site title

$title="EZ Auction Maker Mall";

# self explanatory variables for your site logo
$logo = "$imageurl/mjmall.jpg";
$logoalt = "Cyber Mall";

# Location of the sendmail program
$sendmail = '/usr/sbin/sendmail';

# Your e-mail address here
$myemail = 'manny@jps.net';

# That's it.

# DO NOT CHANGE ANYTHING BELOW THIS LINE
######################################################################################

# Lets do some translating first
$usrname = $FORM{'usrname'};
$login = $FORM{'login'};
$email = $FORM{'email'};
$pagename = $FORM{'pagename'};
$updact = $FORM{'updact'};
$sitename=$FORM{'sitename'};
$closedir=$FORM{'closedir'};
$regdir=$FORM{'regdir'};
$adminpass=$FORM{'adminpass'};
$aftermin=$FORM{'aftermin'};
$newokay=$FORM{'newokay'};
$flock=$FORM{'flock'};
$colorset=$FORM{'colorset'};
$retlink=$FORM{'retlink'};
$mycats = join('|',@{$FORM{'cat'}});

# convert to hash
%mycatd = split('\|',$mycats);

# build string containing all my keys
$mycatk ="";
foreach $tag (keys %mycatd) { # For every tag 
    $mycatk .= ".$tag";
    }

# eliminate some special characters
$pagename=~s/\W//g;
# If the user tries to add more than one word in
# the page name field, this will put an underscore
# in the spaces to make it one word
$pagename =~ s/ /_/g;

if ($FORM{'action'} eq "New Page") {
    &newpage;
    }
if ($FORM{'action'} eq "Create Page") {
    &create;
    }
if ($FORM{'action'} eq "Edit Page") {
    &confirm("edit");
    }
if ($FORM{'action'} eq "Delete Page") {
    &confirm("delete");
    }
if ($FORM{'action'} eq "checkuser") {
    &checkuser;
    }
if ($FORM{'action'} eq "recreate") {
    &recreate;
    }
if ($FORM{'action'} eq "delcat") {
    &delcat;
    }
    exit;

sub newpage {
    local($usrname, $email, $sitename,  $pagename, $colorset, $gbparms);

    ($usrname, $email, $sitename,  $pagename, $colorset, $gbparms) = split(/%%/, "");

    $closedir="closed";
    $regdir="reg";
    $adminpass="";
    $aftermin="5";
    $newokay="1";
    $flock="1";

    # To avoid any security risks. Take out the HTML tags added when HPM translated
    # the %% to: <br><br>. They will be re-translated to: %% Once the user updates
    # the page, the: %% will be put back to: <br><br>

    # print the edit-page form

    print "content-type: text/html\n\n";
    print "<html><head><title>Create Your Own Auction Page</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<table width=75% cellspacing=2 cellpadding=2 border=0>\n";
    print "<tr><td width=100% align=left valign=top>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>Create Your Own Auction Page</h2></font></p>\n";
    print "<p>Below is an empty form for you to fill in. The next six fields (<b>bold</b>) are required.\n";
    print "You can edit any part of your page later</p>\n";
    print "<p></p>\n";
    print "<form action=\"$cgiurl/ezauctgn.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"userdir\" value=\"$userdir\">\n";
    print "<input type=hidden name=\"action\" value=\"Create Page\">\n";
    print "<b>Your name:</b><br>\n";
    print "<font size=\"-1\">(will appear in page as link to your email)</font><br>\n";
    print "<input type=text size=40 name=\"usrname\" value=\"$usrname\"><br><br>\n";
    print "<h3>(The next 4 fields will be used for editing)<h3>\n";
    print "<b>Login Id:</b>\n";
    print "<font size=\"-1\">(one word only you should know, used later for editing)</font><br>\n";
    print "<input type=text size=40 name=\"login\" value=\"$login\"><br><br>\n";
    print "<b>Your e-mail:</b>\n";
    print "<font size=\"-1\">(used for editing, will also appear in page)</font><br>\n";
    print "<input type=text size=40 name=\"email\" value=\"$email\"><br><br>\n";
    print "<b>Your page:</b>\n";
    print "<font size=\"-1\">(one word, will become the name of your auction page)</font><br>\n";
    print "<input type=text size=40 name=\"pagename\" value=\"$pagename\"><br><br>\n";
    print "<b>Your password:</b>\n";
    print "<font size=\"-1\">(password for auction administration)</font><br>\n";
    print "<input type=password size=20 name=\"adminpass\" value=\"$adminpass\"><br><br>\n";
    print "<br><b>Auction Title:</b>\n";
    print "<font size=\"-1\">(title of auction - will also be listed in index)</font><br>\n";
    print "<input type=text size=40 name=\"sitename\" value=\"$sitename\"><br><br>\n";
    print "</td></tr></table>\n";

    &build_form_content($usrname, $retlink, $email, $sitename, $pagename, $colorset, $gbparms);
    print "<P><input type=submit value=\"create page\">\n";
    print "</form>\n";
    print "</body></html>\n";
    }

sub create {

    # Now, lets do some error checking. Making sure they filled out each field
    # This is pretty low tech now. I'll improve it later
    &missing(missing_name) unless $usrname;
    &missing(missing_email) unless $email;
    &missing(missing_password) unless $adminpass;
    &missing(missing_pagename) unless $pagename;

    # if they try to name their page "index" This will stop them
    if (uc($pagename) eq "INDEX") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
        print "<p>You cannot name your page <b>index</b>\n";
        print "Please go back and re-name your page</p>\n";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        exit;
        }
    # if they Don't give their page a sitename This will stop them
    if ($sitename eq "") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<p>You MUST give your page an <b>auction title</b>\n";
        print "Please go back and enter one for your page</p>\n";
        exit;
        }

    # if the user tries to name their page 
    # something that is already taken
    # this will HOPEFULLY stop them :)
    if (-d "$base_dir/$pagename") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<p>The page name: <b>$pagename</b>\n";
        print "is already taken.\n";
        print "Please go back and rename your page</p>\n";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        exit;
        }

    &chk_no_cat;

    # create the new directory for pagename
    umask(000);  # UNIX file permission junk
    mkdir("$base_dir/$pagename", 0777) unless (-d "$base_dir/$pagename");     

    # add a dummy index page so curious browsers won't see folders
    open (IDXFILE,">$base_dir/$pagename/index.html")||die "i can't open >$base_dir/$pagename/index.html";
    print IDXFILE "<html><body><font face=\"Arial, Geneva\" size=4><a href=\"$cgiurl/ezauct.$cgi?sitedir=$pagename\">$sitename</a></font></p></body></html>"; 
    close(IDXFILE);

    # create the config file
    open (CFGFILE,">$base_dir/$pagename/myauct.cfg")||die "i can't open >$base_dir/$pagename/myauct.cfg";
    $cryptpwd=pack('u',$adminpass);
    chomp $cryptpwd;
    print CFGFILE "$usrname%%$retlink%%$sitename%%$closedir%%$regdir%%$aftermin%%$newokay%%$flock%%$colorset%%$mycats%%$cryptpwd";
    close(CFGFILE);

    # Write the login name and email address to a separate file for confirmation
    # when they want to edit their page
    open (FILE, ">>$data") || die "I can't open >>$data\n";
    if($win95==0){flock (FILE, 2) or die "can't lock data file\n";}
    $cryptpwd=pack('u',"$adminpass");
    print FILE "$login%%$email%%$pagename%%$cryptpwd";
    close(FILE);

    # Suck the index page, and write the new entry to it
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
    @lines = <FILE>;
    close(FILE);
    $sizelines = @lines;

    # Now, re-open the links file, and add the new link
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file\n";}

    for ($a = 0; $a <= $sizelines; $a++) {

        $_ = $lines[$a];

        if (/<!--begin-->/) {

            print FILE "<!--begin-->\n";
            print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$cgiurl/ezauct.$cgi?sitedir=$pagename\">$sitename</a></font></p>\n";

        } else {
            print FILE $_;
            }
        }
    close(FILE);


    # Give the user a response
    print "content-type: text/html\n\n";
    print "<html><head><title>thanks</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<BR><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";

    print "Your auction page has been created, and you will receive an e-mail confirming this!\n";
    print "You can visit your auction page by clicking ";
    print "<a href=\"$cgiurl/ezauct.$cgi?sitedir=$pagename\">here</a>\n";
    print "  The index page has been updated with this link.\n";
    print "Thanks for your participation!\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";


    # Send the user an e-mail confirming their page
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $usrname <$email>\n";
    print MAIL "From: $myemail\n";
    print MAIL "Subject: Your new URL on the $title\n";
    print MAIL "Your page can be viewed at the URL below:\n";
    print MAIL "\n";
    print MAIL "$cgiurl/ezauct.pl?sitedir=$pagename\n";
    print MAIL "\nThank you for using the $title\n";
    print MAIL "\n\nThe Mall Manager - $myemail\n";
    close (MAIL);

    # Notify us when someone creates a page
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $myemail\n";
    print MAIL "From: $usrname <$email>\n";
    print MAIL "Subject: $title New Page Report\n";
    print MAIL "$usrname created a new page:\n";
    print MAIL "$cgiurl/ezauct.pl?sitedir=$pagename\n";
    close(MAIL);

    }

sub recreate {
    # Suck the index page, and update page name (in case it changed)
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, re-open the links file, and comment out the page to delete
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file to delete entry\n";}

            for ($a = 0; $a <= $sizelines; $a++) {

            $_ = $lines[$a];

        if (/$pagename\b/) {
            print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$cgiurl/ezauct.$cgi?sitedir=$pagename\">$sitename</a></font></p>\n";
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);

    # create the config file
    open (CFGFILE,">$base_dir/$pagename/myauct.cfg")||die "i can't open >$base_dir/$pagename/myauct.cfg";
    $cryptpwd=pack('u',$adminpass);
    chomp $cryptpwd;
    print CFGFILE "$usrname%%$retlink%%$sitename%%$closedir%%$regdir%%$aftermin%%$newokay%%$flock%%$colorset%%$mycats%%$cryptpwd";
    close(CFGFILE);

    &ntfy_usr_edt;

    # Give the user a response
    print "content-type: text/html\n\n";
    print "<html><head><title>thanks</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
    print "<P><BR><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "Your auction page has been revised, and you will receive an e-mail confirming this!\n";
    print "You may visit your auction page by clicking ";
    print "<a href=\"$cgiurl/ezauct.$cgi?sitedir=$pagename\">here</a>.\n";
    print "Thanks for your participation!\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    }

sub ntfy_usr_edt {
    # Send the user a notice that their page has been re-done
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $usrname <$email>\n";
    print MAIL "From: $myemail\n";
    print MAIL "Subject: Your Changes on the $title\n";
    print MAIL "Your revised page can be viewed at the URL below:\n";
    print MAIL "\n";
    print MAIL "$cgiurl/ezauct.pl?sitedir=$pagename\n";
    print MAIL "\nOnce again thank you for using the $title\n";
    print MAIL "\n\nThe Mall Manager\n";
    close (MAIL);
    }

sub chk_bad_maxdepn {
    if ($maxdepn !~ /^(\d){1,3}$/) {
        &input_error("invalid or unreasonable value for max items in a category (enter 1 to 99)");
        exit;
        }
    }
sub chk_bad_maxdays {
    if ($maxdays !~ /^(\d){1,3}$/) {
        &input_error("invalid or unreasonable value for max retention days (enter 1 to 99)");
        exit;
        }
    }
sub chk_no_cat {
    if ($mycatk eq "") {
        &input_error("no ad categories selected (please select from list)");
        exit;
        }
    }
sub input_error {
    local ($errmsg) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Error</title></head>\n";
    print "<body>";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<h1>Input Error!</h1><h3>$errmsg.</h3>\n";
    print "<p>Please go back and correct</p>\n";
    }

# Standard error message for any missing required fields
sub missing {
    local ($missing) = @_;
    print "content-type: text/html\n\n";

    print "<HTML><head><TITLE>You missed something</TITLE></head>\n";
    print "<body>\n";
    &put_banner;    
    print "You forgot to fill in one of the fields. Please go back and make\n";
    print "sure that all required fields are filled in! $missing\n";
    print "</body></HTML>\n";
    exit;
    }

sub confirm {
    local ($updact) = @_;

    print "content-type: text/html\n\n";
    print "<html><head><title>$updact Confirmation</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
    &put_banner; 
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\"  border=0></CENTER>\n";
    print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "<p><h3>Please Enter your login name, e-mail, name of your auction page to $updact and your password</h3></p>\n";
    print "<form action=\"$cgiurl/ezauctgn.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"userdir\" value=\"$userdir\">\n";
    print "<P><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "Login name:<br>\n";
    print "<input size=40 type=text name=\"login\"><br>\n";
    print "E-mail:<br>\n";
    print "<input size=40 type=text name=\"email\"><br>\n";
    print "Name of your auction page:<br>\n";
    print "<input type=text size=40 name=\"pagename\"><br>\n";
    print "Password:<br>\n";
    print "<input type=password size=40 name=\"adminpass\"><br>\n";
    print "<br><input type=submit value=submit>\n";
    print "<input type=hidden name=\"action\" value=\"checkuser\">\n";
    print "<input type=hidden name=\"updact\" value=\"$updact\">\n";
    print "</FONT>\n";
    print "</form></body></html>\n";
    }

sub checkuser {
    open(FILE, "$data") || die "I can't open $data\n";  
    if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}
    while(<FILE>) {
    chop;       
    @all = split(/\n/);

    foreach $line (@all) {
    chomp $line;
    ($loginname, $loginemail, $loginpagename, $logincrypt) = split(/%%/, $line, 4);
    $loginpass=unpack('u',"$logincrypt");
    if($loginname eq "$login" && $loginemail eq "$email" 
    && $loginpagename eq "$pagename" && $loginpass eq "$adminpass") {
        $match = 1;
        if($updact eq "edit") {&edit($loginpagename);}
        elsif ($updact eq "delete") {&delpage($loginpagename);}
          }
        }
     }
    close(FILE);

    if (! $match) {
        &error;
        }

    # del entry from data
    if($updact eq "delete") {

        # Suck the index page, and write the new entry to it
        open(FILE, "$data") || die "I can't open that file $data\n";
        if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}
            @lines = <FILE>;
            close(FILE);
            $sizelines = @lines;

        # Now, re-open the links file, and comment out the page to delete
        open(FILE, ">$data") || die "I can't open that file >$data\n";
        if($win95==0){flock (FILE,2) or die "can't lock $data for append\n";}
        chop;
        for ($a = 0; $a <= $sizelines; $a++) {
        $_ = $lines[$a];
        $w = $_;
        $w =~ s/\cM//g;
        $w =~ s/\n//g;
        chomp $w;
        ($loginname, $loginemail, $loginpagename, $logincrypt) = split(/%%/, $w, 4);
        $loginpass=unpack('u',"$logincrypt");
        if($loginname eq "$login" && $loginemail eq "$email" 
        && $loginpagename eq "$pagename" && $loginpass eq "$adminpass") {
              # do nothing  (ie. don't write)
              } 
            else {
              if($w eq "") {
                # do nothing (skip)
                }
              else {
                print FILE "$w\n";
                }
              }
            }
        close(FILE);
        print "content-type: text/html\n\n";
        print "<html><head><title>$updact Confirmation</title></head>\n";
        print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
        &put_banner; 
        print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
        print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
        print "<p>your page has been deleted";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        print "</form></body></html>\n";
      }
    }

sub edit {
    local ($pagename) = @_;
    # get the config file
    open(CFGFILE, "$base_dir/$pagename/myauct.cfg") || die "I can't open $base_dir/$pagename/myauct.cfg\n";
    if($win95==0){flock (CFGFILE, 1) or die "can't lock data file for edit\n";}
    $txrec=<CFGFILE>;
    &build_edit_form($txrec);
    close(CFGFILE);
    }

sub delpage {
    local ($pagename) = @_;
    &deltree(0,"$base_dir/$pagename");

    # Suck the index page, and write the new entry to it
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, re-open the links file, and comment out the page to delete
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file to delete entry\n";}

            for ($a = 0; $a <= $sizelines; $a++) {

            $_ = $lines[$a];

        if (/$pagename\b/) {
          # do nothing  (ie. don't write)
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);

    }

sub deltree {
    local ($lvl, $dir) = @_;
    local @tnlist;
    opendir (TN, "$dir");
    rewinddir (TN);
    @tnlist =  grep(!/^\.\.?$/, readdir (TN));
    closedir (TN);
    foreach $tn (@tnlist) {
        if (-d "$dir/$tn") {
            $lvl++;
            &deltree($lvl,"$dir/$tn" );
            $lvl--;
            }
        else {
            $cnt=unlink("$dir/$tn");
#            print "<br>deleting $dir/$tn";
            }
        }
    rmdir ("$dir");
#    print "<br>removing $dir";
    }

sub delcat {
    # get the config file
    open(CFGFILE, "$base_dir/$pagename/myauct.cfg") || die "I can't open $base_dir/$pagename/myauct.cfg\n";
    if($win95==0){flock (CFGFILE, 1) or die "can't lock data file for edit\n";}
    $txrec=<CFGFILE>;
    ($usrname, $retlink, $sitename,$closedir,$regdir,$aftermin,$newokay,$flock,$colorset,$mycats,$cryptpwd)=split(/%%/,$txrec);

    # create hash of categories
    %mycatd=split(/\|/,$mycats);
    delete $mycatd{$FORM{'delcatname'}};
    $mycats = join('|',%mycatd);

    &deltree(0,"$base_dir/$pagename/$FORM{'delcatname'}");

    # create the config file
    open (CFGFILE,">$base_dir/$pagename/myauct.cfg")||die "i can't open >$base_dir/$pagename/myauct.cfg";
    print CFGFILE "$usrname%%$retlink%%$sitename%%$closedir%%$regdir%%$aftermin%%$newokay%%$flock%%$colorset%%$mycats%%$cryptpwd";
    close(CFGFILE);

    print "content-type: text/html\n\n";
    print "<html><head><title>$updact Confirmation</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
    &put_banner; 
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
    print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "<p>your auction category named $FORM{'delcatdesc'} has been deleted";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</form></body></html>\n";
    exit;
    }

sub build_edit_form {
    local ($line) = @_;
    chomp $line;
    ($usrname, $retlink, $sitename,$closedir,$regdir,$aftermin,$newokay,$flock,$colorset,$mycats,$cryptpwd)=split(/%%/,$line);
    %mycatd=split(/\|/,$mycats);
    $adminpass=unpack('u',$cryptpwd);

    # build string containing all my keys
    $mycatk ="";
    foreach $tag (keys %mycatd) { # For every tag 
        $mycatk .= ".$tag";
        }

    # To avoid any security risks. Take out the HTML tags added when HPM translated
    # the %% to: <br><br>. They will be re-translated to: %% Once the user updates
    # the page, the: %% will be put back to: <br><br>

    # print the edit-page form

    print "content-type: text/html\n\n";
    print "<html><head><title>Edit Your Auction Page</title></head>\n"; 
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";

    &put_banner; 
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<table width=75% cellspacing=2 cellpadding=2 border=0>\n";
    print "<tr><td width=100% align=left valign=top>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>Edit Your Auction Page</h2></font></p>\n";
    print "<p>Below is a form with the contents\n";
    print "of the auction page you created. You can edit any part of your page</p>\n";
    print "<p></p>\n";
    print "<form action=\"$cgiurl/ezauctgn.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"userdir\" value=\"$userdir\">\n";
    print "<input type=hidden name=\"action\" value=\"recreate\">\n";
    print "Your name:<br>\n";
    print "<input type=text size=40 name=\"usrname\" value=\"$usrname\"><br><br>\n";
    print "Your e-mail:<br>\n";
    print "<input type=text size=40 name=\"email\" value=\"$email\"><br><br>\n";
    print "Title of Your Auction Page:<br>\n";
    print "<input type=text size=40 name=\"sitename\" value=\"$sitename\"><br><br>\n";
    print "</td></tr></table>\n";
    print "Name of Auction Page: <b>$pagename</b><br><br>\n";
    print "<input type=hidden name=\"pagename\" value=\"$pagename\">\n";

    &build_form_content($usrname, $retlink, $email, $sitename,  $pagename, $colorset, $mycatk);
    print "<P><input type=submit value=\"update page\">\n";
    print "</form>\n";

    print "<hr><font face=\"Arial, Geneva\"><h2>Delete Auction Item</h2></font>";
    print "this section is for deleting a single auction item from any category";
    print " - the exact item number (copy from link) and the admin password are required.";
    print "<blockquote><a href=\"$cgiurl/ezauct.$cgi?sitedir=$pagename&action=admin\">delete auction item</a></blockquote>";
    print "<br>";

    print "<hr><font face=\"Arial, Geneva\"><h2>Delete Category</h2></font>";
    print "this section is for deleting single auction categories, one at a time. IMPORTANT: ";
    print "you will not be asked to verify your choice. ";
    print "once you delete a category, there is no turning back. the whole category is deleted, ";
    print "all auctions within it are also deleted and there is no chance of recovery!";
    open(FILE, "$catlist") || die "I can't open that file $catlist\n";
    if($win95==0){flock (FILE, 1) or die "can't lock cat file\n";}
    @catlines = <FILE>;
    close(FILE);
    print "\n<br><br><b>Select the Auction Category you want to delete:</b>\n";
    foreach (@catlines) {
        chop;
        ($catname,$catdesc) = split('\|',$_);
        if ( $mycatk =~ /\.$catname/ ) {
            print "\n<hr><form action=\"$cgiurl/ezauctgn.$cgi\" method=POST>";
            print "\n<input type=hidden name=action value=\"delcat\">";
            print "\n<input type=hidden name=pagename value=\"$pagename\">";
            print "\n<input type=hidden name=delcatname value=\"$catname\">";
            print "\n<input type=hidden name=delcatdesc value=\"$catdesc\">";
            print "\n<input type=submit value=\"Delete\"> $catdesc</form>";
            }
        }
        print "<hr>";
    print "</body></html>\n";
    }

sub build_form_content {
    local ($usrname, $retlink, $email, $sitename,  $pagename, $colorset, $mycatk)=@_;

    print "<b>Select Preset Colors:</b>";
    print "<SELECT NAME=\"colorset\">";
    &put_clropt($colorset,'01','FFFFFF~333333~006699~999900');
    &put_clropt($colorset,'02','CCCCCC~000000~0000CC~660066');
    &put_clropt($colorset,'03','FFFF00~FF6600~FF0033~336633');
    &put_clropt($colorset,'04','CCCC66~330000~CC0000~003300');
    &put_clropt($colorset,'05','FFFF99~330000~CC0000~333333');
    &put_clropt($colorset,'06','99CCCC~000066~0000CC~003366');
    &put_clropt($colorset,'07','CC99FF~000000~FF0033~660066');
    &put_clropt($colorset,'08','CCFF99~666600~006699~003300');
    &put_clropt($colorset,'09','FFCC00~330000~CC0000~660066');
    &put_clropt($colorset,'10','00FF33~0000CC~FF0099~660066');
    &put_clropt($colorset,'11','006699~CCFFCC~FFFF00~00FFFF');
    &put_clropt($colorset,'12','330000~FF6666~FFCC00~CCFF99');
    &put_clropt($colorset,'13','003300~CCCC66~FFFFFF~FFFF00');
    &put_clropt($colorset,'14','333333~CCCCCC~FF6666~CCCC66');
    &put_clropt($colorset,'15','666600~FFFFFF~FFFF00~99CCFF');
    &put_clropt($colorset,'16','000000~99CCFF~FFFF00~CCCC66');
    &put_clropt($colorset,'17','333333~FFFFFF~99CCFF~CC99FF');
    &put_clropt($colorset,'18','CC0000~FFFFFF~FFFF00~00FFFF');
    print "\n</SELECT>";
    print "<br><img src=\"$baseurl/ezpalette.gif\"><br><br>\n";
    print "<b>Closed-Auction Directory:</b>";
    print " This is where closed auction items are stored.";
    print " Leave this blank if you don't want to store closed auctions.";
    print " It can potentially take up quite a bit of disk space.";
    print "<br><input type=text size=20 name=\"closedir\" value=\"$closedir\"><br><br>\n";
    print "<b>User Registration Directory:</b>";
    print " This is where registrations are stored.";
    print " Leave this blank if you don't want to require registration.";
    print " It can potentially take up quite a bit of disk space.";
    print "<br><input type=text size=20 name=\"regdir\" value=\"$regdir\"><br><br>\n";
    print "<b>\"Sniper\" Protection:</b>";
    print " How many minutes past last bid to hold auction.";
    print " If auctions should close at exactly closing time, set to zero.";
    print "<input type=text size=5 name=\"aftermin\" value=\"$aftermin\">\n";
    print "<br><br><b>User Posting:</b><br>";
    &prt_ckb($newokay, 'newokay', 'allow users to post items');
    print "<br><br><b>File Locking:</b><br>";
    &prt_ckb($flock, 'flock', 'use file locking (turn off for windows 95 server)');

    open(FILE, "$catlist") || die "I can't open that file $catlist\n";
    if($win95==0){flock (FILE, 1) or die "can't lock cat file\n";}
    @catlines = <FILE>;
    close(FILE);
    print "<br><br><b>Select the desired Auction Categories:</b>\n";
    foreach (@catlines) {
        chop;
        ($catname,$catdesc) = split('\|',$_);
        print "\n<br><input type=\"Checkbox\" name=\"cat\" value=\"$_\"";
        if ( $mycatk =~ /\.$catname/ ) { print " checked"; }
        print ">$catdesc";
        }

    print "\n<br><br><b>Return Link (URL):</b>link here when user clicks Return<br>\n";
    print "<input type=text size=50 name=\"retlink\" value=\"$retlink\"><br><br>\n";
    }

sub prt_ckb {
    local ($var, $varname, $ckbdesc) = @_;
    print "\n<tr><td><INPUT TYPE=\"CHECKBOX\" NAME=\"$varname\" VALUE=\"1\"";
    if ($var eq "1") {print " CHECKED";} 
    print "></td>";
    print "<td>$ckbdesc</td></tr>";
    }

sub put_clropt  {
    local ($colorset, $id, $colors)=@_;
    print "\n<OPTION VALUE=\"$colors\"";
    if ($colorset eq $colors) {print " SELECTED";}
    print ">$id";
    }

sub error {
    local ($updact) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Permission Denied</title></head>\n";
    print "<body>\n";
    &put_banner; 
    print "<p><h1>Permission Denied</h1></p>\n";
    print "You do not have permission to $updact\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    exit;
    }
sub badpwd {
    print "content-type: text/html\n\n";
    print "<html><head><title>Invalid Password</title></head>\n";
    print "<body>\n";
    &put_banner; 
    print "<p><h1>Invalid Password</h1></p>\n";
    print "Please supply a correct password before proceeding\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    exit;
    }
sub put_banner {
    # do nothing
    }
