#!/usr/bin/perl
######################### 
#   QUICK-RECOMMEND (V. 2.1)
#########################
#AUTHOR: David Powell
#http://www.matrixvault.com/cgi/
# Copyright 1999, David Powell and "The Matrix Vault"
# A Matrix Vault Production.
# Tested and run on a UNIX system with PERL 5
# This script is an original script by David Powell. You may use it free of charge, if you keep this header intact, 
# along with any other copyright notices found in the resulting HTML output or text files generated by this script. 
#########################
#    Desc: 
#    This script sends a recommendation message from your web site visitor to 
# another user directly from your web page. When finished, you can either take the user to a 
# thank you page, or return to the page he/she came from.
#
#  UPDATES: 
#      2.1 -   Added automatic forms and more streamlining
#      2.0  -  Steamlined and added exterior message support with available tags.
#      1.1  -  Now keeps a log of who did what.
#  INSTALLATION:
#     See the Read-me file that came with this file.
#
#########################################
#                B E G I N      E D I T          V A R I A B L E S 

#The UNIX path to your log file.  If you use the filename with no directory defined, it
# will default to the script's dir.
$LOGFILE = "recommend.log";

# The HTTP URL of this script. This is the URL that is used in the post tag of the 
# automatic form generation. 
$post_to = "http://www.matrixvault.com/cgi/scripts2/recommend/recommend.cgi";

#Your Site's top URL. This is the URL that the recipient will be suggested to visit.
$SITE_URL = "http://www.matrixvault.com/";

# Your site's Name
$site_name = "The Matrix's CGI Vault";

#The Path to your server's mail program
$MAIL_PROGRAM="/usr/lib/sendmail -t"; 

#The URL where you want the user to goto after the message is sent. 
$GOTO = "http://www.matrixvault.com/";

# Your email address is shown when the users gets a thank you message
# or when there is an error.
$webmaster_email = 'webmaster@matrixvault.com';

#
#            E N D           E D I T         V A R I A B L E S
#
#######################################
# Decode the Vars

	read (STDIN, $input, $ENV{'CONTENT_LENGTH'});
	@pairs = split(/&/, $input);

	foreach $pair (@pairs)
		 {
		($name, $value) = split(/=/, $pair);
		$value =~ tr/+/ /;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$value =~ s/<([^>]|\n)*>//g;
		$value =~ s/<//g;
		$value =~ s/>//g;
		$value =~ s/\*/\\\*/g;
		$value =~ s/\?/\\\?/g;
		$value =~ s/\+/\\\+/g;
		$FORM{$name} = $value;
		}
	$action = $FORM{'action'};
	$sender_name   = $FORM{'sender_name'};
	$sender_email  = $FORM{'sender_email'};
	$recip_name  = $FORM{'recip_name'};
	$recipient = $FORM{'recip'};
##########
# Front Door
##########
	
	if ($action eq "process") 
		{
		&send_message;
		&thank_you; 
		&redirect; 
		exit;
		}
		else
		{
		&present_form; 
		exit;
		}
	
	exit;
	
################
# Send the recommendation mail
################
sub send_message
{
	if ($sender_email eq ""){ &error ("You left your email blank. Cannot send the message without your email address.");}
	if ($recipient eq ""){&error ("You left the recipient's email blank. How do I know who to email it to?");}
	
	open (TEXT, "to_friend.txt") || &error ("Cannot open the outgoing message to friend for reading!");
	while (<TEXT>)
		{
		$line = $_;
		$line =~s/\%sendername\%/$sender_name/gi;
		$line =~s/\%recipient\%/$recip_name/gi;
		$line =~s/\%sitename\%/$site_name/gi;
		$line =~s/\%url\%/$SITE_URL/gi;
		$line=~s/\%date\%/$date/gi;
		$output .= $line;
		}
	close (TEXT);
	
	$temp_recip="\"$sender_name\" <$sender_email>";

	open (MAIL, "|$MAIL_PROGRAM");
	print MAIL "To: $recipient\n";
	print MAIL "From: $temp_recip\n";
	print MAIL "Subject: Suggestion from $sender_name\n";

	print MAIL qq!
	$output
	
	
	--------------------------------------------------------------------------------
	This message generated on demand from: $SITE_URL
	by $temp_recip. To report abuses of this script (If someone 
	uses this script to mail bomb you) goto $SITE_URL.
	--------------------------------------------------------------------------------
	Powered by:
	"Recommend"
	Original Perl script:
	A Matrix Vault production
	http://www.matrixvault.com/cgi/
	!;
     	 close(MAIL);

	#print "Content-type: text/html\n\n";
	#print "Message Sent<BR>OUTPUT: <BR>$output";
	#exit;
}
##############################
# Send a thank you note to the sender
##############################
sub thank_you
{
	$output="";
	open (TEXT, "thank_you.txt") || &error ("Cannot open the thank you message for reading!");
	while (<TEXT>)
		{
		$line = $_;
		$line =~s/\%sendername\%/$sender_name/gi;
		$line =~s/\%recipient\%/$recip_name/gi;
		$line =~s/\%sitename\%/$site_name/gi;
		$line =~s/\%url\%/$SITE_URL/gi;
		$line=~s/\%date\%/$date/gi;
		$output .= $line;
		}
	close (TEXT);

	open (MAIL, "|$MAIL_PROGRAM");
	print MAIL "To: $sender_email\n";
	print MAIL "From: $webmaster_email\n";
	print MAIL "Subject: Thanks for recommending $site_name\n";
	print MAIL qq!
	$output


	--------------------------------------------------------------------------------
	This message generated on demand from: $SITE_URL
	by $temp_recip. To report abuses of this script (If someone 
	uses this script to mail bomb you) goto $SITE_URL.
	--------------------------------------------------------------------------------
	Powered by:
	"Recommend"
	Original Perl script:
	A Matrix Vault production
	http://www.matrixvault.com/cgi/
	!;

     	 close(MAIL);
}
########################
# Present the default form to the sender
########################
sub present_form
{
	$output = "";
	print "Content-type: text/html\n\n";
	$form = qq!
	<FORM METHOD="POST" ACTION="$post_to">
	<INPUT type=text name="sender_name" size=14 value="Your Name">
	<INPUT type=text name="sender_email" size=14 value="Your Email"><BR>
	<INPUT type=text name="recip_name" size=14 value="Friend's Name">
	<INPUT type=text name="recip" size=14 value="Friend's Email"><BR>
	<INPUT type=hidden name="action" value="process">
	<INPUT TYPE="submit" VALUE="Send">
	</FORM>!;
	$string = $ENV{'QUERY_STRING'};
	if ($string eq "template")
		{
		if (-e "template.html")
		{
		open (HTML, "template.html") || &error ("Cannot open the template for reading!");
			while (<HTML>)
				{
				$line = $_;
				$line =~s/\<\!--FORM--\>/$form/gi;
				$output .= $line;
				}
		close (HTML);
		print $output;
		}
		} else {print "$form";}
	

}
##############################
#   Make the entry in the log file and re
#   direct the user
##############################
sub redirect
{
	open (LOG,">>$LOGFILE");
  	print LOG"$date|$sender_name|$sender_email|$recipient|\n";
 	close(LOG);
	print "Location: $GOTO\n\n";
}

##############
# Error Handling
##############
sub error
{
	print "Content-type: text/html\n\n";
	print "Recommend.cgi ERROR:<BR>";
	print "$_[0]<BR>";
	print "Other: \($!\)<BR>";
	print "If this problem persists, email the <a href=\"mailto:$webmaster_email?subject=Recommend.cgi Error\">webmaster.<BR>";
	exit;
}


