#!/usr/local/bin/perl

require "echat41.cgi";
#################################################
# lister41.cgi - returns a page to the user, substituting
# a list of current occupants in place of *list*.
# The form must provide the room name and the page name.
#################################################

&get_data;

$filepath .= "/$FORM{'room'}/";

$page = "$FORM{'page'}.html";

print "Content-type: text/html\n\n";

################################################
# get help page lines

unless(open (PAGE,"$filepath$page")) {
        &system_error("Can't open $filepath$page");
        exit;
}
@helplines = <PAGE>;
close (PAGE);

foreach $line (@helplines){
	if ($line =~ /\*list\*/) {
		&print_occupants;
	}else {
		print "$line";
	}
}
exit;

################################################
# print occupants

sub print_occupants {
	chmod(0600, "$filepath/$list");
	unless(open (CHATLIST,"$filepath$list")) {
        &system_error("Can't open $filepath$list");
        exit;
	}
	chmod(0200, "$filepath/$list");
	@chatstuff = <CHATLIST>;
	close (CHATLIST);


	%chatters = ();
	foreach $stuff (@chatstuff) {
		chomp($stuff);
		($chatter,$chatip,$chattime,$chatcolor,$pmessfile) = split(/\t/,$stuff, 5);
		$chatters{$chatter} = [$chatip,$chattime,$chatcolor,$pmessfile];
	}

	# Update Occupants, list and count them.

	$olist = "<small> ";

	foreach $chatter (sort(keys(%chatters))){
		if (time - $chatters{$chatter}[1] < $timeout){
			$occ = "<font color=$chatters{$chatter}[2]><b>$chatter</b></font> - ";
			$olist .= $occ;
		}
		else{
			delete ($chatters{$chatter});
		}
	}
	$numchat = keys(%chatters);
	$olist = '<font color=black>The chatroom is currently empty.</font>' if not $numchat;
	$olist =~ s/- $//;
	$olist .= "</small>";
	print $olist;
}

################################################
# get form data

sub get_data {
if ($ENV{'QUERY_STRING'}) {
		$buffer = "&$ENV{'QUERY_STRING'}"
	}
	@pairs=split(/&/,$buffer);
	foreach $pair (@pairs) {
		@a = split(/=/,$pair);
		$name=$a[0];
		$value=$a[1];
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$value =~ s/~!/ ~!/g;
		$value =~ s/\+/ /g;
		$value =~ s/\r//g;
		$FORM{$name} = $value;
	}
}

sub system_error {
        local($errmsg) = @_;
	 print '<html><head></head><body>';
        print $errmsg;
	 print '</body></html>';
}
