#!/usr/local/bin/perl
require "echat41.cgi";
#####################################
# mkroom 4.1, Copyright Mike Bagneski 1999.
# Please do not redistribute.
#####################################
# CONFIGURATION SECTION

# Your password for admin access.
# It can be any sequence of up to eight characters.

	$pass = 'pass';

# Set to yes if you want the script to delete old rooms for you.

	$autonuke = 'yes';

# Number seconds of inactivity before a room is considered "dead".

	$roomtimeout = 600;

# END OF CONFIGURATION
#####################################
# Main Routine

	&get_info;

	@mains = split (/\,/,$perma_rooms);

	if ($autonuke eq 'yes'){
		&roomlist;
		foreach $room (@rooms){
			&last_update;
			if ($lastupdate >= $roomtimeout) {
				&delete_room;
			}
		&save_creators;
		}
	}

	if (exists($FORM{'newroom'}) and ($FORM{'newroom'} eq $pass)){
		&admin_form;
	}

	if (($FORM{'mode'} eq 'nuke') and ($FORM{'pass'} eq $pass)){
		&nuke_room;
	}

	if (($FORM{'mode'} eq 'delete') and ($creator{$remotehost} = $FORM{'room'}) and not(grep(/$FORM{'room'}/, @mains))){
		$room = $FORM{'room'};
		$username = $FORM{'username'};
		&delete_room;
		&save_creators;
		&main_form;
	}

	&check_user;

	if ($FORM{'mode'} eq 'setup'){
		&main_form;
	}

	if ($FORM{'mode'} eq 'create'){
		&create_room;
	}

	exit;

#####################################
# Get Information

sub get_info {

	read(STDIN,$buffer,$ENV{'CONTENT_LENGTH'});
	if ($ENV{'QUERY_STRING'}){
		$buffer = "$buffer\&$ENV{'QUERY_STRING'}";
	}
	@pairs=split(/&/,$buffer);
	foreach $pair (@pairs){
		($name,$value) = split(/=/,$pair);
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
		$value =~ s/\+/ /g;
		$name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
		$name =~ s/\+/ /g;
		$FORM{$name} = $value;
	}

	############# Get chatters list

	if(exists($FORM{'oldroom'})){
		chmod(0600, "$filepath/$FORM{'oldroom'}/$list");
		open (CHATLIST,"$filepath/$FORM{'oldroom'}/$list");
		@chatstuff = <CHATLIST>;
		close (CHATLIST);
		chmod(0200, "$filepath/$FORM{'oldroom'}/$list");

		%chatters = ();
		foreach $stuff (@chatstuff) {
			chomp($stuff);
			($chatter,$chatip,$chattime,$chatemail,$pmessfile) = split(/\t/,$stuff, 5);
			$chatters{$chatter} = [$chatip,$chattime,$chatemail,$pmessfile];
		}
	}

	############### Get Creators List

	unless(-e "./$creatorslist") {
		open(FILE, ">./$creatorslist");
		close(FILE);
		chmod(0200, "./$creatorslist");
	}

	chmod(0600, "./$creatorslist");
	open (CREATORS,"./$creatorslist");
	@creatorstuff = <CREATORS>;
	close (CREATORS);
	chmod(0200, "./$creatorslist");

	%creators = ();
	foreach $stuff (@creatorstuff){
		chomp($stuff);
		($creator,$creatorsroom) = split(/\t/,$stuff);
		$creators{$creator} = $creatorsroom;
	}
	$remotehost = $ENV{'REMOTE_HOST'};
	$remotehost = $ENV{'REMOTE_ADDR'} unless $remotehost;
	chomp ($remotehost);
}

########################################
# Check if user is logged on, if creator.

sub check_user {

	$username = $FORM{'username'};

	foreach $url(@valid){
		if($ENV{'HTTP_REFERER'} =~ /$url/){
			$okay = 'yes';
			last;
		}else{
			$okay = 'no';
		}
	}
	if($okay eq 'no') {
		print "Content-type: text/html\n\n";
		print "<html><head><title>Create Room</title></head><BODY>\n";
		print "<h1 align=center>Data Error<\h1><hr>\n";
		print "Please close this window and try again.\n";
		print "</body></html>";
		exit;
	}
	if (exists($creators{$username})){
		print "Content-type: text/html\n\n";
		print "<html><head><title>Create Room</title></head><BODY>\n";
		print "<h1 align=center>Sorry.  Only one private room to a customer.<\h1>\n";
		$room = $creators{$username};
		print "<H1 align=center>Yours is: <a href=\"$fileurl/$room\">$room</a>\n";
		print "<h2 align=center>Do you wish to delete this room?</h2>\n";
		print "<FORM ACTION=\"$ENV{'SCRIPT_NAME'}\" METHOD=POST>\n";
		print "<input type=hidden name=mode value=delete>\n";
		print "<input type=hidden name=room value=\"$room\">\n";
		print "<input type=hidden name=oldroom value=$FORM{'oldroom'}>\n";
		print "<input type=hidden name=username value=\"$username\">\n";
		print "<input type=submit value=\"Delete Room\">\n";
		print "</form></body></html>";
		exit;
	}
}

#######################################
# main form

sub main_form {
	@olist = sort(keys(%chatters));

	print "Content-type: text/html\n\n";
	print "<html><head><title>Create Room</title></head><BODY>\n";
	print "<FORM ACTION=\"$ENV{'SCRIPT_NAME'}\" METHOD=POST>\n";
	print "<h1 align=center>Creating a Private room for $username.</h1>\n";
	print "Room Name:<br><input type=text name=newroom size=8 maxlength=8>\n";
	print "<hr>Select Occupants to invite:<br>\n";
	print "<input type=hidden name=oldroom value=$FORM{'oldroom'}>\n";
	print "<input type=hidden name=username value=\"$username\">\n";
	print "<input type=hidden name=type value=private>\n";
	print "<input type=hidden name=mode value=create>\n";
	foreach $occupant (@olist){
		if ($occupant ne $username){
			print "<input type=checkbox name=$occupant value=yes>$occupant<br>\n";
		}
	}
	print "<hr><input type=submit value=\"Create Room\"></form></body></html>";
	exit;
}

#######################################
# admin form

sub admin_form {
	&roomlist;

	print "Content-type: text/html\n\n";
	print "<html><head><title>Create Room</title></head><body>";
	print "<FORM ACTION=\"$ENV{'SCRIPT_NAME'}\" METHOD=POST>\n";
	print "<center><table border align=center><tr><th>Select to Delete</th><th>Click to view Room</th><th>Time Since Last Update</th></tr>\n";

	foreach $room (@rooms){
		print "<tr><td><input type=checkbox name=$room value=yes></td><td><a href=\"$fileurl/$room/$admin\" TARGET=\"_blank\">$room</a></td>\n";
		&last_update;
		print "<td>$lastupdate seconds ago.</td></tr><br>\n";
	}
	print "</table></center><input type=hidden name=mode value=nuke>\n";
	print "<input type=hidden name=pass value=\"$FORM{'newroom'}\">\n";
	print "<p align=center><center><input type=submit name=nuke Value=\"Delete Room\"></center>\n";
	print '</form></body></html>';
	exit;
}

#######################################
# nuke room

sub nuke_room {
	&roomlist;

	print "Content-type: text/html\n\n";
	print "<html><head><title>Create Room</title></head><body>\n";

	foreach $room (@rooms){
		if ($FORM{"$room"} eq 'yes'){
			&delete_room;
			print "<h1 align=center>$room is deleted.</h1>\n";
		}
	}
	print "</body></html>\n";
	&save_creators;
	exit;
}

#######################################
# create room, send invitations, and redirect to room.

sub create_room {
	&roomlist;

	$oldroom = $FORM{'oldroom'};
	$newroom = $FORM{'newroom'};

	@badwords = ("fuck", "shit", "pecker", "asshole", "bitch", "cunt", "cock", "pussy", "tit");
 	for (@badwords)
	{
		$newroom =~ s/$_//gi;
	}
	$newroom =~ s/\s/_/g;
	$newroom =~ s/\W//g;
	$newroom = lc($newroom);

		if($newroom eq ''){
		$newroom = time % 100000;
	}

	unless ((grep(/$newroom/, @rooms)) or (grep(/$newroom/, @mains))) {

		$pathfrom = "$filepath/$oldroom";
		$pathto = "$filepath/$newroom";

		mkdir ("$pathto", 0777);

		opendir(FILES, "$pathfrom");
		@files = readdir (FILES);

		foreach $file (@files){
			next if (-d "$pathfrom/$file");
			next if $file =~ /\.log$/;
			next if $file eq $log or $file eq $list;
			if(-B "$pathfrom/$file"){
				$size = (-s "$pathfrom/$file");
				open(OLD, "$pathfrom/$file");
				binmode(OLD);
				read(OLD,$binfile,$size);
				close (OLD);
				open(NEW, ">$pathto/$file");
				print NEW $binfile;
				close (NEW);
			}else{
				open(OLD, "$pathfrom/$file");
				@page=<OLD>;
				close (OLD);

				for ($i=0; $i<=$#page; $i++){
					$page[$i] =~ s/$oldroom/$newroom/i;
					$ucf_newroom = ucfirst($newroom);
					$page[$i] =~ s/$newroom/$ucf_newroom/ if $file eq $header;
				}

				open(NEW, ">$pathto/$file");
				print NEW @page;
				close (NEW);

				chmod (0777, "$pathto/$file");
			}
		}

	#################Clear some files

		open (MESSAGES,"$filepath/$newroom/$messages");
		@messages = <MESSAGES>;
		$header = shift(@messages);
		chomp($header);
		$header =~ s/Occ.+?<\/sm/<\/sm/;
		$footer = pop(@messages);
		$numlines = $#messages;

		open (RMESSAGES,"$filepath/$newroom/$rmessages");
		@rmessages = <RMESSAGES>;
		$rheader = shift(@rmessages);
		chomp($rheader);
		$rfooter = pop(@rmessages);
		$rfooter =~ s/Occ.+?<\/sm/<\/sm/;

		open (MESSAGES,">$filepath/$newroom/$messages");
		open (RMESSAGES,">$filepath/$newroom/$rmessages");

		print MESSAGES "$header\n";
		print RMESSAGES "$rheader\n";

		for($i=0;$i<=$numlines;$i++){

			print MESSAGES "<br>\n";
			print RMESSAGES "<br>\n";
		}

		print MESSAGES "$footer";
		print RMESSAGES "$rfooter";

		close (MESSAGES);
		close (RMESSAGES);

		open (LOG,">$filepath/$newroom/$log");
		close (LOG);
		chmod(0200, "$filepath/$newroom/$log");

		open (LIST,">$filepath/$newroom/$list");
		close (LIST);
		chmod(0200, "$filepath/$newroom/$list");

########## save creator info

		$creators{$username} = $newroom;
		&save_creators;
	}

########## invite guests

	foreach $chatter (keys(%chatters)){
		if ($FORM{$chatter} eq 'yes'){
			$message = "<small><font color=black><$tag>$FORM{'username'}</$tag> - Join me in <a href=$fileurl/$newroom/ target=\"\_blank\">$newroom</a>.</font></small>";
			$chatters{$chatter}[3] .="$message\t";

			open (NEW, "$filepath/$FORM{'oldroom'}/$messages");
			@lines = <NEW>;
			$header = shift (@lines);
			open (NEW, ">$filepath/$FORM{'oldroom'}/$messages");
			if ($lockon eq 'yes'){flock NEW, 2};
			seek (NEW, 0, 0);
			print NEW "$header";
			print NEW "<script LANGUAGE=Javascript> if (parent.frames[2].nickname == \"$chatter\"){ document\.write(\"You have a private message from $FORM{'username'}. Click [Update] to retrieve.<br>\")\; } </script>\n";
			print NEW @lines;
			print NEW "</body></html>";
			close(NEW);

			open (RNEW, "$filepath/$FORM{'oldroom'}/$rmessages");
			@lines = <RNEW>;
			$footer = pop (@lines);
			open (RNEW, ">$filepath/$FORM{'oldroom'}/$rmessages");
			if ($lockon eq 'yes'){flock RNEW, 2};
			seek (RNEW, 0, 0);
			print RNEW @lines;
			print RNEW "<script LANGUAGE=Javascript> if (parent.frames[2].nickname == \"$chatter\"){ document\.write(\"You have a private message from $FORM{'username'}. Click [Update] to retrieve.<br>\")\; } </script>\n";
			print RNEW "$footer";
			close(RNEW);
		}
	}
	chmod(0600, "$filepath/$FORM{'oldroom'}/$list");
	open (CHATLIST,">$filepath/$FORM{'oldroom'}/$list");
	if ($lockon eq 'yes'){flock CHATLIST, 2};
	seek (CHATLIST, 0, 2);
	foreach $chatter (sort(keys(%chatters))) {
		print CHATLIST "$chatter\t",join("\t", @{$chatters{$chatter}}),"\n";
	}
	close (CHATLIST);
	chmod(0200, "$filepath/$FORM{'oldroom'}/$list");

######### redirect

	print "Location:$fileurl/$newroom/index.html\n\n";
	exit;
}

#############################################
# save creator

sub save_creators {

	chmod(0600, "./$creatorslist");
	open(CREATORS, ">./$creatorslist");
	foreach $key (keys(%creators)){
		print CREATORS "$key\t$creators{$key}\t$FORM{'type'}\n";
	}
	close(CREATORS);
	chmod(0200, "./$creatorslist");
}

#############################################
# return list of private rooms

sub roomlist {
	opendir(ROOMS, "$filepath");
	@files = readdir (ROOMS);

	@subdirs = ();
	foreach $file (@files){
		if ((-d "$filepath/$file") and ($file !~ /\./)){
		push (@subdirs, $file);
		}
	}

	@rooms = ();
	foreach $subdir (@subdirs){
		$found = 0;
		foreach $mainroom (@mains){
			if ($subdir eq $mainroom){$found = 1};
		}
		if ($found == 0){push (@rooms, $subdir)};
	}
}

########################################
# delete room

sub delete_room {
	$roompath = "$filepath/$room";

	opendir(FILES, "$roompath");
	@files = readdir (FILES);

	foreach $file (@files){
		if ($file !~ /\w/){next}
		unlink ("$roompath/$file");
	}

	rmdir ("$roompath");

	foreach $creator (keys (%creators)){
		if ($creators{$creator} eq $room){
			delete ($creators{$creator});
		}
	}
}

#######################################
# get time of last update

sub last_update {
	open (MSGFILE,"$filepath/$room/$messages");
	@stats = stat (MSGFILE);
	close (MSGFILE);
	$lastupdate = time - $stats[9];
}
