#!/usr/local/bin/perl

require "echat41.cgi";

################################################

# nph-sp 4.1
# This script implements server push for e_Chat 4.1.
# Copyright 1999, Mike Bagneski, e_Scripts Software.
# Do not redistribute.

#################################################
# OPTIONS SECTION

# This sets the maximum time in seconds that the script will run.
# The longer it is, the more likely you provider will notice.

$run_time = 60;

# This is how often this script checks for file changes. The larger
# the value, the easier the script will be on your server.

$rate = 5;

# The number of lines that carry over from the previous message list
# on refresh.  If this is too small, users may miss messages.

$overlap = 5;

# This is the number of lines that are pushed to the user's list before
# the page is refreshed.  If this is too long, messages will be written
# below the bottom of the user's page.

$push_lines = 10;

# If set to yes, the script will add horizonal lines above and below
# the pushed lines.  This may avoid confusion during refresh.

$hr = 'no';

################################################
# Get input

if ($ENV{'QUERY_STRING'})
	{$buffer = "$buffer\&$ENV{'QUERY_STRING'}";}
@pairs = split(/&/,$buffer);
foreach $pair (@pairs)
	{($name,$value) = split(/=/,$pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
	$FORM{$name} = $value;}

$filepath .="/$FORM{'room'}/$messages";

################################################
# Screen browser.

$browser = $ENV{'HTTP_USER_AGENT'};
if (($browser !~ /Mozilla\/4/) or ($browser =~ /Opera/)){
	print "HTTP/1.0 302 Go\n";
	print "Location: $fileurl/$FORM{'room'}/$messages\n\n";
	exit;
}

################################################
# Initiate server push process.

select (STDOUT);
$| = 1;
$time = time;
$oldmtime = (-M $filepath);
print "HTTP/1.0 200 OK\n";
print "Pragma: no-cache\n";
print "Content-Type: text/html\n\n";
open(MSGFILE,$filepath);
@lines = <MSGFILE>;
close(MSGFILE);
$top_line = shift(@lines);
$bottom_line = pop(@lines);
$occ_box = $bottom_line;
$occ_box =~ s/^.+?(<table>.+?<\/table>).+?$/$1/i;
@ol_lines = splice(@lines,$#lines-$overlap+1,$overlap);
print "$top_line$occ_box\n";
$last_line = $ol_lines[$#ol_lines];
print "<small>\n";
print @ol_lines;
print "<hr>\n" if $hr eq 'yes';
$i = 0;
$now = time;
while(($i<$push_lines) and ($now-$time < $run_time)) {
	if ((-M $filepath) != $oldmtime) {
		$oldmtime = (-M $filepath);
		open(MSGFILE,$filepath);
		@lines = <MSGFILE>;
		close(MSGFILE);
		$bottom_line = pop(@lines);
		$new_line = pop(@lines);
		@temp = ();
		while(($new_line ne $last_line) and (defined($new_line))) {
			unshift(@temp,$new_line);
			$new_line = pop(@lines);
			$i++;
		}
		if (@temp) {
			print @temp;
			$last_line = pop(@temp);
		}
		print "<script LANGUAGE=\"Javascript\">\n";
		print " window.scrollBy(0,100); \n";
		print " setTimeout('window.scrollBy(0,100)', 100)\n";
		print "</script>\n";
	}else {
		sleep($rate);
	}
$now = time;
}
print "<hr>\n" if $hr eq 'yes';
print "<script LANGUAGE=\"Javascript\">\n";
print "<!--\n";
print " window.location.reload()\n";
print "//-->\n";
print "</script>\n";
print "</small></body></html>\n";
exit;