#!/usr/bin/perl
#
# install_help.cgi
# Part of DCForum2000 Version 1.0 by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
#
# Usage:
#       1) Upload this file to your /cgi-bin/dcforum directory 
#       2) chmod to 755
#       3) run it from your browser
# 
# As part of the installation process, you will be asked
# to accept the terms of this Agreement. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts and DCForum.
# You should carefully read this terms agreement as outlined in
# the readme.txt file included with this distribution before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of the Software.
###################################################################

print "Content-type: text/html\n\n";
print qq~
<html>
<head>
</head>
<body bgcolor="#FFFFFF">
<font size="2" face="courier">
~;

$r_in = parse_form();

unless ($r_in->{'cgidir'}) {
   $r_in->{'cgidir'} = ".";
}
unless ($r_in->{'maindir'}) {
   $r_in->{'maindir'} = "..";
}


print qq~
<h2>DCF2000 Installation Help</h2>
This script (hopefully) will help you determine two
variables which you need to specify
in dcboard.cgi, dcadmin.cgi, and dcforum.setup:
\$cgidir and \$maindir<p>
This script will list the contents of directories that you
specify in the text boxes below.  By default, <p>
&nbsp;&nbsp;&nbsp;\$cgidir = ".";<br>
&nbsp;&nbsp;&nbsp;\$maindir = "..";
<p>
You can specify new directories using the text boxes below.
You should know the following:

<ul>
<li>"." means current directory
<li>".." means previous directory or the directory
    that contains current directory
<li>"/" is a directory separator.  For example, "./dcforum/User_info"
    refers to User_info directory inside the dcforum directory, which is
    inside the current directory.
</ul>

For example, if "." directory contains "dcforum" directory,
you might try "./dcforum" as the new path.  On the other hand, if you want to
list the contents of a directory above the current directory,  you might try "..".
<p>
The search ends when \$cgidir listing shows "User_info" directory and
\$maindir listing shows "Images" (below dcforum) directory.
<hr>
<h2>Contents of \$cgidir = \"$r_in->{'cgidir'}\";</h2>
~;

get_dir($r_in->{'cgidir'});

print qq~
<p>If above listing contains your DCForum's "User_info" directory,<br>
then use,<p>
&nbsp;&nbsp;&nbsp;\$cgidir = "$r_in->{'cgidir'}";
<p>If above listing doesn't contain "User_info" directory<br>
then you need to try another path.  Use ".." to go up the directory tree.<br>
<form method="post">
<input type="text" size="40" name="cgidir" value="$r_in->{'cgidir'}"><p>
<hr>
<h2>Contents of \$maindir = \"$r_in->{'maindir'}\";</h2>
~;


get_dir($r_in->{'maindir'});

print qq~
<p>
If above listing contains the DCForum's "Images" directory, <br>
then use,<p>
&nbsp;&nbsp;&nbsp;\$maindir = "$r_in->{'maindir'}";
<p>If above listing doesn't contain "Images" directory<br>
then you need to try another path.  Use ".." to go up the directory tree.<p>
<input type="text" size="40" name="maindir" value="$r_in->{'maindir'}"><p>

<input type="submit" value="Go!">
</form>
</body>
</html>
~;


sub get_dir {
   my $current_dir = shift;
   if (opendir(D,"$current_dir")) {
	   push(@indent,"&nbsp;","&nbsp;");
      my $indent = join("",@indent);
      while($f = readdir(D)) {
         unless ($f =~ /\./) {
            print "$indent\|---$f (\"$current_dir/$f\")<br>";
         }
      }
      closedir(D);
      pop(@indent);
      pop(@indent);
   }
   else {
      print "Couldn't open $current_dir<br>";
   }

}


#======================================================================#
# parse_form                                                           #
# parses input form data                                               #
#======================================================================#

sub parse_form {

	my $r = {};

	my $request_method, $query_string;
	my @pairs;

	$request_method = $ENV{'REQUEST_METHOD'};

	if ($request_method eq "GET") {
   		$query_string = $ENV{'QUERY_STRING'};
	}
	elsif ($request_method eq "POST") {
   		read(STDIN, $query_string, $ENV{'CONTENT_LENGTH'});
	}
   @pairs = split(/&/, $query_string);
	foreach (@pairs) {
		my ($name, $value) = split/=/;
		$name =~ tr/+/ /;
		$value =~ tr/+/ /;
		$name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		if (defined($r->{$name})) {
			$r->{$name} = join("\0",$r->{$name},$value);
		} else {
			$r->{$name} = $value;
		}
	}

	return $r;

}

