#!/usr/bin/perl
#
# dcboard.cgi
# Part of DCForum2000 Version 1.0 by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of this Agreement. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts and DCForum.
# You should carefully read this terms agreement as outlined in
# the readme.txt file included with this distribution before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of the Software.
###################################################################

# NOTE: You may need to provide full path to each setup files
# Some server require this.
# $cgidir is the directory path to the location of this file.

$cgidir = ".";

#>>>>>>>>>>>>>>> NO NEED TO EDIT ANYTHING BELOW THIS LINE <<<<<<<<
#>>>>>>>>>>>>>>> NO NEED TO EDIT ANYTHING BELOW THIS LINE <<<<<<<<
#>>>>>>>>>>>>>>> NO NEED TO EDIT ANYTHING BELOW THIS LINE <<<<<<<<

require "$cgidir/dcforum.setup";
require "$cgilib/dcforumlib.pl";

# unbuffer output
$| = 1;

# Read-in form data...
ReadParse();
$r_in = \%in;

# Check and make sure admin module is not called
if ($r_in->{'az'} =~ /^admin/) {
   print "Location: $boardurl\n\n";
	exit;
}

if ($r_in->{'archive'}) {
  $database = "arc_" . $database;
}

# initialize some internal variables...
# Need to change this for speed improvement
$r_setup = initialize();

require "$cgilib/global.pl";

# Get current time and date
get_date($r_in);

if ($r_in->{'az'} eq 'list') {
	# create forum_links
	$html_forum_links = forum_links($r_in,$r_setup);
}
else {
	$html_forum_links = qq~
   <table border="0" width="$table_width"><tr><td bgcolor="$bg_color_0">
	&nbsp;</td></tr></table>~;
}

# Now, let's see if the user selected Expanded Mode
$forum_style = get_cookie($thread_style_cookie);
if ($forum_style) {
   $r_setup->{'threaded_main_listing'} = 'on';
}
else {
   $r_setup->{'threaded_main_listing'} = 'off';
}

# If the input forum type is Private, then
# set appropriate file extension and dir
if ($r_setup->{'forum_type'}->{ $forum } eq 'Private') {
   $ext = $privateext;
   $maindir = $privatedir;
}

# If template files exists in $maindir, then use it instead
if ($forum and -e "$maindir/$forum/$template") {
   $templatefile = "$maindir/$r_in->{'forum'}/$template";
}

# OK, before we do anything, let's check the user's session ID
# If it exists then read in user data
$r_in->{'userdata'} = get_session();

# Next readin the team members
$team = get_team_members("$password_file_dir/$team_file_name");

if ($r_in->{'az'} eq '') {
   $r_in->{'az'} = 'lobby';
}
elsif	($r_in->{'az'} eq 'list') {

	if ($r_in->{'archive'} eq '' and 
       $r_setup->{'threaded_main_listing'} eq 'on') {
   	$r_in->{'az'} = 'fully_threaded_list';
	}
	elsif ($r_setup->{'display_caption'} eq 'on') {
   	$r_in->{'az'} = 'caption_list';	
	}
}

# OK, depending on az, do it
# But, first check and see if the forum is shutdown
if (-e "$password_file_dir/forumlock.lock") {
   print_header();
	print_header_end();
   $heading = "Forum is currently offline";
	$sub_heading = "Forum is currently offline for maintainance.  
		Please try again later";
}
elsif (-e "$cgilib/$r_in->{'az'}.pl") {
	require "$cgilib/$r_in->{'az'}.pl";
	my $command = '($heading,$sub_heading,$html_output,$menu_button) = ' 
						. $r_in->{'az'} . '($r_in,$r_setup)';
	eval($command);
}
else {
	print_header();
	print_header_end();
	$heading = "ERROR";
	$sub_heading = "$r_in->{'az'}.pl file can't be found!!!";
	$html_output = "<b>Check and make sure $r_in->{'az'}.pl is in your Lib directory</b>";
}

my %namespace = (
     FORUMLINKS => $html_forum_links,
     MENU => $menu_button,
     TITLE => $heading,
     HEADER => $heading,
     SUBHEADER => $sub_heading,
     HTMLOUTPUT => $html_output
);

# display output
display_output($templatefile,\%namespace);

exit(0);
