#!/usr/bin/perl
#
# dcadmin.cgi
# Part of DCForum2000 Version 1.0 by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of this Agreement. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts and DCForum.
# You should carefully read this terms agreement as outlined in
# the readme.txt file included with this distribution before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of the Software.
###################################################################

# NOTE: You may need to provide full path to each setup files
# Some server require this.
# $cgidir is the directory path to the location of this file.

$cgidir = ".";

#>>>>>>>>> NO NEED TO CHANGE ANYTHING BELOW THIS LINE <<<<<<<<<<<<

require "$cgidir/dcforum.setup";
require "$cgilib/dcforumlib.pl";
require "$cgilib/dcforumlib2.pl";

$| = 1;

ReadParse();
$r_in = \%in;

unless ( $r_in->{'az'} eq 'admin_archive_threads'
        and $r_in->{'az'} eq 'admin_lock_threads'
		  and $r_in->{'az'} eq 'admin_remove_threads'
        and $r_in->{'az'} eq 'admin_unlock_threads'
        and $r_in->{'az'} eq 'admin_remove_messages' ) {
	print_header();
}

# If firsttime running this program, run init.pl
unless (-e "$password_file_dir/init.lock") {
   require "$cgilib/init.pl";
	&init();
	exit;
}

# Get current time and date
get_date($r_in);

# HTTP Header Ends here

$r_in->{'privatedir'} = $privatedir;
$r_in->{'cgidir'} = $cgidir;

$r_in->{'counter'} = $datafile;
$r_in->{'ext'} = $ext;

# Initialize setup variables
$r_setup = initialize();

require "$cgilib/global.pl";

$r_in->{'userdata'} = check_user($r_in,$r_setup);

# Are we working with archives?

if ($r_in->{'archive'}) {
	$database =  "arc_" . $database;
}

if ($r_setup->{'forum_type'}->{ $r_in->{'forum'} } eq 'Private') {
	$ext = $privateext;
	$r_in->{'ext'} = $ext;
	$maindir = $r_in->{'privatedir'};
	$maindir = $maindir;
}

# Check to make sure that user is admin or moderator

unless ($r_in->{'userdata'}->{'Group'} eq 'admin') {

	if ($r_in->{'userdata'}->{'Group'} ne 'moderator') {

	 	my $heading = 'ACCESS DENIED!!!';
		my $sub_heading = '<b>You must be an adminitrator or a moderator to use this program.</b>';
   	my $html_output .= qq~
		<h3 align="center"> [ <a href="$boardurl">Go Back Main</a> ]</h3>
  		~;
      my %namespace =	(
     	   FORUMLINKS => $html_forum_links,
     	   MENU => $menu,
     	   TITLE => $title,
     	   HEADER => $heading,
     	   SUBHEADER => $sub_heading,
     	   HTMLOUTPUT => $html_output
		);
  		display_output($templatefile,\%namespace);
  		exit;

	}
	elsif ($r_in->{'forum'} eq "") {
		# Do nothing
	}
	elsif ($r_in->{'userdata'}->{'Username'} ne

		$r_setup->{'forum_owner'}->{ $r_in->{'forum'} } ) {

	 	my $heading = 'ACCESS DENIED!!!';
  		my $sub_heading = "<b>As a moderator, you only
	  	   have access to the forum(s) that you own.</b>";

   	my %namespace = (
     	   FORUMLINKS => $html_forum_links,
     	  MENU => $menu,
     	  TITLE => $title,
     	  HEADER => $heading,
     	  SUBHEADER => $sub_heading,
     	  HTMLOUTPUT => $html_output
		);

   	display_output($templatefile,\%namespace);
   	exit;

	}

}

if ($r_in->{"forum"}) {
   $forum=$r_in->{"forum"};
}

if ($r_in->{"thread_select"}) {
   $thread_select = $r_in->{'thread_select'};
}

$heading = '';
$sub_heading = '';
$html_menu = main($r_in,$r_setup);

$heading = $forum_title . " Administration";

if ($r_in->{'az'} eq '') {
   $r_in->{'az'} = 'admin_main';
}

if ($r_in->{"az"} eq "admin_remove_randfiles") {
	require "$cgilib/admin_remove_randfiles.pl";
   $html_output = admin_remove_randfiles($password_file_dir);
}
elsif (-e "$cgilib/$r_in->{'az'}.pl") {
	require "$cgilib/$r_in->{'az'}.pl";
	my $command = '$html_output = ' 
						. $r_in->{'az'} . '($r_in,$r_setup)';
	eval($command);
}
else {
	print_header();
	print_header_end();
	$heading = "ERROR";
	$sub_heading = "$r_in->{'az'}.pl file can't be found!!!";
	$html_output = "<b>Check and make sure $r_in->{'az'}.pl is in your Lib directory</b>";
}

print_header_end();

$html_output = qq~
<table border="0" cellspacing="0" cellpadding="3" width="$table_width">
<tr>
   <td valign="top">
   $html_menu
	<br>
	<img src="$imgurl/blank.gif" width="175">
   </td>
   <td valign="top" width="100%">
	<font size="3" face="$font_face_1" 
			color="$font_color_1"><b>
			$heading</b>
	</font>
	<hr>
   $html_output
   </td>
</tr>
</table> 
~;

$heading = '';

my %namespace =	(
   FORUMLINKS => $html_forum_links,
   MENU => '',
   TITLE => $heading,
   HEADER => $heading,
   SUBHEADER => $sub_heading,
   HTMLOUTPUT => $html_output
);

&display_output($templatefile,\%namespace);

exit(0);


###
### subroutine main
### main admin page
###

sub main {

	my ($r_in,$r_setup) = @_;

	my $html_output .= qq~
		<TABLE BORDER="0" cellpadding="2" align="center" width="100%">
		<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_0">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			<B>Menu</U></B></font></TD></TR>
		<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_2">
			<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
			<a href="$boardurl?az=login">Logout</a> |
			<a href="$adminurl">Admin</a> |
			<a href="$boardurl">Lobby</a>
			</font></td></tr>
	~;

	if ($r_in->{'userdata'}->{'Group'} eq "admin") {

		$html_output .= qq~
		<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_0">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			<B>General Administration</U></B></font></TD></TR>
		<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_2">
			<font size="$font_size_2" face="$font_face_2" color="$font_color_2">~;

		if (-e "$password_file_dir/forumlock.lock") {
			$html_output .= qq~
			<a href="$adminurl?az=admin_start">Start DCForum</a>~;
		}
		else {
			$html_output .= qq~
			<a href="$adminurl?az=admin_shutdown">Shutdown DCForum</a>~;		
		}
				
			$html_output .= qq~
			<br><a href="$adminurl?az=admin_forum_attributes">Forum
			Settings</a></font></TD></TR>
	   <TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_0">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
		  	<B>User Administration</B></font></TD></TR>   
      <TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_2">
			<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
	      <a href="$adminurl?az=admin_create_new_account">Create New Account</a><br>
	      <a href="$adminurl?az=admin_user_manager">User Manager</a>
			</font></TD></TR>
      <TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_0">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
	      <B>Conference Manager</B></font></TD></TR>
      <TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_2">
			<font size="$font_size_2" face="$font_face_2" color="$font_color_2"><a
		   href="$adminurl?az=admin_conf_manager&command=c_conf_form">Create New Conference</a>
	      <br><a href="$adminurl?az=admin_conf_manager&command=m_conf_select">Modify Conference</a>
		   <br><a href="$adminurl?az=admin_conf_manager&command=reorder_conf_form">Reorder Conferences</a>
	      <br><a href="$adminurl?az=admin_conf_manager&command=r_conf_select">Remove Conference</a>
		   </font></TD></TR>
      <TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_0">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
	      <B>General Forum Manager</B></font></TD></TR>
      <TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_2">
			<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
		   <a href="$adminurl?az=admin_forum_manager&command=c_forum_form">Create New Forum</a>
			<br><a href="$adminurl?az=admin_forum_manager&command=m_forum_select">Modify Forum</a>
		   <br><a href="$adminurl?az=admin_forum_manager&command=reorder_forum_form">Reorder Forums</a>
	      <br><a href="$adminurl?az=admin_forum_manager&command=r_forum_form">Remove Forum</a>
			</font></TD></TR>~;
		}

		if ($r_in->{'userdata'}->{'Group'} eq "admin" or $r_in->{'userdata'}->{'Group'} eq "moderator" ) {
			$html_output .= qq~
		   <TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_0">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			<B>Private Forum Manager</B></font></TD></TR>
	   	<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_2">
			<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
			<a href="$adminurl?az=admin_private_forum_users">User 
			Manager</a><br></TD></TR>
			~;
		}
		
		$html_output .= qq~
		<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_0">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
		   <B>Board Manager</B></font></TD></TR>
		<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_2">
			<font size="$font_size_2" face="$font_face_2" color="$font_color_2">~;

		$html_output .= qq~
			<a href="$adminurl?az=admin_board_manager&remove_type=admin_queue">Unqueue Messages</a><br>
			<a href="$adminurl?az=admin_board_manager&remove_type=admin_lock_threads">Lock Threads</a><br>
			<a href="$adminurl?az=admin_board_manager&remove_type=admin_unlock_threads">Unlock Threads</a><br>
			<a href="$adminurl?az=admin_board_manager&remove_type=admin_archive_threads">Archive Threads</a><br>
		~;

		if ($r_in->{'userdata'}->{'Group'} eq "admin") {
		   $html_output .= qq~
			<a href="$adminurl?az=admin_board_manager&remove_type=admin_move_threads">Move Threads</a><br>
			~;
		}

	   $html_output .= qq~
		   <a href="$adminurl?az=admin_board_manager&remove_type=admin_remove_threads">Remove Threads</a><br> 
	      <a href="$adminurl?az=admin_board_manager&remove_type=admin_list_messages">Remove Messages</a><br>
			</font></TD></TR>~;

		if ($r_in->{'userdata'}->{'Group'} eq "admin") {
				
	   	$html_output .= qq~
				<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_0">
				<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				<B>Admin Functions</B></font></TD></TR>   
				<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_2">
				<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
				<a href="$adminurl?az=admin_announcement">Announcement Manager</a>
				<br><a href="$adminurl?az=admin_customize_emails">Customize EMails</a>
				<br><a href="$adminurl?az=admin_send_email">Send EMail</a>
				<br><a href="$adminurl?az=admin_send_subscription">Send Subscriptions</a>
				<br><a href="$adminurl"></a>
				</font></td></tr>
				
				<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_0">
				<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				<B>Data Utilities</B></font></TD></TR>   
				<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_2">
				<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
		   	<a href="$adminurl?az=admin_board_manager&remove_type=admin_rebuild_database">Rebuild Database</a>
				<br><a href="$adminurl?az=admin_backup">Backup Forum Files</a>
				<br><a href="$adminurl?az=admin_recover">Recover Forum Files</a>
				</font></td></tr>

				<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_0">
				<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				<B>Misc Utilities</B></font></TD></TR>   
				<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_2">
				<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
         	<a href="$adminurl?az=admin_update_threads">Update Threads</a><br>
         	<a href="$adminurl?az=admin_remove_session_files">Remove Session Files</a><br>
         	<a href="$adminurl?az=admin_remove_session_files&what=all">Remove All Session Files</a><br>
         	<a href="$adminurl?az=admin_remove_randfiles">Remove Temporary Files</a>
				</font></TD></TR>
				~;
		}

   $html_output .= "</table>";

}




####
# quick fix to get members from dcadmin
# Need to fix in our next release
####

sub get_members {

   my ($r_in) = @_;
   my $r_data = readdata("$password_file_dir/$password_file");
   foreach (@$r_data) {
      chomp;
      my $r_entry = [ split(/$split_delim/,$_) ];
      unless ($r_entry->[2] eq 'normal' or $r_entry->[2] eq 'admin') {
         push( @{$r_in->{'user_list'} }, $r_entry->[1]) if 
					($r_entry->[1] ne $r_in->{'userdata'}->{'Username'});
      }

   }#End of foreach

}

#####
# function get_id
#########

sub get_id {

  	my ($datafile) = shift;
  	my $num;

   open(NUMBER,"$datafile");
   flock(NUMBER,2);
      $num = <NUMBER>;
   flock(NUMBER,8);
   close(NUMBER);

	$num++;
	
   open(NUM,">$datafile") || die $!;
   flock(NUMBER,2);
      print NUM "$num";
   flock(NUMBER,8);
   close(NUM);
   
   return $num;
}
