#!/usr/bin/perl
#
# conv_database.cgi
# This conversion file is needed to convert database format
# from DCForum99 Ver 1.000 and 1.001 to Ver 1.002 and 1.1 format
# Use this if you have Ver 1.000 or 1.001
#
# Part of DCForum by DCScripts
# Copyright  1997-1999 DCScripts All Rights Reserved
#
# As part of the installation process, you will be asked
# to accept the terms of this Agreement. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts and DCForum.
# You should carefully read this terms agreement as outlined in
# the readme.txt file included with this distribution before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of the Software.
###################################################################

# NOTE: You may need to provide full path to each setup files
# Some server require this.
# $path is the directory path to the location of this file.

$path = ".";

# If your setup files are named differently, then
# modify lines below

require "$path/dcforum.setup";
require "$path/dcboard.setup";

#>>>>>>>>>>>>>>> NO NEED TO EDIT ANYTHING BELOW THIS LINE <<<<<<<<
require "$cgidir/cgi-lib.pl";
require "$cgidir/dclib.pl";
require "$cgidir/dcforumlib.pl";

$| = 1;

print "Content-type: text/html\n\n";

$r_setup = initialize($password_file_dir,$forum_file,$board_setup_file);

print "<html><head></head><body>\n";

unless (-e "$password_file_dir/$profile_dir") {
	   mkdir("$password_file_dir/$profile_dir",0777) or my_die("can't do that", $!);
}

foreach $forum (@{$r_setup->{'forums'}}) {

	my $data = '';

	print "<h3>Processing $f_dir/$forum</h3>\n";

	if ($r_setup->{'forum_type'}->{ $forum } eq 'Private') {
	   $f_ext = $privateext;
	   $f_dir = $privatedir;
	}
	else {
	   $f_ext = $ext;
	   $f_dir = $maindir;
	}

	# First convert $database

	if (open(F,"$f_dir/$forum/$database")) {
		{
			local $/ = undef;
			$data = <F>;
		}
		close(F);
		$data =~ s/\0/\|/g;
		open(F,">$f_dir/$forum/$database");
			print F $data;
		close(F);
	}
	else {
		my_die("Couldn't open $f_dir/$forum/$database",$!);
		exit(0)
	}

	# First convert $database

	if (open(F,"$f_dir/$forum/arc_$database")) {
		{
			local $/ = undef;
			$data = <F>;
		}
		close(F);
		$data =~ s/\0/\|/g;
		open(F,">$f_dir/$forum/arc_$database");
			print F $data;
		close(F);
	}
	else {
		my_die("Couldn't open $f_dir/$forum/$database",$!);
		exit(0)
	}
	
	print "<h3>Completed processing $f_dir/$forum</h3>\n";
}

print "Done</body></html>";
