#!/usr/bin/perl
#
# convert_98_99.cgi
# DCForum99 Version 1.000
# Used for converting DCForum98 to DCForum99 Ver 1.000
#
# Part of DCForum by DCScripts
# Copyright  1997-1999 DCScripts All Rights Reserved
#
# As part of the installation process, you will be asked
# to accept the terms of this Agreement. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts and DCForum.
# You should carefully read this terms agreement as outlined in
# the readme.txt file included with this distribution before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of the Software.
###################################################################

# NOTE: You may need to provide full path to each setup files
# Some server require this.
# $path is the directory path to the location of this file.

$path = ".";

# If your setup files are named differently, then
# modify lines below

require "$path/dcforum.setup";
require "$path/dcboard.setup";

#>>>>>>>>>>>>>>> NO NEED TO EDIT ANYTHING BELOW THIS LINE <<<<<<<<
require "$cgidir/cgi-lib.pl";
require "$cgidir/dclib.pl";
require "$cgidir/dcforumlib.pl";
require "$cgidir/dcforumlib2.pl";


$| = 1;

print "Content-type: text/html\n\n";

$r_setup = initialize($password_file_dir,$forum_file,$board_setup_file);

print "<html><head></head><body>\n";

unless (-e "$password_file_dir/$profile_dir") {
	   mkdir("$password_file_dir/$profile_dir",0777) or my_die("can't do that", $!);
}

foreach $forum (@{$r_setup->{'forums'}}) {

	print "<h3>Processing $f_dir/$forum</h3>\n";

	if ($r_setup->{'forum_type'}->{ $forum } eq 'Private') {
	   $f_ext = $privateext;
	   $f_dir = $privatedir;
	}
	else {
	   $f_ext = $ext;
	   $f_dir = $maindir;
	}

	unless (-e "$f_dir/$forum/$thread_dir") {
	   mkdir("$f_dir/$forum/$thread_dir",0777) or my_die("can't do that", $!);
	}

	unless (-e "$f_dir/$forum/$email_dir") {
	   mkdir("$f_dir/$forum/$email_dir",0777) or my_die("can't do that", $!);
	}

	@data = ($database,"arc_$database");

	foreach $data (@data) {
		my @out_lines =();
		$r_database = readdata("$f_dir/$forum/$data");
		
		foreach (@{$r_database}) {
		
			chomp;
			$_ =~ s/\0/\|/g;
			my @temp = split /\|/;
			my $filename = "$temp[0]";
			my $r_rows = {};
			if (-e "$f_dir/$forum/$thread_dir/$filename.$f_ext") {
				$r_rows = readdata("$f_dir/$forum/$thread_dir/$filename.$f_ext");
			}
			else {
				$r_rows = readdata("$f_dir/$forum/$filename.$f_ext");
			}
			my @newrow = ();
			my @om=();
			my @level=();
			my @subject=();
			my @name=();
			my @time=();
			my @date=();
			my @email=();
			my @caption=();
			my @text=();
		   my $reply_text = "";
		
			print "<hr><B>Processing $f_dir/$forum/$filename.$ext</B><br>\n";
		
			my $hit	= '';
			my $email_hit	= '';
			foreach $row (@{$r_rows}) {
			   chomp($row);
				if ($row =~ /<!-- HEADER:(.*):(.*) -->/) {
					push(@newrow,"$1\n");
				}
		      elsif ($row =~ /<!-- MESSAGE:(.*):(.*) --><(.*)><(.*)> <a href="#(.*)">(.*)<\/a>, (.*), (.*), (.*), (.*)<(.*)>/) {
		         push(@om,$1);
		         push(@level,$2);
					my $temp_sub = $6;
					$temp_sub =~ s/\|/&pip;/g;
		         push(@subject,$temp_sub);
		         push(@name,$7);
		         push(@time,$8);
					my ($mon,$day,$year) = split(/\//,$9);
					$year += 1900 if ($year < 101);
					my $new_date = join("\/",$mon,$day,$year); 
		         push(@date,$new_date);
		      }
				elsif ($row =~ /<!-- MESSAGE:(.*):(.*) --><(.*)> <a href="#(.*)">(.*)<\/a>, (.*), (.*), (.*)<(.*)>/) {
		         push(@om,$1);
		         push(@level,$2);
					my $temp_sub = $5;
					$temp_sub =~ s/\|/&pip;/g;
		         push(@subject,$temp_sub);
		         push(@name,$6);
		         push(@time,$7);
					my ($mon,$day,$year) = split(/\//,$8);
					$year += 1900 if ($year < 101);
					my $new_date = join("\/",$mon,$day,$year); 
		         push(@date,$new_date);
			   }
				elsif ($row =~ /<a href=\"mailto:(.*)\"><IMG/) {
					$email_hit = "yes";
		         push(@email,$1);
				}
				elsif ($row =~ /<!-- BEGIN_BODY:(.*) -->/) {
		      	$hit = "yes";
				}
				elsif ($row =~ /<!-- END_BODY:(.*) -->/) {
					$hit = "";
					$reply_text =~ s/\r\n/ /g;
					$reply_text =~ s/\n/ /g;
					$reply_text =~ s/\|/&pip;/g;
					$reply_text =~ s/.*<blockquote>(.*)<\/blockquote>.*/$1/i;
					push(@text,$reply_text);
		         push(@email,"") unless ($email_hit);
					$email_hit = '';
					$reply_text =~ s/<([^>]|\n)*>/ /g;
					my $caption_string = substr($reply_text,0,150);
					push(@caption,substr($caption_string,0,150));
				}
				elsif ($hit) {
		      	$reply_text .= $row;
				}
				else {
					next;
				}
		
		   } # End of foreach
			
			my $num = @om;
			for ($j=0;$j<$num;$j++) {
				my $string = "";
				$string = join("\|",$om[$j],$level[$j],$subject[$j],$name[$j],$email[$j],$time[$j],$date[$j],$text[$j]);
				push(@newrow,"$string\n");
				$string = substr($string,0,80);
				$string =~ s/<//g;
				$string =~ s/>//g;
				print "<font size=2>$string</font><br>\n";
			}
		
			writedata("$f_dir/$forum/$thread_dir/$filename.$thread_ext",\@newrow);

			my $final_caption = $caption[0];
			my $sub_caption = join("\0",$subject[0],$final_caption);
			$temp[4] = $sub_caption;
			my $out_string = join("\|",@temp);
			$out_string =~ s/\0/\|/g;

			push(@out_lines,"$out_string\n");

			writedata("$f_dir/$forum/$data",\@out_lines);
			@newrow =();
			@outlines =();

			# added to avoid overwriting existing threads.

			unless (-e "$f_dir/$forum/$thread_dir/$filename.$f_ext") {	
				if (-e "$f_dir/$forum/$filename.$f_ext") {
					rename("$f_dir/$forum/$filename.$f_ext","$f_dir/$forum/$thread_dir/$filename.$f_ext");
				}
			}

#			print "<hr>Finished processing $f_dir/$forum/$filename.$f_ext\n";
#			print "<br>Created $f_dir/$forum/$thread_dir/$filename.$thread_ext\n";
#			print "<br>Moved $f_dir/$forum/$filename.$f_ext to $f_dir/$forum/$thread_dir/$filename.$f_ext<hr>\n";
		
		}
	
	}
	
	print "<h3>Completed processing $f_dir/$forum</h3>\n";
}

	print "Done</body></html>";

