#!/usr/bin/perl
#
# convert_97N_99.cgi
# This utility script converts DCForum97N forum data to
# DCForum99 Ver 1.1 Release 01
#
# Copyright  1997-1999 DCScripts All Rights Reserved
#
# As part of the installation process, you will be asked
# to accept the terms of this Agreement. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts and DCForum.
# You should carefully read this terms agreement as outlined in
# the readme.txt file included with this distribution before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of the Software.
#
###################################################################

# NOTE: You may need to provide full path to each setup files
# Some server require this.
# $path is the directory path to the location of this file.

$path = ".";

# If your setup files are named differently, then
# modify lines below

require "$path/dcforum97.setup";
require "$path/dcadmin97.setup";
require "$path/dcboard97.setup";

#--------Shouldn't have to edit below this line-------------------#

$ext = "html";

# Profiles directory and extension
$profile_dir = "Profiles";
$profile_ext = "pro";

# Email notification extension
$email_ext = "emn";
$email_dir = "EMails";

# Forum Data file directory
# This is where each thread database is
$thread_dir = "Data";
$thread_ext = "txt";

require "$path/cgi-lib.pl";
require "$path/dclib.pl";
require "$path/dcforumlib.pl";
require "$path/dcforumlib2.pl";

#################################################3

$| = 1;

# Send HTTP header
print "Content-type: text/plain\n\n";


# First create forum_info.txt
print "Creating forum_info.txt.....";

open(F,">$auth_user_dir/forum_info.txt");
foreach (@forums) {
   my @temp = ();
   push(@temp, $_, "conference", $forum_name{$_}, $forum_desc{$_},"owner","email","Public","on","Date",0,0);
   $string = join("\|",@temp);
	print F "$string\n";
}
close(F);
chmod(0666,"$auth_user_dir/forum_info.txt");


# next create conf_info.txt
print "Created forum_info.txt\n";
print "Creating conf_info.txt.....";
open(F,">$auth_user_dir/conf_info.txt");
	print F "conference|conference|conference description|on\n";
close(F);
chmod(0666,"$auth_user_dir/conf_info.txt");
print "Created conf_info.txt\n";

# for each forum process each thread...

foreach $forum (@forums) {

	print "Processing $maindir/$forum\n";
   print "==================================\n";
	# First create Data and EMail directory

	unless (-e "$maindir/$forum/$thread_dir") {
	   mkdir("$maindir/$forum/$thread_dir",0777) or my_die("can't do that", $!);
	}

	unless (-e "$maindir/$forum/$email_dir") {
	   mkdir("$maindir/$forum/$email_dir",0777) or my_die("can't do that", $!);
	}


	my @out_lines =();
	if (-e "$maindir/$forum/$thread_dir/$database") {
		$r_database = readdata("$maindir/$forum/$thread_dir/$database");
	}
	else {
		$r_database = readdata("$maindir/$forum/$database");
	}
	
	foreach (@{$r_database}) {
	
		chomp;

		my @temp = split /\|/;
		my $filename = "$temp[0]";
		my $r_rows = {};

		if (-e "$maindir/$forum/$thread_dir/$filename.$ext") {
			$r_rows = readdata("$maindir/$forum/$thread_dir/$filename.$ext");
		}
		else {
			$r_rows = readdata("$maindir/$forum/$filename.$ext");
		}

		my @newrow = ();
		my @om=();
		my @level=();
		my @subject=();
		my @name=();
		my @time=();
		my @date=();
		my @email=();
		my @caption=();
		my @text=();
	   my $reply_text = "";

        print ".........................................\n";
		print "Processing $maindir/$forum/$filename.$ext\n";
        print "\n";

		my $hit	= '';			
		my $email_hit	= '';
		my $body_tag = '';
		
		foreach $row (@{$r_rows}) {
		   chomp($row);

			if ($row =~ /<BODY/i) {
				$body_tag = 'yes';
			}
			
			if ($body_tag) {

				if ($row =~ /<!-- HEADER:(.*):(.*) -->/) {
					push(@newrow,"$1\n");
				}
				elsif ($row =~ /<!-- MESSAGE:(.*):(.*) --><(.*)><(.*)> <a href="#(.*)">(.*)<\/a>, (.*), (.*), (.*)<(.*)>/) {
		         push(@om,$1);
		         push(@level,$2);
				   my $temp_sub = $6;
				   $temp_sub =~ s/\|/&pip;/g;
		         push(@subject,$temp_sub);
		         push(@name,$7);
		         push(@time,$8);
					my ($mon,$day,$year) = split(/\//,$9);
					$year += 1900 if ($year < 101);
					my $new_date = join("\/",$mon,$day,$year); 
		         push(@date,$new_date);
		      }
				elsif ($row =~ /<a href=\"mailto:(.*)\"><IMG .*><\/a>/) {
					$email_hit = "yes";
		         push(@email,$1);
				}
				elsif ($row =~ /<!-- BEGIN_BODY:(.*) -->/) {
		      	$hit = "yes";
				}
				elsif ($row =~ /<!-- END_BODY:(.*) -->/) {
					$hit = "";
					$reply_text =~ s/\r\n/ /g;
					$reply_text =~ s/\n/ /g;
					$reply_text =~ s/\|/&pip;/g;
					$reply_text =~ s/(.*)<blockquote>(.*)<blockquote>(.*)/$2/i;
					$reply_text =~ s/[ ]+/ /g;
					push(@text,$reply_text);
		         push(@email,"") unless ($email_hit);
					$email_hit = '';
					$reply_text =~ s/<([^>]|\n)*>/ /g;
					my $caption_string = substr($reply_text,0,150);
					push(@caption,substr($caption_string,0,150));
				}
				elsif ($hit) {
		      		$reply_text .= $row;
				}
				else {
					next;
				}
				
			} #end of if ($body_tag
		
		} # End of foreach

		if ($#newrow) {
			shift(@newrow);
		}
			 
		my $num = @om;
		for ($j=0;$j<$num;$j++) {
			my $string = "";
			$string = join("\|",$om[$j],$level[$j],$subject[$j],$name[$j],$email[$j],$time[$j],$date[$j],$text[$j]);
			push(@newrow,"$string\n");
			$string = substr($string,0,80);
			$string =~ s/<//g;
			$string =~ s/>//g;
			print "$string\n";
		}
		
      writedata("$maindir/$forum/$thread_dir/$filename.$thread_ext",\@newrow);

		my $final_caption = $caption[0];
		my $sub_caption = join("\|",$subject[0],$final_caption);
		$temp[4] = $sub_caption;
		my $out_string = join("\|",@temp);

		push(@out_lines,"$out_string\n");

	} # foreach r_database

	# added to avoid overwriting existing threads.

	if ($ENV{'QUERY_STRING'} eq 'doit') {

		unless (-e "$maindir/$forum/$thread_dir/$database") {
			rename("$maindir/$forum/$database","$maindir/$forum/$thread_dir/$database");
		}

		writedata("$maindir/$forum/arc_$database","\n");
		writedata("$maindir/$forum/$database",\@out_lines);

		unless (-e "$maindir/$forum/$thread_dir/$filename.$ext") {	
			if (-e "$maindir/$forum/$filename.$ext") {
				rename("$maindir/$forum/$filename.$ext","$maindir/$forum/$thread_dir/$filename.$ext");
			}
		}
	}

	@newrow =();
	@outlines =();

 	print "==================================\n";
	print "Finished processing $maindir/$forum/$filename.$ext\n";
	print "Created $maindir/$forum/$thread_dir/$filename.$thread_ext\n";
	print "Moved $maindir/$forum/$filename.$ext to $maindir/$forum/$thread_dir/$filename.$ext\n";		
	print "Completed processing $maindir/$forum\n";
   print "==================================\n";

}

print "Done</body></html>";

