#!/usr/bin/perl
#
# conv_database_99_00.cgi
# this script converts DCF99 database.txt and arc_database.txt
# to DCF2000 format.  It adds three new fields: filelock status,
# user rating, and number of views
#
# 
# Part of DCForum2000 by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
#
###################################################################

# NOTE: You may need to provide full path to each setup files
# Some server require this.
# $cgidir is the directory path to the location of this file.

$cgidir = ".";


# If your setup files are named differently, then
# modify lines below

require "$cgidir/dcforum.setup";

#>>>>>>>>>>>>>>> NO NEED TO EDIT ANYTHING BELOW THIS LINE <<<<<<<<
require "$cgilib/dcforumlib.pl";

$| = 1;

print "Content-type: text/plain\n\n";

$r_forums = readdata("$password_file_dir/$forum_file");

$dir;

foreach (@$r_forums) {
   chomp;
   my $num = 0;
   my @fields = split /$split_delim/;
   my $forum = $fields[0];
   if ($fields[6] eq 'Private') {
      $dir = $privatedir;
   }
   else {
      $dir = $maindir;
   }
   update_data_99_00("$dir/$forum");
}


#===============================================================
# function total_posts
# Compute total number of posts in a forum
#===============================================================

sub update_data_99_00 {

   my $dir = shift;
   my $r_data = [];
   my $r_arc_data = [];
   my @new_fields;

   if (-e "$dir/$database.tmp") {
      $r_data = readdata("$dir/$database.tmp");
   }
   else {
      $r_data = readdata("$dir/$database");
   }

   foreach (@$r_data) {
      chomp;
      # DCF99 V1.0x uses \0 as delimiter for caption
      s/\0/$split_delim/g;
      my @fields = split /$split_delim/;
      my $replies = pop(@fields);
      push(@fields,'',0,'',$replies);
      my $temp = join("$join_delim",@fields);
      push(@new_fields,"$temp\n");
   }

   unless (-e "$dir/$database.tmp") {
      rename("$dir/$database","$dir/$database.tmp");
      writedata("$dir/$database",\@new_fields);
      print "Processed $dir/$database\n";
   }
   else {
      writedata("$dir/$database",\@new_fields);
      print "Processed $dir/$database\n";
   }

   @new_fields = ();

   if (-e "$dir/arc_$database.tmp") {
      $r_arc_data = readdata("$dir/arc_$database.tmp");
   }
   else {
      $r_arc_data = readdata("$dir/arc_$database");
   }

   foreach (@$r_arc_data) {
      chomp;
      # DCF99 V1.0x uses \0 as delimiter for caption
      s/\0/$split_delim/g;
      my @fields = split /$split_delim/;
      my $replies = pop(@fields);
      push(@fields,'',0,'',$replies);
      my $temp = join("$join_delim",@fields);
      push(@new_fields,"$temp\n");
   }

   unless (-e "$dir/arc_$database.tmp") {
      rename("$dir/arc_$database","$dir/arc_$database.tmp");
      writedata("$dir/arc_$database",\@new_fields);
      print "Processed $dir/arc_$database\n";
   }
   else {
      writedata("$dir/arc_$database",\@new_fields);
      print "Processed $dir/arc_$database\n";
   }

}
