# view_ip.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#
#===================================================================
# view_ip      
# utility for viewing IP address of postings
#===================================================================
sub view_ip {

   my ($r_in,$r_setup) = @_;
	my $ip, $host, @ips, @hosts;
	my $heading, $sub_heading, $menu_button, $html_output;

	$heading = $forum_title;	

	print_header();
	print_header_end();

	# Name is URL encoded
	$r_in->{'name'} = dc_decode($r_in->{'name'});

	if ($r_setup->{'display_ip_address'} eq 'on'
		or $r_in->{'userdata'}->{'Group'} eq 'admin') {

		my ($ip,$r_ips) = select_ips($r_in);

		$sub_heading = "IP and host information for user $r_in->{'name'}";
		$menu_button = create_button("search",$r_in,$r_setup);
	   $html_output = qq~
	      <TABLE BORDER="0" CELLPADDING="4" WIDTH="$table_width" ALIGN="CENTER">
	      <TR>
		      <TD BGCOLOR="$bg_color_2" ALIGN="LEFT" VALIGN="CENTER">
				<font size="3" face="$font_face_2" color="$font_color_2">
			<B>IP address of this message</b>
			</font></TD></TR>~;
		
			if ($ip) {
				$html_output .=qq~
		   	<TR>
	      	<TD BGCOLOR="$bg_color_1" ALIGN="LEFT" VALIGN="CENTER">
				<font size="$font_size_1" face="$font_face_1" color="$font_color_1">
					$ip</font></TD></TR>~;
			}
			else {
				$html_output .=qq~
		   	<TR>
		      <TD BGCOLOR="$bg_color_1" ALIGN="LEFT" VALIGN="CENTER">
				<font size="$font_size_1" face="$font_face_1" color="$font_color_1">
				The IP Address of this message has not been recorded.</font></TD>
				</TR>~;	
			}
	
			$html_output .=qq~
	   	<TR>
	      	<TD BGCOLOR="$bg_color_2" ALIGN="LEFT" VALIGN="CENTER">
				<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
			<B>Other IP information for user $r_in->{'name'}</b>
			</font></TD></TR>~;
	
			if (@$r_ips) {
				my $num_ips = @$r_ips;
				for($j=0;$j<$num_ips;$j++) {
	   			$html_output .= qq~
		   		<TR>
	     			<TD BGCOLOR="$bg_color_1" ALIGN="LEFT" VALIGN="CENTER">
					<font size="$font_size_1" face="$font_face_1" color="$font_color_1">
					$r_ips->[$j]</font></TD>
					</TR>~;	
			}
		}

		else {
	
			$html_output .=qq~
		   <TR>
		     <TD BGCOLOR="$bg_color_1" ALIGN="LEFT" VALIGN="CENTER">
				<font size="$font_size_1" face="$font_face_1" color="$font_color_1">
				There were no other IP address recorded for user $r_in->{'admin'}.</font></TD>
				</TR>~;	
		
		}
		
		if ($r_in->{'userdata'}->{'Group'} eq 'admin') {
 			if ($r_in->{'block_ip'} eq 'yes') {
	 			update_bad_ip_list($r_in);
				$html_output .=qq~
			   <TR>
		   	<TD BGCOLOR="$bg_color_1" ALIGN="LEFT" VALIGN="CENTER">
				<font size="$font_size_1" face="$font_face_1" color="$font_color_1">
				Above IP addresses have been added to the bad IP list.</font></TD>
				</TR>~;
			}
			else {
				$html_output .=qq~
			   <TR>
		   	<TD BGCOLOR="$bg_color_1" ALIGN="LEFT" VALIGN="CENTER">
				<font size="$font_size_1" face="$font_face_1" color="$font_color_1">
				<a href="$boardurl?az=view_ip&forum=$forum&om=$r_in->{'om'}&omm=$r_in->{'omm'}&name=$r_in->{'name'}&block_ip=yes">Click 
				here to add above IP addresses to the bad IP list.</a></font></TD>
				</TR>~;			
			}
		}
		
	   $html_output .= qq~
		</TABLE>~;

	}
	else {
		$sub_heading = 'Listing of IP addresses is disabled.';
		$menu_button = create_button("search",$r_in,$r_setup);
	}
	
   return ($heading, $sub_heading, $html_output,$menu_button);

}

#===================================================================
# select_ips
# Select IP addresses used by specific user
#===================================================================

sub select_ips {
   my $r_in = shift;
	my $r_data = readdata("$password_file_dir/$ipfile");
	foreach (@$r_data) {
		chomp;
		my ($lforum,$om,$omm,$ldate,$ltime,$lname,$subject,$remote_addr) = split /$split_delim/;

		if ($r_in->{'forum'} eq $lforum and
			    $r_in->{'om'} == $om and
				 $r_in->{'omm'} == $omm) {
			$ip = $remote_addr;
		}
		elsif ($r_in->{'name'} eq $lname) {
			push(@ips,$remote_addr);
		}
	}

	# first get rid of duplicate IP's
	my $uniq_ips = unique_array_elements(\@ips);
	return($ip,$uniq_ips);
}

#===================================================================
# update_bad_ip_list
# Updates the bad ip database
#===================================================================

sub update_bad_ip_list {
	my $r_in = shift;
	my @rows;
	my ($ip,$r_ips) = select_ips($r_in);
	my $r_data = readdata("$password_file_dir/$bad_ip_list");
	chomp(@$r_data);
	push(@$r_data,$ip,@$r_ips);
	$r_data = unique_array_elements($r_data);
	foreach (@$r_data) {
		if ($_) {
			push(@rows,"$_\n");
		}
	}
	writedata("$password_file_dir/$bad_ip_list",\@rows);

}


sub unique_array_elements {
	my $r_data = shift; # array reference
	my %seen = ();
	my @uniq = ();
	foreach $item (@$r_data) {
		unless ($seen{$item}) {
			$seen{$item} = 1;
			push(@uniq, $item);
		}
	}
	
	return \@uniq;
}


1;