# user_register.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

sub user_register {

   my ($r_in,$r_setup) = @_; 

   require "$cgilib/dcforumlib2.pl";
   require "$cgilib/auth_lib.pl";
   require "$cgilib/auth_lib_2.pl";

   my $r_local = {};
   my $az_type;
   my $heading, $sub_heading, $html_output;

   $heading = $forum_title . " <br> New user registration form";

   print_header();
   print_header_end();

   if ($r_setup->{'auth_allow_registration'} eq 'off') {
      $sub_heading = "Registration is disabled by the administrator.";
      return ($heading, $sub_heading, $html_output,$menu_button);
   }
   
   $r_local = auth_init($r_in,\@login_fields,\%field_form_type);

   if ($r_in->{'command'} eq 'register') {

      # End of HTTP Header
      print_header_end();
      $heading = "DCForum Registration Result";
      my @required = split(/\,/,$r_in->{'required'}); 

      if ($r_setup->{'auth_register_via_email'} eq 'on') {
         my $session = get_session_id();
         $r_in->{'Password'} = substr($session,3,6);
         $r_in->{'dup_Password'} = substr($session,3,6);
      }

      foreach (@required) {
         unless ($r_in->{$_}) {
            push(@ERROR,$_);
         }
      }
    
      # Check and see if all required fields are completed
  
      if (@ERROR) {
         $sub_heading = "Incomplete Registration Form";
         $html_output .= qq~
         <h4 align="center">
         Some of the required fields have not been provided.<br>
         Please try again.
         </h4>~;
         
         $html_output .= output_form($r_in,$r_local);
      }
      else {

         $username = $r_in->{'Username'};
         $password = $r_in->{'Password'};
         $error = register($r_in,$r_local);

         if ($error) {
            $sub_heading = "$error";
            $html_output = output_form($r_in,$r_local,$r_setup);
         }
         else {

            if ($r_setup->{'auth_notify_admin_on_registration'} eq "on") {
               my $subject = "New user registration";
               my $mail_message = "New user has registered at your site\n";
               $mail_message .= "Here is the registration information\n";

               foreach (@login_fields) {
                  $mail_message .= "$_: $r_in->{$_}\n";
               }

               send_mail($password_file_dir,$r_setup->{'auth_sendmail_path'},
                  $r_setup->{'auth_admin_email_address'},
                  $r_setup->{'auth_admin_email_address'},
                  $subject,$mail_message );
            }

            if ($r_setup->{'auth_register_via_email'} eq "on") {
            
               my $str = "Your username is $username\n";
               $str .= "Your password is $password";

               my $r_mesg = readdata("$password_file_dir/$email_registration_file");
               my $subject = shift(@{$r_mesg});

               my $mail_message = join("",@{$r_mesg});
               $mail_message =~ s/\r//g;
               $mail_message =~ s/USERNAME_PASSWORD/$str/;

               send_mail($password_file_dir, $r_setup->{'auth_sendmail_path'},
               $r_setup->{'auth_admin_email_address'},
               $r_in->{'EMail'},$subject,$mail_message );
   
               $sub_heading .= qq~
                  Your password has been sent to your email.<br>&nbsp;<br>
                  If you do not receive it with in next 24 hours, <br>
                  please contact
                  the site administrator.
                  <br>Thank you.<p>~;
                     
               $html_output .= display_logon($r_in,$r_local);

            }
            elsif ($r_setup->{'auth_activate_user_on_registration'} eq 'on') {
                $sub_heading = "You have been added to Database.<br>&nbsp;<br>
                             You may now login using your username and password.";
                $html_output = display_logon($r_in,$r_local);
            }
            else {
               $sub_heading .= qq~
                <p>
                You have been added to Database.
                <br>However, your account is not active.
                <br>As soon as your account is activated,
                <br>you will be notified via e-mail.  Thank you.<p>~;
           }

         } 

      }
   }
   else {

      $sub_heading = "Complete the following form to register.\n";

      if ($r_setup->{'auth_register_via_email'} eq 'on') {
         $sub_heading .= "<br>Be sure to submit valid email address.\n";
         $sub_heading .= "<br>Your password will sent to your email address.\n";
      }
      
      $r_local->{'form_type'}->{'Status'} = join("$join_delim",
         "hidden","$r_setup->{'auth_activate_user_on_registration'}");

      $r_local->{'form_type'}->{'Group'} = join("$join_delim",
         "select",@group);

      $html_output .= output_form($r_in,$r_local,$r_setup);

   }

   return ($heading, $sub_heading, $html_output,$menu_button);

}

1;
