# user_rating.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# user_rating.pl                                                       #
# utility for users to email each other                                #
#======================================================================#

sub user_rating {

   my ($r_in,$r_setup) = @_;

   require "$cgilib/dcforumlib2.pl";

   $r_in->{'userdata'} = check_user($r_in,$r_setup);

   my $forum = $r_in->{'forum'};
   my $rating = $r_in->{'rating'};
   my $om = $r_in->{'om'};

   # First update the database.txt
   my $r_data = readdata("$maindir/$forum/$database");

   for ($j=0;$j<@{$r_data};$j++) {
      my $row = $r_data->[$j];
      chomp($row);
      my ($num,$date,$ltime,$name,$subject,$caption,$lock,
         $read,$user_rating,$replies)
          = split(/$split_delim/, $row);
      if ($num == $om) {
         $user_rating =~ s/^\s+//g;
         $user_rating =~ s/\s+$//g;
         if ($user_rating) {
            $user_rating .= ",$rating";
         }
         else {
            $user_rating .= "$rating";
         }
         $r_data->[$j] = join("$join_delim",$num,$date,$ltime,
            $name,$subject,$caption,$lock,
               $read,$user_rating,$replies);
         $r_data->[$j] .= "\n";

         # Now update $rating to update #.txt
         $rating = $user_rating;

         last;
      }
   }     
   writedata("$maindir/$forum/$database",$r_data);

   # Next update the thread in Data.txt
   $r_data = []; # Flush $r_data
   $r_data = readdata("$maindir/$forum/Data/$r_in->{'om'}.txt");

   my $first_line, $lock, $next_file_num, $num_read, $dum;
   $first_line = shift @{$r_data};
   chomp($first_line);

   # following unless statement is needed for
   # backward compatibility
   unless ($first_line =~ /\|/) {
      $next_file_num = $first_line;
      $lock = '';
      $num_read = 0;
   }
   else {
      ($next_file_num,$lock,$dum,$num_read) = split( /$split_delim/,$first_line);
   }

   $first_line = join("$join_delim",$next_file_num,$lock,$rating,$num_read);
   unshift(@{$r_data},"$first_line\n");
   writedata("$maindir/$forum/Data/$r_in->{'om'}.txt",$r_data);

   print "Location: $boardurl?az=list&forum=$forum\n\n";

}

1;