# user_profiles.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# function user_profiles
# Menu for users
# Allow users to change password, profile, and account info
#======================================================================#

sub user_profiles {

   my ($r_in,$r_setup) = @_;
   require "$cgilib/dcforumlib2.pl";
   my $heading = $forum_title;
   my $menu_button = create_button("user_menu",$r_in,$r_setup);
   print_header();

   $r_in->{'userdata'} = check_user($r_in,$r_setup);

   print_header_end();  

   # Make sure no remote posting 
   unless ($ENV{'HTTP_REFERER'} =~ /$cgiurl/i or
      $ENV{'HTTP_REFERER'} =~ /$mainurl/i) {
      ($heading,$sub_heading,$html_output) = 
      access_error('remote posting',$r_in,$r_setup);
      return ($heading, $sub_heading, $html_output,$menu_button);
   }
   elsif ($r_in->{'command'} eq 'show_profile') {
      $heading = "Profile information of username $r_in->{'user'}";
      $sub_heading = "";
      $html_output = show_profile($r_in,$r_setup);
      unless ($html_output) {
         $sub_heading = "<b><font size=3>No Such User Profile</font></b>";
         $html_output = "";
      }
   
      return ($heading, $sub_heading, $html_output,$menu_button);
   }

   if ($r_in->{'user'}) {
   
      $sub_heading = "Profile information of username $r_in->{'user'}";
      $html_output = show_profile($r_in,$r_setup);
      unless ($html_output) {
         $sub_heading = "<b><font size=3>No Such User Profile</font></b>";
         $html_output = "";
      }
   

   }
   else {

      my @profiles;
      opendir(D,"$profile_dir") or my_die("Can't open $profile_dir",$!);
      while($file = readdir(D)) {
         my ($f_name,$f_ext) = split(/\./,$file);
         push(@profiles,$f_name) if ($f_ext eq $profile_ext);
      }
      closedir(D);

      $sub_heading = "Click on a username to view his/her profile";

      $html_output .= qq~
         <table border="0"  width="300"  cellpadding="3">~;

      my $ordered_list = {};
      foreach (sort @profiles) {
         my $order_index = lc(substr($_,0,1));
         push(@{$ordered_list{$order_index}},$_);
      }
      $html_output .= qq~
      <tr>
      <td valign="top" bgcolor="$bg_color_3" colspan="2">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      ~;
      my $hit = '';
      foreach $key (sort keys %ordered_list) {
         my $this = uc($key);
         if (@{$ordered_list{$key}}) {
            $hit = 'yes';
            $html_output .= qq~
            <b>$this</b>
            <ul>
            ~;
            foreach (@{$ordered_list{$key}}) {
               $html_output .= qq~        
               <li><a href="$boardurl?az=user_profiles&user=$_">$_</a>
               ~;
            }
            
            $html_output .= qq~        
            </ul>
            ~;
         }

      }
      $html_output .= "<b>No User Profiles</b>" unless ($hit);
      $html_ouput .= "</font></td></tr>\n";
      $html_output .= "</table>\n";
   }
   
   return ($heading, $sub_heading, $html_output,$menu_button);

   
}  


sub show_profile {

   my $r_in = shift;

   # Get user profile
   if (-e "$profile_dir/$r_in->{'user'}.$profile_ext") {
      $r_in->{'userdata'} = get_userdata("$profile_dir/$r_in->{'user'}.$profile_ext");
   }
   else {
      return 0;
   }

   my $output .= qq~
      <table border="0">
   ~;
   
   foreach $profile_field (@profile_fields) {
      unless ($profile_field eq "Signature" or $profile_field eq "EMail") {
         $output .= qq~
         <TR BGCOLOR="$bg_color_3">
         <TH ALIGN="Right" VALIGN="TOP">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         $profile_field</font></TH>
         <td ALIGN="LEFT"><font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         $r_in->{'userdata'}->{$profile_field}</font>&nbsp;
         </td></tr>~;
      }
   }
      
  $output .= qq~
  </table>
   ~;

   return $output;
}

#======================================================================#
# function forum_subscription
# Displays the user options
#======================================================================#

sub forum_subscription {

   my ($r_in,$r_setup) = @_;
   my $heading = "DCForum User Menu";
   my $sub_heading = "Subscribe to forums.";
   my $html_output;

   if ($r_in->{'sub_command'}) {
      $r_in->{'forum_id'} =~ s/\0/,/g;
      update_subscription($r_in->{'userdata'}->{'Username'},$r_in->{'forum_id'});
      $sub_heading = "Your subscription list has been updated.";
   }
   else {
   
      my $forum_list = get_user_subscription($r_in->{'userdata'}->{'Username'});
      $html_output .= qq~
      <form action="$boardurl" method="post">
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="command" value="$r_in->{'command'}">
      <input type="hidden" name="sub_command" value="save">
      <table border="0" cellspacing="2" cellpadding="3">
         <tr bgcolor="$bg_color_3"><th align="left" colspan="2">
            <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
             Check forums you want to subscribe to:</font></th></tr>
         <tr bgcolor="$bg_color_0">
            <th align="left">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
             Select</font></th>
            <th align="left">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
             Forum name</font></th>
             </tr>
         ~;
         
      foreach (@{$r_setup->{'forums'}}) {
         unless ($r_setup->{'forum_type'}->{$_} eq 'Private') {
            $html_output .= qq~
            <tr bgcolor="$bg_color_3"><th align="right" valign="top">
               <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
               ~;
   
               if (subscribed($_,$forum_list)) {
                  $html_output .= qq~
                  <input type="checkbox" name="forum_id" value="$_" checked></font></td>~;
               }
               else {
                  $html_output .= qq~
                  <input type="checkbox" name="forum_id" value="$_"></font></td>~;
               }
   
               $html_output .= qq~
               <TD ALIGN="LEFT">
               <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
               <b>$r_setup->{'forum_name'}->{$_}</b><br> 
               $r_setup->{'forum_desc'}->{$_}
               </font>
               </TD></TR>~;
         }
      }
   
         $html_output .= qq~
            
            <tr bgcolor="$bg_color_3"><th align="Right">
            <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
             </font></td>
            <TH ALIGN="LEFT">
            <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
            </font>
            </TH></TR>
         
      <TR BGCOLOR="$bg_color_3">
        <td align="left">&nbsp;</td>
        <td align="left">
        <input type="submit" value="Submit">
        <input type="reset" value="Reset"></td></tr>
      </table>
      </form>~;

   }
   
   return ($heading, $sub_heading, $html_output);

}

#======================================================================#
# function get_user_subscription
# Returns forums that user subscribed to
#======================================================================#

sub get_user_subscription {
   my $user = shift;
   my $r_data = readdata("$password_file_dir/$subscription_list");
   foreach (@{$r_data}) {
      chomp;
      my ($user_id, $subscribed_forums) = split /$split_delim/;
      if ($user_id eq $user) {
         return $subscribed_forums;
      }
   }
   
   return 0;
}

#======================================================================#
# function subscribed
# returns 1 if user is subscribed to $forum
#======================================================================#
   
sub subscribed {
   my ($forum,$forum_list) = @_;
   my @forums = split(/\,/,$forum_list);
   foreach (@forums) {
      if ($_ eq $forum) {
         return 1;
      }
   }  
   return 0;
}

#======================================================================#
# function update_subscription
# Updates the subscription list
#======================================================================#

sub update_subscription {
   my ($user,$forum_list) = @_;
   my $user_exists = '';
   my $r_data = readdata("$password_file_dir/$subscription_list");
   for ($j=0;$j<@{$r_data};$j++) {
      my $line = $r_data->[$j];
      chomp $line;
      my ($user_id, $subscribed_forums) = split(/$split_delim/,$line);
      if ($user_id eq $user) {
         $user_exists = 'yes';
         $r_data->[$j] = "$user\|$forum_list\n";
         last;
      }
   }
   unless ($user_exists) {
      push(@{$r_data},"$user\|$forum_list\n");
   }

   writedata("$password_file_dir/$subscription_list",$r_data);
   
   return 0;
}

1;