# user.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# function user
# Menu for users
# Allow users to change password, profile, and account info
#======================================================================#

sub user {

   my ($r_in,$r_setup) = @_;

   require "$cgilib/dcforumlib2.pl";

   my $menu_button = create_button("user_menu",$r_in,$r_setup);
   print_header();

   $r_in->{'userdata'} = check_user($r_in,$r_setup);

   print_header_end();  

   # Make sure no remote posting 
   unless ($ENV{'HTTP_REFERER'} =~ /$cgiurl/i or
      $ENV{'HTTP_REFERER'} =~ /$mainurl/i) {
      ($heading,$sub_heading,$html_output) = 
      access_error('remote posting',$r_in,$r_setup);
   }
   elsif ($r_in->{'command'} eq 'show_profile') {
      $heading = "Profile information of username $r_in->{'user'}";
      $sub_heading = "";
      $html_output = show_profile($r_in,$r_setup);
      unless ($html_output) {
         $sub_heading = "<b><font size=3>No Such User Profile</font></b>";
         $html_output = "";
      }
   
   }
   elsif ($r_in->{'command'} eq 'change_password') {  
      ($heading,$sub_heading,$html_output) = change_password($r_in,$r_setup);
   }
   elsif ($r_in->{'command'} eq 'change_profile') {
      ($heading,$sub_heading,$html_output) = change_profile($r_in,$r_setup);
   }
   elsif ($r_in->{'command'} eq 'change_account_info') {
      ($heading,$sub_heading,$html_output) = change_account_info($r_in,$r_setup);
   }
   elsif ($r_in->{'command'} eq 'forum_subscription') {
      ($heading,$sub_heading,$html_output) = forum_subscription($r_in,$r_setup);
   }
   else {
      $heading = "DCForum User Menu";
      $sub_heading = "Please choose from the following options";
      $html_output = main_form($r_in,$r_setup);
   }
   
   return ($heading, $sub_heading, $html_output,$menu_button);

   
}  

#======================================================================#
# function main_form
# Displays the main form for users to choose options
#======================================================================#

sub main_form {

   my ($r_in,$r_setup) = @_;
   my $html_output;
   
   $html_output .= qq~
   <form action="$boardurl" method="post">
   <input type="hidden" name="az" value="$r_in->{'az'}">
   <table border="0" cellspacing="2" cellpadding="3">
   ~;

   if ($r_setup->{'auth_allow_password_mod'} eq 'on') {
      $html_output .= qq~
      <TR BGCOLOR="$bg_color_3"><td ALIGN="Right">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
          <input type="radio" name="command" value="change_password"></font></td>
         <TH ALIGN="LEFT">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         Change your password</font></TH></TR>~;
   }

   if ($r_setup->{'auth_allow_account_mod'} eq 'on') {
      $html_output .= qq~
      <TR BGCOLOR="$bg_color_3"><td ALIGN="Right">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
          <input type="radio" name="command" value="change_account_info"></font></td>
         <TH ALIGN="LEFT">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         Modify your account information</font></TH></TR>~;
   }

   $html_output .= qq~  
   <TR BGCOLOR="$bg_color_3"><td ALIGN="Right">
      <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
       <input type="radio" name="command" value="change_profile"></font></td>
      <TH ALIGN="LEFT">
      <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Modify your member profile</font></TH></TR>~;

   if ($r_setup->{'subscription'} eq 'on') {
      
      $html_output .= qq~  
      <TR BGCOLOR="$bg_color_3"><td ALIGN="Right">
      <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
       <input type="radio" name="command" value="forum_subscription"></font></td>
      <TH ALIGN="LEFT">
      <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Subscribe to forums</font></TH></TR>~;
   }
   
      $html_output .= qq~  
      <TR BGCOLOR="$bg_color_3">
      <td align="left">&nbsp;</td>
      <td align="left">
      <input type="submit" value="Submit">
      <input type="reset" value="Reset"></td></tr>
      </table></form>~;

   $html_output;

}

#======================================================================#
# function change_account_info
# Allow users to change their account information
#======================================================================#

sub change_account_info {

   my ($r_in,$r_setup) = @_;
   my $r_local = {};
   my $heading = "DCForum User Menu";

   if ($r_in->{'subcommand'} eq 'save') {

      # auth_lib.pl is required to initialize some variables
      require "$cgilib/auth_lib.pl";
      require "$cgilib/auth_lib_2.pl";
      $r_local = auth_init($r_in,\@login_fields,\%field_form_type);

      get_login_data("$password_file_dir/$password_file",
         $r_in->{'userdata'}->{'Username'},$r_local);

      foreach (@{$r_local->{'fields'}}) {
         unless ($r_in->{$_}) {
            $r_in->{$_} = $r_local->{'login_info'}->{$_};
         }
      }

      # Following three lines are required for using update_user
      $r_in->{'dup_Password'} = $r_in->{'Password'};
      $r_in->{'no_crypt'} = 'YES';
      $r_in->{'Username'} = $r_in->{'userdata'}->{'Username'};
      
      $error = update_user($r_in,$r_local);

      # Next we must update the sessions file

      my @temp_array;
      unless($error) {

         foreach (@{$r_local->{'fields'}}) {
            unless ($_ eq "Password") {
               my $temp_string = join ("::",$_,$r_in->{$_});
               push(@temp_array,"$temp_string\n");
            }
         }

         my $access = "Forums::";
         foreach $forum (@{$r_setup->{'forums'}}) {
            if ($r_setup->{'forum_type'}->{$forum} eq 'Private') {
               if (-e "$password_file_dir/$forum.$priv_user_ext") {
                  $r_members = readdata("$password_file_dir/$forum.$priv_user_ext");
               }
               foreach (@{$r_members}) {
                  chomp;
                  if ($r_in->{'Username'} eq $_) {
                     $access .= "$forum,";
                     last;
                  }
               }
            }
         } # End of $forum..etc

         chop($access) if ($access =~ /\,$/);
         push(@temp_array,"$access\n");

         # Write infomation back to the session file
         writedata("$sessiondir/$session.session",\@temp_array);

         # Now update profile
         foreach (@{$r_local->{'fields'}}) {
            unless ($_ eq "Password") {
               my $temp_string = join ("::",$_,$r_in->{$_});
               push(@temp_array,"$temp_string\n");
            }
         }


         chop($access) if ($access =~ /\,$/);
         push(@temp_array,"$access\n");

         # Write infomation back to the session file
         writedata("$sessiondir/$session.session",\@temp_array);

         # Now prepare data to write to the profile file       
         unless (-e "$profile_dir/$r_in->{'userdata'}->{'Username'}.$profile_ext") {
            foreach (keys %{$r_in->{'userdata'}}) {
               unless ($_ eq 'Password' or $_ eq 'Username' 
                     or $_ eq 'Group' or $_ eq 'Status' ) {
                  my $line = join("::",$_,$r_in->{'userdata'}->{$_});
                  push(@lines,"$line\n");
               }
            }
            writedata("$profile_dir/$r_in->{'Username'}.$profile_ext",\@lines);
         }
      
         $r_in->{'userdata'} = get_userdata("$profile_dir/$r_in->{'Username'}.$profile_ext");

         my @lines;
         foreach $p_field (@profile_fields) {
            my $hit = '';
            foreach (@login_fields) {
               if ($p_field eq $_) {
                  $hit = 'yes';
               }
            }
            if ($hit) {
               my $line = join("::",$p_field,$r_in->{$p_field});
               push(@lines,"$line\n");
            }
            else {
               my $line = join("::",$p_field,$r_in->{'userdata'}->{$p_field});
               push(@lines,"$line\n");
            }
            
         }
         
         # Write to the profile file   
         writedata("$profile_dir/$r_in->{'Username'}.$profile_ext",\@lines);

         $sub_heading = qq~
         <b>
         Your account information has been updated.</b><br>~;
         $html_output = main_form($r_in,$r_setup);

      }
      else {
         $sub_heading = "<b><font size=3>ERROR: Account modification error<br>
            Your account has not been modified!!! 
            <p> Reason: $error</font></b>\n";
         $html_output .= change_account_form($r_in);
      }

   }
   else {
      $sub_heading = "<b>Modify your account information</b>";
      $html_output .= change_account_form($r_in);
   }

   return ($heading,$sub_heading,$html_output);

}

#======================================================================#
# function change_account_form
# form for changing user account information
#======================================================================#

sub change_account_form {

   my $r_in = shift;

   my $r_local = {};
   require "$cgilib/auth_lib.pl";
   $r_local = auth_init($r_in,\@login_fields,\%field_form_type);

   my $html_output;

   my $output .= qq~
      <form action="$boardurl" method="post">
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="command" value="$r_in->{'command'}">
      <input type="hidden" name="subcommand" value="save">
      <table border="0">
      ~;

   foreach (keys %{$r_local->{'login_info'}} ) {
      unless ($_ eq 'Username' or $_ eq 'Password' 
         or $_ eq 'Group' or $_ eq 'Status') {
         if ($_ eq "EMail") {
            my $temp = remove_antispam($r_in->{'userdata'}->{$_});
               $output .= qq~
               <TR BGCOLOR="$bg_color_3">
                  <TH ALIGN="Right">
                  <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
                  $_</font></TH><td ALIGN="LEFT">
                  <input type="text" size="40" name="$_" value="$temp">
                  ~;
         }
         else {
            my $temp = $r_local->{'login_info'}->{$_};
            my $temp = $r_in->{'userdata'}->{$_};
               $output .= qq~
               <TR BGCOLOR="$bg_color_3">
                  <TH ALIGN="Right">
                  <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
                  $_</font></TH><td ALIGN="LEFT">
                  <input type="text" size="40" name="$_" value="$temp">
                  ~;
         }
      }
    }

   
  $output .= qq~
      </td></tr>
      <tr><th>&nbsp;</th>
        <td><input type="submit" value="Submit">
          <input type="reset" value="Reset"></td></tr>
      </table></form>~;

   return $output;
}

#======================================================================#
# function change_password
# form for changing user password
#======================================================================#

sub change_password {

   my ($r_in,$r_setup) = @_;

   my $heading = "DCForum User Menu";

   my $r_local = {};
   my $r_login_fields = \@login_fields;
   my $r_form_type = \%field_form_type;

   # auth_lib.pl is required to initialize some variables
   require "$cgilib/auth_lib.pl";
   require "$cgilib/auth_lib_2.pl";
   $r_local = auth_init($r_in,$r_login_fields,$r_form_type);

   if ($r_in->{'subcommand'} eq 'save') {

      get_login_data("$password_file_dir/$password_file",
         $r_in->{'userdata'}->{'Username'},$r_local);

      my $test = my_crypt ($r_in->{'Old_Password'},
         $r_local->{'login_info'}->{'Password'});

      unless ($test eq $r_local->{'login_info'}->{'Password'}) {
         my $heading = "ERROR: Password change result";
         my $sub_heading = "<b><font size=3>Your password has not been changed!!! 
            <p> Reason: The old password you submitted is incorrect.</font></b>\n";
         $html_output .= change_password_form($r_in);
         return ($heading,$sub_heading,$html_output);
      }

      $r_in->{'Password'} = $r_in->{'New_Password'};
      $r_in->{'dup_Password'} = $r_in->{'dup_New_Password'};

      foreach (@{$r_local->{'fields'}}) {
         unless($_ eq 'Password') {
            $r_in->{$_} = $r_local->{'login_info'}->{$_};
         }
      }

      $r_in->{'Username'} = $r_in->{'userdata'}->{'Username'};

      $error = update_user($r_in,$r_local);

      unless($error) {
         if (-e "$sessiondir/$session.session") {
            unlink("$sessiondir/$session.session");
         }

         $heading = "DCForum Login Window";
         $sub_heading = "Your password has been changed.<br>\n";
         $sub_heading .= qq~
           Please do not forget them. Please <br>
           login again with your new password.~;

          # Send Email to user...

         if ($r_setup->{'auth_notice_user_on_activation'} eq 'on') {
             my $subject = "DCForum User Account Activity Information";
             my $mail_message = "You just modified your password\n";
             $mail_message .= "Your username is $r_in->{'userdata'}->{'Username'}\n";
             $mail_message .= "Your new password is $r_in->{'New_Password'}\n";
             $mail_message .= "Please do not forget your password\n";
   
             send_mail($datadir, $r_setup->{'auth_sendmail_path'},
               $r_setup->{'auth_admin_email_address'},
               $r_in->{'EMail'},$subject,$mail_message );
         }
         
         $r_in->{'command'} = '';
         $html_output .= display_logon($r_in,$r_setup);

      }
      else {
         $sub_heading = "<b><font size=3>ERROR: Password change result<br>
               Your password has not been changed!!! 
            <p> Reason: $error</font></b>\n";
         $html_output .= change_password_form($r_in);
      }

   }
   else {
      $sub_heading = "Change your password";
      $html_output .= change_password_form($r_in);
   }

   return ($heading,$sub_heading,$html_output);

}

#======================================================================#
# function change_password_form
# form for changing user password
#======================================================================#

sub change_password_form {

   my $r_in = shift;

   my $output .= qq~
      <form action="$boardurl" method="post">
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="command" value="$r_in->{'command'}">
      <input type="hidden" name="subcommand" value="save">
      <table border="0">
      <TR BGCOLOR="$bg_color_3">
         <TH ALIGN="Right">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         Old Password</font></TH>
         <td ALIGN="LEFT">
            <input type="password" name="Old_Password" size="40"></td>
      </TR>
      <TR BGCOLOR="$bg_color_3">
         <TH ALIGN="Right">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         New Password
         </font></TH>
         <td ALIGN="LEFT">
            <input type="password" name="New_Password" size="40"></td>
      </TR>
      <TR BGCOLOR="$bg_color_3">
         <TH ALIGN="Right">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         New Password Again
         </font></TH>
         <td ALIGN="LEFT">
            <input type="password" name="dup_New_Password" size="40"></td>
      </TR>
      <TR BGCOLOR="$bg_color_3">
      <td align="left">&nbsp;</td>
      <td align="left">
      <input type="submit" value="Submit">
      <input type="reset" value="Reset"></td></tr>
      </table></form>
     ~;

   $output;

}

#======================================================================#
# function change_profile
# form for changing user account information
#======================================================================#

sub change_profile {

   my ($r_in,$r_setup) = @_;
   my $html_output;

   
   my $heading = "DCForum User Profile Manager";

   if ($r_in->{'subcommand'} eq 'save') {

      # Profiles directory and extension

      $html_output = main_form($r_in,$r_setup);
   
      $html_output .= qq~
         <table border="0">
      ~;
   
      my $ext = $profile_ext;

      foreach (@profile_fields) {
         $r_in->{$_} =~ s/\n\n/<p>/ig;
         $r_in->{$_} =~ s/\r\n/<br>/ig;
         $r_in->{$_} =~ s/\n/<br>/ig;
         unless ($_ eq 'Password' or $_ eq 'Username' 
               or $_ eq 'Group' or $_ eq 'Status' ) {
            my $line = join("::",$_,$r_in->{$_});
            push(@lines,"$line\n");
            $html_output .= qq~
            <TR BGCOLOR="$bg_color_3">
               <TH ALIGN="Right" VALIGN="TOP">
               <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
               $_</font></TH>
               <td ALIGN="LEFT"><font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
               $r_in->{$_}</font>&nbsp;
               </td></tr>~;
         }
      }
        $html_output .= qq~
        </table>
      ~;

      writedata("$profile_dir/$r_in->{'userdata'}->{'Username'}.$profile_ext",\@lines);
      $sub_heading = "<b>You profile has been changed</b>";

   }
   else {
      $sub_heading = "Change your user profile information";
      $html_output .= change_profile_form($r_in);
   }

   return ($heading,$sub_heading,$html_output);

}

#======================================================================#
# function change_profile_form
# Change profile form
#======================================================================#

sub change_profile_form {

   my $r_in = shift;

   unless (-e "$profile_dir/$r_in->{'userdata'}->{'Username'}.$profile_ext") {
      foreach (keys %{$r_in->{'userdata'}}) {
         unless ($_ eq 'Password' or $_ eq 'Username' 
               or $_ eq 'Group' or $_ eq 'Status' ) {
            my $line = join("::",$_,$r_in->{'userdata'}->{$_});
            push(@lines,"$line\n");
         }
      }
      writedata("$profile_dir/$r_in->{'userdata'}->{'Username'}.$profile_ext",\@lines);
   }

   $r_in->{'userdata'} = get_userdata("$profile_dir/$r_in->{'userdata'}->{'Username'}.$profile_ext");
   my $output .= qq~
      <form action="$boardurl" method="post">
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="command" value="$r_in->{'command'}">
      <input type="hidden" name="subcommand" value="save">
      <table border="0" cellpadding="3">
        <tr>
        <td colspan="2" bgcolor="$bg_color_3">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         Fields denoted with <font color="#FF0000">*</font> cannot be changed
         using this profile form.
         </font>
        </td>
        </tr>
   ~;
   
   foreach $profile_field (@profile_fields) {

      my $do_not_change = '';

      $r_in->{'userdata'}->{$profile_field} =~ s/<p>/\n\n/ig;
      $r_in->{'userdata'}->{$profile_field} =~ s/<br>/\n/ig;

      $output .= qq~
      <TR BGCOLOR="$bg_color_3">
         <TH ALIGN="Right" Valign="top">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         $profile_field</font></TH>
         <td ALIGN="LEFT">~;

      foreach (@login_fields) {
         if ($profile_field eq $_) {
            $do_not_change = "on";
         }
      }
      
      my @fields = split(/$split_delim/,$profile_form_type{$profile_field});
      my $required = pop(@fields);

      unless ($do_not_change) {
   
         if ($required eq "required") {
            if (defined $temp{'required'}) {
               $temp{'required'} = join("\,",$temp{'required'},$field);
            }
            else {
               $temp{'required'} = $field;
            }
         }
         else {
             push(@fields,$required);
             $suffix = ":";
         }
   
         if ($fields[0] eq "text") {
             $output .= qq~
              <input type="$fields[0]" name="$profile_field"
               size="$fields[1]" value="$r_in->{'userdata'}->{$profile_field}">
            ~;
         }
         elsif ($fields[0] eq "hidden") {
            $output .= qq~
             <input type="$fields[0]" name="$profile_field" value="$fields[1]">
           ~;
         }
         elsif ($fields[0] eq "radio" || $fields[0] eq "checkbox") {
   
            $output .= qq~
              $field$suffix
              ~;
            my $type = $fields[0];
            shift(@fields);
            foreach (@fields) {
               if ($_ eq $r_in->{'userdata'}->{$profile_field}) {
                  $output .= qq~
                  <input type="$type" name="$profile_field" value="$_" checked>$_
                  ~;
               }
               else {
                  $output .= qq~
                  <input type="$type" name="$profile_field" value="$_" >$_
                  ~;
               }
            }
   
         }
         elsif ($fields[0] eq "textarea") {
            $output .= qq~
             <textarea name="$profile_field" rows="$fields[1]" 
             cols="$fields[2]" wrap="physical">$r_in->{'userdata'}->{$profile_field}</textarea>
            ~;
         }
      }
      # Ok, do not change this parameter
      else {
            $output .= qq~
             <input type="hidden" name="$profile_field" 
             value="$r_in->{'userdata'}->{$profile_field}">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         $r_in->{'userdata'}->{$profile_field} <font color="#FF0000">*</font>
         </font>  ~;
         
      }
  }

  $output .= qq~
      </td></tr>
      <tr><th>&nbsp;<input type="hidden" 
         name="required" value="$temp{'required'}"></th>
         <td><input type="submit" value="Submit Registration">
          <input type="reset" value="Reset"></td></tr></table></form>
      ~;

}

#======================================================================#
# function show_profile
# display user profile
#======================================================================#

sub show_profile {

   my $r_in = shift;

   # Get user profile
   if (-e "$profile_dir/$r_in->{'user'}.$profile_ext") {
      $r_in->{'userdata'} = get_userdata("$profile_dir/$r_in->{'user'}.$profile_ext");
   }
   else {
      return 0;
   }

   my $output .= qq~
      <table border="0">
   ~;
   
   foreach $profile_field (@profile_fields) {
      unless ($profile_field eq "Signature" or $profile_field eq "EMail") {
         $output .= qq~
         <TR BGCOLOR="$bg_color_3">
         <TH ALIGN="Right" VALIGN="TOP">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         $profile_field</font></TH>
         <td ALIGN="LEFT"><font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         $r_in->{'userdata'}->{$profile_field}</font>&nbsp;
         </td></tr>~;
      }
   }
      
  $output .= qq~
  </table>
   ~;

   return $output;
}

#======================================================================#
# function forum_subscription
# Displays the user options
#======================================================================#

sub forum_subscription {

   my ($r_in,$r_setup) = @_;
   my $heading = "DCForum User Menu";
   my $sub_heading = "Subscribe to forums.";
   my $html_output;

   if ($r_in->{'sub_command'}) {
      $r_in->{'forum_id'} =~ s/\0/,/g;
      update_subscription($r_in->{'userdata'}->{'Username'},$r_in->{'forum_id'});
      $sub_heading = "Your subscription list has been updated.";
   }
   else {
   
      my $forum_list = get_user_subscription($r_in->{'userdata'}->{'Username'});
      $html_output .= qq~
      <form action="$boardurl" method="post">
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="command" value="$r_in->{'command'}">
      <input type="hidden" name="sub_command" value="save">
      <table border="0" cellspacing="2" cellpadding="3">
         <tr bgcolor="$bg_color_3"><th align="left" colspan="2">
            <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
             Check forums you want to subscribe to:</font></th></tr>
         <tr bgcolor="$bg_color_0">
            <th align="left">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
             Select</font></th>
            <th align="left">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
             Forum name</font></th>
             </tr>
         ~;
         
      foreach (@{$r_setup->{'forums'}}) {
         unless ($r_setup->{'forum_type'}->{$_} eq 'Private') {
            $html_output .= qq~
            <tr bgcolor="$bg_color_3"><th align="right" valign="top">
               <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
               ~;
   
               if (subscribed($_,$forum_list)) {
                  $html_output .= qq~
                  <input type="checkbox" name="forum_id" value="$_" checked></font></td>~;
               }
               else {
                  $html_output .= qq~
                  <input type="checkbox" name="forum_id" value="$_"></font></td>~;
               }
   
               $html_output .= qq~
               <TD ALIGN="LEFT">
               <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
               <b>$r_setup->{'forum_name'}->{$_}</b><br> 
               $r_setup->{'forum_desc'}->{$_}
               </font>
               </TD></TR>~;
         }
      }
   
         $html_output .= qq~
            
            <tr bgcolor="$bg_color_3"><th align="Right">
            <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
             </font></td>
            <TH ALIGN="LEFT">
            <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
            </font>
            </TH></TR>
         
      <TR BGCOLOR="$bg_color_3">
        <td align="left">&nbsp;</td>
        <td align="left">
        <input type="submit" value="Submit">
        <input type="reset" value="Reset"></td></tr>
      </table>
      </form>~;

   }
   
   return ($heading, $sub_heading, $html_output);

}

#======================================================================#
# function get_user_subscription
# Returns forums that user subscribed to
#======================================================================#

sub get_user_subscription {
   my $user = shift;
   my $r_data = readdata("$password_file_dir/$subscription_list");
   foreach (@{$r_data}) {
      chomp;
      my ($user_id, $subscribed_forums) = split /$split_delim/;
      if ($user_id eq $user) {
         return $subscribed_forums;
      }
   }
   
   return 0;
}

#======================================================================#
# function subscribed
# returns 1 if user is subscribed to $forum
#======================================================================#
   
sub subscribed {
   my ($forum,$forum_list) = @_;
   my @forums = split(/\,/,$forum_list);
   foreach (@forums) {
      if ($_ eq $forum) {
         return 1;
      }
   }  
   return 0;
}

#======================================================================#
# function update_subscription
# Updates the subscription list
#======================================================================#

sub update_subscription {
   my ($user,$forum_list) = @_;
   my $user_exists = '';
   my $r_data = readdata("$password_file_dir/$subscription_list");
   for ($j=0;$j<@{$r_data};$j++) {
      my $line = $r_data->[$j];
      chomp $line;
      my ($user_id, $subscribed_forums) = split(/$split_delim/,$line);
      if ($user_id eq $user) {
         $user_exists = 'yes';
         $r_data->[$j] = "$user\|$forum_list\n";
         last;
      }
   }
   unless ($user_exists) {
      push(@{$r_data},"$user\|$forum_list\n");
   }

   writedata("$password_file_dir/$subscription_list",$r_data);
   
   return 0;
}

1;