# upload_file.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#===================================================================
# upload_file
# utility for uploading files
#===================================================================

sub upload_file {

   my ($r_in,$r_setup) = @_;

   local $html_output;
   local $heading = $forum_title;
   local $sub_heading = "Define file type and the file you want to upload and click on 'Upload File!'";

   my $max_file_size = $r_setup->{'file_upload_size'} * 1024;

   print_header();
   print_header_end();

   if ($r_in->{'command'} eq 'save') {

      unless ( $ENV{'HTTP_REFERER'} =~ /$cgiurl/i) {
         my $temp = join("::",$r_in->{'userdata'}->{'Username'},
            $ENV{'REMOTE_HOST'},$ENV{'REMOTE_ADDR'});
         check_datafile("$password_file_dir/$sec_file");
         appenddata("$password_file_dir/$sec_file",$temp);
         print_header();
         print_header_end();
         $heading = "POSTING ERROR - PLEASE CONTACT YOUR ADMIN";
      }
      else {
      my $file_id = get_session_id();

      open(F,">$uploaddir/$file_id\.$r_in->{'file_type'}")
            or my_die ("Can't upload your file",$!);
         print F "$r_in->{'file_upload'}";
      close(F);

      my $file_size = -s "$uploaddir/$file_id.$r_in->{'file_type'}";
      my $log = join ("$join_delim",
               $r_in->{'date'},$r_in->{'localtime'},
               $r_in->{'userdata'}->{'Username'},
               $file_id,$file_size);
      appenddata("$password_file_dir/$upload_log",$log);
               
      if ($file_size > $max_file_size ) {
         $html_output .= qq~
         <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
            ERROR: The file you tried to upload was $file_size bytes and was deleted.</font>
         ~;
         unlink("$uploaddir/$file_id\.$r_in->{'file_type'}");
      }
      else {
         $html_output .= qq~
         <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         File was successfully uploaded to remote server.  The URL of this file
         is $uploadurl/$file_id.$r_in->{'file_type'}</font>
         ~;
      }
   }#End of unless
   }
   else {
      $html_output =qq~
      <FORM ENCTYPE="MULTIPART/FORM-DATA" METHOD="POST">
      <INPUT TYPE="HIDDEN" NAME="az" VALUE="$r_in->{'az'}">
      <INPUT TYPE="HIDDEN" NAME="command" VALUE="save">
         <table border="0" cellpadding="2" WIDTH="$table_width">
         <tr>
         <td bgcolor="$bg_color_0" colspan="2">
         <FONT SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
         <b>File type:</b></font>
         </td></tr>
         <tr>
         <td bgcolor="$bg_color_3">
         <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         <INPUT TYPE="radio" NAME="file_type" value="html" checked>HTML file<br>
         <INPUT TYPE="radio" NAME="file_type" value="jpg">JPEG picture<br>
         <INPUT TYPE="radio" NAME="file_type" value="zip">ZIP compressed file
         </font></td>
         <td bgcolor="$bg_color_3">
         <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         <INPUT TYPE="radio" NAME="file_type" value="txt">Text file<br>
         <INPUT TYPE="radio" NAME="file_type" value="gif">GIF picture<br>
         <INPUT TYPE="radio" NAME="file_type" value="tar">TAR compressed file
         </font></td>
         </tr>
         <tr>
         <td bgcolor="$bg_color_0" colspan="2">
         <FONT SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
         <b>Select a file ($r_setup->{'file_upload_size'} 
            KBytes maxmimum size):</b></font>
         </td></tr>
         <tr>
         <td bgcolor="$bg_color_3" colspan="2">
         <INPUT TYPE="FILE" NAME="file_upload" size="40"></td></tr>
         <tr>
         <td bgcolor="$bg_color_3">
         &nbsp;
         </td>
         <td bgcolor="$bg_color_3">
         <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         <INPUT TYPE="SUBMIT" VALUE="Upload File!">
         <INPUT TYPE="RESET" VALUE="Reset"></font></td></tr><tr>
         <td bgcolor="$bg_color_3">
         &nbsp;
         </td>
         <td bgcolor="$bg_color_3" align="right">
         <A HREF = "javascript:window.close();"><FONT 
         SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">Close 
         this Window</font></A></td></tr></TABLE>
         </FORM>~;   
   }

   require "$cgilib/blank_template.pl";
   exit;
}

1;
